/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : cgapcx.c                                                  */
/* Description  : cga mode pcx reader routines                              */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */

#define _CGAPCX_C_


#include "std.h"
#include "stdkeys.h"
#include "cgaload.h"
#include "pixhdr.h"
#include "cgapcx.h"

int cgapcxcheck(PCXHEADER *pcxheader)
{

  if (10 != pcxheader->zsoft)
    return (INVALID_HEADER);
  if (1 != pcxheader->codetype)
    return (INVALID_HEADER);
  if (2 != pcxheader->pixbits)
    if (1 != pcxheader->pixbits)
      return (INVALID_HEADER);
    else
      ucCgaDisplayMode = HIRES_CGA_VIDEO;
  else
    ucCgaDisplayMode = LORES_CGA_VIDEO;

  if (0 != pcxheader->xmin)
    return (INVALID_HEADER);
  if (0 != pcxheader->ymin)
    return (INVALID_HEADER);
  if(319 != pcxheader->xmax)
    if(639 != pcxheader->xmax)
       return (INVALID_HEADER);
  if(199 != pcxheader->ymax)
    return (INVALID_HEADER);
  if(1 != pcxheader->no_planes)
    return (INVALID_HEADER);
  if (CGA_LINE_SIZE != pcxheader->bytes_per_line)
    return (INVALID_HEADER);
  return (SUCCESS);
}


/* read a cga mode full screen pcxfile */
int cgxread(char *pcxfilename)
{
  FILE *fp;
  unsigned int byteoff;
  int byte, count, packet;
  unsigned char pcxheader[128];

  /* read the file header */
  if (NULL == (fp = fopen(pcxfilename,"rb")))
    return (INVALID_HANDLE);

  fread(pcxheader, sizeof(pcxheader), 1, fp);
  if (INVALID_HEADER == cgapcxcheck((PCXHEADER *)&pcxheader[0])) {
    fclose(fp);
    return (INVALID_HEADER);
  }

  byteoff = 0;
  while (byteoff < CGA_SCREENSIZE) {
    if (EOF == (byte = fgetc(fp)))
      break;
    if (0xC0 == (0xC0 &byte)) {        /* if its not raw, run encoded */
      count= 0x3f &byte;
      if (EOF == (byte = fgetc(fp)))
        break;
      for (packet=0; packet < count; packet++)
        cgascreenbuffer[byteoff++] = byte;
    }
    else
      cgascreenbuffer[byteoff++]=byte;
  }

  fclose(fp);
  return (SUCCESS);
}
