{$F+}
                 program neural_application2;

uses objects,owindows,odialogs,strings,win31,windos, wintypes,winprocs,
     ostddlgs,bwcc,bpnet, nnunit, dyna2,wintools,cfmtools;

{$I SLUG.inc}
{$R SLUG}

type

   nninitdata = record
           inputsize            : longint;
           outputsize           : longint;
           hiddensize           : longint;
   end;

   NNLearnparams  = record
           Lcoeff         : double;
           momentum       : double;
           Kmod           : double;
           Maxerr         : double;
           Maxiter        : longint;
   end;

   TrainStepRec = record
           DMdesired     : pdynamat;
           DMinput       : pdynamat;
           DVerror       : pdynavec;
   end;



   pannpgm  = ^ANNpgm;
{----------------------------}
   ANNpgm   = object(tapplication)
{----------------------------}

      procedure Initmainwindow; virtual;

   end;


    pNNwindow   = ^NNwindow;
{----------------------------}
    NNWindow    = object(tdlgwindow)
{----------------------------}
      net                   : psimplebpnet;
      inname                : array[0..fspathname] of char;
      outname               : array[0..fspathname] of char; {these contain a network on stream}
      datainname            : array[0..fspathname] of char;
      logname               : array[0..fspathname] of char; {these contain network data}
      infile,
      outfile               : pdosstream; {streams for network}
      datainfile,
      logfile               : text;
      initbuffer            : nninitdata; {user data}
      learnbuffer           : NNlearnparams;
      datainopen            : boolean;  {are the data files open? }
      logopen               : boolean;
      netok,dataok,logok    : boolean;  {are these specified ?}
      modified              : boolean;  {refers to network spec file}
      paused                : boolean;
      running               : boolean;
      training              : boolean;
      stopped               : boolean;
      logappend             : boolean; {Logfile Append check box}
      edmomentum,edlearn,                 {edit controls in the main dialog box}
      edkmod,edmaxerr,
      infolearn,
      infomomentum          : pfloatedit;  {don't need these in BP7...}
      edmaxiter             : pnumedit;
      edinfocount           : pnumedit;
      edinfoerror           : pfloatedit;
      eddatafile,
      edlogfile             : pedit;
      chlogappend           : pcheckbox;


      constructor init(aparent : pwindowsobject; atitle  : pchar);
      destructor done; virtual;
      function  canclose : boolean; virtual;
      function  getclassname : pchar ;virtual;
      procedure getwindowclass(var awndclass : twndclass); virtual;
      procedure CMnewfile(var mess : tmessage); virtual cm_first +cm_filenew;
      procedure CMopenfile(var mess : tmessage); virtual cm_first +cm_fileopen;
      procedure CMsavefile(var mess : tmessage); virtual cm_first +cm_filesave;
      procedure CMsaveasfile(var mess : tmessage); virtual cm_first +cm_filesaveas;
      procedure CMEXit(var mess : tmessage); virtual cm_first +cm_exit;
      procedure CMbuildnet(var mess : tmessage); virtual cm_first + cm_netedit;
      procedure CMdatain(var mess : tmessage); virtual cm_first +cm_datain;
      procedure CMdataout(var mess : tmessage); virtual cm_first +cm_dataout;
      procedure CMtrain(var mess : tmessage); virtual cm_first +cm_train;
      procedure CMtrainparams(var mess: tmessage); virtual cm_first+ cm_trainedit;
      procedure CMrun(var mess : tmessage); virtual cm_first +cm_run;
      procedure CMAbout(var mess : tmessage); virtual cm_first +cm_about;
      procedure CMdisplay(var mess : tmessage); virtual cm_first +cm_display;
      procedure BNpausenet(var mess : tmessage); virtual id_first+ id_pause;
      procedure BNstopnet(var mess : tmessage); virtual id_first+ id_iterstop;
      procedure BNsavenet(var mess : tmessage); virtual id_first+ id_savenet;
      procedure BNreadnet(var mess : tmessage); virtual id_first+ id_readnet;
      procedure BNshakenet(var mess : tmessage); virtual id_first+ id_shake;
      procedure BNtrain(var mess : tmessage); virtual id_first+ id_train;

      procedure BNdataopen(var mess : tmessage);virtual id_first+id_dataopen;
      procedure BNdataclose(var mess : tmessage); virtual id_first+id_dataclose;
      procedure BNlogopen(var mess : tmessage); virtual id_first+id_logopen;
      procedure BNlogclose(var mess : tmessage); virtual id_first+id_logclose;
      procedure BNtrainparams(var mess : tmessage); virtual id_first+id_trainparams;
      procedure trainsession;
      function  trainepoch(var data : trainsteprec; count: word) : double;
      procedure setupnetparams;
      procedure showtrainparams;
      procedure shownetparams;
      procedure showicon(state : word);
      function  closelogfile    : boolean;
      function  closedatafile   : boolean;
      function  killnet         : boolean;
      procedure report(rep :pchar);          

    end;


    pSpecdialog = ^Specdialog;
{----------------------------}
    Specdialog  = object(tdialog)
{----------------------------}
       procedure zerocounts(var mess : tmessage); virtual
                                                 id_first + id_netspecclear;
    end;




   {--------------------- NNWINDOW PROCEDURES --------------------------}



{----------------------------}
constructor nnwindow.init(aparent : pwindowsobject;
                          atitle  : pchar);
{----------------------------}
begin
     tdlgwindow.init(aparent,atitle);
     ismodal  := false;

     strcopy(outname,'');
     strcopy(inname,'*.ann');
     strcopy(datainname,'');
     strcopy(logname,'');
     infile         := nil;
     outfile        := nil;
     net            := nil;
     modified   := false;
     paused     := false;
     running    := false;
     stopped    := false;
     training   := false;
     datainopen := false;
     logopen    := false;
     logok      := false;
     dataok     := false;
     netok      := false;
     logappend  := false;


     with initbuffer do
        begin
        inputsize     := 2;
        outputsize    := 1;
        hiddensize    := 2;
        end;
     with learnbuffer do
        begin
        lcoeff      := 0.5;
        momentum    := 0.8;
        kmod        := 0;
        maxerr      := 0.1;
        maxiter     := 20000;
        end;

                { Initialize the edit controls }
     new(edmomentum,initresource(@self,ed_usermomen,3,0,999));
     new(edlearn,initresource(@self,ed_userlearn,3,0,999));
     new(edkmod,initresource(@self,ed_userkmod,3,0,999));
     new(edmaxerr,initresource(@self,ed_usermaxerr,3,0,999));
     new(edmaxiter,initresource(@self,ed_usermaxiter,3,0,999));
     new(eddatafile,initresource(@self,ed_userdatafile,20));
     new(edlogfile,initresource(@self,ed_userlogfile,20));

     new(edinfocount,initresource(@self,ed_infocount,3,0,99999));
     new(edinfoerror,initresource(@self,ed_infoerror,6,0,999));
     new(infolearn,initresource(@self,ed_infolearn,6,0,999));
     new(infomomentum,initresource(@self,ed_infomomen,6,0,999));
     new(chlogappend,initresource(@self,id_append));

     showicon(sw_hide);
end;

{----------------------------}
destructor nnwindow.done;
{----------------------------}
begin
     if net <> nil then dispose(net,done);
     dispose(edmomentum, done);
     dispose(edlearn,done);
     dispose(edkmod,done);
     dispose(edmaxerr,done);
     dispose(edmaxiter,done);
     dispose(eddatafile,done);
     dispose(edlogfile,done);

     dispose(edinfocount,done);
     dispose(edinfoerror,done);
     dispose(infolearn,done);
     dispose(infomomentum,done);
     dispose(chlogappend,done);

     if datainopen then close(datainfile);
     if logopen then close(logfile);

     tdlgwindow.done;
end;


{----------------------------}
function nnwindow.getclassname : pchar;
{----------------------------}
begin
     getclassname := 'neuralnetwindow';
end;

{----------------------------}
procedure nnwindow.getwindowclass(var awndclass : twndclass);
{----------------------------}
begin
     tdlgwindow.getwindowclass(awndclass);
     awndclass.hicon := loadicon(hinstance,'networkicon');
     awndclass.lpszmenuname    := 'themenu';
     Awndclass.hbrbackground := getstockobject(null_brush);
        {Remember to specify the menu in the resource file !}
end;


{----------------------------}
function nnwindow.canclose : boolean;
{----------------------------}
var
   reply : integer;
   mess  : tmessage;
begin
    canclose := true;
    if training or running then BNstopnet(mess);
    if netok and modified then
        begin
        reply := messagebox(hwindow,'Lose your changes ?','Net has changed...',
                        mb_yesno or mb_iconquestion);
        if reply = idno then
           canclose := false
        else
            begin
            canclose := true;
            if net <> nil then
               begin
               dispose(net,done);
               net := nil;
               netok := false;
               showicon(sw_hide);
               end;
            end;
        end;

end;

{----------------------------}
procedure nnwindow.cmExit(var mess: tmessage);
{----------------------------}
begin
     if not (training or running) then tdlgwindow.CmExit(mess);
end;

{----------------------------}
function  nnwindow.closelogfile    : boolean;
{----------------------------}
begin
     if logopen then close(logfile);
     logopen := false;
     logok   := false;
     setdlgitemtext(hwindow,ed_userlogfile,'');
     closelogfile := true;
end;

{----------------------------}
function  nnwindow.closedatafile   : boolean;
{----------------------------}
begin
     if datainopen then close(datainfile);
     datainopen := false;
     dataok   := false;
     setdlgitemtext(hwindow,ed_userdatafile,'');
     closedatafile := true;
end;

{----------------------------}
function  nnwindow.killnet         : boolean;
{----------------------------}
                              { If a modified net exists, asks
                                 before disposing of it.
                                 Returns true if the net is disposed.}
var
   ans          : word;
   mess         : Tmessage;
   cankill      : boolean;
begin
     cankill := false;
     if (net = nil) then
         begin
         killnet := true;
         netok := false;
         exit;
         end;

     if not modified then cankill := true;
     if modified then   
          begin
          ans := messagebox(hwindow,'Do you want to save it ?',
                              'This net has changed',
                              mb_yesnocancel or mb_iconhand);
          case ans of
            id_cancel : cankill := false;
            id_yes    :
                       begin
                       CMsaveasfile(mess);
                       cankill := true;
                       end;
            id_no     : cankill := true;
            end;
          end;

     if cankill then
     begin
     dispose(net,done);
     net := nil;
     netok := false;
     showicon(sw_hide);
     end;

     killnet := cankill;
end;

{----------------------------}
procedure nnwindow.CMnewfile(var mess : tmessage);
{----------------------------}
var
   ans  : integer;
begin
                        {Throw the old network out and build a new one}
     if not (running or training) then
     if killnet then
        begin
        setdlgitemtext(hwindow,ed_netname,'');
        strcopy(outname,'');
        strcopy(inname,'');
        if datainopen then closedatafile;
        CMbuildnet(mess);
        if net <> nil then
           begin
           netok := true;
           showicon(sw_show);
           shownetparams;
           end
        else
           begin
           netok := false;
           showicon(sw_hide);
           report('Error creating network - report to author !');
           end;
        end;
end;

{----------------------------}
procedure nnwindow.CMopenfile(var mess : tmessage);
{----------------------------}
                                {Throw out old net and read a new one}
var
   result,save       : integer;
begin
     if running or training then exit;
                          { else, net is now nil.
                            If If new name chosen, get it from stream. }
     strcopy(inname,'*.ann');
     if application^.execdialog(new(pfiledialog,init(@self,
                                    pchar(sd_bcfileopen), inname))) = id_ok
     then
       begin
       if not killnet then exit;
       strcopy(outname,inname);
       new(infile,init(inname,stopenread));
       if (infile^.status <> stOK) then
             begin
             say('Could not open file ! ');
             if infile <> nil then dispose(infile,done);
             exit;
             end; 
       net := psimplebpnet(infile^.get);
       dispose(infile,done);

       if (net <> nil) then    { net OK}
         begin
         netok := true;
         showicon(sw_show);
         shownetparams;
         setdlgitemtext(hwindow,ed_netname,inname);
         if datainopen then closedatafile;
         with initbuffer do
            begin
            inputsize    := net^.inputfield^.count;
            outputsize   := net^.outputfield^.count;
            hiddensize   := net^.hiddenfield^.count;
            end;
         with learnbuffer do
            begin
            lcoeff      := net^.learn;
            momentum    := net^.momen;
            end;
         end
       else                    { Net not OK} 
         begin
         say('No network present !');
         report('Error');
         showicon(sw_hide);
         strcopy(inname,'*.ann');
         strcopy(outname,'');
         setdlgitemtext(hwindow,ed_netname,'');
         netok := false;
         end;  
       end;
     

end;

{----------------------------}
procedure nnwindow.CMsaveasfile(var mess : tmessage);
{----------------------------}
                              { Overwrites without asking !
                              }
begin
     if (strlen(outname) = 0) then
       strcopy(outname,'*.ann')
     else
       strcopy(outname,inname);

     if application^.execdialog(new(pfiledialog,init(@self,
                     pchar(sd_bcFileSave), outname))) = id_ok
     then
       begin
       setdlgitemtext(hwindow,ed_netname,outname);
       modified := false;
       new(outfile,init(outname,stcreate));
       if outfile^.status <> stOK then
          begin
          say('Could not create file ! ');
          exit
          end; 
       outfile^.put(net);
       dispose(outfile,done);
       outfile := nil;
       report('Net saved');
       end;
{$ifdef debug}
     messagebox(hwindow,outname,'File saved as :',mb_ok);
{$endif}
end;

{----------------------------}
procedure nnwindow.CMsavefile(var mess : tmessage);
{----------------------------}

                                {Simply save}
begin
     if (net <>nil) and (strlen(outname)<> 0)  then
       begin
       new(outfile,init(outname,stcreate));
       if outfile^.status <> stOK then
          begin
          say('Could not open file ! ');
          Report('Error during stream access');
          exit
          end; 
       outfile^.put(net);
       dispose(outfile,done);
       modified := false;
       report('Net written');
       end
     else
       if (net <>nil) then CMsaveasfile(mess);

{$ifdef debug}
     messagebox(hwindow,outname,'Written to :',mb_ok);
{$endif}
end;

{-----------------------------------}
procedure nnwindow.CMbuildnet(var mess : tmessage);
{-----------------------------------}
var
   edit1, edit2, edit3, edit4    : pnumedit; {numeric edit boxes}
   dlg                           : pspecdialog;
   result,discard,i              : integer;

procedure builddialog;
begin
      new(dlg,init(@self,'netspec1'));   {init the dialog }
      dlg^.transferbuffer := @initbuffer;
                                         {and the controls}
      new(edit1,initresource(dlg,id_netspecin,3,1,999));
      new(edit2,initresource(dlg,id_netspecout,3,1,999));
      new(edit3,initresource(dlg,id_netspechidden,3,1,999));
                                              {execute the dialog}
      result := application^.execdialog(dlg);
      if result <= 0 then say('Could not open the dialog');
end;

begin
      if killnet then
         begin
         if datainopen then closedatafile;
         builddialog;
         with initbuffer do
             begin
             new(net,init(initbuffer.inputsize,
                          initbuffer.hiddensize,
                          initbuffer.outputsize,0.5,0.5));
             if net <> nil then
               begin
               net^.shake(1.0);
{               for i:= 1 to net^.hiddenfield^.count do
                  pneuron(net^.hiddenfield^.at(i-1))^.setscale(1.7);
}               end;

             end;
         showicon(sw_show);
         modified := false;
         netok := true;
         report('New network created');
         end;

end;

{--------------------------}
procedure nnwindow.CMdatain(var mess : tmessage);
{--------------------------}
begin

     if datainopen then closedatafile;
     strcopy(datainname,'*.dat');
     if application^.execdialog(new(pfiledialog,init(@self,
                     pchar(sd_bcfileopen), datainname))) = id_ok
     then
        begin
        setdlgitemtext(hwindow,ed_userdatafile,datainname);
        dataok := true;
        report('Datafile specified');
        end
     else
         begin
         strcopy(datainname,'');
         dataok := false;
         report('Datafile needs to be specified');
         end;
end;


{--------------------------}
procedure nnwindow.CMdataout(var mess : tmessage);
{--------------------------}
begin
    if logopen
    then
       if messagebox(hwindow,'Do you want to close it ?','Logfile is open !',
                  mb_yesno or mb_iconhand) = id_no
       then exit
       else
            begin
            closelogfile;
            logopen := false;
            logok := false;
            report('Logfile closed');
            end;

    strcopy(logname,'*.log');
    if application^.execdialog(new(pfiledialog,init(@self,
                pchar(sd_bcfileopen), logname))) = id_ok
    then
          begin
          logok := true;
          logopen := false;
          setdlgitemtext(hwindow,ed_userlogfile,logname);
          if chlogappend^.getcheck = bf_checked then logappend := true
             else logappend := false;
          Report('Logfile specified');
          end;

end;


{--------------------------}
procedure nnwindow.CMtrainparams(var mess: tmessage);
{--------------------------}
var
   edit1, edit2, edit3, edit4 : pfloatedit; {numeric edit boxes}
   edit5                      : pnumedit;
   dlg                        : pspecdialog;
   result,discard             : integer;

begin
      new(dlg,init(@self,'trainparam'));   {init the dialog }
      dlg^.transferbuffer := @learnbuffer;
                                         {and the controls}
      new(edit1,initresource(dlg,ed_userlearn,10,0,100));
      new(edit2,initresource(dlg,ed_usermomen,10,0,100));
      new(edit3,initresource(dlg,ed_userkmod,10,0,100));
      new(edit4,initresource(dlg,ed_usermaxerr,10,0,10));
      new(edit5,initresource(dlg,ed_usermaxiter,6,0,100000));

                                              {execute the dialog}
      result := application^.execdialog(dlg);
      if result <= 0 then
         begin
         say('Insufficient memory');
         exit;
         end;
 
      if (net <> nil) and (result=id_ok) then
         begin
         with learnbuffer do
            begin
            net^.learn := learnbuffer.lcoeff;    { tell the net}
            net^.momen := learnbuffer.momentum;
                                                 {tell the user}
            showtrainparams;
            end;
          end;
end;

{--------------------------}
procedure nnwindow.showtrainparams;
{--------------------------}
                            { Redisplays current learning params } 
begin
     if netok then
         begin
         edlearn^.transfer(@net^.learn,tf_setdata);
         edmomentum^.transfer(@net^.momen,tf_setdata);
         edkmod^.transfer(@learnbuffer.kmod,tf_setdata);
         edmaxerr^.transfer(@learnbuffer.maxerr,tf_setdata);
         setdlgitemint(hwindow,ed_usermaxiter,learnbuffer.maxiter,false);
         infolearn^.transfer(@net^.learn,tf_setdata);
         infomomentum^.transfer(@net^.momen,tf_setdata);
         end;
end;

{--------------------------}
procedure nnwindow.shownetparams;
{--------------------------}
begin
     if net <> nil then
         begin
         setdlgitemint(hwindow,id_incount,net^.inputfield^.count,false);
         setdlgitemint(hwindow,id_hiddencount,net^.hiddenfield^.count,false);
         setdlgitemint(hwindow,id_outcount,net^.outputfield^.count,false);
         end;
end;

{--------------------------}
procedure nnwindow.CMtrain(var mess: tmessage);
{--------------------------}
begin
     if ((dataok) and     { If all is set up...}
        (logok) and
        (net <> nil) and
        not training )
     then
       begin
       training := true;             {then open the files..}
       paused := false;
       stopped:= false;
       if not datainopen then opentextfile(datainname,datainfile);
                                     {check for append on logfile}

       if not logopen then
          if not logappend then
             createtextfile(logname,logfile)
          else
             appendtextfile(logname,logfile);

                                     {do some interface stuff}
       logopen     := true;
       datainopen  := true;
       showwindow(getdlgitem(hwindow,id_readnet), sw_hide);
       showwindow(getdlgitem(hwindow,id_dataopen), sw_hide);
       showwindow(getdlgitem(hwindow,id_dataclose), sw_hide);
       showwindow(getdlgitem(hwindow,id_logopen), sw_hide);
       showwindow(getdlgitem(hwindow,id_logclose), sw_hide);
       enablewindow(getdlgitem(hwindow,id_cancel),false);
       enablemenuitem(getmenu(hwindow),cm_exit,mf_bycommand or mf_grayed);
       enablemenuitem(getmenu(hwindow),cm_fileopen,mf_bycommand or mf_grayed);
       enablemenuitem(getmenu(hwindow),cm_filenew,mf_bycommand or mf_grayed);
       enablemenuitem(getmenu(hwindow),cm_netedit,mf_bycommand or mf_grayed);
       drawmenubar(hwindow);
       report('Training');

       trainsession;                  {and train}

       spacedline(logfile,'Final Weights');
       printmattofile(logfile,net^.weights^);
       spacedline(logfile,' ');
       reset(datainfile);
       paused := false;
       training:= false;
       showwindow(getdlgitem(hwindow,id_readnet), sw_show);
       showwindow(getdlgitem(hwindow,id_dataopen), sw_show);
       showwindow(getdlgitem(hwindow,id_dataclose), sw_show);
       showwindow(getdlgitem(hwindow,id_logopen), sw_show);
       showwindow(getdlgitem(hwindow,id_logclose), sw_show);
       enablewindow(getdlgitem(hwindow,id_cancel),true);
       enablemenuitem(getmenu(hwindow),cm_exit,mf_enabled or mf_bycommand);
       enablemenuitem(getmenu(hwindow),cm_filenew,mf_bycommand or mf_enabled);
       enablemenuitem(getmenu(hwindow),cm_fileopen,mf_bycommand or mf_enabled);
       enablemenuitem(getmenu(hwindow),cm_netedit,mf_bycommand or mf_enabled);
       drawmenubar(hwindow);
       end;

end;

{--------------------------}
procedure nnwindow.trainsession;
{--------------------------}
var
   i,j                  : word;
   count                : longint;
   lines,linelength     : integer;
   totalerror,lasterror : double;
   Traindata            : Trainsteprec;
   incount,outcount     : integer;
   mess                 : tmsg;
   dvin                 : pdynavec; { for net response after training}

begin
     if net = nil then
        BEGIN
        messagebox(hwindow,'','No Network defined !',mb_ok);
        exit;
        END
     else
        modified := true;

                                { Check out datafile }
     readln(datainfile); readln(datainfile);
     lines := countlines(datainfile);
     readln(datainfile);readln(datainfile); {position correctly...}
                                            {Data interpretation determined
                                             by network structure}
     outcount := net^.outputfield^.count;   
     incount  := net^.inputfield^.count;
     linelength:= incount + outcount;

                                { Make datastructures}
     with traindata do
          begin
          new(DMInput,init(lines,linelength));
          new(DMdesired,init(lines,outcount));
          new(DVerror,init(outcount,1));
                                { Get input data}
          linestomat(datainfile,DMinput^);
          writeln(logfile,'IO MATRIX');
          printmattofile(logfile,DMinput^);
          for i := 1 to lines do
              for j := 1 to outcount do
                 DMdesired^.put(i,j,DMinput^.get(i,incount+j));
          writeln(logfile,'DESIRED MATRIX');
          printmattofile(logfile,DMdesired^);

          for i := 1 to outcount do DMinput^.deletecol(incount+i);
          writeln(logfile,'INPUT MATRIX');
          printmattofile(logfile,DMinput^);
          end;

     setupnetparams;
     showtrainparams;
                    { Start the training...}

     count      := 0;
     totalerror :=9999;
     repeat
         yield(mess);
         edinfocount^.transfer(@count,tf_setdata);
         edinfoerror^.transfer(@totalerror,tf_setdata);
         if stopped then
            begin
            report('Stopped');
            exit;
            end;
         if not paused then
            begin   
            count := count +1;
            totalerror := TrainEpoch(traindata,lines); {present all data once}
            edinfocount^.transfer(@count,tf_setdata);
            edinfoerror^.transfer(@totalerror,tf_setdata);
            if (count mod 10) = 0 then
               begin
               infolearn^.transfer(@net^.learn,tf_setdata);
               infomomentum^.transfer(@net^.momen,tf_setdata);
               end;
            if (count mod 10)=0 then
                writeln(logfile,'Event # ',count,totalerror:12:6);
            end;

     until (totalerror < learnbuffer.maxerr) or
          (count > learnbuffer.maxiter);

                              {finished Training...}

     report('Trained !');
     with traindata do
       begin
       spacedline(logfile,'Network response: ');
       for j := 1 to lines do
          begin
          dminput^.getrow(j,dvin);
          net^.feedforward(dvin);
          write(logfile,' inputvec  :');
          printvec(logfile,80,dvin^);
          write(logfile,' response : ');
          for i := 1 to net^.outputfield^.count do
             write(logfile,pneuron(net^.outputfield^.at(i-1))^.output:8:3);
          writeln(logfile);
          end;
       flush(logfile);

       dispose(dmdesired,done);
       dispose(dminput,done);
       dispose(dverror,done);
       end;

end;


{----------------------------}
 function nnwindow.trainepoch(var data : trainsteprec; count: word) : double;
{----------------------------}
var                           { Presents count I/O pairs once}
   lasterror, totalerror    : double;
   dvin,dvdesired           : pdynavec;
   thisone                  : pneuron;
   i,j                        : integer;
   mess                       : tmsg;
begin
       if paused then exit;

       for j := 1 to count do { For each training datum...}

          begin
          inc(count);
          data.DMdesired^.getrow(j,dvdesired); {get data}
          data.DMinput^.getrow(j,dvin);
          net^.feedforward(dvin);              { Feed it forward}
           
                                {make error vector}
          for i := 1 to net^.outputfield^.count do  {...for each output neuron}
              begin
              yield(mess);
              thisone := net^.outputfield^.at(i-1);
              lasterror := (dvdesired^.get(i) - thisone^.output);
              totalerror := totalerror + abs(lasterror);
              data.dverror^.put(i, lasterror);
              end;              { feed error back}

          net^.backpropall(data.dverror);
          yield(mess);
          net^.getdeltaweights(net^.learn,net^.momen);
          yield(mess);
          net^.adjustweights;
          yield(mess);
          end;

       trainepoch := totalerror;

end;


{----------------------------}
procedure nnwindow.setupnetparams;
{----------------------------}
                              { Get data from buffers to the existing net}
begin
                                { Setup Backpropnet}
     net^.learn := learnbuffer.lcoeff;
     net^.momen := learnbuffer.momentum;

     net^.setfieldsignal(net^.inputfield,linear);
     net^.setfieldsignal(net^.hiddenfield,sigmoid);
     net^.setfieldsignal(net^.outputfield,linear);
end;


{--------------------------}
procedure nnwindow.CMrun(var mess : tmessage);
{--------------------------}
var
   DMInput      : pdynamat;
   DVIn         : pdynavec;
   lines,i,j     : integer;
begin
   if (net <> nil) and (dataok) then
   begin
     if not datainopen then
       if opentextfile(datainname,datainfile) <> 0 then exit;
     if not logopen then
       if createtextfile(logname,logfile) <> 0 then exit;
     logopen     := true;
     datainopen  := true;

     reset(datainfile);
     readln(datainfile); readln(datainfile);
     lines := countlines(datainfile);
     readln(datainfile);readln(datainfile); {position correctly...}
     new(dminput,init(lines,net^.inputfield^.count));

                                { Get input data}
     linestomat(datainfile,DMinput^);
     writeln(logfile,'DATA MATRIX');
          printmattofile(logfile,DMinput^);

       for j := 1 to lines do
          begin
          dminput^.getrow(j,dvin);
          net^.feedforward(dvin);
          setdlgitemint(hwindow,ed_infocount,j,false);
          printvec(logfile,80,dvin^);
          for i := 1 to net^.outputfield^.count do
             write(logfile,pneuron(net^.outputfield^.at(i-1))^.output:8:3);
          writeln(logfile);
          end;
       flush(logfile);

       dispose(dminput,done);
       report('Run Complete');
     end;
end;
{--------------------------}
procedure nnwindow.CMdisplay(var mess : tmessage);
{--------------------------}
begin
     messagebox(hwindow,'Not implemented','Bad Luck',mb_OK);
end;

{----------------------------}
procedure nnwindow.BNpausenet(var mess : tmessage);
{----------------------------}
                              { Sets flag to indicate pause/resume to running net,
                                and toggles the button text.
                              }
begin
  if (net <> nil) and (running or training) then
     if not paused  then
        begin
        paused := true;
        setdlgitemtext(hwindow,id_pause,'Resume');
        enablewindow(getdlgitem(hwindow,id_train),false);
        enablewindow(getdlgitem(hwindow,id_iterstop),false);
        enablemenuitem(getmenu(hwindow),cm_train,mf_bycommand or mf_grayed);
        drawmenubar(hwindow);
        report('Paused');
        if datainopen then spacedline(logfile,'----- Paused ------');
        end
     else
        begin
        paused := false;
        setdlgitemtext(hwindow,id_pause,'Pause');
        enablewindow(getdlgitem(hwindow,id_train),true);
        enablewindow(getdlgitem(hwindow,id_iterstop),true);
        enablemenuitem(getmenu(hwindow),cm_train,mf_bycommand or mf_enabled);
        drawmenubar(hwindow);
        report('Resumed');
        end;
end;

{----------------------------}
procedure nnwindow.BNstopnet(var mess : tmessage);
{----------------------------}
                              { Flags the running net to stop }
begin
     if running or training then
        begin
        running   := false;
        training  := false;
        stopped   := true;
        end
end;

{----------------------------}
procedure nnwindow.BNsavenet(var mess : tmessage);
{----------------------------}
begin
     CMsavefile(mess);
end;

{----------------------------}
      procedure nnwindow.BNreadnet(var mess : tmessage);
{----------------------------}
begin
     
     CMopenfile(mess);
end;

{----------------------------}
      procedure nnwindow.BNshakenet(var mess : tmessage);
{----------------------------}
begin
     if (net <> nil) then net^.shake(1.0);
end;

{----------------------------}
procedure nnwindow.BNtrain(var mess : tmessage);
{----------------------------}
begin
     CMTrain(mess);
end;


{----------------------------}
procedure nnwindow.showicon(state : word);
{----------------------------}
                             {Indicates the presence of a valid net}
begin
     if (state=sw_hide) or (state=sw_show) then
        showwindow(getdlgitem(hwindow,id_icon),state)
end;

{----------------------------}
procedure nnwindow.report(rep:pchar);
{----------------------------}
begin
     setdlgitemtext(hwindow,id_status,rep);
end;

{----------------------------}
procedure nnwindow.BNdataopen(var mess : tmessage);
{----------------------------}
begin
     cmdatain(mess);
end;

{----------------------------}
procedure nnwindow.BNdataclose(var mess : tmessage);
{----------------------------}
begin
     closedatafile;
end;


{----------------------------}
procedure nnwindow.BNlogopen(var mess : tmessage);
{----------------------------}
begin
     cmdataout(mess);
end;


{----------------------------}
procedure nnwindow.BNlogclose(var mess : tmessage);
{----------------------------}
begin
     closelogfile;
end;

{----------------------------}
procedure nnwindow.BNtrainparams(var mess : tmessage);
{----------------------------}
begin
     CMtrainparams(mess);
end;


{----------------------------}
procedure nnwindow.CMAbout(var mess : tmessage);
{----------------------------}
var
   dlg  : pdialog;
begin
     new(dlg,init(@self,'aboutdlg'));
     application^.execdialog(dlg);
end;


   {---------------------- SPECDIALOG PROCEDURES ------------------------}

{----------------------------}
procedure specdialog.zerocounts(var mess : tmessage);
{----------------------------}
var
   zero : pchar;
begin
    zero       := '0';
    senddlgitemmsg(id_netspecin, wm_settext,0,longint(zero) );
    senddlgitemmsg(id_netspecout, wm_settext,0,longint(zero) );
    senddlgitemmsg(id_netspechidden, wm_settext,0,longint(zero) );
end;





   {---------------------- APPLICATION PROCEDURES -----------------------}

{----------------------------}
procedure ANNpgm.initmainwindow;
{----------------------------}
begin
     mainwindow := new(pNNwindow,init(nil,'ALLIN'));
end;



{======================================== MAIN ====================================================}
var
   demo         : ANNpgm;
   space        : longint;
   temp         : array[0..20] of char;
begin
     demo.init('ANN Program 2');
     demo.run;
     demo.done;

end.

{---------------------------------------  END  -----------------------------------------------------}
