char err_c[]="$Header: d:/wilhelm/winrsh/RCS/err.c%v 1.6 1994/11/07 04:40:07 wcheung Exp wcheung $";
/*************************************************************************
 *
 * err - Error Module
 *
 * Copyright(C) 1994 William K. W. Cheung
 * All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * WinRSH/WinRSH32 - Remote Shell for Windows
 * Author: William K. W. Cheung (wcheung@ee.ubc.ca)
 * Date:   June 30, 1994
 *
 ************************************************************************/
#define STRICT
#include <windows.h>
#pragma hdrstop
#include <stdarg.h>
#include <stdio.h>
#include "err.h"

#define ERRBUFSIZ       256

static HWND     hWndErr;

void ErrInit(HWND hWnd)
{
	hWndErr = hWnd;
}

void ErrPrintf(UINT uErrFlag, const char *szFormat, ...)
{
	static char szBuf[ERRBUFSIZ];
	va_list vaArgs;

	va_start(vaArgs, szFormat);
	if (vsprintf(szBuf, szFormat, vaArgs) != EOF)
	{
		switch(uErrFlag)
		{
			case ERR_WARN:
				MessageBox(hWndErr, szBuf, "Warning", MB_OK|MB_ICONEXCLAMATION);
				break;

			case ERR_INFO:
				MessageBox(hWndErr, szBuf, "Information", MB_OK|MB_ICONINFORMATION);
				break;

			case ERR_FATAL:
				MessageBox(hWndErr, szBuf, "Unrecoverable Fatal Error", MB_OK|MB_ICONHAND);
				SendMessage(hWndErr, WM_CLOSE, 0, 0L);
				break;

			default:
				break;
		}
	}
	va_end(vaArgs);
}

