// File: colortable.js
// This file controls all the color table functions
// It resides in the control frame

// This function is a method of the ColorSet object
// It displays the background and text color in the info frame

function ColorSet_display(){

	INFODOC.open();

	// Set the background and text colors
	INFODOC.write('<BODY BGCOLOR="' + this.bg.value + '" ');
	INFODOC.write('TEXT="' + this.text.value + '">');

	// Write the background color information
	INFODOC.write('<P ALIGN="center"><FONT FACE="Verdana,Georgia,Arial">Background color:</FONT><BR>');
	INFODOC.write('<CODE><BIG>' + this.bg.value + '</BIG></CODE></P>');
	INFODOC.write('<P ALIGN="center"><FONT FACE="Verdana,Georgia,Arial">Color name:</FONT><BR>');
	INFODOC.write('<CODE><BIG>');
	INFODOC.write (this.bg.name);
	INFODOC.write ('</BIG></CODE></P>');
	
	// Write the text color information
	INFODOC.write('<P ALIGN="center"><FONT FACE="Verdana,Georgia,Arial">Text color:</FONT><BR>');
	INFODOC.write('<CODE><BIG>' + this.text.value + '</BIG></CODE></P>');
	INFODOC.write('<P ALIGN="center"><FONT FACE="Verdana,Georgia,Arial">Color name:</FONT><BR>');
	INFODOC.write('<CODE><BIG>');
	INFODOC.write (this.text.name);
	INFODOC.write ('</BIG></CODE></P>');

	INFODOC.write('</BODY>');
	INFODOC.close();
}

// This method of the ColorSet object is called whenever a color is clicked on in the table
// We need to determine whether background or text color is active,
// and whether the other color is on automatic.
// Then we call the display method to display the information.

function ColorSet_newValues (selectedValue){
	// First check the control form values
	autoBgColor = CONTROLDOC.controlForm.backgroundMethod.selectedIndex;
	autoTextColor = CONTROLDOC.controlForm.textMethod.selectedIndex;
	bgActive = CONTROLDOC.controlForm.activeColor[0].checked;

	// Are we dealing with the background color?
	if (bgActive){					
		this.bg.value = selectedValue;		// If so, set the value property
		this.bg.setName();				// and the name property
		if (autoTextColor){				// Is text color on automatic?
			if (this.bg.isDark()){			// If it is, set it
				this.text.value = '#FFFFFF';
				this.text.name = 'white';
			}
			else{
				this.text.value = '#000000';
				this.text.name = 'black';
			}
		}
	}
	else{								// The text color is active
		this.text.value = selectedValue;		// So set the value property
		this.text.setName();				// and the name property
		if (autoBgColor){					// Is background on automatic?
			if (this.text.isDark()){		// If it is, set it
				this.bg.value = '#FFFFFF';
				this.bg.name = 'white';
			}
			else{
				this.bg.value = '#000000';
				this.bg.name = 'black';
			}
		}
	}
	this.display();						// Finally, display the color set 
}

// The setName method of the Color object
// It operates on either the bg or the text property
function Color_setName(){

	if (this.value == "#000000") this.name = "black";
	else if (this.value == "#0000FF") this.name = "blue";
	else if (this.value == "#00FF00") this.name = "lime";
	else if (this.value == "#00FFFF") this.name = "aqua";
	else if (this.value == "#FF0000") this.name = "red";
	else if (this.value == "#FF00FF") this.name = "fuchsia";
	else if (this.value == "#FFFF00") this.name = "yellow";
	else if (this.value == "#FFFFFF") this.name = "white";
	else this.name = "none";
}

// The isDark method of the Color object
// Returns true if a color is dark enough to require a white background
function Color_isDark(){

	var gg = this.value.substring(3,5);			// Extract the green component
	if ((gg == "00") || (gg == "33") || (gg == "66")) return true;
	else return false;
}

// This is the method to display a Table object
// There are four properties: the width and height of a color cell,
// how many cells should be placed in a line, 
// and whether the cells have a border (actually the CELLSPACING attribute)

function Table_display(){

	// Create the array of 216 colors
	var colors = new Array(216);
	var hexValues = new Array("00","33","66","99","CC","FF");
	var r,g,b;
	var arrayItem;

	// Three nested loops are used to set up the colors array
	for (r=0; r<6; r++){
		for (g=0; g<6; g++){
			for (b=0; b<6; b++){
				arrayItem = r*36 + g*6 + b;
				colorValue = "#" + hexValues[r] + hexValues[g] + hexValues[b];
				colors[arrayItem] = ("#" + hexValues[r] + hexValues[g] + hexValues[b]);
			}
		}
	}

	// Open the document
	TABLEDOC.open();
	TABLEDOC.write ('<BODY BACKGROUND="#FFFFFF">');

	// Now write the table
	TABLEDOC.write ('<TABLE BORDER=0 CELLPADDING=0 ');
	TABLEDOC.write ('CELLSPACING=' + this.borderValue + '>');
	TABLEDOC.write ('<TR>');

	for (var i=0; i<216; i++){
		TABLEDOC.write ('<TD BGCOLOR="' + colors[i] + '">');
		TABLEDOC.write ('<A HREF="javascript:parent.control.currentColors.newValues\x28\'' + colors[i] + '\'\x29" ');
		TABLEDOC.write ('onMouseOver="window.status=\'' + colors[i] + '\'; return true;">');
		TABLEDOC.write ('<IMG SRC="blank.gif" BORDER=0 ');
		TABLEDOC.write ('WIDTH=' + this.cellWidth + ' HEIGHT=' + this.cellHeight + '>');
		TABLEDOC.write ('</A></TD>');
		if ((i > 0) && (i < 215) && ((i+1)%this.lineLength == 0))
			TABLEDOC.write ('</TR><TR>');			// the end of the line
	}
	
	TABLEDOC.write ('</TR></TABLE>');

	// Close the document
	TABLEDOC.write ('</BODY>');
	TABLEDOC.close();
}

// The Colorset constructor function
// The properties are background and text
// The display method displays the color info in the info frame
// The newValues method resets the values depending on the user's selection

function ColorSet(bgvalue,bgname,textvalue,textname){

	this.bg = new Color (bgvalue, bgname);
	this.text = new Color (textvalue, textname);

	this.display = ColorSet_display;
	this.newValues = ColorSet_newValues;
}

// This function stores the preferences in a cookie called wscc

function savePreferences(){

	var cookieval = "";					// The value of the cookie
	// Set the cookie to expire in a year
	var expiryDate = new Date((new Date()).getTime() + (1000 * 60 * 60 * 24 * 365));

	// If the user has disabled preference saving, set the cookie accordingly
	if (!cookiesOn) cookieval += "cookies:off";

	// Now combine all the preferences which need stored,
	// in name:value pairs, separated by &
	else{
		cookieval += "&width:" + colorTable.cellWidth;
		cookieval += "&height:" + colorTable.cellHeight;
		cookieval += "&length:" + colorTable.lineLength;
		cookieval += "&border:" + colorTable.borderValue;
	}
	// Finally, set the cookie
	document.cookie = "wscc=" + escape(cookieval) + "; expires=" + expiryDate.toGMTString();
}

// This function extracts all the preferences in the wscc cookie

function getPreferences(){

	// First, get all the cookies and extract the one called wscc
	var allCookies = document.cookie;
	var start = allCookies.indexOf("wscc=");
	if (start != -1){							// Does it exist?
		start += 5;							// Skip the wscc=
		var end = allCookies.indexOf(";", start);
		if (end == -1) end = allCookies.length;
		var allPreferences = allCookies.substring (start, end);
		allPreferences = unescape (allPreferences);	// The list of preferences

		// If cookies have been enabled by the user, set the preferences
		if (allPreferences != "cookies:off"){
			// From the list of preferences, extract the names (prefaced by an &)
			// and the values (prefaced by a :)
			// and place them in an array preferences
			var preferences = new Array();
			preferences = allPreferences.split ("&");
			for (var i=0; i<preferences.length; i++)
				preferences[i] = preferences[i].split (":");

			// Now transfer the preferences to the relevant variables
			for (i=0; i<preferences.length; i++){
				if (preferences[i][0] == "width") 
					colorTable.cellWidth = preferences[i][1];
				else if (preferences[i][0] == "height") 
					colorTable.cellHeight = preferences[i][1];
				else if (preferences[i][0] == "length") 
					colorTable.lineLength = preferences[i][1];
				else if (preferences[i][0] == "border") 
					colorTable.borderValue = preferences[i][1];
			}
			cookiesOn = true;
		}
		else cookiesOn = false;
	}
}

// This is the Color object constructor function
// A color has two properties: value and name
// The setName method sets the name property based on the value property
// The isDark method returns true if the color is dark enough to require a white background
function Color (value,name){

	this.value = value;
	this.name = name;

	this.setName = Color_setName;
	this.isDark = Color_isDark;
}

// The Table constructor function
// The properties are the width and height of a cell,
// how many cells are on a line, and the thickness of the border between cells
// All these properties can be altered in the Options dialog box
// The display method displays the table

function Table(cellWidth, cellHeight, lineLength, borderValue){

	this.cellWidth = cellWidth;
	this.cellHeight = cellHeight;
	this.lineLength = lineLength;
	this.borderValue = borderValue;

	this.display = Table_display;
}

// The frame name constants
var CONTROLDOC = document;
var TABLEDOC = parent.table.document;
var INFODOC = parent.info.document;

// The default preferences
var WIDTH_DEFAULT = 75;
var HEIGHT_DEFAULT = 20;
var LENGTH_DEFAULT = 6;
var BORDER_DEFAULT = 1;
var COOKIES_DEFAULT = true;

// Initialise the objects and flags
var cookiesOn = COOKIES_DEFAULT;
var colorTable = new Table (WIDTH_DEFAULT, HEIGHT_DEFAULT, LENGTH_DEFAULT, BORDER_DEFAULT);
var currentColors = new ColorSet ("#FFFFFF","white","#000000","black");

getPreferences();			// Load the preferences from a cookie if there is one
savePreferences();		// To reset the expiry date
colorTable.display();		// Display the table
currentColors.display();	// Display the color information