unit Demunit4;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, WinImage;

type
  TForm1 = class(TForm)
    WindowImage1: TWindowImage;
    WindowImage2: TWindowImage;
    WindowImage3: TWindowImage;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure WindowImage1Click(Sender: TObject);
    procedure WindowImage2Click(Sender: TObject);
    procedure WindowImage3Click(Sender: TObject);
    procedure WindowImage3Capture(Sender: TObject);
    procedure WindowImage2Capture(Sender: TObject);
    procedure WindowImage1Capture(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
   WMAX,HMAX:integer;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     close;
end;

procedure stretch_fit(var image:TWindowImage);
var
   width,height:integer;
   s1,s2:single;
begin
     width :=image.picture.bitmap.width;
     height:=image.picture.bitmap.height;
     if (width>WMAX) or (height>HMAX) then
        begin
             s1:=WMAX/width;
             s2:=HMAX/height;
             if s2<s1 then s1:=s2;
             width :=trunc(width*s1);
             height:=trunc(height*s1);
        end;
     image.setbounds(image.left,image.top,width,height);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
    WindowImage1.picture:=nil;
    WindowImage2.picture:=nil;
    WindowImage3.picture:=nil;
    WindowImage1.refresh;
    WindowImage2.refresh;
    WindowImage3.refresh;
    WindowImage1.GetWindowImage;
    windowimage3.otherwindow:=button1.handle;
    WindowImage3.GetWindowImage;
    windowimage2.otherwindow:=findwindow(nil,'Program Manager');
    WindowImage2.GetWindowImage;
    stretch_fit(windowimage1);
    stretch_fit(windowimage2);
    stretch_fit(windowimage3);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  WMAX:=windowimage1.width;  {store max width}
  HMAX:=windowimage1.height; {store max height}
end;

procedure TForm1.WindowImage1Click(Sender: TObject);
begin
     showmessage('See, WindowImage1 click event still works!!!');
end;

procedure TForm1.WindowImage2Click(Sender: TObject);
begin
     showmessage('See, WindowImage2 click event still works!!!');
end;

procedure TForm1.WindowImage3Click(Sender: TObject);
begin
     showmessage('See, WindowImage3 click event still works!!!');
end;

procedure TForm1.WindowImage3Capture(Sender: TObject);
begin
     windowimage3.picture.savetofile('button.bmp');
end;

procedure TForm1.WindowImage2Capture(Sender: TObject);
begin
     windowimage2.picture.savetofile('progman.bmp');
end;

procedure TForm1.WindowImage1Capture(Sender: TObject);
begin
     windowimage1.picture.savetofile('activwin.bmp');
end;

end.
