unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, RtfDoc;

type
  TForm1 = class(TForm)
    SampRpt: TButton;
    ExitBtn: TButton;
    Doc: TRtfDoc;
    Edit1: TEdit;
    Label1: TLabel;
    procedure SampRptClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{--------------------------------------------------}
procedure TForm1.SampRptClick(Sender: TObject);
var
   CheckGroupNo:    integer ;
begin
  {Define rtf paragraph defaults - ie the standard for the whole document}
  {for paragraphs}
  Doc.Align:= jLeft ;          {Paragraph Alignment}
  Doc.SetFrFontName('Times') ; {Text Font Name}
  Doc.SetFrFontSize(12) ;      {Text Font Size}
  Doc.IndentLeft  :=   0 ;     {Paragraph left indent Amount - twips}
  Doc.Indent1st   := 720 ;     {Paragraph 1st line indent Amount twips}
  Doc.IndentRight :=   0 ;     {Paragraph Right indent Amount}
  Doc.Spacing := 20 ;          {Paragraph Line Spacing}
  Doc.WordWrap := rtfYes ;     {Text Word Wrap}
  {for text}
  Doc.Color := clBlack ;       {Text Color}
  Doc.Style := stplain ;       {Text Style}
  Doc.Underlining := uNone ;   {Text Underlining}

  {create a file name in the test directory}
  Doc.FFileName := ExtractFilePath(Application.Exename)
                       +'RTF_samp.rtf' ;

  {Open rtf file, file header setup, Group 1 open for document text}
  Doc.OpenDoc ;
  CheckGroupNo := Doc.FrGroupNo ; {Group No = 1 }

  {Print a title}
  {Setup commands for the subgroup that I will create}
  Doc.Align := jCenter ;         {Paragraph Alignment}
  Doc.Underlining := uSingle ;   {Underlining}
  Doc.Style := stBold ;          {Text Style}
  Doc.Indent1st   := 0 ;         {Paragraph 1st line indent Amount twips}
  {open group 2 with these default command settings}
  CheckGroupNo := Doc.OpenGroup ;

  {First I will show a how to create text within a subgroup}
  {write the text, and close the group}
  Doc.WriteLineCR('Sample Report') ; {Writes a line & carriage Return}
  Doc.WriteLineCR('') ;              {writes blank line & carriage Return}
  CheckGroupNo := Doc.CloseGroup ;   {Close Group 2 for title}

  {Now, Write some text in the standard defaults}
  {Note how I strung long text by breaking it into strings and using the +}
  {Text is limited to 254 characters, including the control commands}
  {   so keep your text groups relatively short}
  Doc.WriteLine('This is a sample line of data. It may be '
               +'something like a leading paragraph or just text. It '
               +'is using the defaults. Note the wordwrap. Right now '
               +'it is limited to 254 chars including the control '
               +'commands. ') ;
  {Note that I end the string with a blank. If there is no blank,}
  {rtf will put the strings together with no space.}

  Doc.WriteLine('Note, how the word wrap feature just '
               +'strings all these lines together. Note, how ea'
               +'ch sentence must end in a space in order to av'
               +'oid run-on with the next sentence. ' ) ;
               {The next sentence is appended with no carriage return}
  Doc.WriteLineCR('Note, I used the RtfWriteLineCR function'
               +' to make an end to a paragraph and stop that word '
               +'wrap. In order to leave a blank line, I print '
               +'a blank string. ') ; {This line has a carriage return}

  Doc.WriteLineCR('') ; {writes a blank line & carriage Return}

  Doc.WriteLineCR('RTF has three special characters. the \\ and the'
               +' \{ and the \}. If you want to print them, you have to pr'
               +'eceed the character with a \\. For example, ') ;

  Doc.ClearTabs ;   {a good habit is to clear the tabs first}
  Doc.AddTab(2.5, jLeft) ;
  Doc.WriteLineCR(Doc.Tab1+'\\\\ prints a \\. ') ;
  Doc.WriteLineCR(Doc.Tab1+'\\\{ prints a \{ , and') ;
  Doc.WriteLineCR(Doc.Tab1+'\\\} prints a \}. ') ;

  Doc.WriteLineCR('') ; {writes a blank line & carriage Return}

    {Now I am going to set commands and Open a subgroup for a special paragraph}
    {I will set tabs for a numeric list}
    Doc.ClearTabs ;   {a good habit is to clear the tabs first}
    Doc.AddTab(2.0, jLeft) ;     {for the word 'Note:'}
    Doc.AddTab(2.75, jLeft) ;    {Set a left tab for the 'Number' and '_______'}
    Doc.AddTab(3.25, jDecimal) ; {Set a decimal tab for the list}
    Doc.AddTab(4.2, jRight) ;    {offset total}
    Doc.Color := clNavy ;        {Set Text Color}
    Doc.Spacing := 240 ;         {Paragraph Line Spacing}
    Doc.Underlining := uNone ;   {Text Underlining}
    Doc.WordWrap := RtfNo ;      {Text Word Wrap}
    CheckGroupNo := Doc.OpenGroup ;  {open group 2 to do a list}

      {I am now going to setup the commands for a subgroup within the group}
      {I am going to open a group, add text and close the group}
      {See below, it is easier to use WriteGroup}
      {Open a group within the group - ie. a title for the list}
      Doc.Style := stBold ;         {Style set to Bold}
      CheckGroupNo := Doc.OpenGroup ;  {open group 3 to do title of the list}

        {Print title of list}
        {This is where I show how to use the rtf command }
        {as part of the string.  I do this because I }
        {do not want the whole line underlined}
        {So I just use the rtf command '\bdbl ' before the }
        {word 'Numbers' and the rtf command '\b0 ' after.}
        {I could have used the command Doc.uWord. It is }
        {the component code for word underline}
        {If I set it as a paragraph standard, the tab would be underlined}
        Doc.WriteLineCR( Doc.Tab1
                             +Doc.Tab1
                             +'\uldb '        {double underline}
                             +'Numbers'
                             +'\ul0 ') ;      {turn off underlining}
        {Note: how the rtf command is Separated from the string with a ' '}

        {close group 3 for the title of the list}
        CheckGroupNo := Doc.CloseGroup ;

        {This close group eliminates the Bold that was set for this sample}

      {Now I will Print the list - note use of decimal tab}
      {I had set two tabs, one jLeft, and one jDecimal}
      Doc.WriteLineCR( Doc.Tab1
                           +Doc.Tab1
                           +Doc.Tab1
                           +'435.65') ;
      Doc.WriteLineCR( Doc.Tab1
                           +Doc.Tab1
                           +Doc.Tab1
                           +'5.35') ;
      Doc.WriteLineCR( '\tab '    {another way to enter a tab}
                           +'\tab '
                           +'\tab '
                           +'1423.25') ;
      Doc.WriteLineCR( Doc.Tab1
                           +Doc.Tab1
                           +Doc.Tab1
                           +'34.69') ;

      {Now I want to print one number in red }
      {I use the WriteGroup function so that I can embed an rtf command}
      {This prints the string as an enclosed group with Doc.rclRed}
      Doc.WriteGroup( rtfYes,
                          Doc.Tab1
                          +'Note: '
                          +Doc.Tab1
                          +Doc.Tab1
                          +Doc.rclRed
                          +' '
                          +'-431.65',
                          rtfYes,rtfYes) ;
      {Group 3 was opened and closed in the WriteGroup}
      CheckGroupNo := Doc.FrGroupNo ;
      {GroupNo still 2: Note group 2 closed and color goes back to clNavy}

      {Alternatively, I could have included either of the following:}
      {Doc.WriteLineCR(Doc.Tab1
                           +'Note: '
                           +Doc.Tab1
                           +Doc.Tab1
                           +'\cf6'
                           +'-431.65'
                           +'\cf9') ;}
      {   or}
      {Doc.WriteLineCR(Doc.Tab1
                           +'Note: '
                           +Doc.Tab1
                           +Doc.Tab1
                           +Doc.rclRed
                           +'-431.65'
                          + Doc.rclNavy) ; }

      {Print more}
      Doc.WriteLineCR( Doc.Tab1
                           +Doc.Tab1
                           +Doc.Tab1
                           +'71.69') ;
      Doc.WriteLineCR( Doc.Tab1
                           +Doc.Tab1
                           +Doc.Tab1
                           +'282.69') ;

        {open a subgroup for the total}
        Doc.Style := stBold ;     {Text Style}
        {Print total}
        Doc.WriteLineCR( Doc.Tab1
                             +Doc.Tab1
                             +Doc.Tab1
                             +'_________') ;

        {Doc.WriteLineCR(Doc.Tab1+'1821.67') ;}
        Doc.WriteGroup( rtfYes,
                            Doc.Tab1
                            +'Total'
                            +Doc.Tab1
                            +Doc.Tab1
                            +'\b '                   {bold on}
                            +Doc.Tab1+'1821.67'
                            +'\b0 ',                {bold off}
                            rtfYes,rtfYes) ;
        {Group 3 Opened and closed to print total in bold}

        {Close group 2 for the list group}
        CheckGroupNo := Doc.CloseGroup ;    {Close group for the list FrGroupNo = 1}

      {Add another line of special paragraph text}
      Doc.WriteLineCR('') ; {writes a blank line and a carriage Return}
      Doc.WriteGroup( rtfYes,
                             '\fs48'   {this is rtf command for 12 points}
                             +' '      {this space separates command from text}
                             +'And '
                             +'\cf4 '
                             +'that is '
                             +'\cf6 '
                             +'the end'
                             +'\cf12 '
                             +' of the'
                             +'\cf1 '
                             +' sample. ',
                             rtfYes,rtfYes) ;
      {Group 2 was opened and closed to print the color line}
      CheckGroupNo := Doc.FrGroupNo ;  {GroupNo still 1}

      Doc.WriteLineCR('') ; {writes a blank line and a carriage Return}
      Doc.WriteLineCR('') ; {writes a blank line and a carriage Return}

      {Now I will print a narrow column}
      Doc.Align := jJustify ;
      Doc.Indent1st   :=  720 ;   {0.5 inch paragraph indent}
      Doc.IndentLeft  := 1440 ;   {1 inch left margin}
      Doc.IndentRight := 3*1440 ; {3 inch right margin}
      Doc.Spacing := 600 ;
      {Open Group 2 to activate these rtf commands for the poem}
      CheckGroupNo := Doc.OpenGroup ;

      {Note appending text --- no cariage returns below}
      Doc.WriteLine('Once upon a time ') ;
      Doc.WriteLine('on the border of a brook, ') ;
      Doc.WriteLine('there was a wicked little froggie ') ;
      Doc.WriteLine('who had never read a book. ') ;
      Doc.WriteLine('He never read a story ') ;
      Doc.WriteLine('or a funny little rhyme. ') ;
      Doc.WriteLine('Had a sad and tragic ending ') ;
      Doc.WriteLine('and a once upon a time.... ') ;
      Doc.WriteLineCR('') ; {writes a blank line and a carriage Return}
      {Close group 2 for the poem}
      CheckGroupNo := Doc.CloseGroup ;

      {Close group 1 finished document}
      CheckGroupNo := Doc.CloseGroup ;

   {Close rtf file, closes all groups}
   Doc.CloseDoc ;
   CheckGroupNo := Doc.FrGroupNo ; {This is now -1 --- the file is closed }

   {Show file created}
   Edit1.Text := Doc.FileName ;

end;

{--------------------------------------------------}
procedure TForm1.ExitBtnClick(Sender: TObject);
begin
   Close ;
end;

end.
