unit Jwlabel;

{
        **   VERSION History   **
   Version     Date     Notes
    v1.00  - 01APR99    Original Release
}

interface

uses {$IFDEF WIN32} Windows, {$ELSE} WinProcs, WinTypes, {$ENDIF}
     Stdctrls, Controls, Classes, SysUtils, Messages, Graphics, Menus;

type
  {     Introduction:
        The purpose of this component is to illustrate the methods used
  in creating a component.  To do this, this component will give a label
  full control over the various aspects of the FONT that is used to draw
  itself.  In addition, we will explore some other possible uses and
  expansions of the original "TLabel" idea.  The main features of this Label
  are full rotation, a "border" will full styles and offsets, and the
  possiblility of really cool looking DYNAMIC fonts!
        Remember, only YOU can make me famous! - JW}


  {     Okay, we are about to select a new name for our component AND some of the enumerated
  types.  So how do we name it?  USE A PREFIX OR A POSTFIX!!!!  Sometime you will run into
  another perfectly valid object that has nothing to do with what you are doing, but will
  have a similar name.  But if you give it a prefix (like JW for Joseph Wilcock, or Exp for
  Example) you should avoid the obvious ones. }


  {     Whenever you make a class you SHOULD always make a custom exception so that you can
  handle errors with. }
  EExpLabelError = Class( Exception );

  {     Why enumerated types?  All of these values have actual constants defined (I think
  in "WinTypes") but when you are dealing with the Object Inspector, do you want to have to
  remember them all?  This way, the code will reassign the enumerated type easily. }
  TExpFontWeight = ( fwDontCare, fwThin, fwExtraLight, fwUltraLight, fwLight, fwNormal,
              fwRegular, fwMedium, fwSemiBold, fwDemiBold, fwBold, fwExtraBold,
              fwUltraBold, fwBlack, fwHeavy );
  TExpCharSet = ( csAnsiCharSet, csDefaultCharSet, csSymbolCharSet,
              csShiftJisCharSet, csOemCharSet );
  TExpOutputPrecision = ( opOutCharacterPrecis, opOutDefaultPrecis, opOutDevicePrecis,
              opOutRasterPrecis, opOutStringPrecis, opOutStrokePrecis, opOutTTPrecis );
  TExpClipPrecision = ( cpClipCharacterPrecis, cpClipDefaultPrecis, cpClipEncapsulate,
              cpClipLHAngles, cpClipMask, cpClipStrokePrecis, cpClipTTAlways );
  TExpFontQuality = ( fqDefaultQuality, fqDraftQuality, fqProofQuality );
  TExpFontPitch = ( fpDefaultPitch, fpFixedPitch, fpVariablePitch );
  TExpFontFamily = ( ffDecorative, ffDontCare, ffModern, ffRoman, ffScript, ffSwiss );

  TJwExpLabel = Class( TLabel )
    private
      {  We've already inherited all the other stuff, but we can only touch the
      protected and public values.  This will be our declairations. }
      FOverFontColor: TColor;
      FFontHeight: Integer;
      FFontWidth: Integer;
      FEscapement: Integer;
      FOrientation: Integer;
      FFontWeight: TExpFontWeight;
      FItalic: Integer;
      FUnderline: Integer;
      FStrikeOut: Integer;
      FCharSet: TExpCharSet;
      FOutputPrecision: TExpOutputPrecision;
      FClipPrecision: TExpClipPrecision;
      FFontQuality: TExpFontQuality;
      FFontPitch: TExpFontPitch;
      FFontFamily: TExpFontFamily;
      FFacename: array[0..255] of char;

      {For a nice change of pace, I thought I might want a border for my label
      and throw in a few extra options as well.}
      FBorder: Boolean;
      FBorderStyle: TPenStyle;
      FBorderWidth: Integer;
      FBorderColor: TColor;

      {Yes I know there's a better way of doing this, but I'd rather not worry about
      the "perfect" algorythm to autosize a rotated font.  Maybe someday... but for
      now, this is the best I'M goint to do... unless someone else wants to do it
      for me?}
      FLeftOffset: LongInt;
      FTopOffset: LongInt;
      FRightOffset: LongInt;
      FBottomOffset: LongInt;

      {NOTE ON NAMING:  True story!  For some reason I had made the name of a
      private member the same as the published property!  AND whenever it was
      updated, invalidate was called, and got caught into a total loop.  Moral:
      BE CAREFULL WITH THOSE NAMES!}
      PvFontWeight: Integer;
      PvFontCharSet: Word;
      PvFontOutPrecision: Word;
      PvFontClipPrecision: Word;
      PvFontQuality: Word;
      PvFontPitchAndFamily: Word;

      Procedure SetOverFontColor( Value: TColor );
      Procedure SetFontFaceName( Value: String );
      Function GetFontFaceName: String;
      Procedure SetFontFamily( Value: TExpFontFamily );
      Procedure SetFontPitch( Value: TExpFontPitch );
      Procedure SetFontQuality( Value: TExpFontQuality );
      Procedure SetClipPrecision( Value: TExpClipPrecision );
      Procedure SetOutputPrecision( Value: TExpOutputPrecision );
      Procedure SetCharSet( Value: TExpCharSet );
      Procedure SetFontStrikeout( Value: Integer );
      Procedure SetFontUnderline( Value: Integer );
      Procedure SetFontItalic( Value: Integer );
      Procedure SetFontWeight( Value: TExpFontWeight );
      Procedure SetFontOrientation( Value: Integer );
      Procedure SetFontEscapement( Value: Integer );
      Procedure SetFontWidth( Value: Integer );
      Procedure SetFontHeight( Value: Integer );
      Procedure SetBorder( Value: Boolean );
      Procedure SetBorderStyle( Value: TPenStyle );
      Procedure SetBorderWidth( Value: Integer );
      Procedure SetBorderColor( Value: TColor );
      Procedure SetLeftOffset( Value: LongInt );
      Procedure SetTopOffset( Value: LongInt );
      Procedure SetRightOffset( Value: LongInt );
      Procedure SetBottomOffset( Value: LongInt );

    protected
      procedure WMSize(var Message: TWMSize); message WM_SIZE;
      procedure Paint; override;
      {Alright! I lifted this from the VCL, but I did change a lot AND I didn't want
      to conflict with the old one by using the same name!}
      procedure ExpDoDrawText(var Rect: TRect; Flags: Word);

    public
      constructor Create( AOwner : TComponent ); override;

    published
      {  Now, we want to make accessable some of the previously declaired properties.
      If we don't do it here, not all of them will translate!}
      Property Align;
      Property Alignment;
      Property AutoSize;
      Property Caption;
      Property Color;
      Property Cursor;
      Property DragCursor;
      Property DragMode;
      Property Enabled;
      Property FocusControl;
      {Property Font; NO!  We *DON'T* want to have this one available!}
      Property Height;
      Property Hint;
      Property Left;
      Property Name;
      Property ParentColor;
      {Property ParentFont; This one either!}
      Property ParentShowHint;
      Property PopupMenu;
      Property ShowAccelChar;
      Property ShowHint;
      Property Tag;
      Property Top;
      Property Transparent;
      Property Visible;
      Property Width;
      Property WordWrap;
      {Now the inherited EVENTS!}
      Property OnClick;
      Property OnDblClick;
      Property OnDragDrop;
      Property OnDragOver;
      Property OnEndDrag;
      Property OnMouseDown;
      Property OnMouseMove;
      Property OnMouseUp;

      {Down here, we'll add our *NEW* properties.  The reason we supply a default
    is that if the value is equal to the default when the form is saved, it doesn't
    store anything.  But if it doesn't, it stores the value, so try to always have
    a default, but REMEMBER to address this in the constructor.}
      Property OverFontColor: TColor
               Read FOverFontColor
               Write SetOverFontColor
               Default clBlack;

      Property FontHeight: Integer
               Read FFontHeight
               Write SetFontHeight
               Default 15;

      Property FontWidth: Integer
               Read FFontWidth
               Write SetFontWidth
               Default 10;

      Property FontEscapement: Integer
               Read FEscapement
               Write SetFontEscapement
               Default 0;

      Property FontOrientation: Integer
               Read FOrientation
               Write SetFontOrientation
               Default 0;

      Property FontWeight: TExpFontWeight
               Read FFontWeight
               Write SetFontWeight
               Default fwRegular;

      Property FontItalic: Integer
               Read FItalic
               Write SetFontItalic
               Default 0;

      Property FontUnderline: Integer
               Read FUnderline
               Write SetFontUnderline
               Default 0;

      Property FontStrikeout: Integer
               Read FStrikeOut
               Write SetFontStrikeout
               Default 0;

      Property CharacterSet: TExpCharSet
               Read FCharSet
               Write SetCharSet
               Default csDefaultCharSet;

      Property OutputPrecision: TExpOutputPrecision
               Read FOutputPrecision
               Write SetOutputPrecision
               Default opOutDefaultPrecis;

      Property ClipPrecision: TExpClipPrecision
               Read FClipPrecision
               Write SetClipPrecision
               Default cpClipDefaultPrecis;

      Property FontQuality: TExpFontQuality
               Read FFontQuality
               Write SetFontQuality
               Default fqDefaultQuality;

      Property FontPitch: TExpFontPitch
               Read FFontPitch
               Write SetFontPitch
               Default fpDefaultPitch;

      Property FontFamily: TExpFontFamily
               Read FFontFamily
               Write SetFontFamily
               Default ffRoman;

      Property FontFaceName: String
               Read GetFontFaceName
               Write SetFontFaceName;

      Property Border: Boolean
               Read FBorder
               Write SetBorder
               default False;

      Property BorderStyle: TPenStyle
               Read FBorderStyle
               Write SetBorderStyle
               default psSolid;

      Property BorderWidth: Integer
               Read FBorderWidth
               Write SetBorderWidth
               default 1;

      Property BorderColor: TColor
               Read FBorderColor
               Write SetBorderColor
               default clBlack;

      Property OffsetLeft: LongInt
               Read FLeftOffset
               Write SetLeftOffset
               Default 0;

      Property OffsetTop: LongInt
               Read FTopOffset
               Write SetTopOffset
               Default 0;

      Property OffsetRight: LongInt
               Read FRightOffset
               Write SetRightOffset
               Default 0;

      Property OffsetBottom: LongInt
               Read FBottomOffset
               Write SetBottomOffset
               Default 0;

    end;

procedure Register;

implementation

constructor TJwExpLabel.Create( AOwner : TComponent );
begin
  Inherited Create( AOwner );
  ParentFont := False;
  FFontHeight := 15;
  FFontWidth := 10;
  Font.Size := FFontWidth;
  Font.Height := FFontHeight;
  FEscapement := 0;
  FOrientation := 0;
  FFontWeight := fwRegular;
  FItalic := 0;
  FUnderline := 0;
  FStrikeOut := 0;
  FCharSet := csDefaultCharSet;
  FOutputPrecision := opOutDefaultPrecis;
  FClipPrecision := cpClipDefaultPrecis;
  FFontQuality := fqDefaultQuality;
  FFontPitch := fpDefaultPitch;
  FFontFamily := ffRoman;
  FOverFontColor := clBlack;
  StrCopy( FFacename, 'Arial' );
  FBorder := False;
  FBorderStyle := psSolid;
  FBorderWidth := 1;
  FBorderColor := clBlack;
  FLeftOffset := 0;
  FTopOffset := 0;
  FRightOffset := 0;
  FBottomOffset := 0;
  AutoSize := False;
  Width := 120;
  Height := 17;
end;

{    Okay, so how did I know to do all of this stuff?  Well, I cheated.  I REALLY want to have
control over what happens when this component is painted, so rather than trust what it does, I
will override it... and rather than have to rewrite everything, I copied it right from the VCL
code....}

procedure TJwExpLabel.WMSize(var Message: TWMSize);
var
     W, H: Integer;
begin
     inherited;

     { Copy the new width and height of the component
       so we can use SetBounds to change both at once }
     W := Width;
     H := Height;

     { Code to check and adjust W and H }

     { Update the component size if we adjusted W or H }
     if (W <> Width) or (H <> Height) then
        inherited SetBounds(Left, Top, W, H);

     Message.Result := 0;
end;

procedure TJwExpLabel.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var
  Rect: TRect;
begin
  with Canvas do
  begin
    Rect := ClientRect;
    Rect.Left := Rect.Left + FLeftOffset;
    Rect.Top := Rect.Top + FTopOffset;
    Rect.Right := Rect.Right - FRightOffset;
    Rect.Bottom := Rect.Bottom - FBottomOffset;
    if not Transparent then
    begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
    end;
    Brush.Style := bsClear;
    if FBorder then
      begin
        Pen.Style := FBorderStyle;
        Pen.Width := FBorderWidth;
        Pen.Color := FBorderColor;
        Rectangle( Rect.Left, Rect.Top, Rect.Right, Rect.Bottom );
      end;
    ExpDoDrawText(Rect, (DT_EXPANDTABS or DT_WORDBREAK) or
      Alignments[Alignment]);
  end;
end;

procedure TJwExpLabel.ExpDoDrawText(var Rect: TRect; Flags: Word);
var
  Text: array[0..255] of Char;

begin
  GetTextBuf(Text, SizeOf(Text));
  if (Flags and DT_CALCRECT <> 0) and ((Text[0] = #0) or ShowAccelChar and
    (Text[0] = '&') and (Text[1] = #0)) then StrCopy(Text, ' ');
  if not ShowAccelChar then Flags := Flags or DT_NOPREFIX;
  if FEscapement > 0 then
    Flags := DT_NOCLIP;

  {Right here is where we break ranks with the old code.  We want to change the font
  to have the properties that WE set.  We'll do this in a case statement so that
  changes to the API Wont ruin our code.}

  Canvas.Font.Color := FOverFontColor;
  Canvas.Font.Handle := CreateFont(   FFontHeight,  {Height}
                                FFontWidth,  {Width}
                               FEscapement,  {Escapement}
                              FOrientation,  {Orientation}
                     PvFontWeight,           {Weight}
                                   FItalic,  {Italic}
                                FUnderline,  {Underline}
                                FStrikeOut,  {StrikeOut}
                     PvFontCharSet,          {CharSet}
                     PvFontOutPrecision,     {OutputPrecision}
                     PvFontClipPrecision,    {ClipPrecision}
                     PvFontQuality,          {Quality}
                     PvFontPitchAndFamily,   {PitchAndFamily}
                                 FFaceName );{FaceName}


  {Canvas.Font := Font;}
  if not Enabled then Canvas.Font.Color := clGrayText;
  DrawText(Canvas.Handle, Text, StrLen(Text), Rect, Flags);
end;

{*************************************************************************
       Now we deal with our accessor functions.  These will modify our
   component's properties at both design AND run time.  The main idea
   is that if you change something to do with the visual part, invalidate
   before you go on!  This is where we will also convert our Enumerated Types
   into actual usable constants.
*************************************************************************}

Procedure TJwExpLabel.SetOverFontColor( Value: TColor );
begin
  if FOverFontColor <> Value then
    begin
      FOverFontColor := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontFaceName( Value: String );
var
  OldName, TmpStr: array[0..255] of Char;
begin
  StrPCopy( TmpStr, Value );
  if StrComp( TmpStr, FFacename ) <> 0 then
    begin
      StrCopy( OldName, FFaceName );
      StrCopy( FFacename, TmpStr );
      try
        Invalidate;
      except
        { NOTE:  The possiblity of this happening isn't really big, but I wanted to
        make a point here....}
        StrCopy( FFaceName, OldName );
        Raise EExpLabelError.Create( 'Invalid font name' );
      end;
    end;
end;

Function TJwExpLabel.GetFontFaceName: String;
begin
  Result := StrPas( FFacename );
end;

Procedure TJwExpLabel.SetFontFamily( Value: TExpFontFamily );
begin
  if FFontFamily <> Value then
    begin
      FFontFamily := Value;
      { We want to clear out the old values before we add a new one. }
      PvFontPitchAndFamily := PvFontPitchAndFamily AND $0F;
      Case FFontFamily of
        ffDecorative: PvFontPitchAndFamily := PvFontPitchAndFamily + FF_DECORATIVE;
          ffDontCare: PvFontPitchAndFamily := PvFontPitchAndFamily + FF_DONTCARE;
            ffModern: PvFontPitchAndFamily := PvFontPitchAndFamily + FF_MODERN;
             ffRoman: PvFontPitchAndFamily := PvFontPitchAndFamily + FF_ROMAN;
            ffScript: PvFontPitchAndFamily := PvFontPitchAndFamily + FF_SCRIPT;
             ffSwiss: PvFontPitchAndFamily := PvFontPitchAndFamily + FF_SWISS;
      end;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontPitch( Value: TExpFontPitch );
begin
  if FFontPitch <> Value then
    begin
      FFontPitch := Value;
      { We want to clear out the old values before we add a new one. }
      PvFontPitchAndFamily := PvFontPitchAndFamily AND $F0;
      case FFontPitch of
         fpDefaultPitch: PvFontPitchAndFamily := PvFontPitchAndFamily + DEFAULT_PITCH;
           fpFixedPitch: PvFontPitchAndFamily := PvFontPitchAndFamily + FIXED_PITCH;
        fpVariablePitch: PvFontPitchAndFamily := PvFontPitchAndFamily + VARIABLE_PITCH;
      end;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontQuality( Value: TExpFontQuality );
begin
  if FFontQuality <> Value then
    begin
      FFontQuality := Value;
      case FFontQuality of
        fqDefaultQuality: PvFontQuality := DEFAULT_QUALITY;
          fqDraftQuality: PvFontQuality := DRAFT_QUALITY;
          fqProofQuality: PvFontQuality := PROOF_QUALITY;
      end;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetClipPrecision( Value: TExpClipPrecision );
begin
  if FClipPrecision <> Value then
    begin
      FClipPrecision := Value;
      case FClipPrecision of
        cpClipCharacterPrecis: PvFontClipPrecision := CLIP_CHARACTER_PRECIS;
          cpClipDefaultPrecis: PvFontClipPrecision := CLIP_DEFAULT_PRECIS;
            cpClipEncapsulate: PvFontClipPrecision := CLIP_EMBEDDED;
               cpClipLHAngles: PvFontClipPrecision := CLIP_LH_ANGLES;
                   cpClipMask: PvFontClipPrecision := CLIP_MASK;
           cpClipStrokePrecis: PvFontClipPrecision := CLIP_STROKE_PRECIS;
               cpClipTTAlways: PvFontClipPrecision := CLIP_TT_ALWAYS;
      end;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetOutputPrecision( Value: TExpOutputPrecision );
begin
  if FOutputPrecision <> Value then
    begin
      FOutputPrecision := Value;
      case FOutputPrecision of
        opOutCharacterPrecis: PvFontOutPrecision := OUT_CHARACTER_PRECIS;
          opOutDefaultPrecis: PvFontOutPrecision := OUT_DEFAULT_PRECIS;
           opOutDevicePrecis: PvFontOutPrecision := OUT_DEVICE_PRECIS;
           opOutRasterPrecis: PvFontOutPrecision := OUT_RASTER_PRECIS;
           opOutStringPrecis: PvFontOutPrecision := OUT_STRING_PRECIS;
           opOutStrokePrecis: PvFontOutPrecision := OUT_STROKE_PRECIS;
               opOutTTPrecis: PvFontOutPrecision := OUT_TT_PRECIS;
      end;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetCharSet( Value: TExpCharSet );
begin
  if FCharSet <> Value then
    begin
      FCharSet := Value;
      case FCharSet of
            csAnsiCharSet: PvFontCharSet := ANSI_CHARSET;
         csDefaultCharSet: PvFontCharSet := DEFAULT_CHARSET;
          csSymbolCharSet: PvFontCharSet := SYMBOL_CHARSET;
        csShiftJisCharSet: PvFontCharSet := SHIFTJIS_CHARSET;
             csOemCharSet: PvFontCharSet := OEM_CHARSET;
      end;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontStrikeout( Value: Integer );
begin
  if FStrikeOut <> Value then
    begin
      FStrikeOut := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontUnderline( Value: Integer );
begin
  if FUnderline <> Value then
    begin
      FUnderline := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontItalic( Value: Integer );
begin
  if FItalic <> Value then
    begin
      FItalic := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontWeight( Value: TExpFontWeight );
begin
  if FFontWeight <> Value then
    begin
      FFontWeight := Value;
      Case FFontWeight of
        fwDontCare: PvFontWeight := FW_DONTCARE;
            fwThin: PvFontWeight := FW_THIN;
      fwExtraLight: PvFontWeight := FW_EXTRALIGHT;
      fwUltraLight: PvFontWeight := FW_ULTRALIGHT;
           fwLight: PvFontWeight := FW_LIGHT;
          fwNormal: PvFontWeight := FW_NORMAL;
         fwRegular: PvFontWeight := FW_REGULAR;
          fwMedium: PvFontWeight := FW_MEDIUM;
        fwSemiBold: PvFontWeight := FW_SEMIBOLD;
        fwDemiBold: PvFontWeight := FW_DEMIBOLD;
            fwBold: PvFontWeight := FW_BOLD;
       fwExtraBold: PvFontWeight := FW_EXTRABOLD;
       fwUltraBold: PvFontWeight := FW_ULTRABOLD;
           fwBlack: PvFontWeight := FW_BLACK;
           fwHeavy: PvFontWeight := FW_HEAVY;
       end;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontOrientation( Value: Integer );
begin
  if FOrientation <> Value then
    begin
      FOrientation := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontEscapement( Value: Integer );
begin
  if FEscapement <> Value then
    begin
      FEscapement := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontWidth( Value: Integer );
begin
  if FFontWidth <> Value then
    begin
      FFontWidth := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetFontHeight( Value: Integer );
begin
  if FFontHeight <> Value then
    begin
      FFontHeight := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetBorder( Value: Boolean );
begin
  if FBorder <> Value then
    begin
      FBorder := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetBorderStyle( Value: TPenStyle );
begin
  if FBorderStyle <> Value then
    begin
      FBorderStyle := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetBorderWidth( Value: Integer );
begin
  if FBorderWidth <> Value then
    begin
      FBorderWidth := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetBorderColor( Value: TColor );
begin
  if FBorderColor <> Value then
    begin
      FBorderColor := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetLeftOffset( Value: LongInt );
begin
  if FLeftOffset <> Value then
    begin
      FLeftOffset := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetTopOffset( Value: LongInt );
begin
  if FTopOffset <> Value then
    begin
      FTopOffset := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetRightOffset( Value: LongInt );
begin
  if FRightOffset <> Value then
    begin
      FRightOffset := Value;
      InValidate;
    end;
end;

Procedure TJwExpLabel.SetBottomOffset( Value: LongInt );
begin
  if FBottomOffset <> Value then
    begin
      FBottomOffset := Value;
      InValidate;
    end;
end;

{  Don't forget the Register function!  Nothing can be done withou}

procedure Register;
begin
  RegisterComponents( 'JwTools', [ TJwExpLabel ] );
end;

end.
