/*===========================================================================
SOLAR v0.95.1 :: Common module options.c

This source code has been placed into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
08/30/94 KJH  Made a common module. Fixed some code in subscribe and
              unsubscribe functions.
===========================================================================*/

#include <stdio.h>
#include <string.h>
#include <dir.h>
#include "..\common\yesno.h"

#define NEWSRC           "NEWSRC.SLR"
#define OPTIONS_NAME    "OPTIONS.SLR"
#define ONCE                        2

extern enum SOUP_Types { u, M, m, n, C, c, i, b, B };  /* Supported types */

/* External Data */
extern int  verbose;
extern char _slrerr[80];
extern char user_path[MAXPATH];                   /* From config.c  */

extern int  send_list;                            /* From config.c  */
extern int  send_mail;                            /* From config.c  */
extern int  delete_mail;                          /* From config.c  */
extern int  news_index;                           /* From config.c  */
extern int  news_type;                            /* From config.c  */
extern int  mail_type;                            /* From config.c  */
extern int  use_wafjoin;                          /* From config.c  */
extern char compress[10];                         /* From config.c  */
extern char protocol[10];                         /* From config.c  */

/*
 * Function: int write_options()
 * Purpose : Save current user options to user options file.
 * Return  : 0 on success, 1 otherwise.
*/

int write_options()
{
  char path[MAXPATH];
  FILE *options_file = NULL;

	strcpy(path,user_path);
  strcat(path,"\\");
  strcat(path,OPTIONS_NAME);

  if ((options_file = fopen(path,"wt")) == NULL)
  {
    sprintf(_slrerr,"error opening %s for write",path);
    goto ErrorExit;
  }
  fprintf(options_file,"send-mail=");
  switch (send_mail) {
    case YES  : fprintf(options_file,"YES\n"); break;
    case NO   : fprintf(options_file,"NO\n"); break;
  }
  fprintf(options_file,"mail-type=");
  switch (mail_type) {
    case m    : fprintf(options_file,"m\n"); break;
    case M    : fprintf(options_file,"M\n"); break;
    case b    : fprintf(options_file,"b\n"); break;
  }
  fprintf(options_file,"delete-mail=");
  switch (delete_mail) {
    case YES  : fprintf(options_file,"YES\n"); break;
    case NO   : fprintf(options_file,"NO\n"); break;
  }
  fprintf(options_file,"send-list=");
  switch (send_list) {
    case YES  : fprintf(options_file,"YES\n"); break;
    case NO   : fprintf(options_file,"NO\n"); break;
    case ONCE : fprintf(options_file,"ONCE\n"); break;
  }
  fprintf(options_file,"news-index=");
  switch (news_index) {
    case n    : fprintf(options_file,"n\n"); break;
    case C    : fprintf(options_file,"C\n"); break;
    case c    : fprintf(options_file,"c\n"); break;
  }
  fprintf(options_file,"news-type=");
  switch (news_type) {
    case u    : fprintf(options_file,"u\n"); break;
    case i    : fprintf(options_file,"i\n"); break;
    case B    : fprintf(options_file,"B\n"); break;
  }
  fprintf(options_file,"use-wafjoin=");
  switch (use_wafjoin) {
    case YES  : fprintf(options_file,"YES\n"); break;
    case NO   : fprintf(options_file,"NO\n"); break;
  }
  fprintf(options_file,"compress=%s\n",compress);
  fprintf(options_file,"protocol=%s\n",protocol);

  fclose(options_file);
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: int set_send_list(char *token);
 * Purpose : Set the value for send_list
 * Return  : Zero on success, non-zero on error and set _slrerr.
*/

int set_send_list(char *token)
{
  if (token[0] == '\0')
  {
    send_list = ONCE;
  }
  else
  {
    if ((stricmp(token,"ALWAYS") == 0) || (stricmp(token,"y") == 0))
    {
      send_list = YES;
    }
    else
    {
      if ((stricmp(token,"NEVER") == 0) || (stricmp(token,"n") == 0))
      {
        send_list = NO;
      }
      else
      {
        sprintf(_slrerr,"set_send_list(): Bad value for send-list - %s",token);
        goto ErrorExit;
      }
    }
  }
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: int set_send_mail(char *token)
 * Purpose : Set value of send_mail
 * Return  : Zero on success, non-zero on error and set _slrerr.
*/

int set_send_mail(char *token)
{
  if (stricmp(token,"y") == 0)
  {
    send_mail = YES;
  }
  else
  {
    if (stricmp(token,"n") == 0)
    {
      send_mail = NO;
    }
    else
    {
      sprintf(_slrerr,"set_send_mail(): Bad value for send_mail - %s",token);
      goto ErrorExit;
    }
  }
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: int set_delete_mail(char *token)
 * Purpose : Set value of delete_mail
 * Return  : Zero on success, non-zero on error and set _slrerr.
*/

int set_delete_mail(char *token)
{
  if (stricmp(token,"y") == 0)
  {
    delete_mail = YES;
  }
  else
  {
    if (stricmp(token,"n") == 0)
    {
      delete_mail = NO;
    }
    else
    {
      sprintf(_slrerr,"set_delete_mail(): Bad value for delete-mail - %s",token);
      goto ErrorExit;
    }
  }
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: int set_news_index(char *token);
 * Purpose : Set the value for news_index
 * Return  : Zero on success, non-zero on error and set _slrerr.
*/

int set_news_index(char *token)
{
  if (token[0] == 'c')
  {
    news_index = c;
  }
  else
  {
    if (token[0] == 'C')
    {
      news_index = C;
    }
    else
    {
      if (token[0] == 'n')
      {
        news_index = n;
      }
      else
      {
        sprintf(_slrerr,"set_news_index(): Bad value for news-index - %s",token);
        goto ErrorExit;
      }
    }
  }
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: int set_mail_type(char *token)
 * Purpose : Set value of mail_type
 * Return  : Zero on success, non-zero on error and set _slrerr.
*/

int set_mail_type(char *token)
{
  if (strcmp(token,"m") == 0)
  {
    mail_type = m;
  }
  else
  {
    if (strcmp(token,"M") == 0)
    {
      mail_type = M;
    }
    else
    {
      if (strcmp(token,"b") == 0)
      {
        mail_type = b;
      }
      else
      {
        sprintf(_slrerr,"set_mail_type(): Bad value for mail-type - %s",token);
        goto ErrorExit;
      }
    }
  }
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: int set_news_type(char *token);
 * Purpose : Set the value for news_type
 * Return  : Zero on success, non-zero on error and set _slrerr.
*/

int set_news_type(char *token)
{
  if (token[0] == 'u')
  {
    news_type = u;
  }
  else
  {
    if (token[0] == 'i')
    {
      news_type = i;
    }
    else
    {
      if (token[0] == 'B')
      {
        news_type = B;
      }
      else
      {
        sprintf(_slrerr,"set_news_type(): Bad value for news-index - %s",token);
        goto ErrorExit;
      }
    }
  }
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
 * Function: solar_settings()
 * Purpose : Display the current user options for Solar.
 * Return  : N/A
*/

void solar_settings()
{
  RPrintf("\n");
  RPrintf("Include mail in packet    : ");
  switch (send_mail) {
    case YES : RPrintf("YES\n"); break;
    case NO  : RPrintf("NO\n"); break;
	}
  RPrintf("Mail message format       : ");
  switch (mail_type) {
    case m   : RPrintf("Unix Format\n"); break;
    case M   : RPrintf("MMDF Format\n"); break;
    case b   : RPrintf("8-bit binary\n"); break;
  }
  RPrintf("Delete mail after transfer: ");
  switch (delete_mail) {
    case YES : RPrintf("YES\n"); break;
    case NO  : RPrintf("NO\n"); break;
	}
  RPrintf("News header file format   : ");
  switch (news_index) {
    case n   : RPrintf("No Headers\n"); break;
    case C   : RPrintf("Partial C-news Format\n"); break;
    case c   : RPrintf("Full C-news Format\n"); break;
	}
  RPrintf("News message file format  : ");
  switch (news_type) {
    case u   : RPrintf("USENET Format\n"); break;
    case i   : RPrintf("Index Files Only\n"); break;
    case B   : RPrintf("8-bit binary\n"); break;
  }
  RPrintf("Include msg area list     : ");
  switch (send_list) {
    case YES : RPrintf("YES\n"); break;
    case NO  : RPrintf("NO\n"); break;
	}

	RPrintf("Subscription file         : ");
	switch (use_wafjoin) {
    case YES : RPrintf("JOIN\n"); break;
		case NO  : RPrintf("%s\n",NEWSRC); break;
	}

	RPrintf("Compression method        : %s\n", compress);
  RPrintf("Transfer protocol         : %s\n", protocol);

  RPrintf("\n");
  return;
}

