#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <time.h>
#include <sys/stat.h>
#include "crc32.h"

/* note: time.h and sys/stat.h are only needed for size, time and date */

#define BUFFER 49152
#define BUF     8192
#define TBUF   16
#define FA_ANY (FA_ARCH | FA_RDONLY | FA_HIDDEN | FA_SYSTEM)

char buffer[BUFFER];  /* buffer for file, assigned with setvbuf() */
char buf[BUF];        /* buffer for reads */
char *title = "Valid8 version 1.00 Copyleft (c) Dave Conrad 1994. No rights reserved.\n";

/* findval() calculates validate code of an open file, returns error status */
int findval(FILE *fp, unsigned long *val)
{
  size_t size;

  *val = INITCRC;
  for (; !feof(fp) && !ferror(fp); *val = addbfcrc(buf,size,*val))
    size = fread(buf, sizeof(char), BUF, fp);
  return ferror(fp);
}

int main(int argc, char *argv[])
{
  unsigned long val, files = 0L;  /* validate code, number of files */
  FILE *fp;                       /* the file being validated */
  int i, error;                   /* counter for args, error indicator */
  struct tm *tm;                  /* for the file time and date */
  struct stat st;                 /* for the time, date and size */
  struct ffblk s;                 /* for searching directories */
  char tbuf[TBUF];                /* time buffer, ascii */
  char curdir[MAXPATH];           /* current directory (with drive letter) */
  char spec[MAXPATH];             /* specfied (by user) directory */
  char path[MAXPATH], name[MAXPATH],  /* variables for handling filenames */
       drive[MAXDRIVE], dir[MAXDIR], file[MAXFILE], ext[MAXEXT];

  fputs (title, stderr);
  if (argc < 2 || !strcmp(argv[1], "-h")) {
    fputs ("\n\
Usage: VALID8  [drive:][path][filename]\n\
Note:  Wildcards are allowed.\n", stderr);
    return 0;
  }
  getcwd(curdir, MAXPATH);
  /* for all arguments on the command line, do this */
  for (i = 1; i < argc; i++) {
    /* convert to upper case, split into parts, put drive+dir into path */
    strupr(argv[i]);
    fnsplit(argv[i], drive, dir, file, ext);
    strcat(strcpy(path,drive),dir);
    /* show path being valid8ed */
    strcpy(spec, path);
    if (strlen(spec)
        && spec[strlen(spec)-1] == '\\'
        && strlen(spec) != 1
        && spec[strlen(spec)-2] != ':')
      spec[strlen(spec)-1] = 0;
    printf("%sDirectory of %s\n\n", i>1 ? "\n" : "", spec[0] ? spec : curdir);
    /* find all files matching current argument */
    error = findfirst(argv[i], &s, FA_ANY);
    while (!error) {
      strcat(strcpy(name,path),s.ff_name);
      if ((fp = fopen(name,"rb")) == NULL)
        fprintf(stderr, "valid8: error opening file %s\n", name);
      else {
        setvbuf(fp, buffer, _IOFBF, BUFFER);
        /* findval() calculates the crc of the open file */
        if (findval(fp, &val))
          fprintf(stderr, "valid8: error reading file %s\n", name);
        /* fstat() gets the size, date and time (among other things) */
        if (fstat(fileno(fp), &st))
          fprintf(stderr, "valid8: error reading file %s\n", name);
        /* convert to struct tm */
        tm = localtime(&st.st_mtime);
        /* split the name into filename and extension */
        fnsplit(name, drive, dir, file, ext);
        if (ext[0] == '.') strcpy(ext, ext+1);
        /* display name, extension and size */
        printf("%-8s %-3s %9ld  ", file, ext, st.st_size);
        /* display date and time */
        strftime(tbuf, TBUF, "%m-%d-%y  %I:%M", tm);
        if (tbuf[10] == '0') tbuf[10] = ' ';
        printf("%s%s   ", tbuf, tm->tm_hour < 12 ? "a" : "p");
        /* display 32-bit crc as two 16-bit values */
        printf("%04lX   %04lX\n", val >> 16, val & 0xffff);
        ++files; /* keep track of number of files */
        if (fclose(fp))
          fprintf(stderr, "valid8: error reading file %s\n", name);
      }
      error = findnext(&s);
    }
  }
  printf("\n\t%d file(s) were valid8ed\n", files);
  return 0;
}
