	title "Replace LineFeed or Carriage Return with CR/LF."

filefix	segment
	assume ds:filefix,ss:filefix,cs:filefix,es:filefix

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Buffer Data Base.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
filfcb		equ 05ch

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Data Base Fix.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
filefix_start:

	push cs
	pop ds				;insure ds same as cs.
	xor si,si
	mov ch,40
	mov bx,offset filfcb
filefix_04:
	mov al,byte ptr es:[bx]		;copy file control block
	mov byte ptr inputfcb[si],al
	inc bx
	inc si
	dec ch
	jnz filefix_04

	push ds
	pop es				;set es:
	mov si,9
filefix_08:
	mov al,byte ptr inputfcb-1[si]
	mov byte ptr outputfcb-1[si],al
	dec si
	jnz filefix_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  attempt file open.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	mov ah,15
	mov dx,offset inputfcb
	mov word ptr inputfcb+33,0	;set record address to zero.
	int 21h				;open file
	cmp al,-1			;file available ?
	jz dos_exit_cancel		;no -->

	mov ah,22
	mov dx,offset outputfcb
	mov word ptr outputfcb+33,0	;set record address to zero.
	int 21h				;create output file
	cmp al,-1			;file available ?
	jz dos_exit_cancel		;no -->

	mov byte ptr inputbuffer-1,-1
	mov word ptr outputbuffer-2,0
	jmp short filefix_20

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Exit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
dos_exit_cancel:
	mov ax,offset 4c00h
	int 21h

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  read characters...
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
filefix_20:
	call filefix_getcharacter
	jc filefix_40			;if all done -->
	cmp al,"Q"-40h
	jz filefix_20			;ignore ctl-Q -->
	cmp al,"S"-40h
	jz filefix_20			;ignore ctl-S -->
	cmp al,"M"-40h
	jz filefix_24			;ignore ctl-m -->
	cmp al,"J"-40h
	jz filefix_24			;ignore ctl-j -->

	call filefix_storecharacter
	jmp filefix_20

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  fix end of line.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
filefix_24:
	call filefix_getcharacter
	cmp al,"Q"-40h
	jz filefix_24			;ignore ctl-Q -->
	cmp al,"S"-40h
	jz filefix_24			;ignore ctl-S -->
	cmp al,"M"-40h
	jz filefix_24			;ignore ctl-m -->
	cmp al,"J"-40h
	jz filefix_24			;ignore ctl-j -->

	push ax
	mov al,"M"-40h
	call filefix_storecharacter
	mov al,"J"-40h
	call filefix_storecharacter
	pop ax
	call filefix_storecharacter
	jmp filefix_20

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  all done.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
filefix_40:
	mov al,"M"-40h
	call filefix_storecharacter
	mov al,"J"-40h
	call filefix_storecharacter
	mov al,"Z"-40h
	call filefix_storecharacter

	call filefix_writebuffer

	mov ah,16
	mov dx,offset outputfcb
	int 21h				;close write file.

	mov ah,19
	mov dx,offset inputfcb
	int 21h				;delete old (input) file.

	mov si,offset 11
filefix_44:
	mov al,byte ptr inputfcb[si]
	mov byte ptr outputfcb+16[si],al
	dec si
	jnz filefix_44

	mov ah,23
	mov dx,offset outputfcb
	int 21h
	jmp dos_exit_cancel

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  get character from InputBuffer.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
filefix_getcharacter:
	mov al,byte ptr inputbuffer-1
	cmp al,-1			;buffer empty (non-init) ?
	jnz filefix_get_04		;no, go get character -->
	call filefix_readrecord

filefix_get_04:
	xor bx,bx
	mov bl,byte ptr inputbuffer-1
	mov al,byte ptr inputbuffer[bx]
	cmp al,"Z"-40h			;control Z ?
	stc				;yes, set flag
	jz filefix_get_ret		;don't do another read -->

	inc byte ptr inputbuffer-1
	cmp bl,127
	jnz filefix_get_08		;exit -->
	push ax
	call filefix_readrecord
	pop ax

filefix_get_08:
	or al,al

filefix_get_ret:
	ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Read File
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
filefix_readrecord:
	mov ah,26
	mov dx,offset inputbuffer
	int 21h
	mov ah,20
	mov dx,offset inputfcb
	int 21h
	or al,al
	jz filefix_readrecord_08
	dec al				;error code 1 ?
	jz filefix_readrecord_06	;yes, entire record at end of file -->

	mov bx,offset 128

filefix_readrecord_04:
	or bx,bx
	jz filefix_readrecord_08
	dec bx
	mov al,byte ptr inputbuffer-1[bx]
	or al,al
	jnz filefix_readrecord_08
	mov byte ptr inputbuffer-1[bx],"Z"-40h
	jmp filefix_readrecord_04

filefix_readrecord_06:
	mov byte ptr inputbuffer,"Z"-40h

filefix_readrecord_08:
	inc word ptr inputfcb+33
	mov byte ptr inputbuffer-1,0
	ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Store Character.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
filefix_storecharacter:
	push ax
	mov ah,"Z"-40h			;automatically patch end of file
	mov bx,word ptr outputbuffer-2
	mov word ptr outputbuffer[bx],ax;store character(s)
	inc word ptr outputbuffer-2

	cmp bx,offset 128*128-1		;sixteen K?
	jnz filefix_storecharacter_08
	call filefix_writebuffer

filefix_storecharacter_08:
	pop ax
	ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  output buffer (may be partially filled).
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
filefix_writebuffer:
	mov ax,word ptr outputbuffer-2
	or ax,ax			;anything to write ?
	jz filefix_writebuffer_return	;no -->

	mov dx,offset outputbuffer

filefix_writebuffer_04:
	push dx
	mov ah,26
	int 21h

	mov ah,34
	mov dx,offset outputfcb
	int 21h
	inc word ptr outputfcb+33
	pop dx
	add dx,offset 128
	sub word ptr outputbuffer-2,128
	jz filefix_writebuffer_return
	cmp word ptr outputbuffer-2,128
	jnc filefix_writebuffer_04

	mov word ptr outputbuffer-2,128
	jmp filefix_writebuffer_04

filefix_writebuffer_return:
	mov word ptr outputbuffer-2,0
	ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Buffer Data Base.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
inputfcb:	db 40 dup(0)
outputfcb:	db 0,"________$$$",30 dup(0)

		db -1
inputbuffer:	db 128 dup(0)

		dw 0
outputbuffer:	db 128 dup(0)		;actually, goes for many K...

filefix	ends
	end filefix_start

