#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define TRUE 1
#define FALSE 0

long int lno=0;
FILE *fi,*fo1,*fo2,*fopen();
unsigned char *ptr,*wds,*front,*means[100],*tests[100],instr[512];

int notests,nostr,j,f1act,f2act,i;

main(argc,argv)
int argc;
char **argv;
{
	int argk;
	register char **p;
	argk = argc;
	if (argk < 3)
	{
		printf("usage: esplit fni fno-dict fno-names\n\n ");
		printf("ESPLIT takes as its input an _edict_ Japanese Dictionary file\n ");
		printf("and produces from it two files; one containing _proper-name_\n ");
		printf("entries, and the other _normal_ entries.\n\n ");
		printf("   fni - input file name\n ");
		printf("   fno-dict - output file for normal entries\n ");
		printf("   fno-names - output file for proper-name entries\n ");
		exit(0);
	}
	p=argv;
	p++;
	--argk;
	fi= fopen(*p,"r");
	if (fi == NULL)
	{
		printf("\nCannot open %s\n",*p);
		exit(0);
	}
	p++;
	fo1 = fopen(*p,"w");
	if(fo1 == NULL)
	{
		printf("open of %s failed\n",*p);
		exit(0);
	}
	p++;
	fo2 = fopen(*p,"w");
	if(fo2 == NULL)
	{
		printf("open of %s failed\n",*p);
		exit(0);
	}
	wds = (unsigned char *)"pn) pn, pl) pl,";
	ptr = (unsigned char *)strtok(wds," ");
	for(notests = 0;notests<100;notests++)
	{
		tests[notests] = ptr;
		ptr = (unsigned char *)strtok(NULL," ");
		if(ptr == NULL) break;
	}

	while (feof(fi) != TRUE)
	{
		fgets (instr,511,fi);
		if(feof(fi)) break;
		if((++lno % 10) == 0)printf("Line: %ld\r",lno);
		if(instr[strlen(instr)-1] < 0x20) instr[strlen(instr)-1] = 0;
		front = (unsigned char *)strtok(instr,"/");
		ptr = (unsigned char *)strtok(NULL,"/");
		for(nostr = 0;nostr<100;nostr++)
		{
			means[nostr] = ptr;
			ptr = (unsigned char *)strtok(NULL,"/");
			if (ptr == NULL) break;
		}
		f1act = FALSE;
		f2act = FALSE;
		for(i=0;i<=nostr;i++)
		{
			for(j=0;j<=notests;j++)
			{
				if(strstr(means[i],tests[j]) != NULL)
				{
					if(!f2act)
					{
						f2act = TRUE;
						fprintf(fo2,"%s/",front);
					}
					fprintf(fo2,"%s/",means[i]);
					break;
				}
				if(j == notests)
				{
					if(!f1act)
					{
						f1act = TRUE;
						fprintf(fo1,"%s/",front);
					}
					fprintf(fo1,"%s/",means[i]);
				}
			}
		}
		if(f1act) fprintf(fo1,"\n");
		if(f2act) fprintf(fo2,"\n");
	}
	fclose(fi);
	fclose(fo1);
	fclose(fo2);
}
