{$R-,S-,I+,D-,F-,V-,B-,N-,L+ }
{$M 4096,0,0 }
PROGRAM UpConv;
USES Crt,
     Dos;
{
 Original based on a bulletin board program by Jeff Firestone
 This version based on a program by Douglas S. Stivison in his book:
     'Turbo Pascal Library' published by Sybex.

  v1.4, Thanks to

      Radiometer Analytical A/S
      Krogshojvej 49
      DK-2880 Bagsvaerd
      Denmark

    - Spelling corrected. More words added: Turbo 5.5.

  Niels Kristian Jensen, 1990.

  v1.3, Lyngby, Denmark Dec 1988.
    - Bugs corrected:
      Screen left hilighted. TurboPas 3 bug??
      Counted lines incorrectly.
      Quoted strings in "(* ... *)" comments could cause trouble.
      The prog didn't issue INT $28's when waiting. INT $28 is needed to
      make DOS PRINT work. INT $28 should ALLWAYS ALLLWAAYS be used instead
      of 'busy waiting'. (INT $28 is DOS idle interrupt)

    Added features:
    "/F" switch:
       Every identifier is spelled like the first time it appers in the file.
       Units & include files not supported.

       More words added.

    Comment:
       Downloaded from TRICKLE AT DKTC11 (BITNET), thanks to TURGUT AT TREARN

    Niels Kristian Jensen & Lars Riemer,
    Technical Uni of Denmark.
    MSTCOM@NEUVM1.BITNET

  v1.2, Toad Hall, 12 Oct 88
    - Bug in Scan_Till procedure.  Fixed.
    - Isn't leaving quoted strings alone.  Fixed.

  v1.1 Toad Hall Tweak, Sep 88
    - Added command line filename input.
    - Moved Identifier char set to a global typed constant.
    - Changed simple Reserved Word uppercasing to include Turbo Pascal
      formatted reserved words.
    - Added more reserved words for Turbo Pascal.  (Complete thru v3.0,
      I think .. don't have 4.0, so that should be added.)
    - Command line switch ('-U') to force all reserved words to uppercase
      (e.g., ignore Turbo Pascal format).
    - Considering how to change other text (non-quoted, non-comments)
      to all-upper, all-lower, As-Is, like PFORMAT.PAS does.
    - Still suspect a fancy hash procedure to confirm a RamWord as a
      reserved word would be better than this "if word is in line"
      business.  Later.
  One peculiarity about the comment-handling:  Anything within the usual
  '}{' comments is skipped over; anything within the "parenthesis asterisk"
  type comment IS processed!  So .. put real comments within '}{' comments,
  and commented-out code within the '(* *)' type comments.

  v1.0
    - Found in SIMTEL20's PD1:<MSDOS.TURBOPAS>UPCONV.ARC.
      Original author unknown.

  David Kirschbaum
  Toad Hall
  kirsch@braggvax.ARPA
}


CONST

  NRLINES = 380;
  CHLIN   = 80;
  PrgNam = 'UpConv v1.4';
  ReservedWords : ARRAY[1..NRLINES] OF STRING[CHLIN] = (

{ These words are NOT in any special order. They are alphabetized just to look
neat. Not all of the words below are "reserved", some are standard functions or
procedures. The words in UPPER are reserved words. }

' Abs ABSOLUTE Addr AND Append Arc ArcTan ARRAY Assign AssignCrt Aux AuxIn ',
' AuxInPtr AuxOutPtr Bar Bar3D BEGIN BlockRead BlockWrite Boolean BufLen Byte ',
' CASE Chain Char ChDir Chr Circle ClearDevice ClearViewPort Close CloseGraph ',
' ClrEol ClrScr Con Concat ConIn ConInPtr ConOut ConOutPtr CONST ConstPtr ',
' CONSTRUCTOR ',
' Copy Cos CrtExit CrtInit CSeg Dec Delay Delete DelLine DESTRUCTOR ',
' DetectGraph DiskFree ',
' DiskSize Dispose DIV DO DosExitCode DosVersion DOWNTO Draw DSeg Ellipse ',
' ELSE END EnvCount EnvStr Eof Eoln Erase Exec Execute Exit Exp EXTERNAL ',
' False FExpand FILE FilePos FileSize FillChar FillPoly FindFirst FindNext ',
' FloodFill Flush FOR FORWARD Frac FreeMem FSplit FUNCTION GetArcCoords ',
' GetAspectRatio GetBKcolor GetCBreak GetColor GetDate GetDir GetEnv GetFAttr ',
' GetFillSettings GetFTime GetGraphMode GetImage GetIntVec GetLineSettings ',
' GetMaxX GetMaxY GetMem GetPalette GetPixel GetTextSettings GetTime ',
' GetVerify GetViewSettings GetX GetY GOTO GotoXY GraphErrorMsg GraphMode ',
' GraphResult GraphWindow Halt HeapStr Hi HiRes HiResColor HighVideo IF ',
' ImageSize IMPLEMENTATION IN Inc InitGraph INLINE Input Insert InsLine Int ',
' Integer INTERFACE INTERRUPT Intr IOResult Kbd Keep KeyPressed LABEL ',
' Length Line LineRel LineTo LN Lo LongFilePos LongFileSize LongSeek LowVideo ',
' Lst LstOut LstOutPtr Mark MaxAvail MaxInt Mem MemAvail MemW MkDir MOD Move ',
' MoveTo MSDos New NIL NormVideo NoSound NOT OBJECT Odd OF Ofs OR Ord Output ',
' OutText ',
' OutTextXY OvrPath PACKED PackTime Palette ParamCount ParamStr Pi PieSlice ',
' Plot Port PortW Pos Pred PROCEDURE PROGRAM Ptr PutImage PutPixel Random ',
' Randomize Read ReadKey ReadLn Real RECORD Rectangle Release Rename REPEAT ',
' Reset RestoreCrtMode Rewrite RmDir Round Seek SeekEof SeekEoln Seg SET ',
' SetActivePage SetAllPalette SetAspectRatio SetBKColor SetCBreak SetColor ',
' SetFAttr SetFillPattern SetFillStyle SetFTime SetGraphMode SetIntVec ',
' SetLineStyle SetPalette SetTextBuf SetTextJustify SetTextStyle SHL SetTime ',
' SetVerify SetViewPort SetVisualPage SHR Sin SizeOf Sound SPtr Sqr Sqrt SSeg ',
' Str STRING Succ Text TextBackGround TextColor TextHeight TextMode TextWidth ',
' THEN ',
' TO Trm True Trunc Truncate TYPE unError UNIT UnpackTime UNTIL USES UpCase ',
' Usr UsrIn UsrInPtr UsrOut UsrOutPtr Val VAR WhereX WhereY WHILE Window WITH ',
' Wrap Write WriteLn XOR ',

{   Some Turbo Pascal "Constants"  }
' Black Blue Green Cyan Red Magenta Brown LightGray DarkGray LightBlue ',
' LightGreen LightCyan LightRed LightMagenta Yellow White BW40 C40 BW80 C80 ',

{ You may enable the additional words below if you're using them.
   Be sure to adjust the constant NRLINES above to include them,
   and fix up the line ends.
   (E.g., add a comma after the "C80 '" above, move the ");" down to below
    your last line.)
}

{   Extended Graphics (from GRAPH.P). }
(*
' ColorTable Arc Circle GetPic PutPic '
' GetDotColor FillPattern FillScreen FillShape Pattern ',
*)

{  Turtle stuff (Tuborg 3.0)}
(*
' Back ClearScreen Forwd Heading HideTurtle Home NoWrap PenUp PenDown '
' SetHeading SetPenColor SetPosition ShowTurtle TurnLeft TurnRight',
' TurtleDelay TurtleThere TurtleWindow Wrap Xcor Ycor',
*)

{ There's also CP/M stuff, like BDOS .. you CP/M'ers insert that. }

'','','','','','','', {40}
'','','','','','','','','','','','','','','','','','','','', {60}
'','','','','','','','','','','','','','','','','','','','', {80}
'','','','','','','','','','','','','','','','','','','','', {100}

'','','','','','','','','','','','','','','','','','','','', {20}
'','','','','','','','','','','','','','','','','','','','', {40}
'','','','','','','','','','','','','','','','','','','','', {60}
'','','','','','','','','','','','','','','','','','','','', {80}
'','','','','','','','','','','','','','','','','','','','', {200}

'','','','','','','','','','','','','','','','','','','','', {20}
'','','','','','','','','','','','','','','','','','','','', {40}
'','','','','','','','','','','','','','','','','','','','', {60}
'','','','','','','','','','','','','','','','','','','','', {80}
'','','','','','','','','','','','','','','','','','','','', {300}

'','','','','','','','','','','','','','','','','','','','', {20}
'','','','','','','','','','','','','','','','','','','','', {40}
'','','','','','','','','','','','','','','','','','','','', {60}
'','','','','','','','','','','','','','','',''); {380}


  APOS          = #39;            {This is the ' symbol.}
  OPENCOMMENT   = '{';
  CLOSECOMMENT  = '}';

TYPE
  StrChLin  = STRING[CHLIN];
  Str255    = STRING [255];

CONST
   {Note: These are the only valid characters that can be used in Turbo
    identifiers.}
  Identifier : SET OF Char = ['A'..'Z', '0'..'9', '_'];

VAR
  LinUse,                     {Last line used in ReservedWords and}
                              {UCReserved}
  CharPsn,
  LineNum    : Integer;
  SpFirst,                    {TRUE = identifiers spelled as first time}
  AllUpper,                   {if TRUE, all reserved words uppercased}
  Lazy,                       {That's right! (read help)}
  FileOutput : Boolean;       {true if output file isn't "CON:"}
  UcWord,                     {possible keyword, uppercased}
  Padded     : StrChLin;      {UcWord, padded with spaces}

  ProgLine   : Str255;
  RamWord    : StrChLin;
  InputFile,
  OutputFile : Text;
  UCReserved : ARRAY[1..NRLINES] OF StrChLin;  {uppercased reserved word lines}
  Regs       : Registers;     {For Idle interrupts, archeologists (3.0-users)
                               should define their own "registers" recordtype.}


FUNCTION Uc(S : Str255) : Str255;
VAR i : Byte;
BEGIN
  FOR i := 1 TO Length(S) DO S[i] := UpCase(S[i]);
  Uc := S;
END;  {of Uc}


PROCEDURE Usage;
  {Give user help, terminate.
   Happens on cmd line of '?', '-?', '/?', '-h', '/h'
  }
BEGIN
  WriteLn(
PrgNam,' - Convert Pascal reserved words to uppercase and');
  WriteLn(
'convert Turbo Pascal predefined words to Borland style; or spell all');
  WriteLn(
'identifiers as the first time they appear.');
  WriteLn;
  WriteLn(
'Usage:  UpConv [-|/[?|H|U|F|L]] file1[.typ] [file2.typ]');
  WriteLn;
  WriteLn(
'where the switches -U or /U will upcase the Borland reserved words too.');
  WriteLn(
'The switches -F or /F will use first spelling for all identifiers.');
  WriteLn(
'The /L switch will spell reserved words in uppercase, standard identifiers');
  WriteLn(
'in Borland style and any other identifiers like the first occurrence.');
  WriteLn(
'Source filename file1 will be forced to .PAS if no type is given.');
  WriteLn(
'Formatted output filename file2.typ defaults to FILE1.FMT');
  WriteLn(
'Use output filename of CON: or PRN: to direct formatted output');
  WriteLn(
'to console or printer.');
  WriteLn(
'Warning: Text inside the "(*....*)" type of comments IS processed. Usefull');
  WriteLn(
'for "code comments", but take care to have an equal number of ''s in that');
  WriteLn(
'type of comments.');
  Halt;
END;  {of Usage}


FUNCTION Exists(Name : StrChLin) : Boolean;
  {Returns TRUE if file exists}
VAR  f : FILE;
BEGIN
  Assign(f,Name);
  {$I-}  Reset(f);            {try to open it}
  Exists := (IOResult = 0);   {hokay, it's there}
  Close(f);   {$I+}           {neaten up after us}
  IF IOResult <> 0 THEN ;     {just clear IOResult}
END;  {of Exists}


PROCEDURE Open_Files;
VAR
  p,sw,p1,p2 : Integer;
  Ch : Char;
  Dummy : STRING[2];
  InName,OutName : StrChLin;
BEGIN
  AllUpper := False;            {assume mixed Uppercase/Turbo format}
  SpFirst  := False;            {don't use first spelling}

  sw := 0;                      {assume no switch parm}
  p1 := 0;                      {and no file names}
  p2 := 0;
  FOR p := 1 TO ParamCount DO BEGIN     {check all the cmdline parms}

    Dummy := Copy(ParamStr(p),1,1);     {get first char}
    Ch := Dummy[1];
    CASE Ch OF
      '?' : Usage;                      {give it help, terminate}
      '-',
      '/' : BEGIN                       {we got a switch}
              sw := p;                  {this is switch parm}
              IF Length(ParamStr(sw)) < 2 THEN Ch := #0       {bad}
              ELSE BEGIN
                Dummy := Copy(ParamStr(sw),2,1);   {get 2d char}
                Ch := UpCase(Dummy[1]);
              END;
              CASE Ch OF
                '?',
                'H'  : Usage;           {give it help, terminate}
                'U'  : AllUpper := True;
                'F'  : SpFirst  := True;
                'L'  : Lazy     := True; {LR insisted on this feature}
                ELSE WriteLn('Unknown switch: [', ParamStr(p), '].  Ignored');
              END;  {case of 2d char}
            END;
      ELSE BEGIN  {this parm wasn't a switch, fiddle filename parm nrs}

        CASE p OF
          1 : p1 := 1;         {not a switch, so must be input filename}
          2 : IF sw = 1        {1 was switch..}
              THEN p1 := 2     {..so this must be input filename}
              ELSE p2 := 2;    {..otherwise this must be output filename}
          3 : IF sw = 1        {1 was the switch, so p1 is 2 already}
              THEN p2 := 3;    {so 3d parm must be output filename}
        END;  {case of p}

      END;  {case of non-switch parm}
    END;  {Case of 1st char}

  END;  {Parameter parsing}

  IF p1 = 0 THEN Usage;             {dummy}

  IF AllUpper AND SpFirst THEN BEGIN
    WriteLn('F and U switch can''t both be used');
    Usage;
  END;
  InName := Uc(ParamStr(p1));       {move cmdline filename into string}
  p := Pos('.', InName);            {remember where the type separator is}
  IF p = 0 THEN p := Length(InName) {period goes at end}
  ELSE p := Pred(p);                {back up from the period}

  IF p2 <> 0 THEN BEGIN             {he provided an output filename}
    OutName := Uc(ParamStr(p2));    {..so use his}
    IF Pos('.', OutName) = 0           {no type}
    THEN OutName := OutName + '.FMT';  {copy up to separator,
                                        add type}
  END
  ELSE BEGIN                       {he didn't provide an output filename}
    OutName := Copy(InName,1,p) + '.FMT';
  END;

  IF p = Length(InName)            {input filename didn't have a type...}
  THEN InName := InName + '.PAS';  {.. so add on the .PAS default ending}

  IF NOT Exists(InName) THEN BEGIN
    WriteLn(InName, ' not found.');
    Halt;
  END;

  IF OutName = InName THEN BEGIN      {can't have same name, dummy!}
    WriteLn('Cannot output ', InName, ' to ', OutName);
    Halt;
  END;

  WriteLn('Converting ', InName, ' => ', OutName);

  FileOutput := (OutName <> 'CON:');    {set global flag}
  IF FileOutput THEN BEGIN              {check for overwrite}
    IF Exists(OutName) THEN BEGIN       {it exists}
      Write(OutName, ' exists.  Overwrite?  [Y/N]: ');
      REPEAT
        Intr($28,Regs); {Idle Interrupt}
      UNTIL KeyPressed;
      Ch := UpCase(ReadKey);  {get his response}
      IF Ch <> 'Y' THEN Halt;           {user abort}
      WriteLn;
    END;
  END;

  Assign(InputFile,InName);
  Reset(InputFile);

  Assign (OutputFile, OutName);
  Rewrite (OutputFile);
END;  {of Open_Files}


PROCEDURE Uc_The_Array;
{Create a new array of uppercased lines of reserved words}
BEGIN
  LinUse := 1;         {At least one line of reserved words}
  WHILE (ReservedWords[LinUse]<>'') AND (LinUse<NRLINES) DO
    BEGIN
      UCReserved[LinUse] := Uc(ReservedWords[LinUse]);
      LinUse := Succ(LinUse);
    END;
  IF LinUse<>NRLINES THEN LinUse := Pred(LinUse);
  END;  {of Uc_The_Array}

PROCEDURE Reset_Array;
{Reset both arrays}
VAR i : Integer;
BEGIN
  FOR i := 1 TO NRLINES DO
    BEGIN
      UCReserved[i] := '';
      ReservedWords[i] := '';
    END; {FOR}
  LinUse := 1;
  END;  {of Reset_Array}

PROCEDURE ErrorHalt(S:STRING);
BEGIN
  WriteLn;
  WriteLn(S);
  Close(OutputFile);
  Halt;
END;

PROCEDURE Test_For_Reserved_Words;
{
 Test if the current word (RamWord) is in the reserved words list.
 If so, write its equivalent (uppercased or Turbo Pascal format or first
 used form) out to our output file.
 Else just write it as it is and put it in the list if "first used form"
 is active.
}
VAR
  i,p : Integer;
  Tmp : Str255;
BEGIN
  Padded := ' ' + Uc(RamWord) + ' ';    {bracket with spaces}

  FOR i := 1 TO LinUse DO BEGIN         {check all the reserved words}
    p := Pos(Padded, UCReserved[i]);    {is this word in this word line?}
    IF p > 0 THEN BEGIN                 {yep}
      Padded := Copy(ReservedWords[i], Succ(p), Length(RamWord) );
      IF AllUpper THEN Padded := Uc(Padded);   {force to uppercase}
      Write(OutputFile, Padded);
      Exit;                             {don't look at any more lines}
    END;
  END; {For}

  IF SpFirst OR Lazy THEN BEGIN
    Tmp := ReservedWords[LinUse];
    IF (Tmp='') OR (Length(Tmp+RamWord)+1>CHLIN) THEN BEGIN
      IF Tmp<>'' THEN BEGIN
        LinUse := Succ(LinUse); {Line full}
        IF LinUse>NRLINES THEN ErrorHalt('Error: Too many identifiers.');
      END;
      ReservedWords[LinUse] := ' '+RamWord+' ';
      UCReserved[LinUse] := ' '+Uc(RamWord)+' ';
    END
    ELSE BEGIN
      ReservedWords[LinUse] := Tmp+RamWord+' '; {Append to line}
      UCReserved[LinUse] := Uc(Tmp+RamWord)+' ';
    END; {else}
  END;

  Write (OutputFile, RamWord);          {write the original word}
END;  {of Test_For_Reserved_Words}

PROCEDURE Process_A_Word;
BEGIN
  RamWord := '';
  WHILE (UpCase (ProgLine [CharPsn]) IN Identifier)  {it's a legal char}
  AND (CharPsn <= Length (ProgLine))                 {and line isn't done}
  DO BEGIN
    RamWord := RamWord + ProgLine [CharPsn];         {build our RamWord}
    CharPsn := Succ(CharPsn);                        {bump ProgLine pointer}
  END;
  Test_For_Reserved_Words;                           {check for reserved
                                                      words, write out}

END;  {of Process_A_Word}


PROCEDURE Scan_Till (SearchChar: Char);
VAR Ch : Char;  {v1.2}
BEGIN
  REPEAT
    IF CharPsn > Length (ProgLine) THEN BEGIN
      WriteLn (OutputFile);           {Simply terminates current line
                                       on output.}
      ReadLn (InputFile, ProgLine);   {Gets the next input line.}
      IF FileOutput THEN BEGIN
        Write('Processing line: ', LineNum,#$0D);
        LineNum := Succ(LineNum);
      END;

      IF SearchChar=APOS THEN
        ErrorHalt('Error: unequal number of ''s in "(*...*)" comment');
      CharPsn := 1
    END;
    IF ProgLine <> '' THEN BEGIN
      Ch := ProgLine[CharPsn];    {v1.2 remember what this char was}
      Write (OutputFile, Ch);     {v1.2 write it out}
      CharPsn := Succ(CharPsn);
    END
    ELSE Ch := #0;                {v1.2 blank line, clear Ch}
  UNTIL (Ch = SearchChar)         {v1.2 the LAST char was end of
                                   quoted string or comment}
  OR Eof(InputFile);
END;  {of Scan_Till}


PROCEDURE Convert;
VAR Ch : Char;
BEGIN
  LineNum := 0;
  WHILE NOT Eof(InputFile) DO BEGIN
    CharPsn := 1;
    ReadLn (InputFile, ProgLine);
    IF FileOutput THEN BEGIN
      Write('Processing line: ', LineNum,#$0D);
      LineNum := Succ(LineNum);
    END;
    IF Length (ProgLine) = 0 THEN WriteLn (OutputFile)  {blank line}
    ELSE BEGIN
      REPEAT
        Ch := UpCase(ProgLine[CharPsn]);
        IF Ch IN Identifier THEN Process_A_Word    {could be a reserved word}
        ELSE BEGIN
          Write (OutputFile, ProgLine [CharPsn]);  {v1.2 write out char}
          CharPsn := Succ(CharPsn);
          IF Ch = OPENCOMMENT
          THEN Scan_Till(CLOSECOMMENT)             {v1.2 write until
                                                    closing comment}
          ELSE IF Ch = APOS THEN Scan_Till(APOS);  {v1.2 write until 2d '}
        END;
      UNTIL (CharPsn > Length (ProgLine));
      WriteLn (OutputFile);                        {new line}

    END; {If}
  END;  {While}
  Close (InputFile);
  Close(OutputFile);
END;  {of Convert}

BEGIN
  Open_Files;
  IF NOT SpFirst THEN
    Uc_The_Array  {v1.1 build an array of uppercased reserved word lines}
  ELSE IF NOT Lazy THEN Reset_Array; {Spell everything like the first occ.}
  Convert;
END.
