{$M 16384,0,80000}
(* This is a test program for the TSUNTJ.TPU unit
   Note the heap needed because of the COPYFILE procedure *)

uses TSUNTJ,
     TSUNTB;  { for the HEXFN in procedure TEST4 }

procedure LOGO;
begin
  writeln;
  writeln ('TSUNTJ unit test by Prof. Timo Salmi, 2-Mar-95');
  writeln ('University of Vaasa, Finland, ts@uwasa.fi');
{$IFDEF VER40}
  writeln ('TP version 4.0');
{$ENDIF}
{$IFDEF VER50}
  writeln ('TP version 5.0');
{$ENDIF}
{$IFDEF VER55}
  writeln ('TP version 5.5');
{$ENDIF}
{$IFDEF VER60}
  writeln ('TP version 6.0');
{$ENDIF}
{$IFDEF VER70}
  writeln ('TP version 7.0');
{$ENDIF}
  writeln;
end;  (* logo *)

(* Testing copy *)
procedure TEST1;
var file1, file2 : string;
    status       : byte;
begin
  file1 := 'c:\command.com';
  file2 := 'r:\command.com';
  COPYFILE (file1, file2, status);
  if status = 0 then
     writeln (file1, ' copied to ', file2)
   else
     begin
       writeln ('Error in copying ', file1, ' to ', file2);
       writeln ('Status = ', status);
     end;
end;  (* test1 *)

(* Testing if the given name is a directory *)
procedure TEST2;
var name : string;
    b    : boolean;
begin
  name := ParamStr(1);
  b := ISDIRFN (name);
  writeln (name, ' is a directory: ', b);
  b := ISDIR2FN (name);
  writeln (name, ' is a directory: ', b);
end;  (* test2 *)

(* Test where the standard input comes from, and where does the standard
   output go to *)
procedure TEST3;
var s   : string;
    con : text;
begin
  { We must have a way to write messages to the screen irrespective of
    where the standard output is directed. }
  assign (con, 'con');
  rewrite (con);
  {}
  if PIPEDIFN then
    writeln (con, 'Input from redirection')
    else writeln (con, 'Input not from redirection');
  {}
  if PIPEDOFN then
    writeln (con, 'Output redirected')
    else writeln (con, 'Output not redirected');
  {}
  if PIPEDNFN then
    writeln (con, 'Output redirected to nul')
    else writeln (con, 'Output not redirected to nul');
  {}
  close (con);
end;  (* test3 *)

(* Show interrupt information *)
procedure TEST4;
const intn : byte = $1F;  { graphics display character table }
var segm, offs : word;
begin
  INTRLOCA (intn, segm, offs);
  writeln ('Interrupt $', HEXFN(intn), ' is located at [',
            HEXFN(segm),':$', HEXFN(offs), ']');
  INTRADDR (intn, segm, offs);
  writeln ('Interrupt $', HEXFN(intn), ' points to mem [',
            HEXFN(segm),':$', HEXFN(offs), ']');
end;  (* test4 *)

(* Test whether a name refers to a directory *)
procedure TEST5;
const name = 'r:\cmand';
var b : boolean;
begin
  b := ISDIR3FN(name);
  writeln (name, ' is a directory is ', b);
end;  (* test5 *)

(* Testing if a non-text file is open *)
procedure TEST6;
const name = 'R:\TMP';
var f  : file;
begin
  Assign (f, name);
  writeln ('File ', name, ' is open is ', OPENFLFN(f));
  {$I-} rewrite (f); {$I+}
  if IOResult <> 0 then
    begin
      writeln ('Failed to open ', name);
      exit;
    end;
  writeln ('File ', name, ' is open is ', OPENFLFN(f));
  close(f);
  writeln ('File ', name, ' is open is ', OPENFLFN(f));
end;  (* test6 *)

(* Main program *)
begin
  LOGO;
  {      If you want test other than 2, remove the two bracket lines
  TEST1;
  TEST3;
  TEST4;
  TEST5;
  TEST6;
  write ('Press <ͼ'); readln;
  }
  TEST2;
end.  (* tsuntj.tst *)
