Program TestPGUI;

{$M 8192,0,655360}
{$F+}
Uses CRT,PGUI,Graph,KeyDef,Strings;

Function DetectSVGA:Integer;
Begin
  DetectSVGA:=3;
End;

Var
  NewBGIM  :BGIMouseShapePtr;
  Main,
  W        :GraphicWindow;
  C        :Char;

  EndVal,
  NewVal,
  Dummy,
  X,Y      :Word;
  MB       :Byte;
  Held,
  Doubled,
  Special  :Boolean;
  Key      :Char;
  Check    :Char;
  Strg     :String;

  gd,gm    :Integer;

Begin
  InitVGA('D:\TP\BGI');
{  gd:=InstallUserDriver('SVGA16',@DetectSVGA);}  {Super VGA Driver Required}
  If GraphResult<>grOk Then
  Begin
    WriteLn('Error');
    Halt;
  End;
  gd:=Detect;
  gm:=0;
  InitGraph(gd,gm,'D:\TP\SVGA');
  Main.Open(200,200,400,440,Blue,Black,3,EmptyFill,Black,False);
  Main.NewHeading('Main Window',CentreText,White,InterleaveFill,Green);

  W.Open(50,50,190,150,Red,Black,2,EmptyFill,Black,True);
  W.NewHeading('Zoom',CentreText,Yellow,CloseDotFill,LightGray);
  W.CloseIcon(True);
  W.HeadingIcon(True);
  W.VertSlideBar(0,3,1,7);
  W.HorzSlideBar(0,3,1,7);
  W.HorzSlideIcon(True);
  W.VertSlideIcon(True);
  Mouse.Init(True);
  InstallBGIMouse(NIL);
  New(NewBGIM);
  NewBGIM^.Picture:=IconBGIMouseCursorC;
  NewBGIM^.Mask:=IconBGIMouseMaskC;
  NewBGIM^.XHot:=-15;
  NewBGIM^.YHot:=-15;
  Mouse.SetShape(NewBGIM);
  Mouse.Show;
{  CommentWindow(150,200,'The Pure Power GUI, Revision 1.30');}

  SetFillStyle(SolidFill,1);
  Mouse.Hide;
  W.Lock;
  Bar(30,30,100,70);
  W.UnLock;

  Main.Lock;

  SetFillStyle(SolidFill,1);
  Bar(30,50,50,70);
  SetFillStyle(SolidFill,5);
  Bar(70,50,90,70);
  SetFillStyle(SolidFill,9);
  Bar(110,50,130,70);
  SetFillStyle(SolidFill,13);
  Bar(150,50,170,70);

  SetFillStyle(SolidFill,2);
  Bar(30,90,50,110);
  SetFillStyle(SolidFill,6);
  Bar(70,90,90,110);
  SetFillStyle(SolidFill,10);
  Bar(110,90,130,110);
  SetFillStyle(SolidFill,14);
  Bar(150,90,170,110);

  SetFillStyle(SolidFill,3);
  Bar(30,130,50,150);
  SetFillStyle(SolidFill,7);
  Bar(70,130,90,150);
  SetFillStyle(SolidFill,11);
  Bar(110,130,130,150);
  SetFillStyle(SolidFill,1);
  Bar(150,130,170,150);

  SetFillStyle(SolidFill,4);
  Bar(30,170,50,190);
  SetFillStyle(SolidFill,8);
  Bar(70,170,90,190);
  SetFillStyle(SolidFill,12);
  Bar(110,170,130,190);
  SetFillStyle(SolidFill,2);
  Bar(150,170,170,190);

  Main.UnLock;

  Mouse.Show;

  Repeat
    W.Buttons.WaitForClick(X,Y,MB,Held,Doubled,Special,Key);

    If (Special=SpecialCode(Key_Ctrl, Key_F5)) And
       (Key=KeyCode(Key_Ctrl, Key_F5)) And Held Then W.Drag;

    If (Special=SpecialCode(Mouse_Only, Mouse_SlideButtonHorz)) And
       (Key=KeyCode(Mouse_Only, Mouse_SlideButtonHorz)) And
       Held Then W.DragHorzSlideButton;

    If (Special=SpecialCode(Mouse_Only, Mouse_SlideButtonVert)) And
       (Key=KeyCode(Mouse_Only, Mouse_SlideButtonVert)) And
       Held Then W.DragVertSlideButton;

    If (Special=SpecialCode(Key_None, Key_Left)) And
       (Key=KeyCode(Key_None, Key_Left)) And
       (W.HSlideBarCurPos>0) Then W.UpdateHorzSlideBar(W.HSlideBarCurPos-1);

    If (Special=SpecialCode(Key_None, Key_Right)) And
       (Key=KeyCode(Key_None, Key_Right)) And
       (W.HSlideBarCurPos<3) Then W.UpdateHorzSlideBar(W.HSlideBarCurPos+1);

    If (Special=SpecialCode(Key_None, Key_Up)) And
       (Key=KeyCode(Key_None, Key_Up)) And
       (W.VSlideBarCurPos>0) Then W.UpdateVertSlideBar(W.VSlideBarCurPos-1);

    If (Special=SpecialCode(Key_None, Key_Down)) And
       (Key=KeyCode(Key_None, Key_Down)) And
       (W.VSlideBarCurPos<3) Then W.UpdateVertSlideBar(W.VSlideBarCurPos+1);

    If (Key=KeyCode(Mouse_Only, Mouse_SlideBarHorz)) And
       (Special=SpecialCode(Mouse_Only, Mouse_SlideBarHorz)) Then
    Begin
      W.HorzSlideBarPos(NewVal,Dummy,EndVal,Dummy);
      W.UpdateHorzSlideBar(
                           AdjustMeter(NewVal,EndVal,X,0,3)
                          );
    End;

    If (Key=KeyCode(Mouse_Only, Mouse_SlideBarVert)) And
       (Special=SpecialCode(Mouse_Only, Mouse_SlideBarVert)) Then
    Begin
      W.VertSlideBarPos(Dummy,NewVal,Dummy,EndVal);
      W.UpdateVertSlideBar(
                           AdjustMeter(NewVal,EndVal,Y,0,3)
                          );
    End;

    Case W.HSlideBarCurPos Of
      0:Case W.VSlideBarCurPos Of
          0:SetFillStyle(SolidFill,1);
          1:SetFillStyle(SolidFill,2);
          2:SetFillStyle(SolidFill,3);
          3:SetFillStyle(SolidFill,4);
        End;
      1:Case W.VSlideBarCurPos Of
          0:SetFillStyle(SolidFill,5);
          1:SetFillStyle(SolidFill,6);
          2:SetFillStyle(SolidFill,7);
          3:SetFillStyle(SolidFill,8);
        End;
      2:Case W.VSlideBarCurPos Of
          0:SetFillStyle(SolidFill,9);
          1:SetFillStyle(SolidFill,10);
          2:SetFillStyle(SolidFill,11);
          3:SetFillStyle(SolidFill,12);
        End;
      3:Case W.VSlideBarCurPos Of
          0:SetFillStyle(SolidFill,13);
          1:SetFillStyle(SolidFill,14);
          2:SetFillStyle(SolidFill,1);
          3:SetFillStyle(SolidFill,2);
        End;
    End;
    Mouse.Hide;
    W.Lock;
    Bar(30,30,100,70);
    W.UnLock;
    Mouse.Show;
  Until W.Buttons.Number=W.CloseButtonNum;

{  Strg:='';
  SetColor(White);
  EditString(60,76,14,False,Strg);}
  W.Close;
  Main.Close;
  CloseGraph;
End.
