{$F+} { Compiler Directive: Generate far procedure calls: On }
{$O+} { Compiler Directive: Generate overlay code: On }

(*****************************************************************************

  Indicators
    Version 1.22

  Purpose:
    A collection of specialty procedures that are useful in building a
    nice consistent user interface.

  Features:
    Attractive and easy to user interface.

  Limitations:
    Limited error checking code ensures faster running, but gives the
      responsibility to the programmer of providing valid input.

  Versions
    1.1 - Alters the code to work with Pointer version 1.11
    1.11 - Updates the code to work with the pointer revision.
    1.12 - Added the Calculate_Percentage function.
    1.2 - Added the Duel graph routines.
    1.21 - Recoded the duel tall bar graph routine to work better.
    1.22 - Included code to compile and work under Speed Pascal/2.

  CopyRight 1992, 1994, 1995, All rights reserved.
    By Paul Renaud.

  Compilers:
    Turbo Pascal versions 5.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

{$IFNDEF OS2}
Unit Indicators;
{$ELSE}
Unit Indicato;
{$ENDIF}

  Interface

    Uses
      CRT,
      Core,
      KeyBoard,
     {$IFNDEF OS2}
      String_Utilities;
     {$ELSE}
      String_U;
     {$ENDIF}

(***********************************************************

  Colors - define the available colors for the text
    attribute.

***********************************************************)

    Const
      Black_Background   = 0;
      Blue_Background    = 16;
      Green_Background   = 32;
      Cyan_Background    = 48;
      Red_Background     = 64;
      Magenta_Background = 80;
      Yellow_Background  = 96;
      White_Background   = 112;

      Black_Character         = 0;
      Blue_Character          = 1;
      Green_Character         = 2;
      Cyan_Character          = 3;
      Red_Character           = 4;
      Magenta_Character       = 5;
      Brown_Character         = 6;
      Light_Gray_Character    = 7;
      Dark_Gray_Character     = 8;
      Light_Blue_Character    = 9;
      Light_Green_Character   = 10;
      Light_Cyan_Character    = 11;
      Light_Red_Character     = 12;
      Light_Magenta_Character = 13;
      Yellow_Character        = 14;
      White_Character         = 15;

      Flashing_Character      = 128;

      No_Character                = 0;
      Dim_Underlined_Character    = 1;
      Dim_Character               = 2;
      Bright_Underlined_Character = 9;
      Bright_Character            = 10;
      Reverse_Video_Character     = 112;

(***********************************************************

  Thise constants are used for the duel bar graph plotting
  routines.  Feel free to change them when you wish.

***********************************************************)

      Bar1_Color: Byte = Red_Character;
      Bar2_Color: Byte = Brown_Character;
      Bar_Background: Byte = Green_Background;

(***********************************************************

  Procedure: Change attribute.

    This procedure presents the user with a map of all the
    possible text attribute on the screen and allows him/her
    to select one of the choices by moving the selection bar
    to the preferred choice.  The current window size should
    be large enough to display the entire screen map.

      Valid keys are...
        Left, Right, Up, Down, Home, End, PgUp, PgDn, Enter,
        Escape.

    For use with the CRT unit.

***********************************************************)

    Procedure Change_Attribute( Var Current_Attribute: Byte );

(***********************************************************

  Procedure: Side bar graph.

    This procedure displays a bar graph on the screen with
    it's location determined by Left, Right and Row.  Amount
    should be a number between 0 and 100 which determines
    the percentage of the whole the bar graph should be.
    The attribute is the current attribute and the current
    cursor location is saved.

***********************************************************)

    Procedure Side_Bar_Graph( Left, Row, Right, Amount: Byte );

(***********************************************************

  Procedure: Tall bar graph.

    This procedure displays a bar graph on the screen with
    it's location determined by Top, Bottom, Column.  Amount
    should be a number between 0 and 100 which determines
    the percentage of the whole the bar graph should be.
    The attribute is the current attribute and the current
    cursor location is saved.

***********************************************************)

    Procedure Tall_Bar_Graph( Top, Bottom, Column, Amount: Byte );

(***********************************************************

  Function:  Calculate_Percentage

    This function calculates the percentage value from two
    given values, the amount and the total possible amount.
    The result is a value from 0 to 100.

***********************************************************)

    Function Calculate_Percentage( Amount, Total: LongInt ): Byte;

(***********************************************************

  Procedure: Duel side bar graph.

    This procedure displays a duel bar graph on the screen
    with it's location determined by Left, Right and Row.
    Amount1 and Amount2 should both be numbers between 0 and
    100 which determines the percentage of the whole the bar
    graph should be.  The attributes are those defined for
    the unit and the current cursor location is saved.

***********************************************************)

    Procedure Duel_Side_Bar_Graph( Left, Row, Right, Amount1, Amount2: Byte );

(***********************************************************

  Procedure: Duel tall bar graph.

    This procedure displays a duel bar graph on the screen
    with it's location determined by Top, Bottom, Column.
    Amount1 and Amount2 should both be numbers between 0 and
    100 which determines the percentage of the whole the bar
    graph should be.  The attributes are those defined for
    the unit and the current cursor location is saved.

***********************************************************)

    Procedure Duel_Tall_Bar_Graph( Top, Bottom, Column, Amount1, Amount2: Byte );

{----------------------------------------------------------------------------}

  Implementation

    Const
     { These constants determines the text attribute map on screen. }
      Main_Row = 2;
      Main_Column = 3;
     { This constant represents the flashing code in the attribute. }
      Flashing = $80;
     { These constants determine the text attribute map's appearance. }
      Text_Size = 4;
      Text_Display = 'Text';
      Select_Display = 'Text';
     { These constants are used to draw the bar graph on the screen. }
      Bar_Full = #219;
      Bar_Half_Side = #221;
      Bar_Half_Tall = #220;
      Bar_Empty = ' ';

{----------------------------------------------------------------------------}

(*************************************************

  Function:  Calculate_Percentage
    As previously defined.

*************************************************)

    Function Calculate_Percentage( Amount, Total: LongInt ): Byte;
      Begin
        Total := Abs( Total );
        Amount := Abs( Amount );
        If ( Total > 10000 )
          then
            Begin
              Total := Total div 10000;
              Amount := Amount div 10000;
            End;
        If ( Amount >= Total )
          then
            Calculate_Percentage := 100
          else
            Calculate_Percentage := ( ( Amount * 100 ) div Total );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Display attributes.
    This procedure draws all the possible
    attributes on the screen in an orderly
    and attractive way.

*************************************************)

    Procedure Display_Attributes( Start_Row, Start_Column, Normal_Attribute: Byte );
      Var
        Row,
        Column: Byte;
      Begin
        TextAttr := Normal_Attribute;
       {$IFDEF OS2}
        TextBackground( Normal_Attribute shr 4 );
       {$ENDIF}
        ClrScr;
        For Row := 0 to 15 do
          Begin
            GotoXY( Start_Column, ( Start_Row + Row ) );
            For Column := 0 to 7 do
              Begin
                TextAttr := ( Row + ( Column shl 4 ) );
               {$IFDEF OS2}
                TextBackground( TextAttr shr 4 );
               {$ENDIF}
                Write( Screen, Text_Display: Text_Size );
              End;
            WriteLn( Screen );
          End;
        TextAttr := Normal_Attribute;
       {$IFDEF OS2}
        TextBackground( Normal_Attribute shr 4 );
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Test attribute.
    This procedure displays a test sample of the
    current attribute for the user to view.

*************************************************)

    Procedure Test_Attribute( Row, Column, Current_Attribute, Normal_Attribute: Byte );
      Begin
        TextAttr := Current_Attribute;
       {$IFDEF OS2}
        TextBackground( Current_Attribute shr 4 );
       {$ENDIF}
        GotoXY( Column, Row );
        Write( Screen, 'This is the current attribute.  ' );
        TextAttr := Normal_Attribute;
       {$IFDEF OS2}
        TextBackground( Normal_Attribute shr 4 );
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Unmap attribute.
    This procedure erases the current selection
    bar from the current position on the attribute
    map screen.

*************************************************)

    Procedure UnMap_Attribute( Start_Row, Start_Column, Current_Attribute, Normal_Attribute: Byte );
      Var
        Row,
        Column,
        New_Row,
        Last_Row,
        New_Column,
        Last_Column: Byte;
      Begin
        TextAttr := Normal_Attribute;
       {$IFDEF OS2}
        TextBackground( Normal_Attribute shr 4 );
       {$ENDIF}
        Row := ( Current_Attribute and $0F );
        Column := ( ( Current_Attribute and $70 ) shr 4 );
        New_Row := ( Start_Row + Row );
        New_Column := ( Start_Column + ( Column * Text_Size ) );
        Last_Row := ( Start_Row + 16 );
        Last_Column := ( Start_Column + ( 8 * Text_Size ) );
        GotoXY( Pred( Start_Column ), New_Row );
        Write( Screen, ' ' );
        GotoXY( Last_Column, New_Row );
        Write( Screen, ' ' );
        GotoXY( New_Column, Pred( Start_Row ) );
        Write( Screen, Expand( ' ', Text_Size ) );
        GotoXY( New_Column, Last_Row );
        Write( Screen, Expand( ' ', Text_Size ) );
        GotoXY( New_Column, New_Row );
        TextAttr := ( Row + ( Column shl 4 ) );
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
        Write( Screen, Text_Display: Text_Size );
        TextAttr := Normal_Attribute;
       {$IFDEF OS2}
        TextBackground( Normal_Attribute shr 4 );
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Map attribute.
    This procedure puts the current selection bar
    on the attribute map in the correct position.

*************************************************)

    Procedure Map_Attribute( Start_Row, Start_Column, Current_Attribute, Normal_Attribute: Byte );
      Var
        Row,
        Column,
        Last_Row,
        Last_Column: Byte;
      Begin
        TextAttr := Normal_Attribute;
       {$IFDEF OS2}
        TextBackground( Normal_Attribute shr 4 );
       {$ENDIF}
        Row := ( Current_Attribute and $0F );
        Column := ( ( Current_Attribute and $70 ) shr 4 );
        Cursor_Row := ( Start_Row + Row );
        Cursor_Column_Start := ( Start_Column + ( Column * Text_Size ) );
        Last_Row := ( Start_Row + 16 );
        Last_Column := ( Start_Column + ( 8 * Text_Size ) );
        GotoXY( Pred( Start_Column ), Cursor_Row );
        Write( Screen, #26 );
        GotoXY( Last_Column, Cursor_Row );
        Write( Screen, #27 );
        GotoXY( Cursor_Column_Start, Pred( Start_Row ) );
        Write( Screen, Expand( #25, Text_Size ) );
        GotoXY( Cursor_Column_Start, Last_Row );
        Write( Screen, Expand( #24, Text_Size ) );
        GotoXY( Cursor_Column_Start, Cursor_Row );
        TextAttr := ( Row + ( Column shl 4 ) + Flashing );
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
        Write( Screen, Select_Display );
        TextAttr := Normal_Attribute;
       {$IFDEF OS2}
        TextBackground( Normal_Attribute shr 4 );
       {$ENDIF}
        Cursor_Column_Finish := Pred( Cursor_Column_Start + Length( Select_Display ) );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Change attribute.
    As previously defined.

*************************************************)

    Procedure Change_Attribute( Var Current_Attribute: Byte );
      Var
        Result,
        BackFlash,
        ForeGround,
        BackGround,
        Work_Attribute: Byte;
        Command: Char;
      Begin
        ForeGround := ( Current_Attribute and $0F );
        BackGround := ( ( Current_Attribute and $70 ) shr 4 );
        BackFlash := ( Current_Attribute and $80 );
        Work_Attribute := ( ForeGround or ( BackGround shl 4 ) );
        Display_Attributes( Main_Row, Main_Column, TextAttr );
        Test_Attribute( ( Main_Row + 17 ), Main_Column, Work_Attribute, TextAttr );
        GotoXY( 1, 20 );
        WriteLn( Screen, '  To select a new attribute, put the' );
        WriteLn( Screen, '  the selection bar on the desired' );
        WriteLn( Screen, '  attribute and press ENTER.' );
        Write( Screen, '  To exit, press ESCAPE. ' );
        Map_Attribute( Main_Row, Main_Column, Work_Attribute, TextAttr );
        Repeat
          Get_Command( Command, Result );
          Case Result of
            Pointer_Down,
            Press_Down_Arrow:
              If ( ForeGround < 15 )
                then
                  Inc( ForeGround )
                else
                  ForeGround := 0;
            Pointer_Up,
            Press_Up_Arrow:
              If ( ForeGround > 0 )
                then
                  Dec( ForeGround )
                else
                  ForeGround := 15;
            Pointer_Right,
            Press_Right_Arrow:
              If ( BackGround < 7 )
                then
                  Inc( BackGround )
                else
                  BackGround := 0;
            Pointer_Left,
            Press_Left_Arrow:
              If ( BackGround > 0 )
                then
                  Dec( BackGround )
                else
                  BackGround := 7;
            Press_Home:
              BackGround := 0;
            Press_End:
              BackGround := 7;
            Press_Page_Up:
              ForeGround := 0;
            Press_Page_Down:
              ForeGround := 15;
            Pointer_Button1_Double:
              Result := Press_Enter;
          End; { Case }
          UnMap_Attribute( Main_Row, Main_Column, Work_Attribute, TextAttr );
          Work_Attribute := ( ForeGround or ( BackGround shl 4 ) );
          Map_Attribute( Main_Row, Main_Column, Work_Attribute, TextAttr );
          Test_Attribute( ( Main_Row + 17 ), Main_Column, ( Work_Attribute + BackFlash ), TextAttr );
        Until ( Result in [ Press_Enter, Press_Escape ] );
        If ( Result = Press_Enter )
          then
            Current_Attribute := ( Work_Attribute + BackFlash );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Show side bar
    This procedure displays a bar graph on the
    screen at the current location by printing
    characters.  Bar_Amount should be between 0
    and Limit.  Limit determines the amount of
    characters to print.  Half defines if there
    should be a half character between the main
    bar and the empty part.

*************************************************)

    Procedure Show_Side_Bar( Bar_Amount, Limit: Byte; Half: Boolean );
      Var
        Count: Byte;
      Begin
        Count := 0;
        While ( Count < Bar_Amount ) and ( Count < Limit ) do
          Begin
            Write( Screen, Bar_Full );
            Inc( Count );
          End;
        If ( Count < Limit ) and Half
          then
            Begin
              Write( Screen, Bar_Half_Side );
              Inc( Count );
            End;
        While ( Count < Limit ) do
          Begin
            Write( Screen, Bar_Empty );
            Inc( Count );
          End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Show duel side bar
    This procedure displays a duel bar graph on
    the screen at the current location by printing
    characters.  Bar_Amount1 should be between 0
    and Bar_Amount2.  Bar_Amount2 should be
    between Bar_Amount1 and Limit determines the
    amount of characters to print.  Half1 defines
    if there should be a half character between
    the first bar and the second one, Half2
    defines if there should be a half character
    between the second bar and the empty part.

*************************************************)

    Procedure Show_Duel_Side_Bar( Bar_Amount1, Bar_Amount2, Limit: Byte; Half1, Half2: Boolean );
      Var
        Count,
        Save_Color,
        Bar2_Background: Byte;
      Begin
        Save_Color := TextAttr;
        Bar2_Background := ( Bar2_Color shl 4 );
        Count := 0;
        If ( Bar_Amount1 > Bar_Amount2 )
          then
            Halt
          else
            If ( Bar_Amount1 = Bar_Amount2 ) and ( Half1 and ( not Half2 ) )
              then
                Halt;
        TextAttr := ( Bar1_Color + Bar2_Background );
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
        While ( Count < Bar_Amount1 ) and ( Count < Bar_Amount2 ) and ( Count < Limit ) do
          Begin
            Write( Screen, Bar_Full );
            Inc( Count );
          End;
        If ( Count < Bar_Amount2 ) and ( Count < Limit ) and Half1
          then
            Begin
              If ( Bar_Amount1 = Bar_Amount2 ) and ( Half1 = Half2 )
                then
                  TextAttr := ( Bar1_Color + Bar_Background )
                else
                  TextAttr := ( Bar1_Color + Bar2_Background );
             {$IFDEF OS2}
              TextBackground( TextAttr shr 4 );
             {$ENDIF}
              Write( Screen, Bar_Half_Side );
              Inc( Count );
            End;
        TextAttr := ( Bar2_Color + Bar_Background );
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
        While ( Count < Bar_Amount2 ) and ( Count < Limit ) do
          Begin
            Write( Screen, Bar_Full );
            Inc( Count );
          End;
        If ( Count < Limit ) and Half2
          then
            Begin
              Write( Screen, Bar_Half_Side );
              Inc( Count );
            End;
        While ( Count < Limit ) do
          Begin
            Write( Screen, Bar_Empty );
            Inc( Count );
          End;
        TextAttr := Save_Color;
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Calculation side.
    This procedure calculates the values to draw
    the bar graph on the side.

*************************************************)

    Procedure Calculation_Side( Amount, Width: Byte; Var Size: Byte; Var Part: Boolean );
      Var
        Number: Real;
      Begin
        If ( Amount >= 100 )
          then
            Begin
              Size := Width;
              Part := True;
            End
          else
            Begin
              Number := ( Amount * Width / 100 );
              Size := Trunc( Number );
              Part := ( ( Frac( Number ) * 10 ) > 5 );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Side bar graph.
    As previously defined.

*************************************************)

    Procedure Side_Bar_Graph( Left, Row, Right, Amount: Byte );
      Var
        Size,
        Width,
        Old_X,
        Old_Y: Byte;
        Number: Real;
        Part: Boolean;
      Begin
        Old_X := WhereX;
        Old_Y := WhereY;
        GotoXY( Left, Row );
        Width := Succ( Right - Left );
        Calculation_Side( Amount, Width, Size, Part );
        Show_Side_Bar( Size, Width, Part );
        GotoXY( Old_X, Old_Y );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Duel side bar graph.
    As previously defined.

*************************************************)

    Procedure Duel_Side_Bar_Graph( Left, Row, Right, Amount1, Amount2: Byte );
      Var
        Hold,
        Size1,
        Size2,
        Width,
        Old_X,
        Old_Y: Byte;
        Part1,
        Part2: Boolean;
      Begin
        Old_X := WhereX;
        Old_Y := WhereY;
        GotoXY( Left, Row );
        Width := Succ( Right - Left );
        If ( Amount2 < Amount1 )
          then
            Begin
              Hold := Amount2;
              Amount2 := Amount1;
              Amount1 := Hold;
            End;
        Calculation_Side( Amount1, Width, Size1, Part1 );
        Calculation_Side( Amount2, Width, Size2, Part2 );
        Show_Duel_Side_Bar( Size1, Size2, Width, Part1, Part2 );
        GotoXY( Old_X, Old_Y );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Show tall bar
    This procedure displays a bar graph on the
    screen at the current location by printing
    characters.  Bar_Amount should be between 0
    and Limit.  Limit determines the amount of
    characters to print.  Half defines if there
    should be a half character between the main
    bar and the empty part.

*************************************************)

    Procedure Show_Tall_Bar( Bar_Amount, Limit, Column: Byte; Half: Boolean );
      Var
        Row,
        Count: Byte;
      Begin
        Row := WhereY;
        Count := 0;
        While ( Count < Bar_Amount ) and ( Count < Limit ) do
          Begin
            GotoXY( Column, Row );
            Write( Screen, Bar_Empty );
            Inc( Row );
            Inc( Count );
          End;
        If ( Count < Limit ) and Half
          then
            Begin
              GotoXY( Column, Row );
              Write( Screen, Bar_Half_Tall );
              Inc( Row );
              Inc( Count );
            End;
        While ( Count < Limit ) do
          Begin
            GotoXY( Column, Row );
            Write( Screen, Bar_Full );
            Inc( Row );
            Inc( Count );
          End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Calculation tall.
    This procedure calculates the values to draw
    the tall bar graph.

*************************************************)

    Procedure Calculation_Tall( Amount, Height: Byte; Var Size: Byte; Var Part: Boolean );
      Var
        Number: Real;
      Begin
        If ( Amount >= 100 )
          then
            Begin
              Size := 0;
              Part := False;
            End
          else
            Begin
              Number := Height - ( Amount * Height / 100 );
              Size := Trunc( Number );
              Part := ( ( Frac( Number ) * 10 ) >= 5 );
            End;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Tall bar graph.
    As previously defined.

*************************************************)

    Procedure Tall_Bar_Graph( Top, Bottom, Column, Amount: Byte );
      Var
        Size,
        Old_X,
        Old_Y,
        Height: Byte;
        Part: Boolean;
      Begin
        Old_X := WhereX;
        Old_Y := WhereY;
        GotoXY( Column, Top );
        Height := Succ( Bottom - Top );
        Calculation_Tall( Amount, Height, Size, Part );
        Show_Tall_Bar( Size, Height, Column, Part );
        GotoXY( Old_X, Old_Y );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Draw bar.
    This little procedure draws the part of the
    bar for the duel tall bar graph procedure.

*************************************************)

    Procedure Draw_Bar( Var Row: Byte; Column, Color: Byte; Character: Char );
      Begin
        GotoXY( Column, Row );
        TextAttr := Color;
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
        Write( Character );
        Inc( Row );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Duel tall bar graph.
    As previously defined.

*************************************************)

    Procedure Duel_Tall_Bar_Graph( Top, Bottom, Column, Amount1, Amount2: Byte );
      Var
        Row,
        Hold,
        Old_X,
        Old_Y,
        Height,
        Counter,
        Save_Color,
        Bar2_Background: Byte;
        Step_Value,
        Percent_Value,
        Half_Step_Value: Real;
      Begin
        Bar2_Background := ( Bar2_Color shl 4 );
        Old_X := WhereX;
        Old_Y := WhereY;
        Save_Color := TextAttr;
        Height := ( Bottom - Top );
        If ( Amount1 > Amount2 )
          then
            Begin
              Hold := Amount2;
              Amount2 := Amount1;
              Amount1 := Hold;
            End;
        Row := Top;
        Step_Value := ( 100 / Height );
        Half_Step_Value := ( Step_Value / 2 );
        Percent_Value := 100;
        For Counter := 0 to Height do
          Begin
            If ( Percent_Value > Amount2 )
              then
                If ( ( Percent_Value - Half_Step_Value ) > Amount2 )
                  then
                    Draw_Bar( Row, Column, ( Bar2_Color + Bar_Background ), Bar_Empty )
                  else
                    Draw_Bar( Row, Column, ( Bar2_Color + Bar_Background ), Bar_Half_Tall )
              else
                If ( Percent_Value > Amount1 )
                  then
                    If ( ( Percent_Value - Half_Step_Value ) > Amount1 ) or ( Amount1 = 0 )
                      then
                        Draw_Bar( Row, Column, ( Bar2_Color + Bar2_Background ), Bar_Full )
                      else
                        Draw_Bar( Row, Column, ( Bar1_Color + Bar2_Background ), Bar_Half_Tall )
                  else
                    Draw_Bar( Row, Column, ( Bar1_Color + Bar2_Background ), Bar_Full );
            Percent_Value := ( Percent_Value - Step_Value );
          End;
        TextAttr := Save_Color;
       {$IFDEF OS2}
        TextBackground( TextAttr shr 4 );
       {$ENDIF}
        GotoXY( Old_X, Old_Y );
      End;

{----------------------------------------------------------------------------}

  End.

