(*****************************************************************************

  Program:  Draw Frames.

  Purpose:
    This program demonstrates the ability of the frame unit.

  Features:
    This program displays the various frames that the frame unit can produce.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compiler:
    Turbo Pascal versions 5.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Program Draw_Frames( Input, Output );

  Uses
    Draw,
    Screen,
    Frames;

  Var
   { These variables define the working aspect ratios. }
    XAsp,
    YAsp: Word;
   { Used to accept the keypressed inputs. }
    Command: Char;
   { Holds the old screen mode. }
    Old_Mode: Byte;
   { Holds calculation values for displaying the frames. }
    HalfX,
    HalfY,
    FullX,
    FullY: Integer;

  Begin;
    WriteLn( 'Frames demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;
   { Set up the screen in graphic mode. }
    Get_Screen_Mode( Old_Mode );
    Set_Screen_Mode( {15}6 );

   { Set up the variables for the screen coordinates. }
    FullX := GetMaxX;
    FullY := GetMaxY;
    HalfX := ( FullX div 2 );
    HalfY := ( FullY div 2 );

   { Set up the frame color. }
    Set_Frame_Color( 1 );

   { Draw screen 1. }
    Draw_Frame1( 0, 0, HalfX, HalfY, 20, 10 );
    Draw_Frame2( HalfX, HalfY, FullX, FullY, 20, 10 );
    ReadLn;

   { Draw screen 2. }
    Clear_Graphic_Screen;
    Draw_Frame3( 0, 0, HalfX, HalfY + 50, 18, 9 );
    Draw_Frame4( HalfX, HalfY - 50, FullX, FullY, 18, 9 );
    ReadLn;

   { Draw screen 3. }
    Clear_Graphic_Screen;
    Draw_Frame5( 0, 0, HalfX + 100, HalfY, 20, 10 );
    Draw_Frame6( HalfX - 100, HalfY, FullX, FullY, 20, 10 );
    ReadLn;

   { Draw screen 4. }
    Clear_Graphic_Screen;
    Draw_Frame7( 0, 0, HalfX, FullY, 20, 10 );
    Draw_Frame8( HalfX, 0, FullX, FullY, 20, 10 );
    ReadLn;

   { Draw screen 5. }
    Clear_Graphic_Screen;
    Draw_Frame9( 0, 0, HalfX, HalfY, 14, 7 );
    Draw_Frame10( HalfX, 0, FullX, HalfY, 14, 7 );
    Draw_Frame11( 0, HalfY, HalfX, FullY, 14, 7 );
    Draw_Frame12( HalfX, HalfY, FullX, FullY, 16, 8 );
    ReadLn;

   { Draw screen 6. }
    Clear_Graphic_Screen;
    Draw_Frame13( 0, 0, HalfX, HalfY, 20, 10 );
    Draw_Frame14( HalfX, HalfY, FullX, FullY, 20, 10 );
    Draw_Frame15( HalfX, 0, FullX, HalfY, 20, 10 );
    Draw_Frame16( 0, HalfY, HalfX, FullY, 20, 10 );
    ReadLn;

   { Draw screen 7. }
    Clear_Graphic_Screen;
    Draw_Frame17( 0, 0, HalfX - 5, FullY, 20, 10 );
    Draw_Frame18( HalfX + 5, 0, FullX, FullY, 20, 10 );
    ReadLn;

   { Draw screen 8. }
    Clear_Graphic_Screen;
    Draw_Frame19( 0, 0, FullX, HalfY, 30, 10 );
    Draw_Frame20( 0, HalfY, FullX, FullY, 30, 10 );
    ReadLn;

   { Restore the previous graphic mode. }
    Set_Screen_Mode( Old_Mode );
  End.

