
(*************************************************

  Procedure: Change boolean.
    As previously defined.

*************************************************)

    Procedure Change_Boolean( Row, Column: Byte; Var Field: Boolean );
      Var
        Original_Field: Boolean;
        Character: Char;
        Start,
        Where,
        Finish: Byte;
      Begin
        Cursor_Row := Row;
        Original_Field := Field;
        Write_It( Row, Column, Field );
        Repeat
          Get_Command( Character, Command );
          Case Command of
            Press_Capital_Letters,
            Press_Lower_Letters,
            Press_Extra_Characters:
              Case UpCase( Character ) of
                'T':
                  Begin
                    Field := True;
                    Write_It( Row, Column, Field );
                  End;
                'F':
                  Begin
                    Field := False;
                    Write_It( Row, Column, Field );
                  End;
                'O':
                  Begin
                    Field := Original_Field;
                    Write_It( Row, Column, Field );
                  End;
                ' ':
                  Begin
                    Field := ( Not Field );
                    Write_It( Row, Column, Field );
                  End;
              End; { Case }
            else
              Extended_Capabilities( Command );
          End; { Case }
        Until ( Command in [ Press_Enter, Press_Escape, Press_Up_Arrow, Press_Down_Arrow ] );
        If ( Command = Press_Escape )
          then
            Field := Original_Field;
        GotoXY( Column, Row );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Internal get string.
    This procedure allows for getting the given
    string as input.

*************************************************)

    Procedure Internal_Get_String( Row, Column, Size: Byte; Var Field: String );
      Var
        Stop: Boolean;
        Replace: String;
        Character: Char;
      Begin
        Cursor_Row := Row;
        Field := ' ';
        While ( Length( Field ) < Size ) do
          Field := ( Field + ' ' );
        Replace := Field;
        Print_It( Row, Column, Field );
        Stop := False;
        Repeat
          Get_Command( Character, Command );
          Case Command of
            Press_Lower_Letters,
            Press_Numbers,
            Press_Lower_Letters,
            Press_Capital_Letters,
            Press_Extra_Characters:
              Begin
                Delete( Field, 1, 1 );
                Field := ( Field + Character );
                Print_It( Row, Column, Field );
              End;
            Press_Delete_Arrow:
              Begin
                Delete( Field, Length( Field ), 1 );
                Field := ( ' ' + Field );
                Print_It( Row, Column, Field );
              End;
            Press_Delete:
              Begin
                Field := Replace;
                Print_It( Row, Column, Field );
              End;
            Press_Enter,
            Press_Escape,
            Press_Up_Arrow,
            Press_Down_Arrow,
            Pointer_Up,
            Pointer_Down:
              Stop := True;
            else
              Extended_Capabilities( Command );
          End; { Case }
        Until Stop;
        GotoXY( Column, Row );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set byte.
    As previously defined.

*************************************************)

    Procedure Set_Byte( Row, Column: Byte; Var Field: Byte );
      Const
        Low = 0;
        High = 255;
        Length = 3;
      Var
        Temporary_Field: LongInt;
      Begin
        Temporary_Field := Field;
        Set_Number( Row, Column, Temporary_Field, Length, Low, High );
        Field := Temporary_Field;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set word.
    As previously defined.

*************************************************)

    Procedure Set_Word( Row, Column: Byte; Var Field: Word );
      Const
        Low = 0;
        High = 65535;
        Length = 5;
      Var
        Temporary_Field: LongInt;
      Begin
        Temporary_Field := Field;
        Set_Number( Row, Column, Temporary_Field, Length, Low, High );
        Field := Temporary_Field;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set short integer.
    As previously defined.

*************************************************)

    Procedure Set_Short_Integer( Row, Column: Byte; Var Field: ShortInt );
      Const
        Low = -128;
        High = 127;
        Length = 4;
      Var
        Temporary_Field: LongInt;
      Begin
        Temporary_Field := Field;
        Set_Number( Row, Column, Temporary_Field, Length, Low, High );
        Field := Temporary_Field;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set integer.
    As previously defined.

*************************************************)

    Procedure Set_Integer( Row, Column: Byte; Var Field: Integer );
      Const
        Low = -32768;
        High = 32767;
        Length = 6;
      Var
        Temporary_Field: LongInt;
      Begin
        Temporary_Field := Field;
        Set_Number( Row, Column, Temporary_Field, Length, Low, High );
        Field := Temporary_Field;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set long integer.
    As previously defined.

*************************************************)

    Procedure Set_Long_Integer( Row, Column: Byte; Var Field: LongInt );
      Const
        Low = -2147483647;
        High = 2147483647;
        Length = 11;
      Begin
        Set_Number( Row, Column, Field, Length, Low, High );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get short integer.
    As previously defined.

*************************************************)

    Procedure Get_Short_Integer( Row, Column: Byte; Var Field: ShortInt );
      Var
        Data: String;
        Result: Integer;
        Temporary: ShortInt;
      Begin
        Repeat
          Internal_Get_String( Row, Column, 4, Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Data );
          Val( Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get integer.
    As previously defined.

*************************************************)

    Procedure Get_Integer( Row, Column: Byte; Var Field: Integer );
      Var
        Data: String;
        Result,
        Temporary: Integer;
      Begin
        Repeat
          Internal_Get_String( Row, Column, 6, Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Data );
          Val( Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get long integer.
    As previously defined.

*************************************************)

    Procedure Get_Long_Integer( Row, Column: Byte; Var Field: LongInt );
      Var
        Data: String;
        Result: Integer;
        Temporary: LongInt;
      Begin
        Repeat
          Internal_Get_String( Row, Column, 11, Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Data );
          Val( Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get byte.
    As previously defined.

*************************************************)

    Procedure Get_Byte( Row, Column: Byte; Var Field: Byte );
      Var
        Data: String;
        Result: Integer;
        Temporary: Byte;
      Begin
        Repeat
          Internal_Get_String( Row, Column, 3, Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Data );
          Val( Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get word.
    As previously defined.

*************************************************)

    Procedure Get_Word( Row, Column: Byte; Var Field: Word );
      Var
        Data: String;
        Result: Integer;
        Temporary: Word;
      Begin
        Repeat
          Internal_Get_String( Row, Column, 5, Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Data );
          Val( Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get real.
  As previously defined.

*************************************************)

    Procedure Get_Real( Row, Column: Byte; Var Field: Real );
      Var
        Data: String;
        Result: Integer;
        Temporary: Real;
      Begin
        Repeat
          Internal_Get_String( Row, Column, 15, Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Data );
          Val( Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get string.
    As previously defined.

*************************************************)

    Procedure Get_String( Row, Column: Byte; Var Field: String );
      Begin
        Internal_Get_String( Row, Column, Length( Field ), Field );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Edit short integer.
    As previously defined.

*************************************************)

    Procedure Edit_Short_Integer( Row, Column: Byte; Var Field: ShortInt );
      Var
        Data,
        Edit_Data: String;
        Temporary: ShortInt;
        Result: Integer;
      Begin
        If ( Field = 0 )
          then
            Data := '   0'
          else
            Str( Field:4, Data );
        Repeat
          Edit_Data := Data;
          Reverse_Edit_The_String( Row, Column, Edit_Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Edit_Data );
          Val( Edit_Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Edit integer.
    As previously defined.

*************************************************)

    Procedure Edit_Integer( Row, Column: Byte; Var Field: Integer );
      Var
        Data,
        Edit_Data: String;
        Result,
        Temporary: Integer;
      Begin
        If ( Field = 0 )
          then
            Data := '     0'
          else
            Str( Field:6, Data );
        Repeat
          Edit_Data := Data;
          Reverse_Edit_The_String( Row, Column, Edit_Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Edit_Data );
          Val( Edit_Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Edit long integer.
    As previously defined.

*************************************************)

    Procedure Edit_Long_Integer( Row, Column: Byte; Var Field: LongInt );
      Var
        Data,
        Edit_Data: String;
        Temporary: LongInt;
        Result: Integer;
      Begin
        If ( Field = 0 )
          then
            Data := '              0'
          else
            Str( Field:15, Data );
        Repeat
          Edit_Data := Data;
          Reverse_Edit_The_String( Row, Column, Edit_Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Edit_Data );
          Val( Edit_Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Edit byte.
    As previously defined.

*************************************************)

    Procedure Edit_Byte( Row, Column: Byte; Var Field: Byte );
      Var
        Data,
        Edit_Data: String;
        Temporary: Byte;
        Result: Integer;
      Begin
        If ( Field = 0 )
          then
            Data := '   0'
          else
            Str( Field:4, Data );
        Repeat
          Edit_Data := Data;
          Reverse_Edit_The_String( Row, Column, Edit_Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Edit_Data );
          Val( Edit_Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Edit word.
    As previously defined.

*************************************************)

    Procedure Edit_Word( Row, Column: Byte; Var Field: Word );
      Var
        Data,
        Edit_Data: String;
        Temporary: Word;
        Result: Integer;
      Begin
        If ( Field = 0 )
          then
            Data := '     0'
          else
            Str( Field:6, Data );
        Repeat
          Edit_Data := Data;
          Reverse_Edit_The_String( Row, Column, Edit_Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Edit_Data );
          Val( Edit_Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Edit real.
    As previously defined.

*************************************************)

    Procedure Edit_Real( Row, Column: Byte; Var Field: Real );
      Var
        Data,
        Edit_Data: String;
        Temporary: Real;
        Result: Integer;
      Begin
        If ( Field = 0 )
          then
            Data := '                 0.0'
          else
            Str( Field:10:10, Data );
        Repeat
          Edit_Data := Data;
          Reverse_Edit_The_String( Row, Column, Edit_Data );
          If ( Command = Press_Escape )
            then
              Exit;
          Remove_All_Blanks( Edit_Data );
          Val( Edit_Data, Temporary, Result );
        Until ( Result = 0 );
        Field := Temporary;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Edit string.
    As previously defined.

*************************************************)

    Procedure Edit_String( Row, Column: Byte; Var Field: String );
      Begin
        Edit_The_String( Row, Column, Field );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Toggle byte.
    As previously defined.

*************************************************)

    Procedure Toggle_Byte( Row, Column: Byte; Var Field: Byte );
      Const
        Low = 0;
        High = 255;
        Rate = 1;
        Length = 3;
      Var
        Temporary_Field: LongInt;
      Begin
        Temporary_Field := Field;
        Toggle_Number( Row, Column, Temporary_Field, Length, Rate, Low, High );
        Field := Temporary_Field;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Toggle word.
    As previously defined.

*************************************************)

    Procedure Toggle_Word( Row, Column: Byte; Var Field: Word );
      Const
        Low = 0;
        High = 65535;
        Rate = 2;
        Length = 5;
      Var
        Temporary_Field: LongInt;
      Begin
        Temporary_Field := Field;
        Toggle_Number( Row, Column, Temporary_Field, Length, Rate, Low, High );
        Field := Temporary_Field;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Toggle short integer.
    As previously defined.

*************************************************)

    Procedure Toggle_Short_Integer( Row, Column: Byte; Var Field: ShortInt );
      Const
        Low = -128;
        High = 127;
        Rate = 1;
        Length = 4;
      Var
        Temporary_Field: LongInt;
      Begin
        Temporary_Field := Field;
        Toggle_Number( Row, Column, Temporary_Field, Length, Rate, Low, High );
        Field := Temporary_Field;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Toggle integer.
    As previously defined.

*************************************************)

    Procedure Toggle_Integer( Row, Column: Byte; Var Field: Integer );
      Const
        Low = -32768;
        High = 32767;
        Rate = 2;
        Length = 6;
      Var
        Temporary_Field: LongInt;
      Begin
        Temporary_Field := Field;
        Toggle_Number( Row, Column, Temporary_Field, Length, Rate, Low, High );
        Field := Temporary_Field;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Toggle long integer.
    As previously defined.

*************************************************)

    Procedure Toggle_Long_Integer( Row, Column: Byte; Var Field: LongInt );
      Const
        Low = -2147483647;
        High = 2147483647;
        Rate = 4;
        Length = 11;
      Begin
        Toggle_Number( Row, Column, Field, Length, Rate, Low, High );
      End;
