{ RNGTST.PAS : Test RNGLIB unit

  Title   : RNGTST
  Version : 4.1
  Date    : Nov 26,1996
  Author  : J R Ferguson
  Language: Borland Turbo Pascal 4.0 through 7.0 (all targets)
  Usage   : Test program
}

PROGRAM RNGTST;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  RngLib, ConLib, ChrLib;

var
  r1, r2 : RngTyp;
  l,h,i  : integer;

procedure WrLn2; begin writeln; writeln end;

procedure DisplayRange(r: RngTyp);
begin
  if r<>nil then with r^ do begin
    write(l,'..',h);
    if nxt<>nil then begin
      write(', ');
      DisplayRange(nxt);
    end;
  end;
end;

procedure DisplayRange1;
begin
  write('r1 : '); DisplayRange(r1); writeln;
end;

procedure DisplayRange2;
begin
  write('r2 : '); DisplayRange(r2); writeln;
end;

procedure DisplayRanges;
begin
  DisplayRange1;
  DisplayRange2;
end;

procedure ReadLH;
begin
  write('l='); readln(l);
  write('h='); readln(h);
end;

procedure ReadI;
begin
  write('i='); readln(i);
end;


{--- Main line ---}

procedure xInside;
begin
  WrLn2;
  DisplayRange1;
  ReadI;
  writeln('RngInside=',RngInside(r1,i));
  WrLn2;
end;

procedure xInsert;
begin
  WrLn2;
  DisplayRange1;
  ReadLH;
  RngInsert(r1,l,h);
  DisplayRange1;
end;

procedure xDelete;
begin
  WrLn2;
  DisplayRange1;
  ReadLH;
  RngDelete(r1,l,h);
  DisplayRange1;
end;

procedure xMerge;
begin
  WrLn2;
  DisplayRanges;
  RngMerge(r1,r2);
  DisplayRanges;
end;

procedure xRemove;
begin
  WrLn2;
  DisplayRanges;
  RngRemove(r1,r2);
  DisplayRanges;
end;

procedure xDisplay;
begin
  WrLn2;
  DisplayRanges;
  writeln;
end;


procedure xSwap;
var r: RngTyp;
begin
  WrLn2;
  DisplayRanges;
  r:= r1; r1:= r2; r2:= r;
  DisplayRanges;
end;


{$I RNGTSTM.PAS}


procedure MainInit;
begin
  RngCreate(r1);
  RngCreate(r2);
end;


procedure MainExit;
begin
  RngDispose(r1);
  RngDispose(r2);
end;


begin { Main program }
  MainInit;
  rngtstm;
  MainExit;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  writeln('Exit'); writeln
{$ENDIF}
end.
