{ BPWTST.PAS : Test BpwLib unit

  Title   : BPWTST
  Version : 1.2
  Date    : Nov 08,1996
  Author  : J R Ferguson
  Language: Borland Pascal v7.0 with Objects
  Usage   : MS-Windows v3.1 application
}


{--- Compiler options ---}

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }


PROGRAM BPWTST;

Uses Objects, OWindows, ODialogs, WinTypes, WinProcs, BpwLib, StpLib, Strings;

{$R BPWTST.RES} { Resource file }
{$I BPWTST.INC} { Resource file related constants }

const
  C_ProgramIdent    = 'BPWTST';
  C_MainWindowClass = 'BPWTSTMAIN';
  C_MainWindowTitle = 'Test BpwLib';
  C_FileWindowClass = 'BPWTSTFILE';
  C_SetupFile       = 'BPWTST.SET';

type
  P_TestList     = ^T_TestList;
  P_FileWindow   = ^T_FileWindow;
  P_MainWindow   = ^T_MainWindow;
  P_Application  = ^T_Application;

  T_TestList     = Object(TStringCollection)
    Constructor  Init;
    Constructor  Load(var V_Stream: TStream);
    procedure    Store(var V_Stream: TStream);
  end;

  T_FileWindow   = Object(T_ListWindow)
    Constructor  Init(V_Parent: PWindowsObject; V_Name: PChar);
    Constructor  Load(var V_Stream: TStream);
    procedure    Store(var V_Stream: TStream);
    function     GetClassName: PChar; virtual;
    procedure    GetWindowClass(var V_Class: TWndClass); virtual;
    procedure    ProcessItem(V_Row: integer); virtual;
  end;

  T_MainWindow   = Object(TMDIWindow)
    Constructor  Init(V_Title: PChar; V_Menu: HMenu);
    function     GetClassName: PChar; virtual;
    function     InitChild: PWindowsObject; virtual;
    procedure    SetupWindow; virtual;
    procedure    CMFileNew   (var V_Message: TMessage); virtual cm_First + cm_FileNew;
    procedure    CMOptSave   (var V_Message: TMessage); virtual cm_First + cm_Optsave;
    procedure    CMOptRestore(var V_Message: TMessage); virtual cm_First + cm_OptRestore;
    procedure    CMHelpAbout (var V_Message: TMessage); virtual cm_First + cm_HelpAbout;
  end;

  T_Application  = Object(TApplication)
    procedure    InitMainWindow; virtual;
  end;

const
  R_FileWindow : TStreamRec = (
    ObjType : OT_Test_Object_0;
    VmtLink : Ofs(TypeOf(T_FileWindow)^);
    Load    : @T_FileWindow.Load;
    Store   : @T_FileWindow.Store
  );

  R_TestList : TStreamRec = (
    ObjType : OT_Test_Object_1;
    VmtLink : Ofs(TypeOf(T_TestList)^);
    Load    : @T_TestList.Load;
    Store   : @T_TestList.Store
  );


{--- General ---}

procedure StreamRegistration;
begin
  RegisterObjects;
  RegisterOWindows;
  RegisterBpwLib;
  RegisterType(R_FileWindow);
  RegisterType(R_TestList);
end;


{--- T_TestList ---}

Constructor T_TestList.Init;
var r: integer; c: char; s: string;
begin
  Inherited Init(20,10);
  for r:= 0 to Random(26) do begin
    c:= chr(ord('a')+r);
    StpMake(s,c,1+Random(80));
    Insert(NewStr(s));
  end;
end;

Constructor  T_TestList.Load(var V_Stream: TStream);
begin Inherited Load(V_Stream); end;

procedure    T_TestList.Store(var V_Stream: TStream);
begin Inherited Store(V_Stream); end;


{--- T_FileWindow ---}

Constructor  T_FileWindow.Init(V_Parent: PWindowsObject; V_Name: PChar);
begin inherited Init(V_Parent, V_Name, New(P_TestList,Init)); end;

Constructor  T_FileWindow.Load(var V_Stream: TStream);
begin Inherited Load(V_Stream); end;

procedure    T_FileWindow.Store(var V_Stream: TStream);
begin Inherited Store(V_Stream); end;

function     T_FileWindow.GetClassName: PChar;
begin GetClassName:= C_FileWindowClass; end;

procedure    T_FileWindow.GetWindowClass(var V_Class: TWndClass);
begin inherited GetWindowClass(V_Class); end;

procedure    T_FileWindow.ProcessItem(V_Row: integer);
var RowStr: String[10]; msg: array[0..80] of char;
begin
  Str(V_Row,RowStr);
  MessageBox(HWindow,StrPCopy(msg,'    row number = '+RowStr),'Process Item',mb_OK);
end;


{--- T_MainWindow ---}

Constructor  T_MainWindow.Init(V_Title: PChar; V_Menu: HMenu);
begin
  inherited Init(V_Title, V_Menu);
  ChildMenuPos:= 2;
end;

function     T_MainWindow.GetClassName: PChar;
begin GetClassName:= C_MainWindowClass; end;

function     T_MainWindow.InitChild: PWindowsObject;
begin InitChild:= New(P_FileWindow, Init(@Self,'')); end;

procedure    T_MainWindow.SetupWindow;
var FirstChild: P_FileWindow;
begin
  inherited SetupWindow;
  FirstChild:= P_FileWindow(InitChild);
  with FirstChild^.Attr do Style:= Style or ws_Maximize;
  Application^.MakeWindow(FirstChild);
end;

procedure    T_MainWindow.CMFileNew   (var V_Message: TMessage);
begin CreateChild; end;

procedure    T_MainWindow.CMOptSave   (var V_Message: TMessage);
var Stream: TBufStream; msg: array[0..255] of char;
begin
  Stream.Init(C_SetupFile,stCreate,1024);
  PutChildren(Stream);
  Stream.Done;
  if Stream.Status <> stOK then begin
    StrPCopy(msg,'Unable to save setup file'#13+C_SetupFile+#13+BPWStreamMsg(Stream));
    MessageBox(0,msg,'Error',mb_IconHand or mb_OK);
  end;
end;

procedure    T_MainWindow.CMOptRestore(var V_Message: TMessage);
var Stream: TBufStream; msg: array[0..255] of char;
begin
  Stream.Init(C_SetupFile,stOpenRead,1024);
  if Stream.Status = stOK then begin
    CloseChildren;
    GetChildren(Stream);
    CreateChildren;
  end;
  Stream.Done;
  if Stream.Status <> stOK then begin
    StrPCopy(msg,'Unable to load setup file'#13+C_SetupFile+#13+BPWStreamMsg(Stream));
    MessageBox(0,msg,'Error',mb_IconHand or mb_OK);
  end;
end;

procedure    T_MainWindow.CMHelpAbout (var V_Message: TMessage);
begin
  MessageBox(HWindow,
    C_ProgramIdent + #13 +
    C_MainWindowTitle + #13 +
    '(c)1996 J.R. Ferguson',
    'About this program',
    mb_IconInformation or mb_OK)
end;


{--- T_Application ---}

procedure    T_Application.InitMainWindow;
begin
  MainWindow:= New(P_MainWindow,
    Init(C_MainWindowTitle,LoadMenu(HInstance,MakeIntResource(Mnu_Main))));
end;


{--- Main program ---}

begin { Main program }
  Randomize;
  StreamRegistration;
  Application:= New(P_Application, Init(C_ProgramIdent));
  Application^.Run;
  Dispose(Application,Done);
end.
