{ MATIO.PAS : Simple matrix I/O routines

  title   : MATIO
  version : 4.0
  date    : May 15,1994
  author  : J R Ferguson
  language: Turbo Pascal v4.0 t/m v7.0 (all Targets)
  usage   : unit

  Interactive I/O, using standard input and output.
  Primarily meant for test purposes.
}

UNIT MatIo;

INTERFACE
uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  DefLib, MatLib;

const MatDFLWIDTH = 9;  { default display width for matrix elements }

procedure MatSetElmWidth(width: integer);
{ Sets output display width of matrix elements to specified width.
}

procedure MatWriteElm(x:MatElmTyp);
{ Write matrix element value }

procedure MatReadIndex(prompt: StpTyp; var index: MatInd);
{ Writes prompt, then reads index, validating for valid bounds
  1..MatMAX. The process is repeated until the input passes the
  validation test.
}

procedure MatRead(var A: MatTyp);
{ Uses MatReadIndex to read the dimensions (prompting 'n=' and 'm='),
  then prompts for and reads the matrix elements in a row/column order.
}

procedure MatWrite(var A: MatTyp);
{ Writes all matrix elements of A in a row/column order.
}


IMPLEMENTATION

const ElmWidth : integer = MatDFLWIDTH;

procedure MatSetElmWidth(width: integer);
begin ElmWidth:= width; end;

procedure MatWriteElm(x:MatElmTyp);
begin
  if abs(x)<MatEPS then write ('0':ElmWidth)
  else begin
    if x<0 then write('-') else write(' '); write(abs(x):ElmWidth-1);
  end
end;

procedure MatReadIndex(prompt: StpTyp; var index: MatInd);
var n: integer; ok: boolean;
begin
  repeat
    write(prompt); {$I-} readln(n); {$I+}
    ok:= (IOresult=0) and (n>=1) and (n<=MatMax);
    if not ok then write(chr(AsciiBEL));
  until ok;
  index:= n;
end;

procedure MatRead(var A: MatTyp); { simple version }
var i,j: MatInd; ok: boolean;
begin with A do begin
  MatReadIndex('n = ',Nrow); MatReadIndex('m = ',Ncol); writeln;
  for i:= 1 to Nrow do begin
    for j:= 1 to Ncol do repeat
      write('A(',i,',',j,') = '); {$I-} readln(elm[i,j]); {$I+}
      ok:= IOresult=0; if not ok then write(chr(AsciiBEL));
    until ok;
    writeln;
  end
end end;

procedure MatWrite(var A: MatTyp);
var i,j: MatInd;
begin with A do begin for i:= 1 to Nrow do for j:= 1 to Ncol do begin
  MatWriteElm(elm[i,j]); if j<Ncol then write(' ') else writeln;
end end end;

END.
