program GvLangResCompiler;

{ Copr. 1995 Matthias K"oppe
}

uses Objects, GvTexts;

var
  TextStream: PBufStream;
  List: PStrListMaker;
  gvs: Text;
  s, txt: string;
  i, j, k, id, num, E: Integer;

procedure Warn(w: string);
begin
  WriteLn('Warning: ', ParamStr(i), '(', num, '): ', w)
end;

function OctalVal(s: string): Integer;
var
  Err: Boolean;

	function OctalDigit(c: Char): Integer;
	begin
	  Dec(c, Ord('0'));
	  Err := Err or (c > #9);
	  OctalDigit := Ord(c)
	end;

begin
  Err := false;
  OctalVal := OctalDigit(s[1]) * 64 + OctalDigit(s[2]) * 8 + OctalDigit(s[3]);
  If Err then OctalVal := -1
end;

begin
  RegisterType(RStrListMaker);
  If ParamCount < 2
  then begin
    WriteLn('gvlc GVL-file GVS-file GVS-file GVS-file...');
    WriteLn;
    WriteLn('Compiles a collection of GVS script files and');
    WriteLn('creates a GVL file, which is used by G''Vision.');
    WriteLn;
    WriteLn('Example:  gvlc english.gvl english.gvs englishx.gvs');
    Halt(1)
  end;
  List := New(PStrListMaker, Init(60000, 60000));
  For i := 2 to ParamCount do
  begin
    Assign(GVS, ParamStr(i));
    Reset(GVS);
    num := 0;
    while not eof(GVS) do
    begin
      txt := '';
      ReadLn(GVS, s); Inc(num);
      If s[1] <> '#'	{ Comment }
      then begin
	j := Pos(':', s);
	If j = 0
	then Warn('Wrong syntax.')
	else begin
	  Val(Copy(s, 1, j - 1), id, E);
	  If E <> 0
	  then Warn('Could not interpret ID number.')
	  else begin
	    Inc(j);
	    while j <= Length(s) do
	    begin
	      If s[j] = '\'
	      then begin
		If j = Length(s)
		then begin
		  ReadLn(GVS, s);
		  j := 1;
                  inc(num);
		end else
		If Upcase(s[j+1]) = 'N'
		then begin
		  txt := txt + #13#10;
		  Inc(j, 2)
		end
		else begin
		  k := OctalVal(Copy(s, j + 1, 3));
		  If k = -1
		  then Warn('Wrong octal number.')
		  else txt := txt + Chr(k);
		  Inc(j, 4)
		end;
	      end
	      else begin
		txt := txt + s[j];
		Inc(j)
	      end
	    end;
	    List^.Put(ID, txt);
	  end;
	end;
      end;
    end;
    Close(GVS)
  end;
  StoreTexts(ParamStr(1), List);
  Dispose(List, Done)
end.
