{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Misc/Coord.pas                   [x] Protected mode

  How tCoordinate handles coordinate pairs ( [0 .. 255], [0 .. 255] ).

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFBASIC, EFSTREAM;


var Coord1, Coord2, Coord3 : tCoordinates;

begin
     Coord1.Initialize (0, 0);
     Coord2.Initialize (255, 255);
     Coord3.Duplicate  (@Coord2);   { Copy from Coord2 into a new instance }

     Coord1.Move (1, 0);            { Move (1,1) coordinates relative (0,0) }
     Coord2.Move (-254, -255);      { Move (-254,-255) coordinates relative (255,255) }
     Coord3.Move (-128, -128);      { Move (-128,-128) coordinates relative (255,255) }

     { Display the coordinates }
     Write ('Coord1 = '); Coord1.StreamWrite (StdIO); WriteLn;
     Write ('Coord2 = '); Coord2.StreamWrite (StdIO); WriteLn;
     Write ('Coord3 = '); Coord3.StreamWrite (StdIO); WriteLn;

     { Is Coord1 = Coord2? }
     if Coord1.IsEqual (@Coord2)
        then WriteLn ('Coord1 <==> Coord2.');
end.