{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Queues/Circular.pas     [x] Protected mode

  Demonstration of a circular queue based on the doubly linked
  data structure.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDATA;


var MyQueue : tCircularQueue; Index, Number : integer;

begin
     WriteLn ('* Circular queue demonstration *');

     { Initializes queue and stores 25 integer numbers in structure }
     with MyQueue do begin

          Initialize (SizeOf(Integer));
                      { Element size }

          { Circular queue operations:

            Enqueue (Data) - add an element to the queue.
            Dequeue (Data) - retrieve "the oldest" element and circulate it.
            Skip (Data) - erase "the oldest" element. }

          { Place numbers in queue }
          for Index := 1 to 25 do Enqueue (Index);

          { Display queued data and recycle 8 times }
          for Index := 1 to 200 do begin
              Dequeue (Number);
              Write (Number:5);
          end;

          WriteLn;

          Intercept;
     end;
end.