/* vio.c - virtual pseudo-file i/o
 */

#include "aldtypes.h"	/* for WORD, DWORD, LPSTR, etc */
#include "aldutils.h"	/* for copy prototype */
#include "imtypes.h"

#include "stdio.h"
#include "dloc.h"
#include "vio.h"

#ifdef MACINTOSH
int fseek (FILE *, long, int);
int fread (char *, int, int, FILE *);
#endif

extern DWORD	TiffStart;

/*************** LOCAL routines ***********************/


/******************** external routines **********************/

RC VRead (pD, pos, BytesToRead, lpBuf)
PDLOC	pD;		/* pointer to a structure that tells
				 * where to go for the information 
				 */
DWORD	pos;	/* byte position, with respect to the beginning
				 * of the "file", to start reading data from
				 */
WORD	BytesToRead;
LPSTR	lpBuf;	/* where to put the data */
{
		register DLOC	*pDloc = (DLOC *)pD;
		RC				err = SUCCESS;
		int				red;
		
		/* DBMSG(("VRead: top.  %u\n", BytesToRead)); */
		
		if (pDloc->dlWhere == INFILE) {
			if (err = fseek (pDloc->dlFp, (long) (pos+TiffStart), 0)) {
				DBMSG(( "VRead: fseek error\n"));
				DBMSG((" err=%u pos=%lu BytesToRead=%u\n",
				 err,pos,BytesToRead));
				return err;
			}
			if ((red = fread (lpBuf, 1, BytesToRead, pDloc->dlFp)) == 0) {
				DBMSG(( "VRead: fread error\n"));
				DBMSG((" err=%u pos=%lu BytesToRead=%u\n",
				 err,pos,BytesToRead));						
				return -1;
			}
			/* ByteHexDump (BytesToRead, (LPBYTE)lpBuf); */
			
		} else {
			DBMSG(("VRead: bad dlWhere\n"));
			err = -1;
		}
		
cu0:	/* DBMSG(("VRead: bottom\n")); */
		return err;
}