;
; LSD os library for use with C compilers
;
; Copyright(c) 1996 LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
	.386
	MODEL USE32 SMALL

include lib.asi

	PUBLIC	_OSPutChar,_OSPutExtendedChar, _OSPutText, _OSClearTextScreen
	PUBLIC	_OSSetTextAttribute,_OSSetTextCursor
	PUBLIC	_OSGetTextAttribute,_OSGetTextCursor
	PUBLIC	_OSBlankScreen, _OSUnblankScreen
_TEXT	SEGMENT	
;
;* void OSPutChar(char item);
;
_OSPutChar	PROC	
	ARG	ITEM : DWORD
	ENTER	0,0
	mov	dl,[BYTE PTR ITEM]
	OS	VF_CHAR
	LEAVE
	ret
_OSPutChar	ENDP	
;
;* void OSPutExtendedChar(char item);
;
_OSPutExtendedChar	PROC	
	ARG	ITEM : DWORD
	ENTER	0,0
	mov	dl,[BYTE PTR ITEM]
	OS	VF_CHAR
	LEAVE
	ret
_OSPutExtendedChar	ENDP	
;
;* void OSPutText(char *text);
;
_OSPutText	PROC	
	ARG	ITEM : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[ITEM]
	OS	VF_TEXT
	pop	ebx
	LEAVE
	ret
_OSPutText	ENDP	
;
;* void OSClearTextScreen(void);
;
_OSClearTextScreen	PROC	
	OS	VF_CLEARSCREEN
	ret
_OSClearTextScreen	ENDP	
;
;* void OSSetTextAttribute(int attribute);
;
_OSSetTextAttribute	PROC	
	ENTER	0,0
	ARG	ATTRIBUTE : DWORD
	mov	al,[BYTE PTR ATTRIBUTE]
	OS	VF_SETATTRIBUTE
	LEAVE
	ret
_OSSetTextAttribute	ENDP	
;
;* void OSSetTextCursor(int row, int col);
;
_OSSetTextCursor	PROC	
	ENTER	0,0
	ARG	ROW : DWORD, COL : DWORD
	push	ebx
	mov	bh,[BYTE PTR ROW]
	mov	bl,[BYTE PTR COL]
	OS	VF_SETCURPOS
	pop	ebx
	LEAVE
	ret
_OSSetTextCursor	ENDP	
;
;* int OSGetTextAttribute(void);
;
_OSGetTextAttribute	PROC	
	OS	VF_GETATTRIBUTE
	cbw
	cwde
	ret
_OSGetTextAttribute	ENDP	
;
;* void OSGetTextCursor(int *row, int *col);
;
_OSGetTextCursor	PROC	
	ENTER	0,0
	ARG	ROW : DWORD, COL : DWORD
	OS	VF_GETCURPOS
	mov	ecx,eax
	cbw
	cwde
	mov	edx,[COL]
	mov	[edx],eax
	mov	eax,ecx
	cbw
	cwde
	mov	edx,[ROW]
	mov	[edx],eax
	LEAVE
	ret
_OSGetTextCursor	ENDP	
;
;* void OSBlankScreen(void);
;
_OSBlankScreen	PROC	
	OS	VF_BLANKSCREEN
	ret
_OSBlankScreen	ENDP	
;
;* void OSUnblankScreen(void);
;
_OSUnblankScreen	PROC	
	OS	VF_UNBLANKSCREEN
	ret
_OSUnblankScreen	ENDP	
_TEXT	ENDS	
END