;
; LSD os library for use with C compilers
;
; Copyright(c) 1996 LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
	.386
	MODEL USE32 SMALL

include lib.asi

	PUBLIC	_OSGetTicks,_OSConvertToMS,_OSConvertToTicks
	PUBLIC	_OSSetDate,_OSGetDate,_OSSetTime,_OSGetTime
	PUBLIC	_OSEnableWatchDog, _OSDisableWatchDog,_OSResetWatchDog
	PUBLIC  _OSGetVersion

_TEXT	SEGMENT	
;
;* unsigned OSGetTicks(void);
;
_OSGetTicks	PROC	
	OS	MI_TIMER
	ret
_OSGetTicks	ENDP	
;
;* unsigned OSConvertToMS(unsigned value);
;
_OSConvertToMS	PROC	
	arg	VALUE : DWORD
	ENTER	0,0
	mov	eax,[VALUE]
	OS	MI_CVTTOMS
	LEAVE
	ret
_OSConvertToMS	ENDP	
;
;* unsigned OSConvertToTicks(unsigned value);
;
_OSConvertToTicks	PROC	
	arg	VALUE : DWORD
	ENTER	0,0
	mov	eax,[VALUE]
	OS	MI_CVTFROMMS
	LEAVE
	ret
_OSConvertToTicks	ENDP	
;
;* void OSSetDate(int day, int month, int year);
;
_OSSetDate	PROC	
	ARG	DAY : DWORD, MONTH : DWORD, YEAR : DWORD
	ENTER	0,0
	push	ebx
	mov	bh,[BYTE PTR DAY]
	mov	bl,[BYTE PTR MONTH]
	mov	ecx,[YEAR]
	OS	MI_SETDATE
	pop	ebx
	LEAVE
	ret
_OSSetDate	ENDP	
;
;* void OSSetTime(int hr, int min, int sec);
;
_OSSetTime	PROC	
	ARG	HR : DWORD, MIN : DWORD, SEC : DWORD
	ENTER	0,0
	push	ebx
	mov	bh,[BYTE PTR HR]
	mov	bl,[BYTE PTR MIN]
	mov	cl,[BYTE PTR SEC]
	OS	MI_SETTIME
	pop	ebx
	LEAVE
	ret
_OSSetTime	ENDP	
;
;* void OSGetDate(int *day, int *month, int *year);
;
_OSGetDate	PROC	
	ARG	DAY : DWORD, MONTH : DWORD, YEAR : DWORD
	ENTER	0,0
	push	ebx
	OS	MI_GETDATE
	mov	edx,[DAY]
	movzx	eax,bh
	mov	[edx],eax
	mov	edx,[MONTH]
	movzx	eax,bl
	mov	[edx],eax
	mov	edx,[YEAR]
	mov	[edx],ecx
	pop	ebx
	LEAVE
	ret
_OSGetDate	ENDP	
;
;* void OSGetTime(int *hr, int *min, int *sec);
;
_OSGetTime	PROC	
	ARG	HR : DWORD, MIN : DWORD, SEC : DWORD
	ENTER	0,0
	push	ebx
	OS	MI_GETTIME
	mov	edx,[HR]
	movzx	eax,bh
	mov	[edx],eax
	mov	edx,[MIN]
	movzx	eax,bl
	mov	[edx],eax
	mov	edx,[SEC]
	mov	[edx],ecx
	pop	ebx
	LEAVE
	ret
_OSGetTime	ENDP	
;
;* void OSEnableWatchDog(void);
;
_OSEnableWatchDog	PROC	
	OS	MI_ENABLEWATCHDOG
	ret
_OSEnableWatchDog	ENDP	
;
;* void OSDisableWatchDog(void);
;
_OSDisableWatchDog	PROC	
	MOV	EBX,WATCHDOGVERIFY
	OS	MI_DISABLEWATCHDOG
	ret
_OSDisableWatchDog	ENDP	
;
;* void OSResetWatchDog(void);
;
_OSResetWatchDog	PROC	
	OS	MI_RESETWATCHDOG
	ret
	ENDP	
;
;* int OSGetVersion(void);
;
_OSGetVersion	PROC	
	OS	MI_VERSION
	ret
_OSGetVersion	ENDP	
_TEXT	ENDS	
END