/* 
PC AT Performance Analyzer by Robert Morein 10/26/86.
(215)-646-4894


Purpose: By copying the AT proms into two files, the speed of
file copying to disk is measured. The files, incidentally,  
can be used for other purposes.

The AT bios will be in the file "perform2", while the file
"perform1" will normally contain FF's unless there are 
additional rom drivers in the system.

Compiled with the Computer Innovations C86 compiler.
*/


#include "STDIO.H"
#include "time.h"
main() {
FILE *rom1, *rom2; char *abstoptr();
unsigned cha *base;
unsigned long i;
long starttm, fintm;

/* The file "perform1.exe is whatever is in the range 0xE000 to 0xFFFF,
which sometimes contains additional drivers. */
base = abstoptr( 0xE0000 );
time( &starttm );
rom1 = fopen( "perform1", "wb" );
for( i = 0; i <= 0xFFFF; i++ ) putc( *(base + i), rom1 );
fclose( rom1 );
/* Now we dump the rom bios: */
base = abstoptr( 0xF0000 );
rom2 = fopen( "perform2", "wb" );
for( i = 0; i <= 0xFFFF; i++ ) putc( *(base + i), rom2 );
fclose( rom2 );
time( &fintm );
printf("\nFILE I/O performance time: %ld", fintm - starttm );
printf("\nRelative performance: %f", (double)(fintm - starttm)/12 );
}

/* 
When you burn the rom bios, first adjust the checksum, using
setcheck.exe, then split the file into even and odd bytes using
"splitter.exe"
*/
