/*******************************
 * APManage                    *
 * All code Copyright (c) 1995 *
 * By Jascha Franklin-Hodge    *
 * All Rights Reserved         *
 *                             *
 * Code may be modified or     *
 * redistributed for non-      *
 * commerical use only.        *
 *                             *
 *Send comments to:            *
 * joeshmoe@world.std.com      *
 *******************************/

#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#define APM_INTERRUPT 0x15

void apm_suspend (void);
void apm_standby (void);
void apm_connect(void);
void apm_disconnect(void);
void apm_info(void);
void apm_disable (void);
void apm_enable (void);
void apm_status (void);
void apm_restore (void);
void syntax (void);

int sup16bit;
int sup32bit; 
int supcpuidle;
int apmdisabled;
int apmvermajor;
int apmverminor;
int apmconnected;
char progname[255];

main (int *argc, char *argv[]) {
	union REGS regs;

	strcpy (progname, (char *)argv[0]);

	textcolor(15);
	cprintf ("APManage v1.0 By Jascha Franklin-Hodge\r\n\r\n");
	textcolor(7);

/* Check for APM */
	regs.h.ah = 0x53;
	regs.h.al = 0x00;
	regs.x.bx = 0x0000;

	int86(APM_INTERRUPT, &regs, &regs);

	if (regs.x.cflag == 0) {
		apmvermajor = regs.h.ah;
		apmverminor = regs.h.al;

		if (regs.x.cx & 0x00000001) {
			sup16bit=1;
		} else {
			sup16bit=0;
		}

		if (regs.x.cx & 0x00000010) {
			sup32bit=1;
		} else {
			sup32bit=0;
		}

		if (regs.x.cx & 0x00000100) {
			supcpuidle=1;
		} else {
			supcpuidle=0;
		}
		if (regs.x.cx & 0x00001000) {
			apmdisabled=1;
		} else {
			apmdisabled=0;
		}
	} else {
		fprintf (stderr, "\nERROR: APM not installed\n");
		exit(EXIT_FAILURE);
	}

	(void) apm_connect();

/*process args */
	if ((int) argc == 1) (void) syntax();

	while ((int) argc > 1) {
		if (argv[1][0] == '-') {
			switch (argv[1][1]) {
				case 's':
				case 'S':
					(void) apm_suspend ();
					break;
				case 't':
				case 'T':
					(void) apm_standby ();
					break;
				case 'i':
				case 'I':
					(void) apm_info ();
					break;
				case 'd':
				case 'D':
					(void) apm_disable ();
					break;
				case 'e':
				case 'E':
					(void) apm_enable ();
					break;
				case 'b':
				case 'B':
					(void) apm_status ();
					break;
				case 'p':
				case 'P':
					(void) apm_restore ();
					break;

				default:
					(void) syntax ();
					break;
			}
		}

		(int) argc = (int) argc - 1;
		argv++;
	}

	apm_disconnect();

	return(0);
}

void apm_suspend (void) {
	char c;
	union REGS regs;

	regs.h.ah=0x53;
	regs.h.al=0x07;
	regs.x.bx=0x0001;
	regs.x.cx=0x0002;

	int86(APM_INTERRUPT, &regs, &regs);
	c=getchar();
}

void apm_standby (void) {
	char c;
	union REGS regs;

	regs.h.ah=0x53;
	regs.h.al=0x07;
	regs.x.bx=0x0001;
	regs.x.cx=0x0001;

	int86(APM_INTERRUPT, &regs, &regs);

	c=getchar();
}

void apm_connect(void) {
/* Connect to APM */
	union REGS regs;

	regs.h.ah = 0x53;
	regs.h.al = 0x01;
	regs.x.bx = 0x0000;

	int86(APM_INTERRUPT, &regs, &regs);

	if (regs.x.cflag == 0) {
		apmconnected=1;
	} else {
		fprintf (stderr,"\nERROR: could not connect to APM.\n");
		exit (EXIT_FAILURE);
	}
}

void apm_disconnect(void) {
/* Disconnect interface */
	union REGS regs;

	regs.h.ah=0x53;
	regs.h.al=0x04;
	regs.x.bx=0x0000;

	int86(APM_INTERRUPT, &regs, &regs);

	if (regs.x.cflag == 1) {
		fprintf (stderr, "\nERROR: could not disconnect APM.\n");
	}
}

void apm_restore(void) {
/* Disconnect interface */
	union REGS regs;

	regs.h.ah=0x53;
	regs.h.al=0x09;
	regs.x.bx=0xFFFF;

	int86(APM_INTERRUPT, &regs, &regs);

	if (regs.x.cflag == 0) {
		printf ("APM power-on defaults restored.\n");
	} else {
		printf ("\nERROR: could not restore APM power-on defaults.\n");
	}
}

void apm_info(void) {
	printf ("APM verion %d\.%d installed.\n\n", apmvermajor, apmverminor);

	if (sup16bit==1) {
		printf ("APM 16-bit protected mode: supported\n");
	} else {
		printf ("APM 16-bit protected mode: not supported\n");
	}
	if (sup32bit==1) {
		printf ("APM 32-bit protected mode: supported\n");
	} else {
		printf ("APM 32-bit protected mode: not supported\n");
	}

	if (supcpuidle==1) {
		printf ("CPU Idle Call: slows processor clock speed\n");
	} else {
		printf ("CPU Idle Call: does not slow processor clock speed\n");
	}

	if (apmdisabled==1) {
		printf ("APM Disabled in BIOS\n");
	} else {
		printf ("APM Enabled in BIOS\n");
	}
}
void apm_disable (void) {
/* Disable APM */
	union REGS regs;

	regs.h.ah=0x53;
	regs.h.al=0x08;
	regs.x.bx=0xFFFF;
	regs.x.cx=0;

	int86(APM_INTERRUPT, &regs, &regs);
	if (regs.x.cflag == 0) {
		printf ("APM Disabled.\n");
	} else {
		fprintf (stderr, "\nERROR: Could not disable APM\n");
	}
}
void apm_enable (void){
/* Enable APM */
	union REGS regs;

	regs.h.ah=0x53;
	regs.h.al=0x08;
	regs.x.bx=0xFFFF;
	regs.x.cx=1;

	int86(APM_INTERRUPT, &regs, &regs);

	if (regs.x.cflag == 0) {
		printf ("APM Enabled.\n");
	} else {
		fprintf (stderr, "\nERROR: Could not enable APM\n");
	}
}

void apm_status (void){
	union REGS regs;
	regs.h.ah=0x53;
	regs.h.al=0x0A;
	regs.x.bx=0x0001;

	int86(APM_INTERRUPT, &regs, &regs);

	if (regs.x.cflag == 1) {
		fprintf(stderr, "Could not read APM status.\n");
	} else {
		if (regs.h.bh == 0) {
			printf ("AC Line Status: off-line\n");
		} else if (regs.h.bh == 1) {
			printf ("AC Line Status: on-line\n");
		} else {
			printf ("AC Line Status: unknown\n");
		}

		if (regs.h.bl == 0) {
			printf ("Battery Status: high\n");
		} else if (regs.h.bl == 1) {
			printf ("Battery Status: low\n");
		} else if (regs.h.bl == 2) {
			printf ("Battery Status: critical\n");
		} else if (regs.h.bl == 3) {
			printf ("Battery Status: charging\n");
		} else {
			printf ("Battery Status: unknown\n");
		}

		if (regs.h.cl == 255) {
			printf ("Battery Life Remaining: unknown\n");
		} else {
			printf ("Battery Life Remaining: %d\%\n", regs.h.cl);
		}
	}
}

void syntax (void){
	printf ("Syntax: %s [-S] [-T] [-I] [-D] [-E] [-B] [-P]\n\n", progname);
	printf ("\t -S  -  suspend\n");
	printf ("\t -T  -  standby\n");
	printf ("\t -I  -  display APM information\n");
	printf ("\t -D  -  disable APM\n");
	printf ("\t -E  -  enable APM\n");
	printf ("\t -B  -  show battery status\n");
	printf ("\t -P  -  restore power-on defaults\n");

	if (apmconnected == 1) {
		(void) apm_disconnect();
	}
	exit (EXIT_FAILURE);
}

