procedure DRAWAXES (Xfotran, Yfotran, XYmax: real);
{ Draw axes on the screen, if requested }

var OriginX, OriginY, OriginZ: real;    { transformed (2-D) coords of origin }
    XaxisX,  XaxisY,  XaxisZ:  real;    { transformed coords of end of X axis }
    YaxisX,  YaxisY,  YaxisZ:  real;    { transformed coords of end of Y axis }
    ZaxisX,  ZaxisY,  ZaxisZ:  real;    { transformed coords of end of Z axis }
    Xoffset, Yoffset:          real;    { amt to offset axes from real origin }
    Xchar, Ychar:              integer; { half the size of a character }
    Outp: text;

begin
  if (Showaxes > 0) then begin
    perspect (0.0, 0.0, 0.0, OriginX, OriginY, OriginZ);
    perspect (Xaxislen, 0.0, 0.0, XaxisX, XaxisY, XaxisZ);
    perspect (0.0, Yaxislen, 0.0, YaxisX, YaxisY, YaxisZ);
    perspect (0.0, 0.0, Zaxislen, ZaxisX, ZaxisY, ZaxisZ);
    normalize (OriginX, OriginY, Xfotran, Yfotran, XYmax);
    normalize (XaxisX,  XaxisY,  Xfotran, Yfotran, XYmax);
    normalize (YaxisX,  YaxisY,  Xfotran, Yfotran, XYmax);
    normalize (ZaxisX,  ZaxisY,  Xfotran, Yfotran, XYmax);

{ Offset the origin of the axes to put it in the lower left corner }
    Xoffset := OriginX - Gxmin - (Gxmax - Gxmin) * 0.1;
    Yoffset := OriginY - Gymax + (Gymax - Gymin) * 0.1;

    OriginX := OriginX - Xoffset;
    OriginY := OriginY - Yoffset;
    XaxisX  := XaxisX  - Xoffset;
    XaxisY  := XaxisY  - Yoffset;
    YaxisX  := YaxisX  - Xoffset;
    YaxisY  := YaxisY  - Yoffset;
    ZaxisX  := ZaxisX  - Xoffset;
    ZaxisY  := ZaxisY  - Yoffset;

{ Draw the axes }
    gdraw (round(OriginX), round(OriginY), round(XaxisX), round(XaxisY),
           Axiscolor);
    gdraw (round(OriginX), round(OriginY), round(YaxisX), round(YaxisY),
           Axiscolor);
    gdraw (round(OriginX), round(OriginY), round(ZaxisX), round(ZaxisY),
           Axiscolor);

{ Find the position for the axis labels, about 1.2 time the axis length
  from the origin }
    perspect (1.2*Xaxislen, 0.0, 0.0, XaxisX, XaxisY, XaxisZ);
    perspect (0.0, 1.2*Yaxislen, 0.0, YaxisX, YaxisY, YaxisZ);
    perspect (0.0, 0.0, 1.2*Zaxislen, ZaxisX, ZaxisY, ZaxisZ);
    normalize (XaxisX,  XaxisY,  Xfotran, Yfotran, XYmax);
    normalize (YaxisX,  YaxisY,  Xfotran, Yfotran, XYmax);
    normalize (ZaxisX,  ZaxisY,  Xfotran, Yfotran, XYmax);

    XaxisX  := XaxisX  - Xoffset;
    XaxisY  := XaxisY  - Yoffset;
    YaxisX  := YaxisX  - Xoffset;
    YaxisY  := YaxisY  - Yoffset;
    ZaxisX  := ZaxisX  - Xoffset;
    ZaxisY  := ZaxisY  - Yoffset;

{ Now draw the labels }
    Xchar := (Gxmax - Gxmin) div 160;
    Ychar := (Gymax - Gymin) div 50;

{ Draw an X }
    gdraw (round(XaxisX-Xchar), round(XaxisY-Ychar),
           round(XaxisX+Xchar), round(XaxisY+Ychar), Axiscolor);
    gdraw (round(XaxisX-Xchar), round(XaxisY+Ychar),
           round(XaxisX+Xchar), round(XaxisY-Ychar), Axiscolor);

{ Draw a Y }
    gdraw (round(YaxisX-Xchar), round(YaxisY-Ychar),
           round(YaxisX), round(YaxisY), Axiscolor);
    gdraw (round(YaxisX+Xchar), round(YaxisY-Ychar),
           round(YaxisX), round(YaxisY), Axiscolor);
    gdraw (round(YaxisX), round(YaxisY),
           round(YaxisX), round(YaxisY+Ychar), Axiscolor);

{ Draw a Z }
    gdraw (round(ZaxisX-Xchar), round(ZaxisY-Ychar),
           round(ZaxisX+Xchar), round(ZaxisY-Ychar), Axiscolor);
    gdraw (round(ZaxisX+Xchar), round(ZaxisY-Ychar),
           round(ZaxisX-Xchar), round(ZaxisY+Ychar), Axiscolor);
    gdraw (round(ZaxisX-Xchar), round(ZaxisY+Ychar),
           round(ZaxisX+Xchar), round(ZaxisY+Ychar), Axiscolor);
  end; { if Showaxes }
end; { procedure DRAWAXES }
