unit probst_u;
interface
uses
  anorpr_u;

function probst(t:double;idf:integer):double;

implementation

function probst(t:double;idf:integer):double;
{
c        algorithm as 3 applied stats (1968) vol 17 no 2 pp 189-190
c
c        student t distribution  (lower tail)
c
c        uses method of d b owen (biometrika (1965) vol 52 p 438)
}
const
  g1=0.3183098862;

var
  f,a,b,c,s,fk,z
   : double;
  im2,ioe,ks,k
   : integer;
begin
      f := idf;
      if (f<=125.0) then
      begin
        a := t/sqrt(f);
        b := f / (f+t*t);
        im2 := idf - 2;
        ioe := idf - 2*(idf div 2);
        s := 1.0;
        c := 1.0;
        ks := 2 + ioe;
        fk := ks;
        if (im2-2 >= 0) then
        begin
          k := ks;
      {7} while k<=im2 do
          begin    {for k := ks to im2,2}
            c := c*b*(fk-1.0)/fk;
            s := s + c;
            fk := fk + 2.0;
            inc(k,2);
          end;
        end;
    {6} if (ioe<=0) then
        begin
      {1} probst := 0.5+0.5*a*s*sqrt(b);
          exit;
        end;
    {2} if (idf-1<=0) then
      {4} s := 0.0;
    {5} probst:=0.5+(a*b*s+arctan(a))*g1;
    {3} exit;
      end;
    {10 continue}
      z := t* (1.0-0.25/f) / sqrt(1.0+0.5*t*t/f);
      probst := anorpr(z);
end;

end.
