//------------------------------------------------------------------------
//
//	Last updated: 18 Feb 2000
// This is part 2 of the Grid class
//------------------------------------------------------------------------
extern "C"
{
#include "memory.h"
}
#include "grid.h"
#include "labels.h"
#include <stdlib.h>
#include <string.h>
//-------------------------------------------------------------------------
//If the user has selected more than one cell to paste the
//org block into, then check that the selected destination block
//is big enough to carry either one or more complete copies, without
//and bit left over.
//Exit:
//	ax =1 destination location ok
//       and xfit and yfit indicates the number of copies that can be
//      pasted.
//	ax =0 not ok
//
int Grid::CkeckBlocks()
{
	oxl = (c_block.x2 -c_block.x1)+1;
	oyl = (c_block.y2 -c_block.y1)+1;
	dxl = (block.x2 - block.x1)+1;
	dyl = (block.y2 -block.y1)+1;


	if(dxl ==1 && dyl ==1)  //dest is a single cell
	{	//check that the org block can completely fit here
		if((oxl +block.x1 >26) || (oyl +block.y1 >y100)) return 0;
		xfit =1;
		yfit =1;
		return 1; //it will fit once only
	}

	//dest block is greater than single cell. It must be an exact multiple
	//of the original.
	//int r =  dxl %oxl; //r = remainder: should be 0
	if((dxl % oxl) ||(dyl % oyl)) return 0;     //not ok, because there is
															  //a remainder
	//Is the second block big enough?
	if((dxl < oxl) || (dyl <oyl)) return 0;
	//the org block will fit into the dest block completely at least once
	//Find out the precise number of times it will fit.
	xfit = dxl / oxl;
	yfit = dyl / oyl;
	return 1;
}
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
//Called by RightJustify(), or LeftJustify(), or Centre()
//Change allignment of scrncells
//If block not selected just change allignment of single cell
//else for all the visible columns change the allignment
//for those cells that fall within block's range
//then redisplay the screen with the block selected
//Entry:
//	allign = 0 no allignment,
//          1 left, 2 centre, 3 right
int Grid::ChangeAllignment(int allign)
{
	int y, x;

	if(!block.validsw)
	{
		block.x1 = letters[scrncol] - 'A';
		block.x2 = block.x1;
		block.y1 = homey+scrnrow;
		block.y2 = block.y1;
	}

	else GetBlockVars();
	for(y = block.y1; y<= block.y2; y++)
	{
		for(x = block.x1; x<= block.x2; x++)
		{
			if(colwidths[x])       //if the column is visible
			{                      //change its allignment
				scrnsheet = sheet[y*26+x];
				scrnsheet->u.allign = allign;
				sheet(y*26+x, scrnsheet);
			}

		}

	}

	//if(block.validsw)
	//{
		ReDrawSheet(1);
		Refresh();
	//}
	DispCell(1);

	modified =1;
	return 0;
}
//-------------------------------------------------------------------------
//Called by NumbersInCommas()
//For each cell within the block's range or
//if block not selected, within the cell's range
//toggle the flag in the array scrncell[] indicating  whether
//the number is or is not to appear in commas

int Grid::NumbersInCommas()
{
	int y, x;

	if(!block.validsw)
	{
		block.x1 = letters[scrncol] - 'A';
		block.x2 = block.x1;
		block.y1 = homey+scrnrow;
		block.y2 = block.y1;
	}

	else GetBlockVars();
	for(y = block.y1; y<= block.y2; y++)
	{
		for(x = block.x1; x<= block.x2; x++)
		{
			if(colwidths[x])       //if the column is visible
			{                      //change its allignment
				scrnsheet = sheet[y*26+x];
				if(!scrnsheet->u.commas)
				{
					scrnsheet->u.commas =1;
					sheet(y*26+x, scrnsheet);
				}

				else
				{
					scrnsheet->u.commas = 0;
					sheet(y*26+x, scrnsheet);
			  }

			}

		}

	}

	if(block.validsw)
	{
		ReDrawSheet(1);
		Refresh();
	}
	DispCell(1);
	modified =1;

	return 0;
}

//-------------------------------------------------------------------------
//First copy to the clipboard, then clear from the main sheet
//the range selected
int Grid::Cut()
{
	Copy();
	block.validsw =1;  	//=1 so that org par range will be unaltered
	Clear();    	//clear the selected cell from main sheet
	return 0;
}
//-------------------------------------------------------------------------
//copy the block selected to the clipboard
//it might be just a single cell at the cursor
int Grid::Copy()
{
	unsigned int x, y;
	char cell_name[10];
	Cell *j, ce;
	unsigned int base = (unsigned int )y100*26;


	if(!block.validsw)
	{
		block.validsw =1;
		block.x1 = letters[scrncol] -'A';
		block.x2 = block.x1;
		block.y1 = homey+scrnrow;
		block.y2 = block.y1;
	}
	c_block = block;
	for(y = c_block.y1; y<= c_block.y2; y++)
	{
		itoa(y+1, &cell_name[1], 10);
		for(x = c_block.x1; x<= c_block.x2; x++)
		{
			cell_name[0] = 'A'+x;
			par->errnum =0;
			j = par->Find(cell_name);  //get from main sheet
			memcpy(&ce, j, sizeof(Cell));
			par->errnum =0;
			par->Store(&ce, 1); //store in clipboard at same location
			scrnsheet = sheet[y*26+x];  //fetch from main sheet
			sheet(base+(y*26)+x, scrnsheet);  //store in clipboard
		}
	}
	block.validsw =0; 	    //cancle the block we copied to the clipboard


	ReDrawSheet(1);
	return 0;
}
//-------------------------------------------------------------------------
//Get a cell from the clipboard. if it containts any relative
//cell references in that cell's formula string, and if they
//refer anythere inside the source block (ie., the c_block.x1, y1, x2, y2)
//then adjust those
//relative cell references according to the relative x, y position of
//destination cell when compare to the org position of the source cell
//
// Entry:
//	 scol, srow are the absolute location of the cell in the clipboard
//  dcol, drow are the absolute location to paste it to

int Grid::PasteCell(int scol, int srow, int dcol, int drow)
{
	char cell_name[10];
	int distx = dcol - scol;
	int disty = drow - srow;
	int i, absol =0;      //don't adjust absolute references even if they
							 //refer to cells within the source block
	unsigned int base = y2600;
	unsigned int t;
	unsigned char srowcolour, drowcolour, colour;

	Cell *j, ce;

	cell_name[0] = 'A'+scol;
	itoa(srow+1, &cell_name[1], 10);
	par->errnum =0;	//cancle any parse errors so that Find() will work
	j = par->Find(cell_name, 1); //get from clipboard
	if(j->answer.type) //if it not blank
	{

		i= par->AdjustReferences(j->input, c_block.x1, c_block.y1, c_block.x2, c_block.y2, distx, disty, absol);
		if(!i)
		{
			printf("Error while attempting to alter references in formula for col %c, row %d\n", dcol+'A', drow+1);
			printf("the formula is [%s]\n", j->input);
			exit(0);
		}
	}

	memcpy(&ce, j, sizeof(Cell));
	ce.cell_name[0] = 'A'+dcol;  //change its name to point to the new location
	itoa(drow+1, &ce.cell_name[1], 10);
	par->Store(&ce); //store in main memory

	//look at the colour of the cell that comes from the clipboard
	//compare that colour with the spreadsheet's source row colour
	//for that cell.
	//If they are different use the cell's colour,
	//else they are the same so decide to use either altrow1 colour or
	//altrow2 colour depending on the destination row to which the cell is
	//being pasted.


	t = base +(srow*26)+scol;   //get cell's properties from clipboard
	scrnsheet = sheet[t];
	sheet(drow*26+dcol, scrnsheet);   //pasted properties to main sheet

	t = (srow%2);
	if(t) srowcolour = (unsigned char) gbc[7]*16+gfc[7];
	else srowcolour = (unsigned char) gbc[8]*16+gfc[8];

	t = (drow%2);
	if(t) drowcolour = (unsigned char) gbc[7]*16+gfc[7];
	else drowcolour = (unsigned char) gbc[8]*16+gfc[8];
	if(sheet[(unsigned int)base+(srow*26)+scol]->u.colour == srowcolour)
	{
		colour = drowcolour;
	}
	else
		//there are different so use the cell's colour
		colour = sheet[(unsigned int)base+(26*srow)+scol]->u.colour;

	scrnsheet = sheet[(unsigned int)drow*26+dcol];
	scrnsheet->u.colour = colour;
	sheet((unsigned int)drow*26+dcol, scrnsheet);

	modified =1;
	return 0;
}
//-------------------------------------------------------------------------
//This function is called after a row has been inserted or deleted
//to repattern the alternating screen rows again.
//in doing so, protects the highlighting of any cells currently
//highlighted.
//If the last operation was an insert row, the the rows from the
//beginning to the cursor row are ok, only repattern the rest to the
//last row (row 100).
//If the last operation was a deletion, then repattern the rows from
//the cursor row to the last.
//The point row at which the insertion or deletion occurred is the
//one the cursor is currently on.
//if insertion_or_delete =0 the operation was insert row, else it was
//delete row.
int Grid::RePatternRows(int insert_or_delete)
{
	unsigned int cellcolour, newcolour, oldcolour;
	unsigned int strow, cx, cy, t;

	strow = homey+scrnrow;
	//if(!insert_or_delete) strow++;   //if was insert start from next row
	for(cy = strow; cy<y100; cy++)
	{
		for(cx =0; cx < 26; cx++)
		{

			scrnsheet = sheet[cy*26+cx];
			t = (cy%2);
			if(t)
			{
				//The new pattern colour for this row
				newcolour = (unsigned char) gbc[7]*16+gfc[7];
				//the current old pattern colour
				oldcolour = (unsigned char) gbc[8]*16+gfc[8];
			}
			else
			{  //the new pattern colour for this row
				newcolour = (unsigned char) gbc[8]*16+gfc[8];
				//the current old pattern colour
				oldcolour = (unsigned char) gbc[7]*16+gfc[7];
			}

			cellcolour = scrnsheet->u.colour;

			//if it was insertion, and we are currently looking at the
			//row at the cursor, don't bother examining the colour
			//the cell has, just give it its new normal pattern colour
			if(cy == strow && insert_or_delete ==0)
			{
				scrnsheet->u.colour = newcolour;
				sheet(cy*26+cx, scrnsheet);
			}
			//else if it was deletion are we are currently looking at
			//the last row, don't bother examining the colour
			//the cell has, just give it its new normal patters colour
			else if(cy == y99 && insert_or_delete ==1)
			{
				scrnsheet->u.colour = newcolour;
				sheet(cy*26+cx, scrnsheet);


			 }
			//else if the cell colour has a normal pattern colour
			//for that row, give it its new normal pattern colour
			else if(cellcolour == oldcolour)
			{
				scrnsheet->u.colour = newcolour;
				sheet(cy*26+cx, scrnsheet);

			}
			//there are different so keep the cell's colour
			//because its a highlight colour
		}//next cx
	}

	return 0;
}
//-------------------------------------------------------------------------
//If there are any contents in the clipboard attempt to paste them
//to the main sheet, adjusting any relative cell references in
//the formula string of each cell being pasted if it contains references to
//cells inside the original source block.
int Grid::Paste()
{
  char tempbuf[81];
  char tempbuf2[81];
  int m, x, y, i;
  int scol, srow, dcol, drow, dx, dy, sx, sy;

  static char *pchar1[7] = {"Paste Error",
														 " The clipboard contents cannot be pasted here.",
														 " Make sure the destination area is as large as the",
														 " information you want to paste, or select only a single cell",
														 " where you want to paste.",
														 " "
														};   //6 lines

  static char *pchar2[10] = {"Paste Error",
														 " The clipboard is empty.",
														 " ",
														 " First, select one or more cells, then copy them to the",
														 " clipboard, then go to the cell you want paste to.",
														 " When you have something in the clipboard, if you would",
														 " like to paste multiple copies instead of just one copy",
														 " select a destination block big enough.",
														 " "
														};    //9 lines


	if(!c_block.validsw)  //Show "Clipboard enpty" message
	{
		a->CursorOn();
		a->ShowDialogBox(&pchar2[0], 8, 1, 8,0);
		a->CursorOff();
		return 0;
	}
	//get the vars of the destination block
	if(!block.validsw)
	{
		block.x1 = letters[scrncol]-'A';
		block.x2 = block.x1;
		block.y1 = homey+scrnrow;
		block.y2 = block.y1;
		block.validsw =1;
	}

	i = CkeckBlocks(); //check that the dest is big enough
							 //sets up xfit, yfit, oxl, oyl, dxl, dyl
	if(!i)
	{
		a->CursorOn();
		a->ShowDialogBox(&pchar1[0], 4, 1, 4,0);
		a->CursorOff();
		return 0;
	}
	//------

	for(y =0; y<yfit; y++)   //for each vertical multiple
	{
		for(x = 0; x< xfit; x++) //for each horizontal multiple
		{
			dx = oxl * x + block.x1;   //absolute destination column
			dy = oyl *y + block.y1;    //absolute destination row

			//now loop for each cell within the org src block
			for(sy =0; sy < oyl; sy++)
			{
				for(sx =0; sx < oxl; sx++)
				{
					scol = c_block.x1+sx;
					srow = c_block.y1+sy;
					dcol = dx+sx;
					drow = dy+sy;
					PasteCell(scol, srow, dcol, drow);
				}
			}

		}

	}

	//------
	if(calc) par->AutoCalc();              //re-evaluate all cells
	a->ClrScr(4, 2, 78, 23, gbc[2]*16+gfc[2]);
	block.validsw =0;
	ReDrawSheet(1);   //draw sheet with block off
	DispCell(1);
	return 0;
}
//-------------------------------------------------------------------------
//Clear the selected cell, or single cell, without copying
//them to the clipboard
int Grid::Clear()
{
	int x, y, t;
	char cell_name[10];
	Cell *j, ce;

	if(!block.validsw)
	{
		block.validsw =1;
		block.x1 = letters[scrncol] -'A';
		block.x2 = block.x1;
		block.y1 = homey+scrnrow;
		block.y2 = block.y1;
	}

	for(y = block.y1; y<= block.y2; y++)
	{
		itoa(y+1, &cell_name[1], 10);
		for(x = block.x1; x<= block.x2; x++)
		{
			cell_name[0] = 'A'+x;
			par->errnum =0;
			j = par->Find(cell_name);  //get from main sheet
			if(j->answer.type)        //if not already empty
			{
				memcpy(&ce, j, sizeof(Cell));
				par->errnum =0;
				ce.answer.type =0;    //empty the cell contents
				ce.answer.errnum =0;
				par->Store(&ce); //store in main sheet at same location
		  }
		  scrnsheet = sheet[y*26+x];
		  scrnsheet->u.locked =0;
		  t = y%2; //if line # is even choose colour alt row1, else alt row2
		  if(t) scrnsheet->u.colour = (unsigned char) gbc[7]*16+gfc[7];
		  else scrnsheet->u.colour = (unsigned char) gbc[8]*16+gfc[8];
		  sheet(y*26+x, scrnsheet);
		}
	}

	block.validsw =0; 	    //cancle the block we just cleared
	block.x1 = letters[scrncol] -'A';
	block.x2 = block.x1;
	block.y1 = homey+scrnrow;
	block.y2 = block.y1;

	if(calc) par->AutoCalc();              //re-evaluate all cells

	ReDrawSheet(1);
	modified =1;
	return 0;
}
//-------------------------------------------------------------------------
//Scan the entire 2600 cell formulas
//for cell references that refer to the block x1, y1, x2, y2
//and adjust every cell reference in a cell's formula
//that is with in the block's range.
// Entry:
//  x1, y1, x2, y2 is the block selected
//  distx, disty are the relative inc or dec amounts by which
//  formulas found anywhere on the sheet which refer to cell's in
//	 the block's range are inced or deced
//  absol =0 don't adjust absolute col or row refs
//  absol =1  adjust col and row refs as if there were relative ones.
int Grid::AdjustFormulas(int x1, int y1, int x2, int y2,
										int distx, int disty, int absol)
{
	int x, y, i;
	int f_y100 = FindLastRow();
	char cell_name[10];
	Cell ce, *j;

	if(!f_y100) return 0;

	for(x = 0; x<26; x++)
	{
		cell_name[0] = 'A'+x;
		for(y = 0; y< f_y100; y++)
		{
			cell_name[0] = 'A'+x;
			itoa(y+1, &cell_name[1], 10);
			par->errnum =0;	//cancle any parse errors so that Find() will work
			j = par->Find(cell_name);
			if(j->answer.type) //if it not blank
			{
				i= par->AdjustReferences(j->input, x1, y1, x2, y2, distx, disty, absol);
				if(!i)
				{
					printf("Error while attempting to alter references in formula for col %c, row %d\n", x+'A', y+1);
					printf("the formula is [%s]\n", j->input);
					exit(0);
				}
				memcpy(&ce, j, sizeof(Cell));
				par->Store(&ce);

			}
		} //next y
	}  //next x

	return 0;
}

//-------------------------------------------------------------------------
//Insert a new blank col in all the rows if not on col 'Z'
//This means all the columns from the current to the 2nd last are
//shifted right, and formulas anywhere in the spreadsheet that refer
//to cells in the shifted block are updated accordingly.
int Grid::InsertCol()
{
	int x, y, absol, i, cx, cy, t, distx, disty, x1, y1, x2, y2;
	char cell_name[10];
	Cell *j;
	Cell ce;

	cx = letters[scrncol] -'A';
	if(cx ==25) return 0;     //can't insert if at last cell
	x1 = cx; //current cell col
	x2 = 24; //2nd last cell col
	y1 = 0;  //top row
	y2 = FindLastRow();  //bot row
	if(!y2) return 0;    //empty sheet
	y2--;               //0 based
	distx=1; //all col references are inced
	disty=0; //row references are unaltered
	absol =1; //alter absolute cell references as well as relative ones

	//first, scan the entire 2600 cell formulas
	//for cell references that refer to the block x1, y1, x2, y2
	//and adjust every cell reference in a cell's formula
	//that is with in the block's range.
	AdjustFormulas(x1, y1, x2, y2, distx, disty, absol);
	//next, copy all the block of cells in all the rows from the 2nd last
	//column to column at cursor, shifting the block 1 column right
	for(x = 24; x>=cx; x--)
	{
		cell_name[0] = 'A'+x;
		for(y = 0; y<=y2; y++)
		{
			itoa(y+1, &cell_name[1], 10);
			par->errnum =0;	//cancle any parse errors so that Find() will work
			j = par->Find(cell_name);
			memcpy(&ce, j, sizeof(Cell));
			ce.cell_name[0] = 'A'+x+1;  //change the col, so it will be stored
			par->Store(&ce);            //in the col to the right
												 //we are scanning cols backwards
			scrnsheet = sheet[y*26+x];
			sheet(y*26+x+1, scrnsheet);
		} //next y
	}  //next x


	//clear in all the lines the column cx
	cell_name[0] = 'A'+cx;
	for(y =0; y<=y2; y++)
	{
			itoa(y+1, &cell_name[1], 10);
			par->errnum =0;
			j = par->Find(cell_name);
			j->answer.type =0;	//clear cell
			memcpy(&ce, j, sizeof(Cell));
			par->errnum =0;
			par->Store(&ce);
			//par->errnum =0;
			//j = par->Find(cell_name);
	}
	SetAltCol(letters[scrncol]-'A');    //clear this col for all rows
	ReDrawSheet(1);
	if(block.validsw) Refresh();
	DispCell(1);
	modified =1;
	return 0;
}
//-------------------------------------------------------------------------
//Insert a new blank row at current position if not on last row.
//This means all the rows from the current to the 2nd last are
//shifted down, and formulas anywhere in the spreadsheet that refer
//to cells in the shifted block are updated accordingly.
int Grid::InsertRow()
{
	int x, y, absol, i, cx, cy, t, distx, disty, x1, y1, x2, y2;
	char cell_name[10];
	Cell *j;
	Cell ce;


	cx = 0;
	cy = homey+scrnrow;
	if(cy ==y99) return 0;     //can't insert if at last row
	x1 = 0;  //col 0
	x2 = 25; //last col
	y1 = cy;  //current row
	y2 = FindLastRow();  //2nd last row
	if(!y2) return 0;
	y2 = y2 -1;
	if(y1 >y2) return 0;
	distx=0; //col references are not altered
	disty=1; //row references are inced
	absol =1; //alter absolute cell references as well as relative ones

	//first, scan the entire 2600 cell formulas
	//for cell references that refer to the block x1, y1, x2, y2
	//and adjust every cell reference in a cell's formula
	//that is within the block's range.
	AdjustFormulas(x1, y1, x2, y2, distx, disty, absol);
	//next, copy all the block of cells in all the rows from the 2nd last row
	//to row at cursor, shifting the block 1 row down
	for(y = y2; y>=cy; y--)
	{
		itoa(y+1, &cell_name[1], 10);
		for(x = 0; x< 26; x++)
		{
			cell_name[0] = 'A'+x;
			par->errnum =0;	//cancle any parse errors so that Find() will work
			j = par->Find(cell_name);
			memcpy(&ce, j, sizeof(Cell));
			itoa(y+2, &ce.cell_name[1], 10); //change the row, so it will be
			par->errnum =0;
			par->Store(&ce);            		//stored in the row below
														//we scanning rows backwards
			scrnsheet = sheet[y*26+x];
			sheet((y+1)*26+x, scrnsheet);
		}
	}


	//clear the 26 cols in the the current row
	itoa(cy+1, &cell_name[1], 10);
	for(x=0; x<26; x++)
	{
		cell_name[0] = 'A'+x;
		par->errnum =0;
		j = par->Find(cell_name);
		j->answer.type =0;	//clear cell
		memcpy(&ce, j, sizeof(Cell));
		par->errnum =0;
		par->Store(&ce);
	}

	RePatternRows(0);
	ReDrawSheet(1);
	if(block.validsw) Refresh();
	DispCell(1);
	modified =1;
	return 0;

}
//--------------------------------------------------------------------------
//Delete current col col in all the rows if not on col 'Z'
//This means all the columns from the current+1 to the last are
//shifted left, and formulas anywhere in the spreadsheet that refer
//to cells in the shifted block are updated accordingly.
int Grid::DeleteCol()
{

	int x, y, absol, i, cx, cy, t, distx, disty, x1, y1, x2, y2;
	char cell_name[10];
	Cell *j;
	Cell ce;

	cx = letters[scrncol] -'A'+1;
	if(cx ==26) return 0;     //can't delete if at last cell
	x1 = cx; //current+1 cell col
	x2 = 25; //last cell col
	y1 = 0;  //top row
	y2 = FindLastRow();
	if(!y2) return 0;
	y2--;  //zero based bot row
	distx=-1; //all col references are deced
	disty=0; //row references are unaltered
	absol =1; //alter absolute cell references as well as relative ones

	//first, scan the entire 2600 cell formulas
	//for cell references that refer to the block x1, y1, x2, y2
	//and adjust every cell reference in a cell's formula
	//that is with in the block's range.
	AdjustFormulas(x1, y1, x2, y2, distx, disty, absol);
	//next, copy all the block of cells in all the rows from the current+1
	//column to last column, shifting the block 1 column left
	for(x = cx; x<=25; x++)
	{
		cell_name[0] = 'A'+x;
		for(y = 0; y<=y2; y++)
		{
			itoa(y+1, &cell_name[1], 10);
			par->errnum =0;	//cancle any parse errors so that Find() will work
			j = par->Find(cell_name);
			memcpy(&ce, j, sizeof(Cell));
			ce.cell_name[0] = 'A'+x-1;  //change the col, so it will be stored
			par->Store(&ce);            //in the col to the left
												 //we are scanning cols forwards
			scrnsheet = sheet[y*26+x];
			sheet(y*26+x-1, scrnsheet);
		} //next y
	}  //next x


	//clear in all the lines the last column
	cell_name[0] = 'A'+25;
	for(y =0; y<=y2; y++)
	{
			itoa(y+1, &cell_name[1], 10);
			par->errnum =0;
			j = par->Find(cell_name);
			j->answer.type =0;	//clear cell
			memcpy(&ce, j, sizeof(Cell));
			par->errnum =0;
			par->Store(&ce);
			//par->errnum =0;
			//j = par->Find(cell_name);
	}

	SetAltCol(25);    //clear the last for all rows
	ReDrawSheet(1);
	if(block.validsw) Refresh();
	DispCell(1);
	modified =1;
	return 0;

}
//-------------------------------------------------------------------------
//Delete row at current position if not on last row.
//This means all the rows from the current+1 to the last are
//shifted up, and formulas anywhere in the spreadsheet that refer
//to cells in the shifted block are updated accordingly.
int Grid::DeleteRow()
{

	int x, y, absol, i, cx, cy, t, distx, disty, x1, y1, x2, y2;
	char cell_name[10];
	Cell *j;
	Cell ce;


	cx = 0;
	cy = homey+scrnrow+1;         //the c # of the top row below the cursor
											//to be shifted up a line
	if(cy == y100) return 0;     //can't delete if at last row
	x1 = 0;  //col 0
	x2 = 25; //last col
	y1 = cy;  //current row+1
	y2 = FindLastRow();
	if(!y2) return 0;
	y2 = y2 -1;      //the c # of the last row
	if((y2+1) == y1) goto clearlastrow; //cursor is on the last nonblank row
	if((y2+1) < y1) return 0;     //cursor below last nonblank line
	//which means all the lines from the cursor to the end are empty
	//therefore exit without doing anything.


	//by now we know that y2+1 is greater than y1 this means
	//y2 is either equal to y1 or greater.
	//This means there is at least one nonblank line
	//below the current cursor position.
	//shift the block  from y1 to y2 to a line.
	distx=0; //col references are not altered
	disty=-1; //row references are deced because rows will be shifted up
	absol =1; //alter absolute cell references as well as relative ones

	//first, scan the entire 2600 cell formulas
	//for cell references that refer to the block x1, y1, x2, y2
	//and adjust every cell reference in a cell's formula
	//that is within the block's range.
	AdjustFormulas(x1, y1, x2, y2, distx, disty, absol);
	//next, copy all the block of cells in all the rows from the row below
	//the current one to the last row, shifting the block 1 row up
	for(y = cy; y<=y2; y++)
	{
		itoa(y+1, &cell_name[1], 10);
		for(x = 0; x< 26; x++)
		{
			cell_name[0] = 'A'+x;
			par->errnum =0;	//cancle any parse errors so that Find() will work
			j = par->Find(cell_name);
			memcpy(&ce, j, sizeof(Cell));
			itoa(y, &ce.cell_name[1], 10); //change the row, so it will be
			par->errnum =0;
			par->Store(&ce);            		//stored in the row above
														//we scanning rows forwards
			scrnsheet = sheet[y*26+x];
			sheet((y-1)*26+x, scrnsheet);
		}
	}

clearlastrow:
	//clear the 26 cols in the the last row
	itoa(y2+1, &cell_name[1], 10);
	for(x=0; x<26; x++)
	{
		cell_name[0] = 'A'+x;
		par->errnum =0;
		j = par->Find(cell_name);
		j->answer.type =0;	//clear cell
		memcpy(&ce, j, sizeof(Cell));
		par->errnum =0;
		par->Store(&ce);
	}

	RePatternRows(1);
	ReDrawSheet(1);
	if(block.validsw) Refresh();
	DispCell(1);
	modified =1;
	return 0;

}
//-------------------------------------------------------------------------
//Change the width of a column
int Grid::ColWidth()
{
	char tempbuf[80];

	TMousePos m;
	int i, n, numfields, x1, y1, fieldsize, maxsize, cursorpos, attrib;
	int colour, l, cx, cy, entrycode, sneek;
	char preanswer[128];
	Cell *j;

	cx = letters[scrncol]-'A';
	cy = homey+scrnrow;

	fieldsize = 6;      //max input field size
	maxsize = 6;       //max string size
	m.x1 = 8;
	m.x2 = 77;
	m.y1 = 24;
	m.y2 = 24;
	x1 = 8;
	y1 = 24;
	m.available =0;
	attrib = LIGHTGRAY*16+BLACK;
							  //exit upon:
	entrycode =0; //1+     //tab key
					//2+     //up key
					//4+    //down key
					//16+	 //right key (if at end of input line or on enpty line)
					//32+	 //page up
					//64+    //page down
					//256;   //mouse click outside input field

	//use empty buf to begin the input

	inputbuf[0] =0;
	cursorpos =0;
	//a->PushA_Z(chr);
	//entrycode+=16;  //allow right key to exit input
	//entrycode+=8;   //allow left key to exit input

	strcpy(tempbuf, "  Current width is ");
	n = colwidths[letters[scrncol]-'A'];
	itoa(n, linebuf1, 10);
	strcat(tempbuf, linebuf1);
	strcat(tempbuf, ". Enter new width (0 - 60)?");
	//----
	l = strlen(tempbuf);
	a->WriteLine(tempbuf, 0, 24, 78, gbc[3]*16+gfc[3]);
	a->CursorOn();
	i = a->Input(&m, numfields, inputbuf, l+1, y1, fieldsize, maxsize, &cursorpos, attrib, entrycode);
	a->CursorOff();
	if(i == 1) goto ex; //<esc> don't accept input.

	if(a->IsBlank(inputbuf))
	{
		inputbuf[0] =0;
		goto ex;
	}
	modified =1;
	n = atoi(inputbuf);
	if(n <-1) n =0;
	if(n >60) n = 60;
	if(letters[scrncol] == 'Z') goto ex;
	colwidths[letters[scrncol]-'A'] =n;
	if(n ==0)
	{
		if(scrncol == 0)
		{
			homex++;
		}

	}

	DrawBorder(homex, homey);
	ReDrawSheet(1);
	block.validsw =0;

ex:
	DispCell(1); //turn on cell

ex1:

	return 1;
}
//-------------------------------------------------------------------------
int Grid::RightJustify()
{
	return ChangeAllignment(3);
}
//-------------------------------------------------------------------------
int Grid::LeftJustify()
{
	return ChangeAllignment(1);
}
//-------------------------------------------------------------------------
int Grid::Centre()
{
	return ChangeAllignment(2);

}
//-------------------------------------------------------------------------
//Change the number of decimal places from the selected rblock range
//or if no block, for the current cell
int Grid::DecimalPlaces()
{
	char tempbuf[80];

	TMousePos m;
	int i, n, numfields, x1, y1, fieldsize, maxsize, cursorpos, attrib;
	int colour, l, cx, cy, entrycode, sneek;
	char preanswer[128];
	Cell *j;

	cx = letters[scrncol] -'A';
	cy = homey+scrnrow;

	fieldsize = 6;      //max input field size
	maxsize = 6;       //max string size
	m.x1 = 8;
	m.x2 = 77;
	m.y1 = 24;
	m.y2 = 24;
	x1 = 8;
	y1 = 24;
	m.available =0;
	attrib = LIGHTGRAY*16+BLACK;
							  //exit upon:
	entrycode =0; //1+     //tab key
					//2+     //up key
					//4+    //down key
					//16+	 //right key (if at end of input line or on enpty line)
					//32+	 //page up
					//64+    //page down
					//256;   //mouse click outside input field

	//use empty buf to begin the input

	inputbuf[0] =0;
	cursorpos =0;
	//a->PushA_Z(chr);
	//entrycode+=16;  //allow right key to exit input
	//entrycode+=8;   //allow left key to exit input

	strcpy(tempbuf, "  How many digits after the decimal point (0 - 9) ?");
	l = strlen(tempbuf);
	a->WriteLine(tempbuf, 0, 24, 78, gbc[3]*16+gfc[3]);
	a->CursorOn();
	i = a->Input(&m, numfields, inputbuf, l+1, y1, fieldsize, maxsize, &cursorpos, attrib, entrycode);
	a->CursorOff();
	if(i == 1) goto ex; //<esc> don't accept input.

	if(a->IsBlank(inputbuf))
	{
		inputbuf[0] =0;
		goto ex;
	}
	modified =1;
	n = atoi(inputbuf);
	if(n <-1) n =0;
	if(n >9) n = 9;

	//-----
	//for all cells in the block's range change the number of
	//decimal places var.
	int y, x;

	if(!block.validsw)
	{
		block.x1 = letters[scrncol] - 'A';
		block.x2 = block.x1;
		block.y1 = homey+scrnrow;
		block.y2 = block.y1;
	}

	else GetBlockVars();
	for(y = block.y1; y<= block.y2; y++)
	{
		for(x = block.x1; x<= block.x2; x++)
		{
			if(colwidths[x])       //if the column is visible
			{                      //change its number of decplaces
				scrnsheet = sheet[y*26+x];
				scrnsheet->u.decplaces =n;
				sheet(y*26+x, scrnsheet);
			}

		}

	}

	if(block.validsw)
	{
		ReDrawSheet(1);
		Refresh();
	}
	//-----

ex:
	DispCell(1); //turn on cell
	DispStatusLine();
ex1:
	return 1;
}
//-------------------------------------------------------------------------
int Grid::Auto()
{
	calc =1;
	par->AutoCalc();              //re-evaluate all cells
	a->ClrScr(4, 2, 78, 23, gbc[2]*16+gfc[2]);
	DrawSheet();
	a->m_menu[4][2].txt[6] = ' '; //manual off
	a->m_menu[4][1].txt[4] = '*'; //auto on

ex:
	DispCell(1); //turn on cell
	return 0;
}
//-------------------------------------------------------------------------
int Grid::Manual()
{
	Auto();   //evaluate the sheet one time only
	calc =0;        //turn auto calc off
	a->m_menu[4][2].txt[6] = '*'; //manual on
	a->m_menu[4][1].txt[4] = ' '; //auto off

	return 0;
}
//-------------------------------------------------------------------------
//Erase all cells' contents on the spreadsheet
int Grid::NewSheet()
{
	int x, y, i, cx, cy, t;
	char cell_name[10];
	Cell *j;
	Cell ce;

	modified =0;
	strcpy(editortitle, "UNTITLED");
	//clear the 26 cols in each of the 100 the rows
	for(y =0; y <y100; y++)
	{
		itoa(y+1, &ce.cell_name[1], 10);
		for(x=0; x<26; x++)
		{
			ce.cell_name[0] = 'A'+x;
			ce.answer.type =0;
			par->errnum =0;
			par->Store(&ce);

		}
	}

	block.validsw =0;     //block not selected yet

	block.x1 =0;
	block.y1 =0;            //for demo and testing
	block.x2 =0;
	block.y2 = 0;

	homey =0;
	scrncol =0;
	scrnrow =0;
	orghomey = 0;
	orgscrnrow = 0;
	orgscrncol = scrncol;
	orgcx = 0;
	orgcy = orghomey+orgscrnrow;

	//init the scrnsheet[], before attempting to use it or load
	//an old one in
	for(t=0; t<26; t++)
	{
		colwidths[t] = 10;
	}

	for(t = 0; t<y2600; t++)
	{
		//scrnsheet[t].colour 	 = (unsigned char) gbc[2]*16+gfc[2];
		scrnsheet = sheet[t];
		scrnsheet->u.decplaces = 2; //set any number
		scrnsheet->u.allign 	 = 0;  //default: text left align, numbers right align
		scrnsheet->u.commas 	 = 0;  //nums not in commas
		scrnsheet->u.locked =0;
		scrnsheet->u.percent =0;              //clear percent flags
		sheet(t, scrnsheet);     //store cell's properties

	}
	SetAltRows();
	scrncol = 0;
	scrnrow = 0;
	homex =0;
	homey =0;
	DrawBorder(homex, homey);
	ReDrawSheet(1);
	DispCell(1);
	return 0;

}
//-------------------------------------------------------------------------
//the current cell, or if block.validsw ==1 then the
//selected block of cells locked
int Grid::LockCells()
{

	int cx, cy, x, y;

	if(!block.validsw)
	{
		cx = letters[scrncol] -'A';
		cy = homey+scrnrow;
		scrnsheet = sheet[cy*26+cx];
		scrnsheet->u.locked =1;
		sheet(cy*26+cx, scrnsheet);
	}
	//lock the cells in the selected range
	else
	{
		for(y = block.y1; y<= block.y2; y++)
		{
			for(x = block.x1; x<= block.x2; x++)
			{
				if(colwidths[x])       //if the column is visible
				{                      //change its locked status

					scrnsheet = sheet[y*26+x];
					scrnsheet->u.locked =1;
					sheet(y*26+x, scrnsheet);
				}

			}

		}
	}

	if(block.validsw)
	{
		ReDrawSheet(1);
		Refresh();
	}
	DispCell(1);
	modified =1;

	return 0;
}
//-------------------------------------------------------------------------
int Grid::UnlockCells()
{
	int cx, cy, x, y;

	if(!block.validsw)
	{
		cx = letters[scrncol] -'A';
		cy = homey+scrnrow;
		scrnsheet = sheet[cy*26+cx];
		scrnsheet->u.locked =0;
		sheet(cy*26+cx, scrnsheet);
	}
	//lock the cells in the selected range
	else
	{
		for(y = block.y1; y<= block.y2; y++)
		{
			for(x = block.x1; x<= block.x2; x++)
			{
				if(colwidths[x])       //if the column is visible
				{                      //change its locked status

					scrnsheet = sheet[y*26+x];
					scrnsheet->u.locked =0;
					sheet(y*26+x, scrnsheet);
				}

			}

		}
	}

	if(block.validsw)
	{
		ReDrawSheet(1);
		Refresh();
	}
	DispCell(1);
	modified =1;
	return 0;
}
//-------------------------------------------------------------------------
int Grid::ColourCells()
{
	int cx, cy, x, y;

	if(!block.validsw)
	{
		cx = letters[scrncol] -'A';
		cy = homey+scrnrow;
		scrnsheet = sheet[cy*26+cx];
		scrnsheet->u.colour = gbc[2]*16+gfc[2];
		sheet(cy*26+cx, scrnsheet);
	}
	//lock the cells in the selected range
	else
	{
		for(y = block.y1; y<= block.y2; y++)
		{
			for(x = block.x1; x<= block.x2; x++)
			{
				if(colwidths[x])       //if the column is visible
				{                      //change its colour
					scrnsheet = sheet[y*26+x];
					scrnsheet->u.colour = gbc[2] *16+gfc[2];
					sheet(y*26+x, scrnsheet);
				}

			}

		}
	}

	if(block.validsw)
	{
		ReDrawSheet(1);
		Refresh();
	}
	DispCell(1);


	modified =1;
	return 0;
}
//------------------------------------------------------------------------
//-----------------------------------------------------------------------
int Grid::ShowLockedErrorMsg()
{
	int i;
	char *pchar[10] = {"Error",
							" ",
							"               Cell locked!",
							" ",
							" The cell may be locked intentionally to",
							" protect improtant formula and to prevent",
							" accidental deletion.",
							" But if you really wish to delete or edit",
							" the cell's contents then choose the",
							" 'Unlock cells' option."

							};



	i = a->ShowDialogBox(&pchar[0], 9, 1, 9, 0);
get:

	return i;
}
//-----------------------------------------------------------------------
int Grid::ShowWidth(int x)
{
	int t;
	char numbuf[5];

	t = colwidths[x];
	itoa(t, numbuf, 10);
	strcpy(linebuf1, " Adjusting Column x : Width [    ]: Release button to confirm size . . .");
	linebuf1[18] = x+'A';
	t = strlen(numbuf);
	if(t ==2)
	{
		linebuf1[30] = numbuf[0];
		linebuf1[31] = numbuf[1];
	}
	else
	{
		linebuf1[31] = numbuf[0];
	}

	a->WriteLine(linebuf1, 0,0, 80, YELLOW*16+BLACK);

	return t;
}
//-----------------------------------------------------------------------
//If the mouse is really on a column headers dividing bit
//return its absolute cx, else return -1
//Entry:
// dist = 0 no mouse movement assumed.
// dist = -1 assume mouse moved right 1 char
// dist = 1 assume mouse moved left 1 char
//so by adding dist we get mouse back to where it originally was
//Exit:
//	ax =-1 if not on bit
// ax = the absolute column the mouse in in
int Grid::MouseOnWhichBit(int dist)
{
	int result = -1; //assume error
	int chr, c;

	//the mouse in in a legal column, but is it on a bit?
	int x = mouse.x;
	mouse.x +=dist;
	chr = (a->GetCharAtMouse() &255);
	if(chr != 179) goto ex;
	c = MouseInWhichColumn()-1;
	if(c <0) goto ex;
	result = letters[c] - 'A';

ex:
	mouse.x = x;
	return result;

}
//-----------------------------------------------------------------------
int Grid::IncreaseColumnWidth(int dist)
{
	int n, c, cx, t;
	char numbuf[5];

	int r = scrnrow;
	cx = MouseOnWhichBit(-dist);
	if(cx == -1)
		goto ex;

	if(cx == 25) goto ex;

	n = colwidths[cx];
	if(n == 60)
		goto ex;
	colwidths[cx]+=dist;
	if(colwidths[cx] >60) colwidths[cx] =60;
	t = (MouseInWhichColumn() -1);
	if(t < 0)
	{
		goto ex;
	}
h:
	if(t > scrncol)
	{
		CursorRight(1);
		goto h;
	}
	else
	{
h2:	if(t< scrncol)
		{
			CursorLeft(1);
			goto h2;
	  }
	}

	DrawBorder(letters[0]-'A', homey);
	scrnrow = r;
	ReDrawSheet(1);
	block.validsw =0;

	DispCell(1); //turn on cell
	modified =1;
ex:
	ShowWidth(letters[scrncol]-'A');
	return 0;
}
//-----------------------------------------------------------------------
int Grid::ReduceColumnWidth(int dist)
{

	int n, c, cx, t;
	char numbuf[5];

	int r = scrnrow;
	cx = MouseOnWhichBit(dist);
	if(cx == -1)
		goto ex;

	if(cx == 25) goto ex;

	n = colwidths[cx];
	colwidths[cx]-=dist;
	if(colwidths[cx] <0) colwidths[cx] =0;
	t = MouseInWhichColumn();
	if(t < 0)
	{  colwidths[cx] =n;
		goto ex;
	}
h:
	if(t > scrncol)
	{
		CursorRight(1);
		goto h;
	}
	else
	{
h2:	if(t< scrncol)
		{
			CursorLeft(1);
			goto h2;
	  }
	}


	DrawBorder(letters[0]-'A', homey);
	scrnrow = r;
	ReDrawSheet(1);
	block.validsw =0;

	DispCell(1); //turn on cell
	modified =1;
ex:
	ShowWidth(letters[scrncol]-'A');
	return 0;

}
//-----------------------------------------------------------------------
//a block was selected by means of the mouse on the column header
// scan from the last row backwards looking for blank rows
// those found are removed from the block vars range
//if all are blank block vars are set to just the top row
int Grid::LimitVars()
{
	int x, y, cy, f =0;
	char cell_name[6];
	Cell *j;
	//TwistBlockVars();

	for(y = block.y2; y>= block.y1; y--)
	{
		cy =y;
		itoa(y+1, &cell_name[1], 10);
		for(x = block.x1; x <=block.x2; x++)
		{
			cell_name[0] = x+'A';
			par->errnum =0;
			j = par->Find(cell_name);
			if(j == NULL) continue;
			if(j->answer.type) {f = 1; break;}
		}
		if(f) break;
	}
	if(cy>= block.y1)
		block.y2 = cy;
	else
		block.y2 =  block.y1;
	orgcy = cy;
}
//-----------------------------------------------------------------------
//This function autoscrolls columns left
//it exits if any of the following conditions are met.
//1) the mouse button is released.
//2) the mouse is moved move right, off the left border and off
//   the first relative column to either the right border or to
//   any of the columns right of the first relative column
//This function keeps scrolling left if all following are true:
// 1) There is a column left to be scrolled left on to.
// 2) the mouse button is stilled pressed.
// 3) the mouse.x is in the border.
// If there are no more columns left to scroll to
// this function waits before exiting until either the mouse is released
// or the mouse is moved right, beyond the 1st relative column.
//
int Grid::AutoScrollLeft()
{
	int c, i;

get:
	i = a->WaitMouseButtonRelease(10);
	if(!mouse.ButtonState) return 0;
	c = MouseInWhichColumn();
	if(mouse.x <=4)
	{
		if(letters[0] - 'A')
		{
			scrncol = 0;
			CursorLeft(1);
			block.x1 = orgcx;
			block.y1 = orgcy;
			block.x2 = letters[scrncol] - 'A';
			block.y2 =0;
			block.validsw =1;
			Refresh();
		}
		goto get;
	}
	else
	if(c == 0) goto get;

	return 0;
}
//-----------------------------------------------------------------------
//
int Grid::AutoScrollRight()
{
	int c, i, l;

	i = a->WaitMouseButtonRelease(30);
	if(!mouse.ButtonState) return 0;
	l = strlen(letters);
	goto m1;
get:
	l = strlen(letters);
	i = a->WaitMouseButtonRelease(25);
	if(!mouse.ButtonState) return 0;
m1: c = MouseInWhichColumn();
	if(mouse.x ==79)
	{
		if(letters[scrncol] != 'Z')
		{
			scrncol = strlen(letters)-1;
			CursorRight(1);
			block.x1 = orgcx;
			block.y1 = orgcy;
			block.x2 = letters[scrncol] - 'A';
			block.y2 =0;
			block.validsw =1;
			Refresh();
		}
		goto get;
	}
	//if the mouse was moved on to the last relative column
	//keep waiting
	if(c == (strlen(letters)-1) || (c == -1 && mouse.x >4)) goto get;

	return 0;

}
//-----------------------------------------------------------------------

//The mouse was clicked in the column header
int Grid::DoHeader()
{
	int t, i, chr, c;

	block.validsw =0;
	NormaliseScreen();

	chr = a->GetMouseOrKey();
	mouse.ButtonState =1;
	//if(!mouse.ButtonState)
	//{
		 //return 0;
	//}

	c = MouseOnWhichBit(0);
	if(c != -1) return DoBit(c);

	//the mouse was clicked on a column header but not on a bit
	a->LimitMouse(0, 1, 79, 1);
	c = MouseInWhichColumn();
	if(c == -1) return 0;
	//-----------------------
	//show all of that column as selected
	scrncol = c;
	scrnrow =0;
	block.validsw =1;
	block.x1 = letters[scrncol] - 'A';
	block.x2 = block.x1;
	block.y1 = y99;
	block.y2 = 0;
	orgcx = block.x1;
	orgcy = y99;
	Refresh();




	//----------------
get:
	c = MouseInWhichColumn();
	if(c== -1)
	{
		if(mouse.x <= 4) c = 0;
		else c = strlen(letters)-1;
	}

	scrncol = c;
	block.x1 = orgcx;
	block.y1 = orgcy;
	block.x2 = letters[scrncol] - 'A';
	block.x2 =0;
	block.validsw =1;
	Refresh();

	if(!mouse.ButtonState) goto bex;
	chr = a->WaitGetMouseOrKey();
	if(chr !=256)  //no movement
	{
		if(!mouse.ButtonState)
		{
			block.validsw =0;
			Refresh();
			goto bex;
		}
		else goto get; //keep waiting for a movement
	}
	//------------------------
	//a movement was made.
	//was it:
	//1) to the left border
	//2) to the right border
	//3) withinin the same column
	//4) to the left adjacent column
	//5) to the right adjacent column
	//
movement:
	if(mouse.x <= 4)
	{
		scrncol =0;
		c =0;
		block.x1 = orgcx;
		block.y1 = orgcy;
		block.x2 = letters[scrncol] - 'A';
		block.validsw =1;
		Refresh();
		AutoScrollLeft();
		if(!mouse.ButtonState) goto bex;
		goto movement;
	}
	//------------------------
	//we're not in the left border.Either we are on a legal
	//column or in the right border.
	//if in the right border autoscrollright
	//else move to the column the mouse is at
	c = MouseInWhichColumn();
	scrncol = c;
	if(c== -1)  scrncol = strlen(letters) -1;
	if( c == -1)
	{
		block.x1 = orgcx;
		block.y1 = orgcy;
		block.x2 = letters[scrncol] - 'A';
		block.validsw =1;
		Refresh();
		AutoScrollRight();
		if(!mouse.ButtonState) goto bex;
		goto movement;
	}
	//we are on a legal column
	block.x1 = orgcx;
	block.y1 = orgcy;
	block.x2 = letters[scrncol] - 'A';
	block.validsw =1;
	Refresh();
	goto get;





bex:
	a->LimitMouse(0, 0, 79, 24); //restore mouse area
	block.validsw =1;
	GetBlockVars();
	block.y1 =0;
	LimitVars(); //remove blank rows from block vars range
	Refresh();
	DispCell(1);
	return 0;
}
//-----------------------------------------------------------------------
//Called by DOHeader()
//Entry:
// col = the col's bit the mouse was clicked on
//The mouse was clicked on the column header bit
int Grid::DoBit(int col)
{
	int t, c = col;

	a->LimitMouse(4, 1, 78, 1);
	ShowWidth(c);

wa55: t = mouse.x;
		//a->ShowCoordinates();
wa56:	chr = a->WaitGetMouseOrKey();

		if(chr!= 256) //mouse not moved
		{
			if(!mouse.ButtonState)  //if button released
			{

				goto ex;
			}
			else goto wa56;
		}

		if(t == mouse.x) goto wa56; //move not big enough

		if(t< mouse.x) //if movement was right
		{
			IncreaseColumnWidth(mouse.x-t); //the relative amount by which
			goto wa55;                      //the mouse was moved right
		}
		else
		{
			ReduceColumnWidth(t - mouse.x); //the relative amount by which
			goto wa55;                      //the mouse was moved right
		}

ex:
	a->LimitMouse(0, 0, 79, 24); //restore mouse area
	a->ShowTopMenu(0);
	return 0;
}
//-----------------------------------------------------------------------
//This function scans the 26 cols looking for 0 width cols
//any it finds are set to a width of 10
//If it finds any it redraws the screen so that if the new
//cols are within the current display screen they are redisplayed
int Grid::RevealCols()
{
	int t, l, found =0;
	char *p;
	char *letrs = letters;

	for(t = 0; t< 26; t++)
	{
		if(!colwidths[t])
		{
			found++;
			colwidths[t] =10;
		}
	}

	if(found)
	{
		a->ClrScr(0,0, 79,24, BLACK*16+LIGHTGRAY);
		chr = letters[scrncol];   //the original col
h:
		DrawBorder(homex, homey);
		//when the border has been redraws is the original col's letter
		//still there, or do we have to move homex forward?
		p = strchr(letrs, chr);
		if(p == NULL)
		{
			homex++;
			goto h;
		}

		scrncol = p - letters;
		ReDrawSheet(1);
		DispCell(1);
		a->ShowMouse();
		Refresh();
		//in case the cursor is on the right margin
		//and the whole of that col's width is not displayed
		//cursor left then cursor right. The effect of this
		//is that the whole of the original cursor's cell's width
		//will be brought into focus.
		//if the cursor is not on the right margin nothing happens
		CursorLeft(1);
		CursorRight(1);
		modified = 1;
	}

	return 0;
}
//-----------------------------------------------------------------------
//Toggle the percent property of the cell or range
int Grid::Percent()
{
	int y, x;

	if(!block.validsw)
	{
		block.x1 = letters[scrncol] - 'A';
		block.x2 = block.x1;
		block.y1 = homey+scrnrow;
		block.y2 = block.y1;
	}

	else GetBlockVars();
	for(y = block.y1; y<= block.y2; y++)
	{
		for(x = block.x1; x<= block.x2; x++)
		{
			if(colwidths[x])       //if the column is visible
			{                      //change its allignment
				scrnsheet = sheet[y*26+x];
				if(!scrnsheet->u.percent)
					scrnsheet->u.percent =1;
				else
					scrnsheet->u.percent =0;

				sheet(y*26+x, scrnsheet);

			}

		}

	}

	if(block.validsw)
	{
		ReDrawSheet(1);
		Refresh();
	}
	DispCell(1);
	modified =1;

	return 0;
}
//----------------------------------------------------------------------
//Find last row
//Scans from the bottom upwards looking for the first nonempty
//cell on a line
//If the sheet is blank it returs 0
//else it return the r # of the last row
int Grid::FindLastRow()
{
	unsigned int cx, cy, LastRow =0;   //assume empty sheet
	int t;
	for(t = y99; t >=0; t--)
	{
		//scan all the 26 cols on this row
		for(cx =0; cx<26; cx++)
		{
			if(sheet[(unsigned int)t*26+cx]->u.type)
			{
				LastRow = t+1;
				break;
			}
		}

		if(LastRow) break;
	}


	return LastRow;
}
//----------------------------------------------------------------------



