
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE *fp;
char gstring[80];
char filename[80];
unsigned short ra;
unsigned short rb;
unsigned short rc;
unsigned long la;
unsigned short fmttag=0;
unsigned long ckid;
unsigned long cksize;
unsigned long filesize;
unsigned long nextseek;
char *xchar;

//------------------------------------------------------------------------------
void main ( int argc, char *argv[] )
{
    if(argc==1)
    {
        printf(".WAV file not specified\n");
        exit(1);
    }
    strcpy(filename,argv[1]);
    strcat(filename,".WAV");
    if((fp=fopen(filename,"rb"))==NULL)
    {
        strcpy(filename,argv[1]);
        if((fp=fopen(filename,"rb"))==NULL)
        {
            printf("Error opening .WAV file [%s]\n",filename);
            exit(1);
        }
    }
    printf("FILE: [%s]\n",filename);
    fread(&la,1,4,fp);
    if(la!=0x46464952)
    {
        printf("Not a RIFF format file\n");
        exit(1);
    }
    fread(&filesize,1,4,fp);
    filesize+=ftell(fp);
    fread(&la,1,4,fp);
    if(la!=0x45564157)
    {
        printf("Not a WAVE file\n");
        exit(1);
    }
    nextseek=ftell(fp);
    while(nextseek<filesize)
    {
        fseek(fp,nextseek,0);
        fread(&ckid,1,4,fp);
        fread(&cksize,1,4,fp);
        nextseek=cksize+ftell(fp);
        memcpy(gstring,(void *)&ckid,4); gstring[4]=0;
        printf("\n----- Chunk ID %s, Size %lu -----\n",gstring,cksize);
        switch(ckid)
        {
            case 0x20746D66: //Format Chunk
                printf("Format Chunk\n");
                printf("Common Fields:\n");
                fread(&fmttag,1,2,fp);
                printf("  Format Tag %04Xh:  ",fmttag);
                switch(fmttag)
                {
                    default:
                    case 0x0000: printf("WAVE_FORMAT_UNKNOWN"); break;
                    case 0x0001: printf("WAVE_FORMAT_PCM\n"); break;
                    case 0x0002: printf("WAVE_FORMAT_ADPCM\n"); break;
                    case 0x0005: printf("WAVE_FORMAT_IBM_CVSD\n"); break;
                    case 0x0006: printf("WAVE_FORMAT_ALAW\n"); break;
                    case 0x0007: printf("WAVE_FORMAT_MULAW\n"); break;
                    case 0x0010: printf("WAVE_FORMAT_OKI_ADPCM"); break;
                    case 0x0011: printf("WAVE_FORMAT_DVI_ADPCM or WAVE_FORMAT_IMA_ADPCM\n"); break;
                    case 0x0015: printf("WAVE_FORMAT_DIGISTD\n"); break;
                    case 0x0016: printf("WAVE_FORMAT_DIGIFIX\n"); break;
                    case 0x0020: printf("WAVE_FORMAT_YAMAHA_ADPCM\n"); break;
                    case 0x0021: printf("WAVE_FORMAT_SONARC\n"); break;
                    case 0x0022: printf("WAVE_FORMAT_DSPGROUP_TRUESPEECH\n"); break;
                    case 0x0023: printf("WAVE_FORMAT_ECHOSC1\n"); break;
                    case 0x0024: printf("WAVE_FORMAT_AUDIOFILE_AF18\n"); break;
                    case 0x0101: printf("IBM_FORMAT_MULAW\n"); break;
                    case 0x0102: printf("IBM_FORMAT_ALAW\n"); break;
                    case 0x0103: printf("IBM_FORMAT_ADPCM\n"); break;
                    case 0x0200: printf("WAVE_FORMAT_CREATIVE_ADPCM\n"); break;
                }
                fread(&ra,1,2,fp);
                printf("  %u Channels\n",ra);
                fread(&la,1,4,fp);
                printf("  %lu Samples Per Second\n",la);
                fread(&la,1,4,fp);
                printf("  %lu Average Bytes Per Second\n",la);
                fread(&ra,1,2,fp);
                printf("  Block Align %u\n",ra);
                printf("Format Specific Fields:\n");
                fread(&ra,1,2,fp);
                printf("  %u Bits Per Sample\n",ra);
                if(fmttag!=0x0001)
                {
                    fread(&ra,1,2,fp);
                    printf("  %u Bytes of extra information\n");
                    printf("  ***I have not seen a file like this before, hope it goes well***\n");
                    switch(fmttag)
                    {
                        case 0x0002:    //MS ADPCM?
                            fread(&ra,1,2,fp);
                            printf("  %u Samples Per Block\n",ra);
                            fread(&ra,1,2,fp);
                            printf("  %u Coefficients\n",ra);
                            for(la=0;la<ra;la++)
                            {
                                fread(&rb,1,2,fp);
                                fread(&rc,1,2,fp);
                                printf("    %u  %u\n",rb,rc);
                            }
                            break;
                        case 0x0011: //WAVE_FORMAT_DVI_ADPCM
                        case 0x0022: //WAVE_FORMAT_DSPGROUP_TRUESPEECH
                            fread(&ra,1,2,fp);
                            printf("  %u Samples Per Block\n",ra);
                            break;
                        case 0x0021:  // WAVE_FORMAT_SONARC
                            fread(&ra,1,2,fp);
                            printf("  %u CompType\n",ra);
                            break;
                        case 0x0200: //WAVE_FORMAT_CREATIVE_ADPCM
                            fread(&ra,1,2,fp);
                            printf("  Revision %u\n",ra);
                            break;
                    }
                }
                break;
           case 0x61746164: //Data Chunk
                printf("Data Chunk\n");
                if(!fmttag) printf("Warning Format Chunk not defined before Data Chunk\n");
                //...
                fmttag=0; //in the event that multiple waveforms are allowed
                break;
            default:
                printf("Unknown Chunk\n");
        }
    }
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1995
//------------------------------------------------------------------------------

