/*
 *  Passdata.c
 *  These are functions which handle data passed from the main program loop.
 *  They may be defined to do whatever you wish.
 *  The definitions below create output files, and save all of the data,
 *  both waveform and FFT, to those files
 *  Note: you must use the #define PASS_WAVEDATA and PASS_FFTDATA lines in
 *  the freq.h file to enable these functions.
 */

#include <stdio.h>
#include <math.h>
#include "fft.h"   /* Used for definition of BitReversed */
#include "freq.h"  /* Used for definition of FAR only */

void pass_wavedata(void FAR *ptr,int samples,int sample_size)
{
   static firstcall=1;
   static FILE *fp;
   int i;

   if(firstcall)
   {
      fp=fopen("wavedata.dat","w");
      firstcall=0;
   }
   if(sample_size==8)
   {
      /* Handle 8-bit unsigned data (values 0 to 255) */
      unsigned char *sample=(unsigned char *)ptr;
      for(i=0;i<samples;i++)
	 fprintf(fp,"%d\n",(int)sample[i]);
   }
   else
   {
      /* Handle 16-bit signed data (values -32768 to 32767) */
      short *sample=(short *)ptr;
      for(i=0;i<samples;i++)
	 fprintf(fp,"%d\t",sample[i]);
   }
   fprintf(fp,"\n");
}

/* File pointer assigned in the main program loop */
/* When this is non-NULL, the data is logged to a file */
FILE *fp_fftlog=NULL;

void pass_fftdata(short *fftdata,int samples)
{
   if(fp_fftlog)
   {
      int i;
      for(i=0;i<samples/2;i++)
      {
         fprintf(fp_fftlog,"%d\t%d\t",fftdata[BitReversed[i]],
                                      fftdata[BitReversed[i]+1]);
      }
      fprintf(fp_fftlog,"\n");
   }
}


