/* #includes section */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* global variables section */
extern char *optarg;
extern int optind, opterr;
extern char optopt;
int cmdargs;
/* function prototypes section */
int getopt(int argc, char *const *argv, const char *options);
int bcd_open(void);
int bcd_set_volume(int);
int bcd_play_track(int tracknum);
int bcd_stop(void);
int bcd_resume(void);
int bcd_open_door(void);
int bcd_close_door(void);
int bcd_reset(void);
int bcd_close(void);
void instruct_usage(void);
/* main program function */
int main(int argc, char *argv[])
{
        /* if the user typed garbage after the command name,
           or nothing at all, print usage instructions and exit */
	if (strchr(argv[1], '-') == NULL) {
		instruct_usage();
		exit(1);
	}
        /* startup function for BCD library */
	bcd_open();
        /* set volume to half of max */
	bcd_set_volume(128);
        /* assign opterr a value of zero so getopt won't print its errmsg */
	opterr = 0;
        /* figure out what arguments the user typed and act accordingly */
	while ((cmdargs = getopt(argc, argv, "p:srv:ocR")) != -1) {
		switch (cmdargs) {
		case 'p':
			bcd_play_track(atoi(optarg));
                        if(bcd_play_track(atoi(optarg))==1)
                                printf("Playing track %s\n",optarg);
			break;
		case 's':
			bcd_stop();
                        if(bcd_stop()==1)
                                printf("DSCD stopped\n");
			break;
		case 'r':
			bcd_resume();
                        if(bcd_resume()==1)
                                printf("DSCD resumed\n");
			break;
		case 'v':
			bcd_set_volume(atoi(optarg));
                        if(bcd_set_volume(atoi(optarg))==1)
                                printf("Volume set to %s\n",optarg);
			break;
		case 'o':
			bcd_open_door();
                        if(bcd_open_door()==1)
                                printf("CD door open\n");
			break;
		case 'c':
			bcd_close_door();
                        if(bcd_close_door()==0)
                                printf("CD door closed\n");
			break;
		case 'R':
			bcd_reset();
                        if(bcd_reset()==1)
                                printf("CD device reset\n");
			break;
		default:
			printf("Unknown option entered.\n");
			instruct_usage();
			exit(1);
		}
	}
        /* shutdown function for BCD library */
	bcd_close();
        /* return program exit code */
	return (0);
}
/* function to print out usage instructions */
void instruct_usage(void)
{
	printf("\n [ dscd v1.7 ] \n [ a 32-bit console-mode CD player written in C using DJGPP ] \n [ (C) d_struct software 1999 ] \n");
	printf("\nDistributed under the terms of the GNU General Public License.\n");
	printf("See documentation for details.\n\n");
	printf("Usage:  dscd [options]\n");
	printf("Valid options:  -p x\t\t     plays CD track (x = track number)\n");
	printf("\t\t-s\t\t     stops the CD player\n");
	printf("\t\t-r\t\t     resumes play after stop\n");
	printf("\t\t-v 0-255\t     sets volume\n");
	printf("\t\t-o\t\t     opens the CD tray\n");
	printf("\t\t-c\t\t     closes the CD tray\n");
	printf("\t\t-R\t\t     resets the CD drive\n");
}
