;============================================================================
;		Title - PWINIT           DATE: 3/15/89
;		This program is used with PASSWORD.ASM
;		and its resulting file PASSWORD.BIN after
;		compiling with MASM and converting it
;		to a binary image file using EXE2BIN.EXE.
;
;		The resulting EXE file will take an uninitialized
;		PASSWORD.BIN file and insert the password of
;		your choice and then encode the resulting
;		PASSWORD.SYS file to transfer under whatever
;		name you desire (as long as the name in CONFIG.SYS
;		matches ie:DEVICE=PASSWORD.SYS) to your boot disk.
;		I would suggest using a different name to conceal
;		your intentions!

;============================================================================
Dos	equ	21h
;============================================================================
code segment					; Define code segment
;============================================================================

main	proc	far

	assume	cs:code,ds:data,es:file

start:						; Main starting address

; Set ds to our data segment

	mov	ax,data				;Data segment address
	mov	ds,ax				;Move into ds register
	mov	ax,file				;Get File segment
	mov	es,ax				;Set es: to file segment
	call	check_video			;See what type of monitor
	mov	dx,offset org_file_name		;Point to Uninit file name
	call	open_file			;Open file for read only
	mov	old_handle,ax			;Store the handle
	mov	bx,ax				;Set up for read
	mov	dx,offset ds:file_buffer	;Point to file buffer area
	mov	cx,800h				;Set number of characters
	push	bx				;Save the file handle
	call	read_file			;Read file into buffer
	mov	file_size,ax			;Store number of bytes in file
	pop	bx				;Restore the file handle
	call	close_file			;Close the old file
	call	clear_screen			;Clear the CRT
	call	input_word			;Ask user for PASSWORD
	call	box				;Clear the entry box
	call	off_screen			;Get cursor out of box
	mov	ax,word ptr ds:file_buffer+22	;Get count of char to encode
	mov	scramble_count,ax		;Store it for later
	mov	ax,offset es:file+24		;Point to PASSWORD address
	mov	pass_location,ax		;Store the offset
	mov	di,ax				;Move offset to di
	push	di				;Save it for the moment
	xor	cx,cx				;Zero the counter
	mov	cl,password+1			;Get user entered char. count
	inc	cl				;Account for char. count
	mov	ax,offset password+1		;Point to user password
	mov	si,ax				;Move pointer into si
	rep	movsb				;Move the PASSWORD into the
						;new file area
	pop	di				;Restore es:offset to new
						;file password area
	mov	cx,scramble_count		;Load the char count to encode
	push	ds				;Save original data segment
	push	es
	pop	ds				;Make ds=es
	mov	si,di				;Make di & si point to the
scramble:					;same bytes
	lodsb					;Get a byte
	sub	al,40h				;Remove 40h
	stosb					;Store the byte
	loop	scramble			;Loop until done
	pop	ds				;Restore the original ds
	mov	dx,offset new_file_name		;Point to the new file name
	call	create_file			;Create it
	mov	bx,ax				;Get the file handle into bx
	push	bx				;Save it
	mov	cx,file_size			;Load the cx with the file
						;size
	mov	dx,offset ds:file_buffer	;Point to the file buffer
	call	write_file			;Write the new file
	pop	bx				;Restore the file handle
	call	close_file			;Close the new file
	mov	ah,8fh				;Set attribute for display
	mov	bx,offset msg_4			;Point to the complete msg.
	mov	cx,msg_4_len			;Length of message
	mov	dx,0d1ch			;Location to write it
	call	write_crt			;Display message

done:
	mov	ax,4c00h
	int	dos				;Return to DOS

main	endp		;End of main program

;============================================================================

check_video	proc	near			;See where video RAM is

	mov	ah,0fh				;via video ROM
	int	10h				
	cmp	al,07h				;See if Mono card installed
	jz	set_mono			;Jump to monochrome routine

	mov	video_location,0b800h		;If not mono then Color RAM
	jmp	video_done			;Exit routine

set_mono:

	mov	video_location,0b000h		;Set location to Mono RAM

video_done:

	ret

check_video	endp

;============================================================================
;The following routines are the direct CRT display code
;============================================================================

write_crt	proc	near

	push	es				;Save original es
	push	dx				;Save location to write
	push	ax				;Save the attribute
	push	cx				;Save the character count
	push	dx				;Save for the moment
	mov	cx,02h				;Set the multiplier
	mov	ax,video_location		;Get the address of video RAM
	mov	es,ax				;Set the es register to RAM
	mov	si,bx				;Point si to the message
	xor	ax,ax				;Zero the ax
	mov	al,dl				;Move to al the column
	sub	al,1				;Adjust the al
	imul	cx				;Times to for actual column
	pop	dx				;Get the original location
	mov	dl,al				;Store column in dl
	mov	al,dh				;Move into ax the row
	push	dx				;Save for the moment
	sub	ax,1				;Adjust the ax
	mov	cx,160				;80 times 2 for actual offset
	imul	cx
	pop	dx				;Get dx back
	and	dh,00h				;Zero the dh
	add	ax,dx				;Add the column offset to the
	mov	di,ax				;row and move di to the actual
						;memory position
	pop	cx				;Restore character count
	pop	ax				;Restore the attribute

write_crt_1:

	lodsb					;Load a byte of message
	stosw					;Store byte & attribute to RAM
	loop	write_crt_1			;Loop until cx=0
	pop	dx				;Restore original dx
	pop	es				;restore original es
	ret					;And return

write_crt	endp
;============================================================================

write_cursor	proc	near

off_screen:

	xor	bx,bx				;Zero bx (page 0) and set
	xor	dx,dx				;position to upper left corner
						
position_cursor:

	mov	ah,02h				;Have DOS reset the cursor 
	int	10h				;where we want it
	ret					;And return

clear_screen:

	mov	ax,0600h			;Use DOS scroll to clear CRT
	mov	bh,07				;Set attribute
	xor	cx,cx				;Upper left corner 0,0
	mov	dx,184fh			;Lower right 24,79
	int	10h
	ret					;And return

write_cursor	endp

;============================================================================
;Area to get the user password
;============================================================================

input_word	proc	near

	call	box				;Make input display box
	mov	ah,0fh				;Set attribute for display
	mov	bx,offset msg_1			;Point to opening mess.
	mov	cx,msg_1_len			;Set message length
	mov	dx,0d19h			;Location on CRT
	call	write_crt			;Display it
	mov	dx,0c27h			;Address for cursor
	xor	bx,bx				;Zero bx : Page 0
	call	position_cursor			;set cursor to entry position
	mov	ax,0c0ah			;Set up to use DOS buffer
	mov	dx,offset password		;input routine (point to
						;our buffer
	int	DOS				;Get input string
	call	box				;Clear the box
	mov	ah,0fh				;Load attribute
	mov	bx,offset msg_2			;Point to next message
	mov	cx,msg_2_len			;Load the length
	mov	dx,0c19h			;Load where to display it
	call	write_crt			;Write the display
	xor	cx,cx				;Zero the count register
	mov	cl,password+1			;Load # of char entered
	mov	bx,offset password+2		;Point to the string
	mov	dx,0c27h			;Address to display
	mov	ah,8fh				;Load attribute
	call	write_crt			;Display entered password
						;for conformation
	mov	ah,0fh				;Load attribute
	mov	bx,offset msg_3			;Point to confirm message
	mov	cx,msg_3_len			;Length
	mov	dx,0e19h			;Location for display
	call	write_crt			;Display message

char_loop:

	mov	dx,0d33h			;Location for cursor
	xor	bx,bx				;Page 0
	call	position_cursor			;Position cursor for input
						;of a Y or N answer
	mov	ah,0ah				;Write a blank at the cursor
	mov	al,' '				;to erase a answer that is
	mov	cx,01h				;not a Y or N
	int	10h
	mov	ah,01h				;Get one character
	int	DOS
	and	al,5fh				;Convert to upper case
	cmp	al,'Y'				;If PASSWORD confirmed then
	je	ok				;jump to a return
	cmp	al,'N'				;If not, then ask for new 
	je	input_word			;password
	mov	ax,0e07h			;If neither then ring bell
	int	10h				;and ask for Y or N
	jmp	char_loop

ok:	ret					;PASSWORD ok.  Set up
						;PASSWORD.SYS
input_word	endp
;============================================================================

;============================================================================
;This routine draws a box for an entry window
;============================================================================

box	proc	near

	mov	ah,04h				;Set attribute for box
	mov	bx,offset msg_5			;Point to Upper portion
	mov	cx,34				;Horizontal Length
	mov	dx,0b17h			;Start at line 11, col 23
	call	write_crt			;Draw it
	mov	bx,offset msg_6			;Middle portion
	mov	cx,34				;Length
	mov	dx,0c17h			;Start next at 12 and 23
	call	write_crt			;Draw it
	mov	cx,34				;Length
	mov	dx,0d17h			;Start next at 13 and 23
	call	write_crt			;Draw it
	mov	cx,34
	mov	dx,0e17h
	call	write_crt
	mov	bx,offset msg_7			;Bottom portion
	mov	cx,34				;length
	mov	dx,0f17h			;Start next at 14 and 23
	call	write_crt			;Draw it
	ret					;And return

box	endp

;============================================================================
disk_routines	proc	near
;============================================================================

open_file:					;Uses standard DOS function
	mov	ax,3d00h			;to open the file
	int	DOS				;PASSWORD.BIN
	jc	error_1			;Jump if does not exist
	ret

close_file:					;Uses standard DOS function
	mov	ah,3eh				;to close files
	int	DOS
	jc	error_2				;Jump if error in closing
	ret

write_file:					;Uses standard DOS function
	mov	ah,40h				;to write buffer to file
	int	DOS
	jc	error_3				;Jump if error writing
	cmp	ax,cx				;See if bytes written equal
	jne	disk_full			;filesize, if not then disk
	ret					;is full

read_file:					;Uses standard DOS function
	mov	ah,3fh				;to read file
	int	DOS
	jc	error_4				;Jump if error in reading
	ret

create_file:					;Uses standard DOS function
	mov	ah,3ch				;to create a file
	mov	cx,0				;Set normal attribute
	int	DOS
	jc	error_5				;Jump if error creating file
	ret

error_1:
	call	error_set_up
	mov	dx,offset e_msg_1
	jmp	error_exit

error_2:
	call	error_set_up
	mov	dx,offset e_msg_2
	jmp	error_exit

error_3:
	call	error_set_up
	mov	dx,offset e_msg_3
	jmp	error_exit

error_4:
	call	error_set_up
	mov	dx,offset e_msg_4
	jmp	error_exit

error_5:
	call	error_set_up
	mov	dx,offset e_msg_5
	jmp	error_exit

disk_full:
	call	error_set_up
	mov	dx,offset e_msg_6
	jmp	error_exit

error_exit:
	mov	ah,09h
	int	DOS
	call	off_screen
	mov	ax,4c01h
	int	DOS

error_set_up:

	call	box
	mov	cx,30
	mov	dx,0c19h
	mov	bx,offset disk_error
	mov	ah,8fh
	call	write_crt
	mov	cx,30
	mov	dx,0d19h
	mov	bx,offset blanks
	call	write_crt
	mov	cx,30
	mov	dx,0e19h
	mov	bx,offset terminate
	call	write_crt
	xor	bx,bx
	mov	dx,0c18h
	call	position_cursor
	ret


disk_routines	endp
;============================================================================
;============================================================================
code	ends		;End of code segment
;============================================================================
;	Program Stack Area
;============================================================================
st_seg	segment	stack	; Define Stack Area
;============================================================================
	db	20 dup	('Stack   ')
;============================================================================
st_seg	ends
;============================================================================
;	Data Storage areas
;============================================================================
data	segment		'DATA'		; Define Data Segment
;============================================================================



msg_1		db	'Enter Password:',15 dup(20h)	;Enter Password
msg_1_len	dw	$-msg_1				
msg_2		db	'Password is :                 ';Password Accepted
msg_2_len	dw	$-msg_2
msg_3		db	'Password Correct ?  (Y/N) :   ';Wrong Password
msg_3_len	dw	$-msg_3
msg_4		db	'Password.SYS is complete'	;Access Denied
msg_4_len	dw	$-msg_4
msg_5		db	201,32 dup(205),187		;Screen Box
msg_6		db	186,32 dup(20h),186		;Screen Box
msg_7		db	200,32 dup(205),188		;Screen Box
blanks		db	'                              '
e_msg_1		db	'        Opening A File$'
e_msg_2		db	'        Closing A File$'
e_msg_3		db	'        Writing A File$'
e_msg_4		db	'        Reading A File$'
e_msg_5		db	'       Creating A File$'
e_msg_6		db	'          Disk Full$'
disk_error	db	'    Disk Error Occurred On    '
terminate	db	'      Program Terminated      '
;============================================================================
password	db	16,00,16 dup(0)
scramble_count	dw	0
pass_location	dw	0
org_file_name	db	'PASSWORD.BIN',0
new_file_name	db	'PASSWORD.SYS',0
old_handle	dw	0
new_handle	dw	0
video_location	dw	0
file_size	dw	0
;============================================================================
data	ends
;============================================================================
;	File Buffer Area for PASSWORD.BIN
;============================================================================
file	segment	para	'DATA'
;============================================================================
file_buffer	db	800h dup(?)
;============================================================================
file	ends
;============================================================================

	end	start	;End of assembly
