/*
  wtm.c - Windowed Text Mode.

  Jason Hood, 10 & 11 May, 2003.

  Set screen size for windowed DOS-boxes. It will NOT work full-screen.
*/

#define PVERS "1.00"
#define PDATE "11 May, 2003"

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "vgamem.h"

void screen_cpy( Word* buffer, int wb, int hb, int ws, int hs, int r );

int main( int argc, char* argv[] )
{
  int	 cols,	rows;
  int	 ocols, orows;
  int	 font,	lines;
  Word	 size;
  Word*  buffer;
  Word	 screen;
  Cursor cur;
  int	 page;
  char*  x;

  if (argc != 2 || !strcmp( argv[1], "/?" ) || !strcmp( argv[1], "--help" ))
  {
    printf( "Windowed Text Mode by Jason Hood <jadoxa@yahoo.com.au>.\n"
	    "Version "PVERS" ("PDATE"). Freeware.\n"
	    "http://tm.adoxa.cjb.net/\n"
	    "\n"
	    "Usage: %s [<cols>][x<rows>]\n"
	    "\n"
	    "cols can be 2 to 132 (must be even);\n"
	    "rows can be 1 to 128.\n"
	    "\n"
	    "This program is for windowed DOS-boxes only.\n"
	    "It will NOT work in full-screen mode.\n"
	    , argv[0] );
    return 0;
  }

  cols = (int)strtol( argv[1], &x, 10 );
  rows = (*x == 'x') ? atoi( x + 1 ) : 0;
  if (cols == 0) cols = video->cols;
  if (rows == 0) rows = video->rows + 1;

  if (cols < 2 || cols > 132 || (cols & 1))
  {
    fprintf( stderr, "Unsupported columns: %d.\n", cols );
    return 1;
  }
  if (rows < 1 || rows > 128)
  {
    fprintf( stderr, "Unsupported rows: %d.\n", rows );
    return 2;
  }
  if (cols * rows > 16384)
  {
    fprintf( stderr, "Unsupported size: %d x %d.\n", cols, rows );
    return 3;
  }

  // Remember the current screen.
  ocols  = video->cols;
  orows  = video->rows + 1;
  cur	 = video->curs[video->page];
  screen = video->offset;
  size	 = video->size;
  buffer = malloc( size );
  asm {
	push	ds
	push	si
	push	di
	mov	si,screen
	mov	di,buffer
	mov	cx,size
	shr	cx,1
	push	0xb800
	push	ds
	pop	es
	pop	ds
	rep	movsw
	pop	di
	pop	si
	pop	ds
  }

  // Set normal text mode and an appropriate font size.
  font = (rows < 26) ? 4 : 3;
  asm {
	mov	ax,3
	int	0x10
	mov	ah,0x11
	mov	al,byte ptr font
	and	al,6
	or	al,16		// 0x14 -> 16-line font, 0x12 -> 8-line font
	mov	bl,0
	int	0x10
  }

  // Program the necessary column CRTC registers.
  outpw( 0x3d4, ((cols - 1) << 8)  | 0x01 );	// Horizontal Display-Enable End
  outpw( 0x3d4, ((cols >> 1) << 8) | 0x13 );	// Offset

  // Program the necessary row CRTC registers.
  size	= 0;
  lines = (rows << font) - 1;			// Scan lines
  if (lines & 0x200) size |= 0x40;
  if (lines & 0x100) size |= 0x02;
  outpw( 0x3d4, (size << 8)  | 0x07 );		// Overflow
  outpw( 0x3d4, (lines << 8) | 0x12 );		// Vertical Display-Enable End

  // Let the BIOS know the new dimensions.
  video->cols = cols;
  video->rows = rows - 1;
  video->size = ((cols * rows) << 1) + 256;

  // Restore the screen contents.
  lines = (cur.y < rows) ? 0 : cur.y + 1 - rows;
  screen_cpy( buffer, ocols, orows, cols, rows, lines );
  free( buffer );

  // Restore the cursor position.
  page = video->page;
  asm {
	mov	al,byte ptr cols
	dec	ax
	mov	dl,byte ptr cur //.x
	cmp	dl,al
	jle	XOkay
	mov	dl,al
  }
  XOkay: asm {
	mov	al,byte ptr rows
	dec	ax
	mov	dh,byte ptr cur.y
	cmp	dh,al
	jle	YOkay
	mov	dh,al
  }
  YOkay: asm {
	mov	ah,2
	mov	bh,byte ptr page
	int	0x10
  }

  return 0;
}


// Copy the old screen to the new screen, making allowances for the
// differences in dimensions.
void screen_cpy( Word* buffer, int wb, int hb, int ws, int hs, int r )
{
  Word* screen = (Word*)video->offset;
  Word	left;
  int	w = (ws > wb) ? wb : ws;
  int	h = (hs > hb) ? hb : hs;
  Word	attr = ' ' | (buffer[wb * hb - 1] & 0xff00);

  asm {
	push	si
	push	di
	mov	si,buffer
	mov	ax,r
	mov	bx,wb
	mul	bx
	shl	ax,1
	add	si,ax		// SI = (Byte*)buffer + r * wb * 2
	push	0xb800
	pop	es
	mov	di,screen	// DI = screen
	mov	ax,w
	sub	bx,ax
	shl	bx,1		// BX = (wb - w) * 2
	mov	dx,ws
	sub	dx,ax		// DX = ws - w
  }
  Loop: asm {
	mov	cx,w
	rep	movsw
	mov	ax,attr
	mov	cx,dx
	rep	stosw
	add	si,bx
	dec	h
	jnz	Loop
	mov	screen,di	// screen = DI
	pop	di
	pop	si
  }
  left = video->size - ((unsigned)screen - video->offset);
  asm {
	push	di
	push	0xb800
	pop	es
	mov	di,screen
	mov	ax,attr
	mov	cx,left
	shr	cx,1
	rep	stosw
	pop	di
  }
}
