/* FONTRESIZE - Resizes the character height of .FNT files          */
/* Freeware version                                                 */
/* By Marcio Afonso Arimura Fialho                                  */
/* http://pessoal.iconet.com.br/jlfialho                            */
/* e-mail: jlfialho@iconet.com.br or (alternate) jlfialho@yahoo.com */

// To be able to recompile it, read COMPILE.TXT

#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>

#include "readname.c"

void main (int n, char *ent[5])
 {
	FILE *source,*target;
	int c0,c1;
	int a0,a1;
	int k;
	char path[132];

	char c;
	char info[]="\nType FONTRESZ with no parameters for help\n";
	if (n==1)
	 {
		printf ("\tFONTRESZ ver 1.0a - - - DOS FONT RESIZER - - - FREEWARE VERSION\n\n\
\tUsage:\tFONTRESZ source[.fnt] s_height target[.fnt] t_height\n\n");
		printf ("Where: s_height is the height of characters patterns in source file and\n\
\40\40\40\40\40\40 t_height is the height of characters patterns in target file\n\n");
		printf ("By Marcio Afonso Arimura Fialho\nhttp://pessoal.iconet.com.br/jlfialho\n");
		return;
	 }
	if (n<4)
	 {
		printf ("ERROR: FEW PARAMETERS%s",info);
		return;
	 }

	readfname (path, ent[1], ".FNT");
	source=fopen (path,"rb");
	if(source==NULL)
	 {
		printf ("ERROR: FILE %s COULDN'T BE OPEN TO READ%s",ent[1],info);
		fcloseall();
		return;
	 }
	readfname (path,ent[3], ".FNT");
	target=fopen (path,"rb");
	if (target!=NULL)
		do
		 {
			printf ("\nFILE %s already exists. Overwrite (Y/N)?",path);
			k=toupper(getche());
			if (k=='N')
			 {
				fcloseall();
				return;
			 }
		 }
		 while (k!='N' && k!='Y');
	target=fopen (path,"wb");
	if(target==NULL)
	 {
		printf ("ERROR: FILE %s COULDN'T BE OPEN TO WRITE%s",ent[3],info);
		fcloseall();
		return;
	 }
	sscanf(ent[2],"%d",&a0);
	sscanf(ent[4],"%d",&a1);

	if (a0<0 || a0>256 || a1<0 || a1>256)
	 {
		printf ("ERROR: INPUT VALUES OUT OF RANGE%s",info);
		fcloseall();
		return;
	 }
	for (c0=0;c0<256;c0++)
	 {
		for (c1=0;c1<a0;c1++)
			path[c1]=fgetc(source);
		for (c1=0;c1<a1;c1++)
			fputc(path[c1*a0/a1],target);
	 }
	fseek(target,-1,2);
	fcloseall ();
 }
