;--------------------------------------------------------------------
;	This is a C callable function which uses the BIOS to
; change the hardware border on a video display.
;
; Written By: Gary L. Hennigan <ghenniga@NMSU.Edu>
;	      New Mexico State University
;	      Las Cruces, NM
; Date: 11/30/90
;
; Note that I use Turbo Assembler's simplified segment directives
; and stack frame addressing conventions so this code will not
; compile properly under MSASM.
;--------------------------------------------------------------------
; Variable Used:
;	      	brd_color (int) -  The border color to change to.
;--------------------------------------------------------------------
; Pre-processor Equates
;
	BIOS_INT	EQU	10h
	BIOS_CC		EQU	0Bh
;--------------------------------------------------------------------
; Set up the segments with Turbo's simplified segment directives
;
	DOSSEG
	.MODEL SMALL
	.DATA
	.CODE
	PUBLIC	C bord_change

bord_change PROC
	ARG brd_color:WORD
	push	bp
	mov	bp,sp
	mov	bx, brd_color
	mov	ah, BIOS_CC
	int	BIOS_INT
	pop	bp
	ret
bord_change ENDP
	END
