' $linesize:132
' $title: 'CNFGSUB1.BAS 17.5, Copyright 1987-94 by D. Thomas Mack'
'  Copyright 1994 by D. Thomas Mack, all rights reserved.
'  Name ...............: CNFGSUB1.BAS
'  First Released .....: May 1, 1994
'  Subsequent Releases.: 
'  Copyright ..........: 1987-94
'  Purpose.............: The Remote Bulletin Board System for the IBM PC,
'                        RBBS-PC, configuration program -- CONFIG.BAS
'                        utilizes a lot of menus and string space.
'                        These are incorporated within CNFG-SUB.BAS as a
'                        seperately callable subroutines in order to free
'                        up as much code as possible within the 64K code
'                        segment used by CONFIG.BAS.
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine  Line      Function of Subroutine
'    Name    Number
' ANYINTEGER 61450      Prompt for any integer
' ANYNUMBER  61400      Prompt for any number
' CHKFMSDIR  61700      Check FMS directory for valid structure
' CHKPERSDIR 61755      Check Personal directory format
' CHKRANDOM  61751      Checks FMS/Pers read Randomly
' CNFGINIT   60385      Initialize CONFIG's constants
' DISPLAY    12190      Display the CONFIG menu pages
' GETANSI    62000      Prompt for ANSI colors to be used
' GETASCII   61810      Get any character by character or ascii value
' GETCOLOR   61950      Process request for setting color
' GETINIT    61110      Get answers that are integers
' GETNUMYN   61150      Get TRUE/FALSE answer to a YES/NO question
' GETYESNO   61200      Ask a question with a "yes" or "no" response
' HANDERR    61775+     Handle error checking for FMS directories
' MMINTEGER  61500      Prompt for integer with min and a max
' REMOVE     61800      Remove characters from a string
' SECURE     61860      Allow commands and their security level to be changed
' SETSCRSCHK 61754      Sets up screen for check of FMS directory
'
'  $INCLUDE: 'CNFG-VAR.BAS'
'
'  $SUBTITLE: 'DISPLAY - subroutine to display CONFIG's menus'
'  $PAGE
'
'  SUBROUTINE NAME    --  DISPLAY
'
'  INPUT PARAMETERS   --  PARAMETER        DESCRIPTION
'                         IX = 0           DISPLAY THE CHOICE OF MENUS
'                         IX = -1          RE-READ THE INPUT (INVALID REQUEST)
'                         IX > 0           DISPLAY THE APPROPRIATE PAGE
'
'  OUTPUT PARAMETERS  --  HJ$              OPTION SELECTED
'                         IPAGE            MENU PAGE CONTAINING OPTION
'                         ILOOKUP          INDEX (1 TO 20) OF OPTION SELECTED
'
'  SUBROUTINE PURPOSE --  TO DISPLAY CONFIG'S MENUS AND REQUEST OPTION
'
      SUB DISPLAY STATIC
'
' *  DISPLAY CONFIG'S MAIN FUNCTION KEY MENU
'
      IF IX > 0 THEN _
         GOTO 12320
      IF IX = -1 THEN _
         GOTO 12590
12190 COLOR FG,BG,BORDER
      CLS
      DISPLAYED.PAGE.NUMBER = 0
      I! = FRE(C$)
      COLOR 0,7,0
      LOCATE 4,10
      PRINT "RBBS-PC "+ CONFIG.VERSION$ + " CONFIGURATION PROGRAM"
      COLOR FG,BG,BORDER
      LOCATE 1,1,0
      TITLE.FILENAME$ = CONFIG.FILENAME$                             ' FIX041501
12195 IF INSTR(TITLE.FILENAME$,"\") THEN _                           ' FIX041501
	 TITLE.FILENAME$ = MID$(TITLE.FILENAME$,INSTR(TITLE.FILENAME$,"\") + 1) : _ ' FIX041501
	 GOTO 12195                                                  ' FIX041501
      PRINT "Copyright (c) 1983-1994 Tom Mack"
      LOCATE 1,66                                                    ' FIX041501
      PRINT TITLE.FILENAME$                                          ' FIX041501
      LOCATE 2,1,0
      PRINT "39 Cranbury Dr, Trumbull, CT. 06611";
      IF CONFERENCE.MODE THEN _
         GOSUB 24970
      LOCATE  5,1
      CALL ANSI(FG1$ + "   F1            " + FG2$ + "Global RBBS-PC Parameters (part 1)") ' FIX052301
      CALL ANSI(FG1$ + "   F2            " + FG2$ + "Global RBBS-PC Parameters (part 2)") ' FIX052301
      CALL ANSI(FG1$ + "   F3            " + FG2$ + "Global RBBS-PC Parameters (part 3)") ' FIX052301
      CALL ANSI(FG1$ + "   F4            " + FG2$ + "RBBS-PC System Files (part 1)") ' FIX052301
      CALL ANSI(FG1$ + "   F5            " + FG2$ + "RBBS-PC System Files (part 2)") ' FIX052301
      CALL ANSI(FG1$ + "   F6            " + FG2$ + "Parameters for RBBS-PC's 'Doors'") ' FIX052301
      CALL ANSI(FG1$ + "   F7            " + FG2$ + "Parameters for RBBS-PC's Security (part 1)") ' FIX052301
      CALL ANSI(FG1$ + "   F8            " + FG2$ + "Parameters for RBBS-PC's Security (part 2)") ' FIX052301
      CALL ANSI(FG1$ + "   F9            " + FG2$ + "Parameters for multiple RBBS-PC's") ' FIX052301
      CALL ANSI(FG1$ + "  F10            " + FG2$ + "RBBS-PC utilities") ' FIX052301
      CALL ANSI(FG1$ + "  Shift-F1       " + FG2$ + "RBBS-PC File Management Faciliites") ' FIX052301
      CALL ANSI(FG1$ + "  Shift-F2       " + FG2$ + "RBBS-PC Communications Parameters (part 1)") ' FIX052301
      CALL ANSI(FG1$ + "  Shift-F3       " + FG2$ + "RBBS-PC Communications Parameters (part 2)") ' FIX052301
      CALL ANSI(FG1$ + "  Shift-F4       " + FG2$ + "Parameters for RBBS-PC NET-MAIL") ' FIX052301
      CALL ANSI(FG1$ + "  Shift-F5       " + FG2$ + "New users parameters") ' FIX052301
      CALL ANSI(FG1$ + "  Shift-F6       " + FG2$ + "Library Sub-System") ' FIX052301
      CALL ANSI(FG1$ + "  Shift-F7       " + FG2$ + "RBBS-PC Color parameters") ' FIX052301
      CALL ANSI(FG1$ + "  Shift-F8       " + FG2$ + "New 17.5 Features") ' FIX052301
      XX$ = "Press END to terminate or Function Key to select page "
      GOSUB 50345
      LOCATE ,,1
12310 GOSUB 22160
12320 IF IX THEN _            'IX    Key    Where to branch to
         ON IX GOTO 12360, _  ' 1       F1 - Global Parameters (Part 1)
                    12370, _  ' 2       F2 - Global Parameters (Part 2)
                    12380, _  ' 3       F3 - Global Parameters (Part 3)
                    12390, _  ' 4       F4 - RBBS-PC System Files (Part 1)
                    12400, _  ' 5       F5 - RBBS-PC System Files (Part 2)
                    12410, _  ' 6       F6 - RBBS-PC "doors"
                    12420, _  ' 7       F7 - RBBS-PC security parms. (Part 1)
                    12466, _  ' 8       F8 - RBBS-PC security parms. (Part 2)
                    12470, _  ' 9       F9 - Multiple RBBS-PC parameters
                    12480, _  '10      F10 - RBBS-PC's utilities
                    12490, _  '11 Shift-F1 - RBBS-PC File Manager
                    12500, _  '12 Shift-F2 - RBBS-PC comm. parameters (Part 1)
                    12505, _  '13 Shift-F3 - RBBS-PC comm. parameters (Part 2)
                    12510, _  '14 Shift-F4 - RBBS-PC Net Mail
                    12520, _  '15 Shift-F5 - New user parameters
                    12530, _  '16 Shift-F6 - Library parameters
                    12540, _  '17 Shift-F7 - RBBS-PC Color parameters
		    12550, _  '18 Shift-F8 - New 17.5 features
                    12340, _  '19     PgUp - Go to previous page
                    12330, _  '20     PgDn - Go to next page
                    12630, _  '21      End - Terminate CONFIG
                    12350     '22    Enter - Re-display current page
      GOTO 12310
'
' *  COMMON ROUTINE TO HANDLE UNDEFINED OPTIONS
'
12325 IX = IPAGE
      GOTO 12320
'
' *  COMMON ROUTINE TO HANDLE PAGE UP OF DISPLAYS
'
12330 IF (DISPLAYED.PAGE.NUMBER + 1 ) > 18 THEN _
         GOTO 12190
      IX = DISPLAYED.PAGE.NUMBER + 1
      GOTO 12320
'
' *  COMMON ROUTINE TO HANDLE PAGE DOWN OF DISPLAYS
'
12340 IF DISPLAYED.PAGE.NUMBER - 1 = 0 THEN _                        ' FIX041501
	 GOTO 12190                                                  ' FIX041501
      IF DISPLAYED.PAGE.NUMBER - 1 < 0 THEN _                        ' FIX050903
	 IX = 18 : GOTO 12320                                        ' FIX050903
      IX = DISPLAYED.PAGE.NUMBER - 1
      GOTO 12320
'
' *  RETURN TO PRIMARY MENU SELECTION DISPLAY
'
12350 GOSUB 60380
      GOTO 12310
'
' *  COMMON CONFIGURATION PROGRAM MENU AND PAGE DISPLAY
'
12360 DISPLAYED.PAGE.NUMBER = 1
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + "  1. " + FG2$ + _                             ' FIX052301
	 "SYSOP's Public First Name -------------------- " + FG3$ + _ ' FIX052301
	 SYSOP.FIRST.NAME$)                                           ' FIX052301
      CALL ANSI(FG1$ + "  2. " + FG2$ + _                             ' FIX052301
	 "SYSOP's Public Last Name --------------------- " + FG3$ + _ ' FIX052301
	 SYSOP.LAST.NAME$)                                            ' FIX052301
      CALL ANSI(FG1$ + "  3. " + FG2$ + _                             ' FIX052301
	 "---------------------------------------------- " + FG3$)    ' FIX052301
      CALL ANSI(FG1$ + "  4. " + FG2$ + _                             ' FIX052301
	 "SYSOP's office hours -------------------------" + FG3$ + _  ' FIX052301
	 STR$(START.OFFICE.HOURS) + " to" + STR$(END.OFFICE.HOURS))   ' FIX052301
      CALL ANSI(FG1$ + "  5. " + FG2$ + _                             ' FIX052301
	 "Page SYSOP using printer's bell -------------- " + FG3$ + _ ' FIX052301
	 M11$)                                                        ' FIX052301
      CALL ANSI(FG1$ + "  6. " + FG2$ + _                             ' FIX052301
	 "Go off-line whenever a DISK FULL occurs? ----- " + FG3$ + _ ' FIX052301
	 FNYESNO$(DISKFULL.GO.OFFLINE))                               ' FIX052301
      CALL ANSI(FG1$ + "  7. " + FG2$ + _                             ' FIX052301
	 "Prompt bell default is ----------------------- " + FG3$ + _ ' FIX052301
	 PROMPT.BELL$)                                                ' FIX052301
      CALL ANSI(FG1$ + "  8. " + FG2$ + _                             ' FIX052301
	 "Maximum time per session (in minutes) --------" + FG3$ + _  ' FIX052301
	 STR$(MINUTES.PER.SESSION!))                                  ' FIX052301
      CALL ANSI(FG1$ + "  9. " + FG2$ + _                             ' FIX052301
	 "Maximum minutes per day ----------------------" + FG3$ + _  ' FIX052301
	 STR$(MAX.PER.DAY))                                           ' FIX052301
      CALL ANSI(FG1$ + " 10. " + FG2$ + _                             ' FIX052301
	 "Factor to extend session time for uploads ----" + FG3$ + _  ' FIX052301
	 STR$(UPLOAD.TIME.FACTOR!))                                   ' FIX052301
      CALL ANSI(FG1$ + " 11. " + FG2$ + _                             ' FIX052301
	 "# Months of inactivity before user deleted ---" + FG3$ + _  ' FIX052301
	 STR$(ACT.MNTHS.B4.DELETING))                                 ' FIX052301
      CALL ANSI(FG1$ + " 12. " + FG2$ + _                             ' FIX052301
	 "Name of RBBS-PC shown initially is ----------- " + FG3$ + _ ' FIX052301
	 RBBS.NAME$)                                                  ' FIX052301
      CALL ANSI(FG1$ + " 13. " + FG2$ + _                             ' FIX052301
	 "Foreground color (for color monitors) is -----" + FG3$ + _  ' FIX052301
	 STR$(FG))                                                    ' FIX052301
      CALL ANSI(FG1$ + " 14. " + FG2$ + _                             ' FIX052301
	 "Background color (for color monitors) is -----" + FG3$ + _  ' FIX052301
	 STR$(BG))                                                    ' FIX052301
      CALL ANSI(FG1$ + " 15. " + FG2$ + _                             ' FIX052301
	 "The border color (for color monitors) is -----" + FG3$ + _  ' FIX052301
	 STR$(BORDER))                                                ' FIX052301
      CALL ANSI(FG1$ + " 16. " + FG2$ + _                             ' FIX052301
	 "Your CONFIG.SYS contains 'DEVICE=ANSI.SYS'---- " + FG3$ + _ ' FIX052301
	 FNYESNO$(DOSANSI))                                           ' FIX052301
      IF SMART.TEXT THEN _
         SMART.TEXT$ = STR$(SMART.TEXT) _
      ELSE SMART.TEXT$ = NONE.PICKED$
      CALL ANSI(FG1$ + " 17. " + FG2$ + _                             ' FIX052301
	 "Control character for SMART TEXT -------------" + FG3$ + _  ' FIX052301
	 SMART.TEXT$)                                                 ' FIX052301
      CALL ANSI(FG1$ + " 18. " + FG2$ + _                             ' FIX052301
	 "Path\Filename with auto-operator page parms -- " + FG3$ + _ ' FIX052301
	 AUTOPAGE.DEF$)                                               ' FIX052301
      X = INSTR("ANS",LOGON.MAIL.LEVEL$)
      IF X < 1 THEN _
         X = 1
      X$ = MID$("OLD & NEWNEW ONLY NONE",9*X-8,9)
      IF X$ = "NONE" THEN _
         X$ = NONE.PICKED$
      CALL ANSI(FG1$ + " 19. " + FG2$ + _                             ' FIX052301
	 "Personal mail notification level at logon is - " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + " 20. " + FG2$ + _                             ' FIX052301
	 "Seconds to wait for caller's ANSI detect -----" + FG3$ + _  ' FIX052301
	 STR$(TEST.ANSI.TIME))                                        ' FIX052301
      GOTO 12580
12370 DISPLAYED.PAGE.NUMBER = 2
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + " 21. " + FG2$ + _                             ' FIX052301
	 "Remind users of messages that they left? ----- " + FG3$ + _ ' FIX052301
	 FNYESNO$(MESSAGE.REMINDER))                                  ' FIX052301
      CALL ANSI(FG1$ + " 22. " + FG2$ + _                             ' FIX052301
	 "Remind users of # uploads and downloads? ----- " + FG3$ + _ ' FIX052301
	 FNYESNO$(REMIND.FILE.TRANSFERS))                             ' FIX052301
      CALL ANSI(FG1$ + " 23. " + FG2$ + _                             ' FIX052301
	 "Remind users of their user preferences? ------ " + FG3$ + _ ' FIX052301
	 FNYESNO$(REMIND.PROFILE))                                    ' FIX052301
      CALL ANSI(FG1$ + " 24. " + FG2$ + _                             ' FIX052301
	 "Enable download of new files at logon? ------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(NEW.FILES.CHECK))                                   ' FIX052301
      CALL ANSI(FG1$ + " 25. " + FG2$ + _                             ' FIX052301
	 "Default user page length is ------------------" + FG3$ + _  ' FIX052301
	 STR$(PAGE.LENGTH))                                           ' FIX052301
      CALL ANSI(FG1$ + " 26. " + FG2$ + _                             ' FIX052301
	 "Maximum number of lines allowed per message --" + FG3$ + _  ' FIX052301
	 STR$(MAX.MESSAGE.LINES))                                     ' FIX052301
      CALL ANSI(FG1$ + " 27. " + FG2$ + _                             ' FIX052301
	 "Is system 'welcome' interruptable? ----------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(WELCOME.INTERRUPTABLE))                             ' FIX052301
      CALL ANSI(FG1$ + " 28. " + FG2$ + _                             ' FIX052301
	 "Are system bulletins to be 'optional'? ------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(BULLETINS.OPTIONAL))                                ' FIX052301
      CALL ANSI(FG1$ + " 29. " + FG2$ + _                             ' FIX052301
	 "Type of PC RBBS-PC will be running on -------- " + FG3$ + _ ' FIX052301
	 COMPUTER.TYPE$)                                              ' FIX052301
      CALL ANSI(FG1$ + " 30. " + FG2$ + _                             ' FIX052301
	 "Symbols to use for SYSOP commands ------------ " + FG3$ + _ ' FIX052301
	 SYSOP.COMMANDS$)                                             ' FIX052301
      CALL ANSI(FG1$ + " 31. " + FG2$ + _                             ' FIX052301
	 "Symbols to use for MAIN menu commands -------- " + FG3$ + _ ' FIX052301
	 MAIN.COMMANDS$)                                              ' FIX052301
      CALL ANSI(FG1$ + " 32. " + FG2$ + _                             ' FIX052301
	 "Symbols to use for FILE menu commands -------- " + FG3$ + _ ' FIX052301
	 FILE.COMMANDS$)                                              ' FIX052301
      CALL ANSI(FG1$ + " 33. " + FG2$ + _                             ' FIX052301
	 "Symbols to use for UTILITIES menu commands --- " + FG3$ + _ ' FIX052301
	 UTIL.COMMANDS$)                                              ' FIX052301
      CALL ANSI(FG1$ + " 34. " + FG2$ + _                             ' FIX052301
	 "Symbols to use for global commands ----------- " + FG3$ + _ ' FIX052301
	 GLOBAL.COMMANDS$)                                            ' FIX052301
      CALL ANSI(FG1$ + " 35. " + FG2$ + _                             ' FIX052301
	 "Show section in command prompt? -------------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(SHOW.SECTION))                                      ' FIX052301
      CALL ANSI(FG1$ + " 36. " + FG2$ + _                             ' FIX052301
	 "Show commands in command prompt? ------------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(COMMANDS.IN.PROMPT))                                ' FIX052301
      CALL ANSI(FG1$ + " 37. " + FG2$ + _                             ' FIX052301
	 "Restrict valid commands to current section? -- " + FG3$ + _ ' FIX052301
	 FNYESNO$(RESTRICT.VALID.CMDS))                               ' FIX052301
      CALL ANSI(FG1$ + " 38. " + FG2$ + _                             ' FIX052301
	 "Use machine language routines for speed? ----- " + FG3$ + _ ' FIX052301
	 FNYESNO$(TURBO.RBBS))                                        ' FIX052301
      CALL ANSI(FG1$ + " 39. " + FG2$ + _                             ' FIX052301
	 "Use BASIC PRINT for screen writes? ----------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(USE.BASIC.WRITES))                                  ' FIX052301
      CALL ANSI(FG1$ + " 40. " + FG2$ + _                             ' FIX052301
	 "# of lines for extended file descriptions ----" + FG3$ + _  ' FIX052301
	 STR$(MAX.EXTENDED.LINES))                                    ' FIX052301
      GOTO 12580
12380 DISPLAYED.PAGE.NUMBER = 3
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + " 41. " + FG2$ + _                             ' FIX052301
	 "Field used to identify users ----------------- " + FG3$ + _ ' FIX052301
	 HASH.ID$)                                                    ' FIX052301
      CALL ANSI(FG1$ + " 42. " + FG2$ + _                             ' FIX052301
	 "Field used to distinguish users with same ID-- " + FG3$ + _ ' FIX052301
	 INDIV.ID$)                                                   ' FIX052301
      CALL ANSI(FG1$ + " 43. " + FG2$ + _                             ' FIX052301
	 "Start position identifying personal downloads-" + FG3$ + _  ' FIX052301
	 STR$(PERSONAL.BEGIN))                                        ' FIX052301
      CALL ANSI(FG1$ + " 44. " + FG2$ + _                             ' FIX052301
	 "Field length to identify personal downloads --" + FG3$ + _  ' FIX052301
	 STR$(PERSONAL.LEN))                                          ' FIX052301
      CALL ANSI(FG1$ + " 45. " + FG2$ + _                             ' FIX052301
	 "Prompt for first part of personal identifier - " + FG3$ + _ ' FIX052301
	 FIRST.NAME.PROMPT$)                                          ' FIX052301
      CALL ANSI(FG1$ + " 46. " + FG2$ + _                             ' FIX052301
	 "Prompt for last part of personal identifier -- " + FG3$ + _ ' FIX052301
	 LAST.NAME.PROMPT$)                                           ' FIX052301
      CALL ANSI(FG1$ + " 47. " + FG2$ + _                             ' FIX052301
	 "Enforce upload/download ratios? -------------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(ENFORCE.UPLOAD.DOWNLOAD.RATIOS))                    ' FIX052301
      CALL ANSI(FG1$ + " 48. " + FG2$ + _                             ' FIX052301
	 "RESTRICT users by SUBSCRIPTION date? --------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(RESTRICT.BY.DATE))                                  ' FIX052301
      CALL ANSI(FG1$ + " 49. " + FG2$ + _                             ' FIX052301
	 "Security level when SUBSCRIPTION expires -----"  + FG3$ + _ ' FIX052301
	 STR$(EXPIRED.SECURITY))                                      ' FIX052301
      CALL ANSI(FG1$ + " 50. " + FG2$ + _                             ' FIX052301
	 "Days before expiration to warn callers -------"  + FG3$ + _ ' FIX052301
	 STR$(DAYS.TO.WARN))                                          ' FIX052301
      CALL ANSI(FG1$ + " 51. " + FG2$ + _                             ' FIX052301
	 "Default # days in SUBSCRIPTION PERIOD --------"  + FG3$ + _ ' FIX052301
	 STR$(DAYS.IN.SUBSCRIPTION.PERIOD))                           ' FIX052301
      CALL ANSI(FG1$ + " 52. " + FG2$ + _                             ' FIX052301
	 "Turn printer off after each recycle? --------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(TURN.PRINTER.OFF))                                  ' FIX052301
      CALL ANSI(FG1$ + " 53. " + FG2$ + _                             ' FIX052301
	 "Play musical themes for RBBS-PC functions? --- " + FG3$ + _ ' FIX052301
	 FNYESNO$(MUSIC))                                             ' FIX052301
      CALL ANSI(FG1$ + " 54. " + FG2$ + _                             ' FIX052301
	 "BUFFER SIZE used when displaying text files --" + FG3$ + _  ' FIX052301
	 STR$(BUFFER.SIZE))                                           ' FIX052301
      CALL ANSI(FG1$ + " 55. " + FG2$ + _                             ' FIX052301
	 "Stack space to be made available -------------" + FG3$ + _  ' FIX052301
	 STR$(SIZE.OF.STACK))                                         ' FIX052301
      CALL ANSI(FG1$ + " 56. " + FG2$ + _                             ' FIX052301
	 "----------------------------------------------")            ' FIX052303
      CALL ANSI(FG1$ + " 57. " + FG2$ + _                             ' FIX052301
	 "Prompt for location (What is your ...) ------- " + FG3$ + _ ' FIX052301
	 USER.LOCATION$)                                              ' FIX052301
      CALL ANSI(FG1$ + " 58. " + FG2$ + _                             ' FIX052301
	 "---------------------------------------------- ")           ' FIX052301
      CALL ANSI(FG1$ + " 59. " + FG2$ + _                             ' FIX052301
	 "BUFFER SIZE for writes on internal protocols -" + FG3$ + _  ' FIX052301
	 STR$(WRITE.BUF.DEF))                                         ' FIX052301
      CALL ANSI(FG1$ + " 60. " + FG2$ + _                             ' FIX052301
	 "Voice Synthesizer support -------------------- " + FG3$ + _ ' FIX052301
	 VOICE.TYPE$)                                                 ' FIX052301
      GOTO 12580
12390 DISPLAYED.PAGE.NUMBER = 4
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + " 61. " + FG2$ + _                             ' FIX052301
	 "Path\Filename describing 'bulletins' is ------ " + FG3$ + _ ' FIX052301
	 DRIVE.FOR.BULLETINS$ + BULLETIN.MENU$)                       ' FIX052301
      CALL ANSI(FG1$ + " 62. " + FG2$ + _                             ' FIX052301
	 "Number of active 'bulletins' -----------------" + FG3$ + _  ' FIX052301
	 STR$(ACTIVE.BULLETINS))                                      ' FIX052301
      CALL ANSI(FG1$ + " 63. " + FG2$ + _                             ' FIX052301
	 "Prefix used to name bulletin files is -------- " + FG3$ + _ ' FIX052301
	 BULLETIN.PREFIX$)                                            ' FIX052301
      CALL ANSI(FG1$ + " 64. " + FG2$ + _                             ' FIX052301
	 "Drive and path (optional) for 'help' files --- " + FG3$ + _ ' FIX052301
	 HELP.PATH$)                                                  ' FIX052301
      CALL ANSI(FG1$ + " 65. " + FG2$ + _                             ' FIX052301
	 "Prefix used to name three major 'help' files - " + FG3$ + _ ' FIX052301
	 HELP.FILE.PREFIX$)                                           ' FIX052301
      CALL ANSI(FG1$ + " 66. " + FG2$ + _                             ' FIX052301
	 "Extension for help files of individual cmds -- " + FG3$ + _ ' FIX052301
	 HELP.EXTENSION$)                                             ' FIX052301
      CALL ANSI(FG1$ + " 67. " + FG2$ + _                             ' FIX052301
	 "HELP file when callers CATEGORIZE uploads ---- " + FG3$ + _ ' FIX052301
	 UPCAT.HELP$)                                                 ' FIX052301
      CALL ANSI(FG1$ + " 68. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of 'newuser' file for new users  " + FG3$ + _ ' FIX052301
	 NEWUSER.FILE$)                                               ' FIX052301
      CALL ANSI(FG1$ + " 69. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of 'welcome' file shown at logon " + FG3$ + _ ' FIX052301
	 WELCOME.FILE$)                                               ' FIX052301
      CALL ANSI(FG1$ + " 70. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of SYSOP's command menu -------- " + FG3$ + _ ' FIX052301
	 MENU$(1))                                                    ' FIX052301
      CALL ANSI(FG1$ + " 71. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of MAIN system menu ------------ " + FG3$ + _ ' FIX052301
	 MENU$(2))                                                    ' FIX052301
      CALL ANSI(FG1$ + " 72. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of FILE subsystem menu --------- " + FG3$ + _ ' FIX052301
	 MENU$(3))                                                    ' FIX052301
      CALL ANSI(FG1$ + " 73. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of UTILITIES subsystem menu ---- " + FG3$ + _ ' FIX052301
	 MENU$(4))                                                    ' FIX052301
      CALL ANSI(FG1$ + " 74. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of menu listing conferences ---- " + FG3$ + _ ' FIX052301
	 CONFERENCE.MENU$)                                            ' FIX052301
      CALL ANSI(FG1$ + " 75. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of menu listing questionnaires - " + FG3$ + _ ' FIX052301
	 ANS.MENU$)                                                   ' FIX052301
      CALL ANSI(FG1$ + " 76. " + FG2$ + _                             ' FIX052301
	 "Drive\path for optional questionnaires ------- " + FG3$ + _ ' FIX052301
	 QUES.PATH$)                                                  ' FIX052301
      CALL ANSI(FG1$ + " 77. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of SYSOP-supplied user interface " + FG3$ + _ ' FIX052301
	 MAIN.PUI$)                                                   ' FIX052301
      CALL ANSI(FG1$ + " 78. " + FG2$ + _                             ' FIX052301
	 "Allow menus to pause in the middle? ---------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(MENUS.CAN.PAUSE))                                   ' FIX052301
      CALL ANSI(FG1$ + " 79. " + FG2$ + _                             ' FIX052301
	 "Drive\path where macro files are stored ------ " + FG3$ + _ ' FIX052301
	 MACRO.DRVPATH$)                                              ' FIX052301
      IF MACRO.EXTENSION$ = "" THEN _
         X$ = NONE.PICKED$ _
      ELSE X$ = MACRO.EXTENSION$
      CALL ANSI(FG1$ + " 80. " + FG2$ + _                             ' FIX052301
	 "Extension of macro files --------------------- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      GOTO 12580
12400 DISPLAYED.PAGE.NUMBER = 5
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + " 81. " + FG2$ + _                             ' FIX052301
	 "Path\Filename containing invalid user names -- " + FG3$ + _ ' FIX052301
	 TRASHCAN.FILE$) ' FIX052201                                  ' FIX052301
      CALL ANSI(FG1$ + " 82. " + FG2$ + _                             ' FIX052301
	 "Name questionnaire required of ALL callers --- " + FG3$ + _ ' FIX052301
	 REQUIRED.QUESTIONNAIRE$)                                     ' FIX052301
      CALL ANSI(FG1$ + " 83. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of 'pre-log' file -------------- " + FG3$ + _ ' FIX052301
	 PRELOG$)                                                     ' FIX052301
      CALL ANSI(FG1$ + " 84. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of questionnaire for new users - " + FG3$ + _ ' FIX052301
	 NEW.USER.QUESTIONNAIRE$)                                     ' FIX052301
      CALL ANSI(FG1$ + " 85. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of 'epi-log' questionnaire ----- " + FG3$ + _ ' FIX052301
	 EPILOG$)                                                     ' FIX052301
      CALL ANSI(FG1$ + " 86. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of file containing messages ---- " + FG3$ + _ ' FIX052301
	 MAIN.MESSAGE.FILE$)                                          ' FIX052301
      CALL ANSI(FG1$ + " 87. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of file for recording users ---- " + FG3$ + _ ' FIX052301
	 MAIN.USER.FILE$)                                             ' FIX052301
      CALL ANSI(FG1$ + " 88. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of file for comments to SYSOP -- " + FG3$ + _ ' FIX052301
	 COMMENTS.FILE$)                                              ' FIX052301
      CALL ANSI(FG1$ + " 89. " + FG2$ + _                             ' FIX052301
	 "Record comments as private messages? --------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(COMMENTS.AS.MESSAGES))                              ' FIX052301
      CALL ANSI(FG1$ + " 90. " + FG2$ + _                             ' FIX052301
	 "Path\Filename for recording caller activity -- " + FG3$ + _ ' FIX052301
	 CALLERS.FILE$)                                               ' FIX052301
      CALL ANSI(FG1$ + " 91. " + FG2$ + _                             ' FIX052301
	 "Extended logging to 'callers' file? ---------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(EXTENDED.LOGGING))                                  ' FIX052301
      CALL ANSI(FG1$ + " 92. " + FG2$ + _                             ' FIX052301
	 "Wrap-around the 'callers' file? -------------- " + FG3$ + _ ' FIX052301
	 NOT.YET.IN$)                                                 ' FIX052301
      CALL ANSI(FG1$ + " 93. " + FG2$ + _                             ' FIX052301
	 "Path\Filename defining scan for mail waiting - " + FG3$ + _ ' FIX052301
	 CONFMAIL.LIST$)                                              ' FIX052301
      CALL ANSI(FG1$ + " 94. " + FG2$ + _                             ' FIX052301
	 "Max # of work variables in ques/macros -------" + FG3$ + _  ' FIX052301
	 STR$(MAX.WORK.VAR))                                          ' FIX052301
      IF ZCallersLst$ = "" THEN _
         X$ = NONE.PICKED$ _
      ELSE X$ = ZCallersLst$
      CALL ANSI(FG1$ + " 95. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of callers files for each node - " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + " 96. " + FG2$ + _                             ' FIX052301
	 "Seconds to display copyright of RBBS ---------" + FG3$ + _  ' FIX052301
	 STR$(ZCopyrightSecs))                                        ' FIX052301
      CALL ANSI(FG1$ + " 97. " + FG2$ + _                             ' FIX052301
	 "Prevent callers from quoting in a reply? ----- " + FG3$ + _ ' FIX052301
	 FNYESNO$(ZNoQuoting))                                        ' FIX052301
      GOTO 12580
12410 DISPLAYED.PAGE.NUMBER = 6
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + "101. " + FG2$ + _                             ' FIX052301
	 "Is the 'door' subystem available? ------------ " + FG3$ + _ ' FIX052301
	 FNYESNO$(DOORS.AVAILABLE))                                   ' FIX052301
      CALL ANSI(FG1$ + "102. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of 'door' subsystem menu ------- " + FG3$ + _ ' FIX052301
	 MENU$(5))                                                    ' FIX052301
      CALL ANSI(FG1$ + "103. " + FG2$ + _                             ' FIX052301
	 "Path\Filename built dynamically to open a door " + FG3$ + _ ' FIX052301
	 RCTTY.BAT$)                                                  ' FIX052301
      CALL ANSI(FG1$ + "104. " + FG2$ + _                             ' FIX052301
	 "Path\Filename re-invoke RBBS-PC via after door " + FG3$ + _ ' FIX052301
	 RBBS.BAT$)                                                   ' FIX052301
      CALL ANSI(FG1$ + "105. " + FG2$ + _                             ' FIX052301
	 "Drive\path to look for COMMAND.COM on -------- " + FG3$ + _ ' FIX052301
	 DISK.FOR.DOS$)                                               ' FIX052301
      CALL ANSI(FG1$ + "106. " + FG2$ + _                             ' FIX052301
	 "Use the Dos 'CTTY' command to redirect I/O? -- " + FG3$ + _ ' FIX052301
	 FNYESNO$(REDIRECT.IO.METHOD))                                ' FIX052301
      CALL ANSI(FG1$ + "107. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of Door Program to check users - " + FG3$ + _ ' FIX052301
	 REGISTRATION.PROGRAM$)                                       ' FIX052301
      CALL ANSI(FG1$ + "108. " + FG2$ + _                             ' FIX052301
	 "Logon door required of new users & security <=" + FG3$ + _  ' FIX052301
	 STR$(MAX.REG.SEC))                                           ' FIX052301
      CALL ANSI(FG1$ + "109. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of control file for doors ------ " + FG3$ + _ ' FIX052301
	 DOORS.DEF$)                                                  ' FIX052301
      GOTO 12580
12420 DISPLAYED.PAGE.NUMBER = 7
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + "121. " + FG2$ + _                             ' FIX052301
	 "Pseudonym to sign on remotely as the SYSOP ---- " + FG3$ + _ ' FIX052301
	 MN1$ + " " + MN2$)                                           ' FIX052301
      CALL ANSI(FG1$ + "122. " + FG2$ + _                             ' FIX052301
	 "ESC key logs SYSOP on locally without password? " + FG3$ + _ ' FIX052301
	 FNYESNO$(ESCAPE.INSECURE))                                   ' FIX052301
      CALL ANSI(FG1$ + "123. " + FG2$ + _                             ' FIX052301
	 "Minimum security level to log on RBBS-PC ------" + FG3$ + _ ' FIX052301
	 STR$(MINIMUM.LOGON.SECURITY))                                ' FIX052301
      CALL ANSI(FG1$ + "124. " + FG2$ + _                             ' FIX052301
	 "Default security level for new callers --------" + FG3$ + _ ' FIX052301
	 STR$(DEFAULT.SECURITY.LEVEL))                                ' FIX052301
      CALL ANSI(FG1$ + "125. " + FG2$ + _                             ' FIX052301
	 "Security level for SYSOP ----------------------" + FG3$ + _ ' FIX052301
	 STR$(SYSOP.SECURITY.LEVEL))                                  ' FIX052301
      CALL ANSI(FG1$ + "126. " + FG2$ + _                             ' FIX052301
	 "Minimum security level to see SYSOP's menu ----" + FG3$ + _ ' FIX052301
	 STR$(SYSOP.MENU.SECURITY.LEVEL))                             ' FIX052301
      CALL ANSI(FG1$ + "127. " + FG2$ + _                             ' FIX052301
	 "Minimum security to leave extended description-" + FG3$ + _ ' FIX052301
	 STR$(ASK.EXTENDED.DESC))                                     ' FIX052301
      CALL ANSI(FG1$ + "128. " + FG2$ + _                             ' FIX052301
	 "Max # security violations before disconnect ---" + FG3$ + _ ' FIX052301
	 STR$(MAXIMUM.VIOLATIONS))                                    ' FIX052301
      M22$ = STR$(SYSOP.FUNCTION(1))
      IX = SYSOP.FUNCTION(1)
      FOR I = 2 TO NUM.SYSOP
        IF IX <> SYSOP.FUNCTION(I) THEN _
	   M22$ = " (Variable)" : _
           GOTO 12430
      NEXT
12430 CALL ANSI(FG1$ + "129. " + FG2$ + _                             ' FIX052301
	 "Security level for SYSOP functions ------------" + FG3$ + _ ' FIX052301
	 M22$)                                                        ' FIX052301
      M23$ = STR$(MAIN.FUNCTION(1))
      IX = MAIN.FUNCTION(1)
      FOR I = 2 TO NUM.MAIN
        IF IX<>MAIN.FUNCTION(I) THEN _
	   M23$ = " (Variable)" : _
           GOTO 12440
      NEXT
12440 CALL ANSI(FG1$ + "130. " + FG2$ + _                             ' FIX052301
	 "Security level for main menu functions --------" + FG3$ + _ ' FIX052301
	 M23$)                                                        ' FIX052301
      M24$ = STR$(FILES.FUNCTION(1))                                  ' FIX052301
      IX = FILES.FUNCTION(1)
      FOR I = 2 TO NUM.FILES
        IF IX<>FILES.FUNCTION(I) THEN _
	   M24$ = " (Variable)" : _
           GOTO 12450
      NEXT
12450 CALL ANSI(FG1$ + "131. " + FG2$ + _                             ' FIX052301
	 "Security level for file menu functions --------" + FG3$ + _ ' FIX052301
	 M24$)                                                        ' FIX052301
      M25$ = STR$(UTILITY.FUNCTION(1))
      IX = UTILITY.FUNCTION(1)
      FOR I = 2 TO NUM.UTILITY
        IF IX<>UTILITY.FUNCTION(I) THEN _
	   M25$ = " (Variable)" : _
           GOTO 12460
      NEXT
12460 CALL ANSI(FG1$ + "132. " + FG2$ + _                             ' FIX052301
	 "Security level for utilities menu functions ---" + FG3$ + _ ' FIX052301
	 M25$)                                                        ' FIX052301
      M26$ = STR$(GLOBAL.FUNCTION(1))
      IX = GLOBAL.FUNCTION(1)
      FOR I = 1 TO NUM.GLOBAL
        IF IX<>GLOBAL.FUNCTION(I) THEN _
	   M26$ = " (Variable)" : _
           GOTO 12465
      NEXT
12465 CALL ANSI(FG1$ + "133. " + FG2$ + _                             ' FIX052301
	 "Security level for GLOBAL commands ------------" + FG3$ + _ ' FIX052301
	 M26$)                                                        ' FIX052301
      CALL ANSI(FG1$ + "134. " + FG2$ + _                             ' FIX052301
	 "Max # of password changes in a session --------" + FG3$ + _ ' FIX052301
	 STR$(MAXIMUM.PASSWORD.CHANGES))                              ' FIX052301
      CALL ANSI(FG1$ + "135. " + FG2$ + _                             ' FIX052301
	 "Minimum security for temp. password changes ---" + FG3$ + _ ' FIX052301
	 STR$(MINIMUM.SECURITY.FOR.TEMP.PASSWORD))                    ' FIX052301
      CALL ANSI(FG1$ + "136. " + FG2$ + _                             ' FIX052301
	 "Minimum security to overwrite on uploads ------" + FG3$ + _ ' FIX052301
	 STR$(OVERWRITE.SECURITY.LEVEL))                              ' FIX052301
      CALL ANSI(FG1$ + "137. " + FG2$ + _                             ' FIX052301
	 "User's security exempted from 'packing' -------" + FG3$ + _ ' FIX052301
	 STR$(SEC.LVL.EXEMPT.FRM.PURGING))                            ' FIX052301
      CALL ANSI(FG1$ + "138. " + FG2$ + _                             ' FIX052301
	 "Default security to read new PRIVATE messages -" + FG3$ + _ ' FIX052301
	 STR$(PRIVATE.READ.SEC))                                      ' FIX052301
      CALL ANSI(FG1$ + "139. " + FG2$ + _                             ' FIX052301
	 "Default security to read new PUBLIC messages --"  + FG3$ + _ ' FIX052301
	 STR$(PUBLIC.READ.SEC))                                       ' FIX052301
      CALL ANSI(FG1$ + "140. " + FG2$ + _                             ' FIX052301
	 "Minimum security to change msg.'s security ----"  + FG3$ + _ ' FIX052301
	 STR$(SEC.CHANGE.MSG))                                        ' FIX052301
      GOTO 12580
12466 DISPLAYED.PAGE.NUMBER = 8
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + "141. " + FG2$ + _                             ' FIX052301
	 "Call-back verification ----------------------- " + FG3$ + _ ' FIX052301
	 NOT.YET.IN$)                                                 ' FIX052301
      CALL ANSI(FG1$ + "142. " + FG2$ + _                             ' FIX052301
	 "Drive\path where personal files stored ------- " + FG3$ + _ ' FIX052301
	 PERSONAL.DRVPATH$)                                           ' FIX052301
      CALL ANSI(FG1$ + "143. " + FG2$ + _                             ' FIX052301
	 "Name of Personal Directory ------------------- " + FG3$ + _ ' FIX052301
	 PERSONAL.DIR$)                                               ' FIX052301
      CALL ANSI(FG1$ + "144. " + FG2$ + _                             ' FIX052301
	 "Protocol required for personal downloads ----- " + FG3$ + _ ' FIX052301
	 MID$("<other><none> Ascii  XMODEM Xm/CRC Kermit Ymodem Imodem YmodemGWxmodem", _ ' FIX052301
	 7 * INSTR("NAXCKYIGW",PERSONAL.PROTOCOL$) + 1,7))            ' FIX052301
      CALL ANSI(FG1$ + "145. " + FG2$ + _                             ' FIX052301
	 "Path\Filename listing download security  ----- " + FG3$ + _ ' FIX052301
	 FILESEC.FILE$)                                               ' FIX052301
      CALL ANSI(FG1$ + "146. " + FG2$ + _                             ' FIX052301
	 "Path\Filename with privileged group passwords  " + FG3$ + _ ' FIX052301
	 PASSWORD.FILE$)                                              ' FIX052301
      CALL ANSI(FG1$ + "147. " + FG2$ + _                             ' FIX052301
	 "Concatenate multi-file ASCII downloads? ------ " + FG3$ + _ ' FIX052301
	 FNYESNO$(PERSONAL.CONCAT))                                   ' FIX052301
      CALL ANSI(FG1$ + "148. " + FG2$ + _                             ' FIX052301
	 "Min SECURITY to CATEGORIZE uploads -----------" + FG3$ + _  ' FIX052301
	 STR$(SL.CATEGORIZE.UPLOADS))                                 ' FIX052301
      CALL ANSI(FG1$ + "149. " + FG2$ + _                             ' FIX052301
	 "Min security level to view new uploads -------" + FG3$ + _  ' FIX052301
	 STR$(MIN.SEC.TO.VIEW))                                       ' FIX052301
      CALL ANSI(FG1$ + "150. " + FG2$ + _                             ' FIX052301
	 "Security level exempt from 'epi-log' file ----" + FG3$ + _  ' FIX052301
	 STR$(SECURITY.EXEMPT.FROM.EPILOG))                           ' FIX052301
      CALL ANSI(FG1$ + "151. " + FG2$ + _                             ' FIX052301
	 "Min. security to 'AUTO ADD' conference user -- " + FG3$ + _ ' FIX052301
	 AUTO.ADD.SECURITY$)                                          ' FIX052301
      CALL ANSI(FG1$ + "152. " + FG2$ + _                             ' FIX052301
	 "Min. security for old caller to turbo logon --" + FG3$ + _  ' FIX052301
	 STR$(ALLOW.CALLER.TURBO))                                    ' FIX052301
      CALL ANSI(FG1$ + "153. " + FG2$ + _                             ' FIX052301
	 "Min. security to describe an existing file ---" + FG3$ + _  ' FIX052301
	 STR$(ADD.DIR.SECURITY))                                      ' FIX052301
      CALL ANSI(FG1$ + "154. " + FG2$ + _                             ' FIX052301
	 "Help file to display for a security violation- " + FG3$ + _ ' FIX052301
	 SECVIO.HLP$)                                                 ' FIX052301
      TIME.LOCK$ = MID$("<none> DOORS  DOWNLDSBOTH   ",TIME.LOCK*7+1,7)
      CALL ANSI(FG1$ + "155. " + FG2$ + _                             ' FIX052301
	 "Time lock on DOORS and DOWNLOADS ------------- " + FG3$ + _ ' FIX052301
	 TIME.LOCK$)                                                  ' FIX052301
      CALL ANSI(FG1$ + "156. " + FG2$ + _                             ' FIX052301
	 "Min. sec level exempt from auto-update of sec-" + FG3$ + _  ' FIX052301
	 STR$(AUTO.UPGRADE.SEC))                                      ' FIX052301
      CALL ANSI(FG1$ + "157. " + FG2$ + _                             ' FIX052301
	 "Min security to READ & KILL all messages -----" + FG3$ + _  ' FIX052301
	 STR$(SEC.KILL.ANY))                                          ' FIX052301
      CALL ANSI(FG1$ + "158. " + FG2$ + _                             ' FIX052301
	 "Do not display lines in msgs beginning with -- " + FG3$ + _ ' FIX052301
	 SCREEN.OUT.MSG$)                                             ' FIX052301
      CALL ANSI(FG1$ + "159. " + FG2$ + _                             ' FIX052301
	 "Min. sec level to do personal uploads --------" + FG3$ + _  ' FIX052301
	 STR$(ZMinSecPersUpld))                                       ' FIX052301
      CALL ANSI(FG1$ + "160. " + FG2$ + _                             ' FIX052301
	 "Let messages have multiple recipients? ------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(ZEnableCC))                                         ' FIX052301
      GOTO 12580
12470 DISPLAYED.PAGE.NUMBER = 9
      GOSUB 30040
      ' MAX.USR.FILE.SIZE.FRM.DEF = HIGHEST.USER.RECORD
      MAX.MSG.FILE.SIZE.FRM.DEF! = HIGHEST.MESSAGE.RECORD
      MAX.ALLOWED.MSGS.FRM.DEF  = MAXIMUM.NUMBER.OF.MSGS
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + "161. " + FG2$ + _                             ' FIX052301
	 "Maximum number of concurrent RBBS-PC's  -------" + FG3$ + _ ' FIX052301
	 STR$(MAXIMUM.NUMBER.OF.NODES))                               ' FIX052301
      MT$ = "single RBBS-PC copy -"
      IF MAXIMUM.NUMBER.OF.NODES <> 1 THEN _
	 MT$ = "multiple RBBS-PC's --" : _
         SUBROUTINE.PARAMETER = 2 : _
         IF NETWORK.TYPE < 0 OR NETWORK.TYPE > 7 THEN _
            SUBROUTINE.PARAMETER = 1 : _
            CALL NETTYPE : _
         ELSE CALL NETTYPE
      CALL ANSI(FG1$ + "162. " + FG2$ + _                             ' FIX052301
	 "Environment running " + MT$ + "------ " + FG3$ + _          ' FIX060401
	 NETWORK.TYPE$)                                               ' FIX052301
      CALL ANSI(FG1$ + "163. " + FG2$ + _                             ' FIX052301
	 "RBBS-PC 'recycle' method when users log off --- " + FG3$ + _ ' FIX052301
	 RECYCLE.TO.DOS$)                                             ' FIX052301
      FILE$ = MAIN.MESSAGE.FILE$
      GOSUB 30180
      MAX.MSG.FILE.SIZE.FRM.DEF! = UG
      IF CONFERENCE.MODE <> 1 THEN _
         X$ = "MAIN" _
      ELSE X$ = ZConfName$
      CALL ANSI(FG1$ + "164. " + FG2$ + _                             ' FIX052301
	 "Number of records in " + X$ + " User File " + _             ' FIX052301
	 STRING$(15-LEN(X$),"-") + FG3$ + STR$(MAX.USR.FILE.SIZE.FRM.DEF)) ' FIX052301
      IF MAIN.MESSAGE.FILE$ = MAINMSG$ THEN _
         X$ = "MAIN" _
      ELSE X$ = ZConfName$
      CALL ANSI(FG1$ + "165. " + FG2$ + _                             ' FIX052301
	 "Number of records in " + X$ + " Message File " + _          ' FIX052301
	 STRING$(12-LEN(X$),"-") + FG3$ + STR$(MAX.MSG.FILE.SIZE.FRM.DEF!)) ' FIX052301
      CALL ANSI(FG1$ + "166. " + FG2$ + _                             ' FIX052301
	 "Maximum number of messages allowed ------------" + FG3$ + _ ' FIX052301
	 STR$(MAX.ALLOWED.MSGS.FRM.DEF))                              ' FIX052301
      CALL ANSI(FG1$ + "167. " + FG2$ + _                             ' FIX052301
	 "Conference/Subboard File Maintenance.")                     ' FIX052301
      IF DEFAULT.EXTENSION$ = "" THEN _
	 X$ = NONE.PICKED$ _
      ELSE X$ = DEFAULT.EXTENSION$                                    ' FIX052301
      CALL ANSI(FG1$ + "168. " + FG2$ + _                             ' FIX052301
	 "Default extension for compressed files -------- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + "169. " + FG2$ + _                             ' FIX052301
	 "Additional extensions for compressed files ---- " + FG3$ + _ ' FIX052301
	 COMPRESSED.EXT$)                                             ' FIX052301
      CALL ANSI(FG1$ + "170. " + FG2$ + _                             ' FIX052301
	 "Message file GROWS in size as messages added? - " + FG3$ + _ ' FIX052301
	 FNYESNO$(MESSAGES.CAN.GROW))                                 ' FIX052301
      CALL ANSI(FG1$ + "171. " + FG2$ + _                             ' FIX052301
	 "Name (prefix only) of distribution lists menu - " + FG3$ + _ ' FIX052301
	 ZDistriHelp$)                                                ' FIX052301
      CALL ANSI(FG1$ + "172. " + FG2$ + _                             ' FIX052301
	 "Drive\path where distribution lists stored ---- " + FG3$ + _ ' FIX052301
	 ZDistriPath$)                                                ' FIX052301
      CALL ANSI(FG1$ + "173. " + FG2$ + _                             ' FIX052301
	 "Msg sec can be (U=public,R=private,P=password)- " + FG3$ + _ ' FIX052301
	 ZMsgSecCats$)                                                ' FIX052301
      GOTO 12580
12480 DISPLAYED.PAGE.NUMBER = 10
      GOSUB 24800
      RB = 0
      LOCATE  3,1
      CALL ANSI(FG1$ + "181. " + FG2$ + _                             ' FIX052301
	 "Pack " + MAIN.MESSAGE.FILE$ + " file.")                     ' FIX052301
      CALL ANSI(FG1$ + "182. " + FG2$ + _                             ' FIX052301
	 "Rebuild " + MAIN.USER.FILE$ + " file.")                     ' FIX052301
      CALL ANSI(FG1$ + "183. " + FG2$ + _                             ' FIX052301
	 "Print " + MAIN.MESSAGE.FILE$ + " 'header' records.")        ' FIX052301
      CALL ANSI(FG1$ + "184. " + FG2$ + _                             ' FIX052301
	 "Renumber messages in " + MAIN.MESSAGE.FILE$ + " file.")     ' FIX052301
      CALL ANSI(FG1$ + "185. " + FG2$ + _                             ' FIX052301
	 "Repair messages in " + MAIN.MESSAGE.FILE$ + " file.")       ' FIX052301
      CALL ANSI(FG1$ + "186. " + FG2$ + _                             ' FIX052301
	 "Make all users answer required questionnaire.")             ' FIX052301
      CALL ANSI(FG1$ + "187. " + FG2$ + _                             ' FIX052301
	 "Check FMS directory structure.")                            ' FIX052301
      CALL ANSI(FG1$ + "188. " + FG2$ + _                             ' FIX052301
	 "Check Personal Download directory structure.")              ' FIX052301
      CALL ANSI(FG1$ + "189. " + FG2$ + _                             ' FIX052301
	 "Set most critical parameters.")                             ' FIX052301
      CALL ANSI(FG1$ + "190. " + FG2$ + _                             ' FIX052301
	 "Set parameters new to RBBS-PC " + CONFIG.VERSION$)          ' FIX052301
      CALL ANSI(FG1$ + "191. " + FG2$ + _                             ' FIX052301
	 "Reset active printers for all nodes.")                      ' FIX052301
      CALL ANSI(FG1$ + "192. " + FG2$ + _                             ' FIX052301
	 "Make user pref. on hilighting match color graphics.")       ' FIX052301
      GOTO 12580
12490 DISPLAYED.PAGE.NUMBER = 11
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + "201. " + FG2$ + _                             ' FIX052301
	 "Drive available for uploading files to ------- " + FG3$ + _ ' FIX052301
	 DRIVE.FOR.UPLOADS$ + ":")                                    ' FIX052301
      CALL ANSI(FG1$ + "202. " + FG2$ + _                             ' FIX052301
	 "File name of Upload Directory  --------------- " + FG3$ + _ ' FIX052301
	 UPLOAD.DIRECTORY$)                                           ' FIX052301
      CALL ANSI(FG1$ + "203. " + FG2$ + _                             ' FIX052301
	 "Drive\path where Upload Directory stored ----- " + FG3$ + _ ' FIX052301
	 UPLOAD.PATH$)                                                ' FIX052301
      CALL ANSI(FG1$ + "204. " + FG2$ + _                             ' FIX052301
	 "Drive(s) available for Downloading ----------- " + FG3$ + _ ' FIX052301
	 DRIVES.FOR.DOWNLOADS$)                                       ' FIX052301
      CALL ANSI(FG1$ + "205. " + FG2$ + _                             ' FIX052301
	 "Will you be using DOS sub-directories? ------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(WILL.SUBDIRS.B.USED))                               ' FIX052301
      CALL ANSI(FG1$ + "206. " + FG2$ + _                             ' FIX052301
	 "Write Uploads to a DOS sub-directory? -------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(UPLOAD.TO.SUBDIR))                                  ' FIX052301
      CALL ANSI(FG1$ + "207. " + FG2$ + _                             ' FIX052301
	 "Are downloads from DOS sub-directories? ------ " + FG3$ + _ ' FIX052301
	 FNYESNO$(DOWNLOAD.TO.SUBDIR))                                ' FIX052301
      CALL ANSI(FG1$ + "208. " + FG2$ + _                             ' FIX052301
	 "Add, change, delete, import, list sub-dirs. --")            ' FIX052301
      CALL ANSI(FG1$ + "209. " + FG2$ + _                             ' FIX052301
	 "Extension for file directories --------------- " + FG3$ + _ ' FIX052301
	 DIRECTORY.EXTENTION$)                                        ' FIX052301
      X$ = ALTDIR.EXTENSION$
      IF ALTDIR.EXTENSION$ = "" OR _
         ALTDIR.EXTENSION$ = "<none>" THEN _
         X$ = NONE.PICKED$
      CALL ANSI(FG1$ + "210. " + FG2$ + _                             ' FIX052301
	 "Alternate extension for directory files ------ " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + "211. " + FG2$ + _                             ' FIX052301
	 "Name (prefix) of directory of directories ---- " + FG3$ + _ ' FIX052301
	 DIRECTORY.PREFIX$)                                           ' FIX052301
      CALL ANSI(FG1$ + "212. " + FG2$ + _                             ' FIX052301
	 "Omit directory of directories in N)ew cmnd. -- " + FG3$ + _ ' FIX052301
	 OMIT.MAIN.DIRECTORY$)                                        ' FIX052301
      X$ = ALWAYS.STREW.TO$                                           ' FIX052301
      IF ALWAYS.STREW.TO$ = "" OR _
         ALWAYS.STREW.TO$ = "<none>" THEN _
         X$ = "NO"
      CALL ANSI(FG1$ + "213. " + FG2$ + _                             ' FIX052301
	 "Copy all upload descriptions to -------------- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      A$ = FMS.DIRECTORY$
      IF FMS.DIRECTORY$ = "" THEN _
         A$ = NONE.PICKED$
      CALL ANSI(FG1$ + "214. " + FG2$ + _                             ' FIX052301
	 "Name of master File Management System dir is - " + FG3$ + _ ' FIX052301
	 A$)                                                          ' FIX052301
      CALL ANSI(FG1$ + "215. " + FG2$ + _                             ' FIX052301
	 "Limit file searches to master FMS dir only? -- " + FG3$ + _ ' FIX052301
	 FNYESNO$(LIMIT.SEARCH.TO.FMS))                               ' FIX052301
      CALL ANSI(FG1$ + "216. " + FG2$ + _                             ' FIX052301
	 "Default category code for uploads ------------ " + FG3$ + _ ' FIX052301
	 DEFAULT.CATEGORY.CODE$)                                      ' FIX052301
      CALL ANSI(FG1$ + "217. " + FG2$ + _                             ' FIX052301
	 "Path\Filename containing directory categories  " + FG3$ + _ ' FIX052301
	 DIR.CATEGORY.FILE$)                                          ' FIX052301
      X$ = MASTER.DIRECTORY.NAME$
      IF MASTER.DIRECTORY.NAME$ = "" THEN _
         X$ = "NO"
      CALL ANSI(FG1$ + "218. " + FG2$ + _                             ' FIX052301
	 "Limit search for 'ALL' dirs to directory ----- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + "219. " + FG2$ + _                             ' FIX052301
	 "Max length of description of uploaded file ---" + FG3$ + _  ' FIX052301
	 STR$(MAX.DESC.LEN))                                          ' FIX052301
      CALL ANSI(FG1$ + "220. " + FG2$ + _                             ' FIX052301
	 "Drive\path(optional) for directory files ----- " + FG3$ + _ ' FIX052301
	 DIRECTORY.PATH$)                                             ' FIX052301
      GOTO 12580
12500 DISPLAYED.PAGE.NUMBER = 12
      GOSUB 24800
      LOCATE 3,1
      CALL ANSI(FG1$ + "221. " + FG2$ + _                             ' FIX052301
	 "Communications port to be used by RBBS-PC ---- " + FG3$ + _ ' FIX052301
	 COM.PORT$)                                                   ' FIX052301
      CALL ANSI(FG1$ + "222. " + FG2$ + _                             ' FIX052301
	 "# of seconds to wait for modem to initialize -" + FG3$ + _  ' FIX052301
	 STR$(MODEM.INIT.WAIT.TIME))                                  ' FIX052301
      CALL ANSI(FG1$ + "223. " + FG2$ + _                             ' FIX052301
	 "Seconds to wait before issuing modem commands-" + FG3$ + _  ' FIX052301
	 STR$(MODEM.COMMAND.DELAY.TIME))                              ' FIX052301
      X$ = ""
      IF INSTR(USER.INIT.COMMAND$, "S0=255") > 0 THEN _
	 X$ = " RING BACK"
      CALL ANSI(FG1$ + "224. " + FG2$ + _                             ' FIX052301
	 "Number of rings to wait before answering -----" + FG3$ + _  ' FIX052301
	 STR$(REQUIRED.RINGS) + X$)                                   ' FIX052301
      CALL ANSI(FG1$ + "225. " + FG2$ + _                             ' FIX052301
	 "Set the modem commands")                                    ' FIX052301
      CALL ANSI(FG1$ + "226. " + FG2$ + _                             ' FIX052301
	 "---------------------------------------------- ")           ' FIX052301
      CALL ANSI(FG1$ + "227. " + FG2$ + _                             ' FIX052301
	 "Issue modem commands between rings? ---------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(COMMANDS.BETWEEN.RINGS))                            ' FIX052301
      CALL ANSI(FG1$ + "228. " + FG2$ + _                             ' FIX052301
	 "BPS rate to initially open modem at ---------- " + FG3$ + _ ' FIX052301
	 MODEM.INIT.BAUD$)                                            ' FIX052301
      X$ = STR$(WAIT.BEFORE.DISCONNECT) + " seconds"
      IF WAIT.BEFORE.DISCONNECT = 0 THEN _
         X$ = "NO"
      CALL ANSI(FG1$ + "229. " + FG2$ + _                             ' FIX052301
	 "Log off users who are idle for ---------------" + FG3$ + _  ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + "230. " + FG2$ + _                             ' FIX052301
	 "Are you using a 'DUMB' auto-answer modem? ---- " + FG3$ + _ ' FIX052301
	 FNYESNO$(DUMB.MODEM))                                        ' FIX052301
      CALL ANSI(FG1$ + "231. " + FG2$ + _                             ' FIX052301
	 "Initialize modem firmware for RBBS-PC.")                    ' FIX052301
      CALL ANSI(FG1$ + "232. " + FG2$ + _                             ' FIX052301
	 "# seconds to wait after dropping DTR ---------" + FG3$ + _  ' FIX052301
	 STR$(DTR.DROP.DELAY))                                        ' FIX052301
      IF PROTO.DEF$ = "" THEN _
	 X$ = NONE.PICKED$ _
      ELSE X$ = PROTO.DEF$
      CALL ANSI(FG1$ + "233. " + FG2$ + _                             ' FIX052301
	 "Path\Filename with PROTOCOL definitions ------ " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + "234. " + FG2$ + _                             ' FIX052301
	 "Always check user for AUTODOWNLOAD support? -- " + FG3$ + _ ' FIX052301
	 FNYESNO$(ASK.IDENTITY))                                      ' FIX052301
      CALL ANSI(FG1$ + "235. " + FG2$ + _                             ' FIX052301
	 "Require non-ascii protocol for BASIC files? -- " + FG3$ + _ ' FIX052301
	 FNYESNO$(REQUIRE.NON.ASCII))                                 ' FIX052301
      X$ = STR$(RECYCLE.WAIT) + " minutes"
      IF RECYCLE.WAIT = 0 THEN _
	 X$ = " <Don't recycle>"
      CALL ANSI(FG1$ + "236. " + FG2$ + _                             ' FIX052301
	 "Recycle if no calls are received within ------" + FG3$ + _  ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + "237. " + FG2$ + _                             ' FIX052301
	 "Leave (lock) modem at initial baud? ---------- " + FG3$ + _ ' FIX052301
	 FNYESNO$(KEEP.INIT.BAUD))                                    ' FIX052301
      GOTO 12580
12505 DISPLAYED.PAGE.NUMBER = 13
      GOSUB 24800
      LOCATE 3,1
      CALL ANSI(FG1$ + "241. " + FG2$ + _                             ' FIX052301
	 "Restore initial parms. after change to N/8/1?  " + FG3$ + _ ' FIX052301
	 FNYESNO$(SWITCH.BACK))                                       ' FIX052301
      CALL ANSI(FG1$ + "242. " + FG2$ + _                             ' FIX052301
	 "Minimum BPS rate required of new callers -----" + FG3$ + _  ' FIX052301
	 STR$(MIN.NEWCALLER.BAUD))                                    ' FIX052301
      CALL ANSI(FG1$ + "243. " + FG2$ + _                             ' FIX052301
	 "Minimum BPS rate required of old callers -----" + FG3$ + _  ' FIX052301
	 STR$(MIN.OLDCALLER.BAUD))                                    ' FIX052301
      CALL ANSI(FG1$ + "244. " + FG2$ + _                             ' FIX052301
	 "Modem flow control uses Clear-to-Send (CTS)? - " + FG3$ + _ ' FIX052301
	 RTS$)                                                        ' FIX052301
      CALL ANSI(FG1$ + "245. " + FG2$ + _                             ' FIX052301
	 "Modem flow control uses XON/XOFF? ------------ " + FG3$ + _ ' FIX052301
	 FNYESNO$(XON.XOFF))                                          ' FIX052301
      CALL ANSI(FG1$ + "246. " + FG2$ + _                             ' FIX052301
	 "Seconds to wait for carrier after answering --"  + FG3$ + _ ' FIX052301
	 STR$(MAX.CARRIER.WAIT))                                      ' FIX052301
      GOTO 12580
12510 DISPLAYED.PAGE.NUMBER = 14
      GOSUB 24800
      LOCATE 3,1
      IF TIME.TO.DROP.TO.DOS < 1 THEN _
         TIME.TO.DROP.TO.DOS$ = NONE.PICKED$ _
      ELSE TIME.TO.DROP.TO.DOS$ = STRING$(4 - (LEN(STR$(TIME.TO.DROP.TO.DOS)) - 1),"0") + _
	 MID$(STR$(TIME.TO.DROP.TO.DOS),2)
12512 CALL ANSI(FG1$ + "261. " + FG2$ + _                             ' FIX052301
	 "Time of day to exit to DOS ------------------- " + FG3$ + _ ' FIX052301
	 TIME.TO.DROP.TO.DOS$)                                        ' FIX052301
      CALL ANSI(FG1$ + "262. " + FG2$ + _                             ' FIX052301
	 "Net mail to invoke is ------------------------ " + FG3$ + _ ' FIX052301
	 NET.MAIL$)                                                   ' FIX052301
      X$ = HOST.ECHO.ON$
      IF HOST.ECHO.ON$ = "" THEN _
         X$ = NONE.PICKED$
      CALL ANSI(FG1$ + "263. " + FG2$ + _                             ' FIX052301
	 "Command for intermediate host to ECHO -------- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      X$ = HOST.ECHO.OFF$
      IF HOST.ECHO.OFF$ = "" THEN _
         X$ = NONE.PICKED$
      CALL ANSI(FG1$ + "264. " + FG2$ + _                             ' FIX052301
	 "Command for intermediate host NOT to ECHO ---- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      X = INSTR("ICR",DEFAULT.ECHOER$)
      X$ = MID$("Intermediate hostCaller's softwareRBBS-PC",1 + 17 * (X - 1),17)
      CALL ANSI(FG1$ + "265. " + FG2$ + _                             ' FIX052301
	 "Who echos what a remote caller types? -------- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      X$ = DEFAULT.LINE.ACK$                                          ' FIX052301
      IF DEFAULT.LINE.ACK$ = "" THEN _
         X$ = NONE.PICKED$
      CALL ANSI(FG1$ + "266. " + FG2$ + _                             ' FIX052301
	 "String to acknowledge line in ASCII upload --- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052302
      CALL ANSI(FG1$ + "267. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of sorted file list for speed -- " + FG3$ + _ ' FIX052301
	 FAST.FILE.LIST$)                                             ' FIX052301
      CALL ANSI(FG1$ + "268. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of locator file used in x-fers - " + FG3$ + _ ' FIX052301
	 FAST.FILE.LOCATOR$)                                          ' FIX052301
      GOTO 12580
12520 DISPLAYED.PAGE.NUMBER = 15
      GOSUB 24800
      LOCATE  3,1
      CALL ANSI(FG1$ + "281. " + FG2$ + _                             ' FIX052301
	 "Let new users set their preferences? -------- " + FG3$ + _  ' FIX052301
	 FNYESNO$(NEWUSER.SETS.DEFAULTS))                             ' FIX052301
      CALL ANSI(FG1$ + "282. " + FG2$ + _                             ' FIX052301
	 "--------------------------------------------- ")            ' FIX052301
      CALL ANSI(FG1$ + "283. " + FG2$ + _                             ' FIX052301
	 "New users default file-transfer protocol ---- " + FG3$ + _  ' FIX052301
	 NOT.YET.IN$)                                                 ' FIX052301
      CALL ANSI(FG1$ + "284. " + FG2$ + _                             ' FIX052301
	 "Line feeds for new users default to --------- " + FG3$ + _  ' FIX052301
	 NOT.YET.IN$)                                                 ' FIX052301
      CALL ANSI(FG1$ + "285. " + FG2$ + _                             ' FIX052301
	 "Nulls for new users default to -------------- " + FG3$ + _  ' FIX052301
	 NOT.YET.IN$)                                                 ' FIX052301
      CALL ANSI(FG1$ + "286. " + FG2$ + _                             ' FIX052301
	 "Prompt bell for new users defaults to ------- " + FG3$ + _  ' FIX052301
	 NOT.YET.IN$)                                                 ' FIX052301
      CALL ANSI(FG1$ + "287. " + FG2$ + _                             ' FIX052301
	 "New users 'graphics' capability is assumed -- " + FG3$ + _  ' FIX052301
	 NOT.YET.IN$)                                                 ' FIX052301
      CALL ANSI(FG1$ + "288. " + FG2$ + _                             ' FIX052301
	 "New users are assumed UPPERCASE only -------- " + FG3$ + _  ' FIX052301
	 NOT.YET.IN$)                                                 ' FIX052301
      CALL ANSI(FG1$ + "289. " + FG2$ + _                             ' FIX052301
	 "New users message margins defaults to ------- " + FG3$ + _  ' FIX052301
	 NOT.YET.IN$)                                                 ' FIX052301
      CALL ANSI(FG1$ + "290. " + FG2$ + _                             ' FIX052301
	 "Add new users to USERS file? ---------------- " + FG3$ + _  ' FIX052301
	 FNYESNO$(REMEMBER.NEW.USERS))                                ' FIX052301
      CALL ANSI(FG1$ + "291. " + FG2$ + _                             ' FIX052301
	 "Let new users on even when USERS file full? - " + FG3$ + _  ' FIX052301
	 FNYESNO$(SURVIVE.NOUSER.ROOM))                               ' FIX052301
      CALL ANSI(FG1$ + "292. " + FG2$ + _                             ' FIX052301
	 "Default max number of minutes can Bank ------" + FG3$ + _   ' FIX052301
	 STR$(ZMaxBank))                                              ' FIX052301
      GOTO 12580
12530 DISPLAYED.PAGE.NUMBER = 16
      GOSUB 24800
      LOCATE  3,1
      X$ = LIBRARY.DRIVE$
      IF LIBRARY.DRIVE$ = "" THEN _
         X$ = NONE.PICKED$
      CALL ANSI(FG1$ + "301. " + FG2$ + _                             ' FIX052301
	 "Library drive ------------------------------- " + FG3$ + _  ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + "302. " + FG2$ + _                             ' FIX052301
	 "Drive\Path for Library directory ------------ " + FG3$ + _  ' FIX052301
	 LIBRARY.DIRECTORY.PATH$)                                     ' FIX052301
      CALL ANSI(FG1$ + "303. " + FG2$ + _                             ' FIX052301
	 "Extension for Library directory ------------- " + FG3$ + _  ' FIX052301
	 LIBRARY.DIRECTORY.EXTENTION$)                                ' FIX052301
      CALL ANSI(FG1$ + "304. " + FG2$ + _                             ' FIX052301
	 "Drive\Path for Library work/RAM disk -------- " + FG3$ + _  ' FIX052301
	 LIBRARY.WORK.DISK.PATH$)                                     ' FIX052301
      CALL ANSI(FG1$ + "305. " + FG2$ + _                             ' FIX052301
	 "# of disks in Library -----------------------" + FG3$ + _   ' FIX052301
	 STR$(LIBRARY.MAX.DISK))                                      ' FIX052301
      CALL ANSI(FG1$ + "306. " + FG2$ + _                             ' FIX052301
	 "# of master Library subdirectories ----------" + FG3$ + _   ' FIX052301
	 STR$(LIBRARY.MAX.DIRECTORY))                                 ' FIX052301
      CALL ANSI(FG1$ + "307. " + FG2$ + _                             ' FIX052301
	 "# of subdirectories in each master ----------" + FG3$ + _   ' FIX052301
	 STR$(LIBRARY.MAX.SUBDIR))                                    ' FIX052301
      CALL ANSI(FG1$ + "308. " + FG2$ + _                             ' FIX052301
	 "Prefix of Library subdirectories ------------ " + FG3$ + _  ' FIX052301
	 LIBRARY.SUBDIR.PREFIX$)                                      ' FIX052301
      CALL ANSI(FG1$ + "309. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of LIBRARY subsystem menu ----- " + FG3$ + _  ' FIX052301
	 MENU$(6))                                                    ' FIX052301
      CALL ANSI(FG1$ + "310. " + FG2$ + _                             ' FIX052301
	 "Symbols to use for Library menu commands ---- " + FG3$ + _  ' FIX052301
	 LIBRARY.COMMANDS$)                                           ' FIX052301
      IX = LIBRARY.FUNCTION(1)
      M27$ = STR$(IX)                                                ' FIX051001
      FOR I = 1 TO NUM.LIBRARY
         IF IX<>LIBRARY.FUNCTION(I) THEN _
	    M27$ = " (Variable)" : _
            GOTO 12531
      NEXT
12531 CALL ANSI(FG1$ + "311. " + FG2$ + _                             ' FIX052301
	 "Security level for Library menu functions ---" + FG3$ + _   ' FIX052301
	 M27$)                                                        ' FIX052301
      CALL ANSI(FG1$ + "312. " + FG2$ + _                             ' FIX052301
	 "Drive\Path of archive utility --------------- " + FG3$ + _  ' FIX052301
	 LIBRARY.ARCHIVE.PATH$)                                       ' FIX052301
      CALL ANSI(FG1$ + "313. " + FG2$ + _                             ' FIX052301
	 "Name of executable archive utility ---------- " + FG3$ + _  ' FIX052301
	 LIBRARY.ARCHIVE.PROGRAM$)                                    ' FIX052301
      GOTO 12580
12540 DISPLAYED.PAGE.NUMBER = 17
      GOSUB 24800
      LOCATE  3,1
      X$ = EMPHASIZE.ON.DEF$
      IF EMPHASIZE.ON.DEF$ = "" THEN _
         X$ = NONE.PICKED$
      CALL ANSI(FG1$ + "321. " + FG2$ + _                             ' FIX052301
	 "String to turn ON Graphic Emphasis ----------- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      X$ = EMPHASIZE.OFF.DEF$
      IF EMPHASIZE.OFF.DEF$ = "" THEN _
         X$ = NONE.PICKED$
      CALL ANSI(FG1$ + "322. " + FG2$ + _                             ' FIX052301
	 "String to restore normal text (Emphasis OFF) - " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      CALL ANSI(FG1$ + "323. " + FG2$ + _                             ' FIX052301
	 "Caller's Foreground color 1 ------------------ " + FG1$ + _ ' FIX052301
	 FG.1.DEF$)                                                   ' FIX052301
      CALL ANSI(FG1$ + "324. " + FG2$ + _                             ' FIX052301
	 "Caller's Foreground color 2 ------------------ " + FG2$ + _ ' FIX052301
	 FG.2.DEF$)                                                   ' FIX052301
      CALL ANSI(FG1$ + "325. " + FG2$ + _                             ' FIX052301
	 "Caller's Foreground color 3 ------------------ " + FG3$ + _ ' FIX052301
	 FG.3.DEF$)                                                   ' FIX052301
      CALL ANSI(FG1$ + "326. " + FG2$ + _                             ' FIX052301
	 "Caller's Foreground color 4 ------------------ " + FG4$ + _ ' FIX052301
	 FG.4.DEF$)                                                   ' FIX052301
      X$ = MID$("<none>Blue  Green Cyan  Red   PurpleYellowWhite",CALLER.BKGRD*6+1,6)
      CALL ANSI(FG1$ + "327. " + FG2$ + _                             ' FIX052301
	 "Caller's Background color -------------------- " + FG3$ + _ ' FIX052301
	 X$)                                                          ' FIX052301
      GOTO 12580
12550 DISPLAYED.PAGE.NUMBER = 18
      GOSUB 24800                                                    ' FIX050903
      LOCATE  3,1                                                    ' FIX050903
      CALL ANSI(FG1$ + "341. " + FG2$ + _                             ' FIX052301
	 "Path\Filename used to store MENU0 info. ------ " + FG3$ + _ ' FIX052301
	 MNEW.DEF$)                                                   ' FIX052301
      CALL ANSI(FG1$ + "342. " + FG2$ + _                             ' FIX052301
	 "EXTENSION of new style sub menu files -------- " + FG3$ + _ ' FIX052301
	 SMN.EXT$)                                                    ' FIX052301
      CALL ANSI(FG1$ + "343. " + FG2$ + _                             ' FIX052301
	 "Drive and path for new style sub menu files -- " + FG3$ + _ ' FIX052301
	 SMN.PATH$)                                                   ' FIX052301
      CALL ANSI(FG1$ + "344. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of external color definitions -- " + FG3$ + _ ' FIX052301
	 COLOR.DEF$)                                                  ' FIX052301
      CALL ANSI(FG1$ + "345. " + FG2$ + _                             ' FIX052301
	 "Max new files RBBS will search for -----------" + FG3$ + _  ' FIX052301
	 STR$(MAX.NEW.FILES))                                         ' FIX052301
      CALL ANSI(FG1$ + "346. " + FG2$ + _                             ' FIX052301
	 "Path\Filename of RIP menu when listing files - " + FG3$ + _ ' FIX052301
	 FILESCAN.RIP$)                                               ' FIX052301
      CALL ANSI(FG1$ + "347. " + FG2$ + _                             ' FIX052301
	 "Path\Filename containing wildcard xfer specs - " + FG3$ + _ ' FIX052301
	 FIDX.CFG$)                                                   ' FIX052301
      CALL ANSI(FG1$ + "348. " + FG2$ + _                             ' FIX052301
	 "Get description from uploader before upload? - " + FG3$ + _ ' FIX052301
	 FNYESNO$(DESC.BEFORE.UPLOAD))                                ' FIX052301
      CALL ANSI(FG1$ + "349. " + FG2$ + _                             ' FIX052301
	 "Should RBBS show 'CTRL-X = Abort' prompts? --- " + FG3$ + _ ' FIX052301
	 FNYESNO$(CTRLX))                                             ' FIX052301
      CALL ANSI(FG1$ + "350. " + FG2$ + _                             ' FIX052301
	 "Will RBBS add 'Uploaded by...' in description? " + FG3$ + _ ' FIX052301
	 FNYESNO$(WHO.UPLOADED))                                      ' FIX052301
      CALL ANSI(FG1$ + "351. " + FG2$ + _                             ' FIX052301
	 "Path\Filename used for exporting messages ---- " + FG3$ + _ ' FIX052301
	 NODE.TXT$)                                                   ' FIX052301
      CALL ANSI(FG1$ + "352. " + FG2$ + _                             ' FIX052301
	 "Path\Filename shown when SYSOP needs system -- " + FG3$ + _ ' FIX052301
	 NEEDSYS.MSG$)                                                ' FIX052301
      CALL ANSI(FG1$ + "353. " + FG2$ + _                             ' FIX052301
	 "Is name searching to be disabled? ------------ " + FG3$ + _ ' FIX060401
	 FNYESNO$(NOPEEK))                                            ' FIX052301
      CALL ANSI(FG1$ + "354. " + FG2$ + _                             ' FIX052404
	 "Entertaining characters cycled when working -- " + FG3$ + _ ' FIX060404
	 TWIRL$)                                                      ' FIX052404
      CALL ANSI(FG1$ + "355. " + FG2$ + _                             ' FIX062303
	 "Foreground color for extended descriptions --- " + FG5$ + _ ' FIX062303
	 FG.5.DEF$)                                                   ' FIX062303
      CALL ANSI(FG1$ + "356. " + FG2$ + _                             ' FIX062303
	 "Allow RIP detection at login? ---------------- " + FG3$ + _ ' FIX062303
	 FNYESNO$(RIP.DETECT))                                        ' FIX062303
      GOTO 12580
12580 IF PRE.DISPLAY THEN _
         PRE.DISPLAY = FALSE : _
	 GOTO 12622
      GOSUB 24890
12590 GOSUB 22160
12592 IF IX THEN _            'IX       Key    Where to branch to
         ON IX GOTO 12360, _  ' 1       F1 - Global Parameters (Part 1)
                    12370, _  ' 2       F2 - Global Parameters (Part 2)
                    12380, _  ' 3       F3 - Global Parameters (Part 3)
                    12390, _  ' 4       F4 - RBBS-PC System Files (Part 1)
                    12400, _  ' 5       F5 - RBBS-PC System Files (Part 2)
                    12410, _  ' 6       F6 - RBBS-PC "doors"
                    12420, _  ' 7       F7 - RBBS-PC security parms. (Part 1)
                    12466, _  ' 8       F8 - RBBS-PC security parms. (Part 2)
                    12470, _  ' 9       F9 - Multiple RBBS-PC parameters
                    12480, _  '10      F10 - RBBS-PC's utilities
                    12490, _  '11 Shift-F1 - RBBS-PC File Manager
                    12500, _  '12 Shift-F2 - RBBS-PC comm. parameters (Part 1)
                    12505, _  '13 Shift-F3 - RBBS-PC comm. parameters (Part 2)
                    12510, _  '14 Shift-F4 - RBBS-PC Net Mail
                    12520, _  '15 Shift-F5 - New user parameters
                    12530, _  '16 Shift-F6 - Library parameters
                    12540, _  '17 Shift-F7 - RBBS-PC Color parameters
		    12550, _  '18 Shift-F8 - New 17.5 features
                    12340, _  '19     PgUp - Go to previous page
                    12330, _  '20     PgDn - Go to next page
                    12630, _  '21      End - Terminate CONFIG
                    12620     '22 Enter - Option selected followed by "enter"
      GOTO 12590
12620 GOSUB 50340
      IF LEFT$(HJ$,1)="H" OR LEFT$(HJ$,1)="h" THEN _                 ' FIX041802
	 CALL ASKRO ("Enter option number for extensive help (CR quits):",24,HJ$) : _ ' FIX041802
	 EXTHELP = TRUE                                              ' FIX041802
      IF VAL(HJ$) < 1 OR VAL(HJ$) > 356 THEN _                       ' FIX052401
	 GOTO 12580                                                  ' FIX041801
      IPAGE = INT((VAL(HJ$) - 1) / 20)                               ' FIX042501
      IF EXTHELP = TRUE THEN _                                       ' FIX042501
	 EXTHELP = FALSE : _                                         ' FIX042501
	 CALL EHELP (HJ$) : _                                        ' FIX042501
	 IX = IPAGE+1 : _                                            ' FIX042501
	 GOTO 12592                                                  ' FIX042501
      IF DISPLAYED.PAGE.NUMBER <> IPAGE+1 THEN _
         PRE.DISPLAY = TRUE : _
         IX = IPAGE+1 : _
         GOTO 12592
12622 ILOOKUP = VAL(HJ$) - (20 * IPAGE)
      IPAGE = IPAGE + 1
      IF ILOOKUP < 1 THEN _
         ILOOKUP = 20 : _
	 IPAGE = IPAGE - 1
12630 EXIT SUB
'
' * COMMON SUBROUTINE TO HANDLE THE FUNCTION KEYS, SCROLL BETWEEN CONFIG'S
' * PAGES OF OPTIONS, AND USER'S SELECTING A NUMERIC 4-CHARACTER OPTION.
'
22160 I! = FRE(C$)
      IX = 0
      IF KSTACKED$ = "DONE" THEN _                                   ' FIX051101
	 KSTACKED$ = "" : _                                          ' FIX051101
	 CALL ASKRO ("Setting " + KSTACKMSG$ + " features completed.  Press ENTER to continue.",24,HJ$) : _ ' FIX051101
	 GOTO 12190                                                  ' FIX051101
      IF KSTACKED$ = "" THEN _
         GOTO 22161
      X = INSTR(KSTACKED$,CHR$(13))
      IF X > 0 THEN _
         IX = 22 : _
         HJ$ = LEFT$(KSTACKED$,X-1) : _
         KSTACKED$ = RIGHT$(KSTACKED$,LEN(KSTACKED$)-X) : _
         OPTION$ = HJ$ : _
         RETURN
      Y$ = CHR$(0) + CHR$(68)
      IF KSTACKED$ = "END" THEN _
	 Y$ = CHR$(0) + CHR$(79)
      KSTACKED$ = ""
      GOTO 22240
22161 Y$ = INKEY$
      IF LEN(Y$) < 1 THEN _
         GOTO 22161
      IF LEN(Y$) = 2 THEN _               ' IF A FUNCTION KEY, BRANCH
         GOTO 22240
      IF ASC(Y$) = 13 THEN _              ' IF A CARRIAGE RETURN, RETURN
         IX = 22 : _
         RETURN
      IF ASC(Y$) = 8 AND LEN(HJ$) > 0 THEN _
         HJ$ = LEFT$(HJ$,LEN(HJ$) - 1) : _
         PRINT CHR$(29) + " " + CHR$(29); : _
	 GOTO 22161
      IF (ASC(Y$) < 48 OR ASC(Y$) > 57) AND _                        ' FIX041802
	 (Y$ <> "H" AND Y$ <> "h") THEN _                            ' FIX041802
         GOTO 22161
      PRINT Y$;
      HJ$ = HJ$ + _
            Y$
      OPTION$ = HJ$
      IF LEN(HJ$) > 4 THEN _              ' IF MORE THAN FOUR CHARACTERS,
         IX = 22                          ' RETURN
      RETURN
'
' * COMMON SUBROUTINE TO HANDLE SET UP RETURN CODES FOR FUNCTION KEYS THAT
' * WERE PRESSED ON THE LOCAL PC RUNNING CONFIG
'
22240 IX = ASC(RIGHT$(Y$,1))
      IF IX < 59 OR IX > 91 THEN _        ' IGNORE IF NOT F1 THROUGH F10 OR
         IX = 0: _                        ' SHIFT-F1 THROUGH SHIFT-F8
         RETURN
      IF IX = 73 THEN _                   ' IF PGUP THEN SET IX = 19
         IX = 19 : _
         RETURN
      IF IX = 79 THEN _                   ' IF END THEN SET IX = 21
         IX = 21 : _
         RETURN
      IF IX = 81 THEN _                   ' IF PGDN THEN SET IX = 20
         IX = 20 : _
         RETURN
      IF (IX-58) < 11 THEN _              ' IF F1 THROUGH F10 SET IX = 1
         IX = IX - 58 : _                 ' THROUGH 10 ACCORDINGLY.
         RETURN
      IF (IX-73) > 10 AND _               ' IF SHIFT-F1 THROUGH SHIFT-F8 THEN
         (IX-73) < 19 THEN _              ' SET IX = 11 THROUGH 18
            IX = IX - 73 : _              ' ACCORDINGLY.
            RETURN
      IX = 0
      RETURN
'
' * ROUTINE TO DISPLAY THE PAGE HEADER FOR CONFIG'S DISPLAYS
'
24800 CLS
      I! = FRE(C$)
      COLOR 0,7,0
      LOCATE 1,10
      PRINT "RBBS-PC " + CONFIG.VERSION$ + " Configuration";
      IF CONFERENCE.MODE THEN _
         GOSUB 24970
      COLOR FG,BG,BORDER
      PRINT " Page" + STR$(DISPLAYED.PAGE.NUMBER) + " of" + STR$(MAXIMUM.DISPLAYABLE.PAGES)
      LOCATE 1,66                                                    ' FIX041501
      PRINT TITLE.FILENAME$                                          ' FIX041501
      RETURN
24890 A$ = "Enter # to change, H for help, END to update, PgUp/PgDn to scroll:"
24900 LOCATE 24,5
      COLOR FG                                                       ' FIX052701
      PRINT A$;
      X = POS(0) + 2
      PRINT STRING$((75 - LEN(A$)),32);
      LOCATE 24,X
      COLOR FG,BG,BORDER
      HJ$ = "
      I! = FRE(C$)
      RETURN
'
' * ROUTINE TO DISPLAY CONFERENCE MAINTENANCE MODE IN CONFIG'S DISPLAYS
'
24970 LOCATE 2,1                                                     ' FIX041801
      COLOR FG,BG,BORDER                                             ' FIX041801
      PRINT SPACE$(10);                                              ' FIX041801
      COLOR 0,7                                                      ' FIX041801
      PRINT "(Conference Maintenance Mode for " + _                  ' FIX041801
	    ZConfName$ + _                                           ' FIX041801
	    ")";                                                     ' FIX041801
      COLOR FG,BG,BORDER                                             ' FIX041801
      RETURN
'
' * COMMON SUBROUTINE TO READ THE MESSAGES FILE'S CHECKPOINT RECORD
'
30040 IF NETWORK.TYPE = 6 THEN _
         OPEN MAIN.MESSAGE.FILE$ FOR RANDOM SHARED AS #2 LEN=128 _
      ELSE OPEN "R",2,MAIN.MESSAGE.FILE$,128
      FIELD 2,128 AS RR$
      GET 2,1
      CALLS.TODATE! = VAL(MID$(RR$,1,8))             '  1-  8  =  number of last message on system
      FIRST.USER.RECORD = VAL(MID$(RR$,52,5))        ' 52- 56  =  first rec. of user file
      CURRENT.USER.COUNT = VAL(MID$(RR$,57,5))       ' 57- 61  =  next avail. user record
      HIGHEST.USER.RECORD = VAL(MID$(RR$,62,5))      ' 62- 66  =  last rec. of user file
      FIRST.MESSAGE.RECORD = VAL(MID$(RR$,68,7))     ' 68- 74 = first rec. of msgs file
      NEXT.MESSAGE.RECORD = VAL(MID$(RR$,75,7))      ' 75- 81 = next avail. msgs record
      HIGHEST.MESSAGE.RECORD = VAL(MID$(RR$,82,7))   ' 82- 88 = last rec. of msgs file
      MAXIMUM.NUMBER.OF.MSGS = VAL(MID$(RR$,89,7))   ' 89- 95 = maximum number of messages
      MAXIMUM.NUMBER.OF.NODES = VAL(MID$(RR$,127,2)) '127-128 = maximum number of "nodes"
      CLOSE 2
      RETURN
'
' * COMMON ROUTINE TO GET THE LENGTH OF A FILE
'
30180 IF NETWORK.TYPE = 6 THEN _
         OPEN FILE$ FOR RANDOM SHARED AS #2 LEN=128 _
      ELSE OPEN "R",2,FILE$,128
      FIELD 2,128 AS RR$
      UG = LOF(2) / 128
      CLOSE 2
      RETURN
'
' * COMMON SUBROUTINE TO KEEP STRING SPACE CLEAN AND CLEAR LINE 24
'
50340 I! = FRE(C$)
      LOCATE 24,1
      PRINT STRING$(79,32);
      RETURN
'
' * COMMON SUBROUTINE TO DISPLAY A MESSAGE ON LINE 24
'
50345 GOSUB 50340
      LOCATE 24,5
      PRINT XX$;
      RETURN
'
' * COMMON SUBROUTINE TO BEEP AT THE SYSOP
'
60380 FOR I = 1 TO 3
        BEEP
      NEXT
      RETURN
      END SUB
'  $SUBTITLE: 'CNFGINIT - subroutine to initialize CONFIG's constants'
'  $PAGE
'
'  SUBROUTINE NAME    --  CNFGINIT
'
'  INPUT PARAMETERS   --  NONE
'
'  OUTPUT PARAMETERS  --  CONFIG'S CONSTANTS INITIALIZED
'
'  SUBROUTINE PURPOSE --  TO INITIALIZE THE CONSTANTS USED BY CONFIG
'
60385 SUB CNFGINIT STATIC
'
' * INITALIZE ALL VARIABLES IF A .DEF FILE DOESN'T AREADY EXIST
'
      D$ = DD$
      DRV$ = LEFT$(D$,1)
      FALSE                      = 0
      TRUE                       = NOT FALSE
      SYSOP.SECURITY.LEVEL       = 10
      ACT.MNTHS.B4.DELETING      = 1
      ACTIVE.BULLETINS           = 6
      ADD.DIR.SECURITY           = SYSOP.SECURITY.LEVEL
      ALLOW.CALLER.TURBO         = 6
      ALTDIR.EXTENSION$          = ""
      ALWAYS.STREW.TO$           = ""
      ANS.MENU$                  = D$ + "MENUA"
      ASK.EXTENDED.DESC          = SYSOP.SECURITY.LEVEL
      ASK.IDENTITY               = FALSE
      AUTO.ADD.SECURITY          = 5
      AUTO.UPGRADE.SEC           = SYSOP.SECURITY.LEVEL
      AUTOPAGE.DEF$              = D$ + "AUTOPAGE.DEF"
      BG                         = 0
      BORDER                     = 0
      BUFFER.SIZE                = 256
      BULLETIN.MENU$             = "BULLET"
      BULLETIN.PREFIX$           = "BULLET"
      BULLETINS.OPTIONAL         = TRUE
      C$                         = ""
      CALLER.BKGRD               = 0
      CALLERS.FILE$              = D$ + "CALLERS"
      SEC.KILL.ANY               = SYSOP.SECURITY.LEVEL
      COM.PORT$                  = "COM1"
      COMMANDS.BETWEEN.RINGS     = FALSE
      COMMANDS.IN.PROMPT         = TRUE
      COMMENTS.AS.MESSAGES       = FALSE
      COMMENTS.FILE$             = D$ + "COMMENTS"
      COMPRESSED.EXT$            = ".ARC.PAK"
      COMPUTER.TYPE              = 0
      CONFERENCE.MENU$           = D$ + "CONFENCE"
      CONFMAIL.LIST$             = D$ + "CONFMAIL.DEF"
      CONFIG.VERSION$            = "Version 17.5"
      CTRLX                      = TRUE                              ' FIX050903
      DEFAULT.CATEGORY.CODE$     = "UNC"
      DAYS.IN.SUBSCRIPTION.PERIOD = 365
      DAYS.TO.WARN               = 60
      DIR.CATEGORY.FILE$         = D$ + "DIR.CAT"
      DIRECTORY.PREFIX$          = "DIR"
      DEFAULT.ECHOER$            = "R"
      DEFAULT.LINE.ACK$          = ""
      DEFAULT.SECURITY.LEVEL     = 5
      DESC.BEFORE.UPLOAD         = FALSE                             ' FIX050903
      DIRECTORY.EXTENTION$       = "DIR"
      DIRECTORY.PATH$            = D$
      DISK.FOR.DOS$              = D$
      DISKFULL.GO.OFFLINE        = TRUE
      DNLD.SUB                   = 0
      DOORS.AVAILABLE            = FALSE
      DOORS.DEF$                 = D$ + "DOORS.DEF"
      DOORS.TERMINAL.TYPE        = 8
      DOSANSI                    = FALSE
      DOWNLOAD.DRIVES$           = DRV$ + DRV$
      DOWNLOAD.TO.SUBDIR         = FALSE
      DRIVE.FOR.BULLETINS$       = D$
      DRIVE.FOR.HELP.FILES$      = D$
      DTR.DROP.DELAY             = 3
      DUMB.MODEM                 = FALSE
      ECHOER$                    = "R"
      EMPHASIZE.OFF.DEF$         = "[27]" + "[0;40;33m"
      EMPHASIZE.ON.DEF$          = "[27]" + "[1;41;37m"
      END.OFFICE.HOURS           = 2200
      ENFORCE.UPLOAD.DOWNLOAD.RATIOS = FALSE
      EPILOG$                    = D$ + "EPILOG.DEF"
      ESCAPE.INSECURE            = FALSE
      EXPIRED.SECURITY           = DEFAULT.SECURITY.LEVEL
      COLOR.DEF$                 = D$ + "COLOR.DEF"                  ' FIX050901
      EXTENDED.LOGGING           = FALSE
      EXTENSION.LIST$            = "ZIP"
      FAST.FILE.LIST$            = D$ + "FIDX.DEF"
      FAST.FILE.LOCATOR$         = D$ + "LIDX.DEF"
      FC                         = 5
      FG                         = 7
      FG.1.DEF$                  = "Bright Green"
      FG.2.DEF$                  = "Bright Yellow"
      FG.3.DEF$                  = "Bright Purple"
      FG.4.DEF$                  = "Bright Cyan"
      FG.5.DEF$                  = "Normal Cyan"                     ' FIX062303
      FIDX.CFG$                  = D$ + "FIDX.CFG"                   ' FIX050903
      FILESCAN.RIP$              = D$ + "FILESCAN.RIP"               ' FIX050903
      FILE.COMMANDS.DEFAULTS$    = "DGLNPSUV"
      FILE.COMMANDS$             = FILE.COMMANDS.DEFAULTS$
      FILE.NOTIFY                = FALSE
      FILES.FUNCTION$(1,1)       = "D)ownload a file      "
      FILES.FUNCTION$(2,1)       = "G)oodbye              "
      FILES.FUNCTION$(3,1)       = "L)ist file directory  "
      FILES.FUNCTION$(4,1)       = "N)ew file search      "
      FILES.FUNCTION$(5,1)       = "P)ersonal files       "
      FILES.FUNCTION$(6,1)       = "S)earch files         "
      FILES.FUNCTION$(7,1)       = "U)pload a file        "
      FILES.FUNCTION$(8,1)       = "V)erbose archive list "
      FILES.FUNCTION$(1,2)       = "D"
      FILES.FUNCTION$(2,2)       = "G"
      FILES.FUNCTION$(3,2)       = "L"
      FILES.FUNCTION$(4,2)       = "N"
      FILES.FUNCTION$(5,2)       = "P"
      FILES.FUNCTION$(6,2)       = "S"
      FILES.FUNCTION$(7,2)       = "U"
      FILES.FUNCTION$(8,2)       = "V"
      FILESEC.FILE$              = D$ + "FILESEC"
      FIRST.NAME.PROMPT$         = "FIRST name"
      FOSSIL                     = 0
      GB                         = FC
      GLOBAL.COMMANDS.DEFAULTS$  = "H?QX"
      GLOBAL.COMMANDS$           = GLOBAL.COMMANDS.DEFAULTS$
      GLOBAL.FUNCTION$(1,1)      = "H)elp on-line           "
      GLOBAL.FUNCTION$(2,1)      = "?)help on-line (=H)     "
      GLOBAL.FUNCTION$(3,1)      = "Q)uit this part         "
      GLOBAL.FUNCTION$(4,1)      = "X)Expert toggle on/off  "
      GLOBAL.FUNCTION$(1,2)      = "H"
      GLOBAL.FUNCTION$(2,2)      = "?"
      GLOBAL.FUNCTION$(3,2)      = "Q"
      GLOBAL.FUNCTION$(4,2)      = "X"
      GO.TO.SHELL                = TRUE
      HELP$(3)                   = "HELP03"
      HELP$(4)                   = "HELP04"
      HELP$(7)                   = "HELP07"
      HELP$(9)                   = "HELP09"
      HELP.EXTENSION$            = "HLP"
      HELP.FILE.PREFIX$          = "HELP0"
      HELP.PATH$                 = D$
      HOST.ECHO.OFF$             = ""
      HOST.ECHO.ON$              = ""
      IB                         = 0
      KEEP.INIT.BAUD             = FALSE
      KEEP.TIME.CREDITS          = FALSE
      LAST.NAME.PROMPT$          = "LAST name"
      LEN.HASH                   = 31
      LEN.INDIV                  = 0
      LIBRARY.ARCHIVE.PATH$        = D$
      LIBRARY.ARCHIVE.PROGRAM$     = "ARCA "
      LIBRARY.COMMANDS.DEFAULTS$   = "ACDGLSV"
      LIBRARY.COMMANDS$            = LIBRARY.COMMANDS.DEFAULTS$
      LIBRARY.DRIVE$               = ""
      LIBRARY.MAX.DISK             = 705
      LIBRARY.MAX.DIRECTORY        = 7
      LIBRARY.MAX.SUBDIR           = 100
      LIBRARY.SUBDIR.PREFIX$       = "DISK"
      LIBRARY.DIRECTORY.PATH$      = D$
      LIBRARY.DIRECTORY.EXTENTION$ = "CDR"
      LIBRARY.FUNCTION$(1,1)       = "A)rchive a Library disk  "
      LIBRARY.FUNCTION$(2,1)       = "C)hange Library disk     "
      LIBRARY.FUNCTION$(3,1)       = "D)ownload a file         "
      LIBRARY.FUNCTION$(4,1)       = "G)oodbye                 "
      LIBRARY.FUNCTION$(5,1)       = "L)ist a file directory   "
      LIBRARY.FUNCTION$(6,1)       = "S)earch files            "
      LIBRARY.FUNCTION$(7,1)       = "V)erbose archive list    "
      LIBRARY.FUNCTION$(1,2)       = "A"
      LIBRARY.FUNCTION$(2,2)       = "C"
      LIBRARY.FUNCTION$(3,2)       = "D"
      LIBRARY.FUNCTION$(4,2)       = "G"
      LIBRARY.FUNCTION$(5,2)       = "L"
      LIBRARY.FUNCTION$(6,2)       = "S"
      LIBRARY.FUNCTION$(7,2)       = "V"
      LIBRARY.WORK.DISK.PATH$      = D$
      LIMIT.SEARCH.TO.FMS        = FALSE
      LOGON.MAIL.LEVEL$          = "A"
      LSB                        = 1016
60390 MACRO.DRVPATH$             = D$
      MACRO.EXTENSION$           = ""
      MAIN.COMMANDS.DEFAULTS$    = "ABCDEFIJKOPRSTUVW@"
      MAIN.COMMANDS$             = MAIN.COMMANDS.DEFAULTS$
      MAIN.FUNCTION$(1,1)        = "A)nswer questionnaire  "
      MAIN.FUNCTION$(2,1)        = "B)ulletins             "
      MAIN.FUNCTION$(3,1)        = "C)omments              "
      MAIN.FUNCTION$(4,1)        = "D)oor subsystem        "
      MAIN.FUNCTION$(5,1)        = "E)nter message         "
      MAIN.FUNCTION$(6,1)        = "F)iles subsystem       "
      MAIN.FUNCTION$(7,1)        = "I)nitial welcome       "
      MAIN.FUNCTION$(8,1)        = "J)oin a conference     "
      MAIN.FUNCTION$(9,1)        = "K)ill messages         "
      MAIN.FUNCTION$(10,1)       = "O)perator page         "
      MAIN.FUNCTION$(11,1)       = "P)ersonal mail         "
      MAIN.FUNCTION$(12,1)       = "R)ead messages         "
      MAIN.FUNCTION$(13,1)       = "S)can messages header  "
      MAIN.FUNCTION$(14,1)       = "T)opic msg scan        "
      MAIN.FUNCTION$(15,1)       = "U)tilities subsystem   "
      MAIN.FUNCTION$(16,1)       = "V)iew conference mail  "
      MAIN.FUNCTION$(17,1)       = "W)ho's on other nodes  "
      MAIN.FUNCTION$(18,1)       = "@)Library subsystem    "
      MAIN.FUNCTION$(1,2)        = "A"
      MAIN.FUNCTION$(2,2)        = "B"
      MAIN.FUNCTION$(3,2)        = "C"
      MAIN.FUNCTION$(4,2)        = "D"
      MAIN.FUNCTION$(5,2)        = "E"
      MAIN.FUNCTION$(6,2)        = "F"
      MAIN.FUNCTION$(7,2)        = "I"
      MAIN.FUNCTION$(8,2)        = "J"
      MAIN.FUNCTION$(9,2)        = "K"
      MAIN.FUNCTION$(10,2)       = "O"
      MAIN.FUNCTION$(11,2)       = "P"
      MAIN.FUNCTION$(12,2)       = "R"
      MAIN.FUNCTION$(13,2)       = "S"
      MAIN.FUNCTION$(14,2)       = "T"
      MAIN.FUNCTION$(15,2)       = "U"
      MAIN.FUNCTION$(16,2)       = "V"
      MAIN.FUNCTION$(17,2)       = "W"
      MAIN.MESSAGE.BACKUP$       = D$ + "MESSAGES.BAK"
      MAIN.MESSAGE.FILE$         = D$ + "MESSAGES"
      MAIN.PUI$                  = D$ + "MAIN.PUI"
      MAIN.USER.FILE$            = D$ + "USERS"
      MASTER.DIRECTORY.NAME$     = ""
      MAX.ALLOWED.MSGS.FRM.DEF   = 5
      MAX.CARRIER.WAIT           = 30
      MAX.DESC.LEN               = 40
      MAX.EXTENDED.LINES         = 2
      MAX.MESSAGE.LINES          = 19
      MAX.NEW.FILES              = 99                                ' FIX042801
      MAX.PER.DAY                = 0
      MAX.REG.SEC                = 0
      MAX.USR.FILE.SIZE.FRM.DEF  = 16
      MAX.WORK.VAR               = 30
      MAXD                       = 15
      MAXIMUM.DISPLAYABLE.PAGES  = 18
      MAXIMUM.PASSWORD.CHANGES   = 3
      MAXIMUM.VIOLATIONS         = 5
      MAXIMUM.NUMBER.OF.NODES    = 1
      MENU$(1)                   = D$ + "MENU1"
      MENU$(2)                   = D$ + "MENU2"
      MENU$(3)                   = D$ + "MENU3"
      MENU$(4)                   = D$ + "MENU4"
      MENU$(5)                   = D$ + "MENU5"
      MENU$(6)                   = D$ + "MENU6"
      MENUS.CAN.PAUSE            = TRUE
      MESSAGE.REMINDER           = TRUE
      MESSAGES.CAN.GROW          = FALSE
      MIN.NEWCALLER.BAUD         = 0
      MIN.OLDCALLER.BAUD         = 0
      MIN.SEC.TO.VIEW            = DEFAULT.SECURITY.LEVEL
      MINIMUM.LOGON.SECURITY     = 0
      MINIMUM.SECURITY.FOR.TEMP.PASSWORD = 5
      MINUTES.PER.SESSION!       = 72
      MLCOM                      = FALSE
      MM                         = 5
      MNEW.DEF$                  = D$ + "MNEW.DEF"                   ' FIX042601
      SMN.EXT$                   = "SMN"                             ' FIX060401
      SMN.PATH$                  = D$                                ' FIX060401
      MO$                        = DD$
      MUSIC                      = FALSE
      NEEDSYS.MSG$               = D$ + "NEEDSYS.MSG"                ' FIX050903
      NET.MAIL$                  = "<none>"
      NETWORK.TYPE               = 0
      NETWORK.TYPE$              = "IBM's DOS"
      NEW.FILES.CHECK            = FALSE
      NEW.USER.QUESTIONNAIRE$    = D$ + "RBBS-REG.DEF"
      NEWUSER.FILE$              = D$ + "NEWUSER"
      NEWUSER.SETS.DEFAULTS      = TRUE
      NODE.TXT$                  = D$ + "NODE.TXT"                   ' FIX050903
      OMIT.MAIN.DIRECTORY$       = "NO"
      OMIT.UPLOAD.DIRECTORY$     = "NO"
      OVERWRITE.SECURITY.LEVEL   = SYSOP.SECURITY.LEVEL
      PAGE.LENGTH                = 23
      PAGING.PRINTER.SUPPORT$    = ". "
      PASSWORD.FILE$             = D$ + "PASSWRDS"
      PCJR                       = FALSE
      PERSONAL.BEGIN             = 1
      PERSONAL.DIR$              = D$+"PRIV.DEF"
      PERSONAL.DRVPATH$          = D$
      PERSONAL.LEN               = 31
      PERSONAL.CONCAT            = FALSE
      PRELOG$                    = D$ + "PRELOG"
      PRIVATE.READ.SEC           = DEFAULT.SECURITY.LEVEL
      PROTO.DEF$                 = D$ + "PROTO.DEF"
      PROMPT.BELL                = 0
      PROMPT.HASH$               = "Name"
      PROMPT.INDIV$              = ""
      PS                         = 5
      PUBLIC.READ.SEC            = DEFAULT.SECURITY.LEVEL
      QUES.PATH$                 = D$
      RBBS.BAT$                  = D$ + "RBBS" + NODE.ID$ + ".BAT"
      RBBS.NAME$                 = "RBBS-PC"
      RCTTY.BAT$                 = D$ + "RCTTY" + NODE.ID$ + ".BAT"
      RECYCLE.TO.DOS             = 0
      RECYCLE.TO.DOS$            = "INTERNAL"
      RECYCLE.WAIT               = 0
      REDIRECT.IO.METHOD         = TRUE
      REGISTRATION.PROGRAM$      = "<none>"
      REMEMBER.NEW.USERS         = TRUE
      REMIND.FILE.TRANSFERS      = FALSE
      REMIND.PROFILE             = FALSE
      REQUIRE.NON.ASCII          = TRUE
      REQUIRED.QUESTIONNAIRE$    = "<none>"
      REQUIRED.RINGS             = 1
      RESTRICT.BAUD              = FALSE
      RESTRICT.BY.DATE           = FALSE
      RESTRICT.VALID.CMDS        = FALSE
      RTS$                       = "NO"
      SCREEN.OUT.MSG$            = "SEEN-BY: "
      SEC.CHANGE.MSG             = SYSOP.SECURITY.LEVEL
      SEC.LVL.EXEMPT.FRM.PURGING = SYSOP.SECURITY.LEVEL
      SECVIO.HLP$                = D$ + "SECVIO." + HELP.EXTENSION$
      SECURITY.EXEMPT.FROM.EPILOG= DEFAULT.SECURITY.LEVEL + 1
      SF                         = SYSOP.SECURITY.LEVEL
      SHOOT.YOURSELF             = FALSE
      SHOW.SECTION               = TRUE
      SIZE.OF.STACK              = 1024
      SL.CATEGORIZE.UPLOADS      = SYSOP.SECURITY.LEVEL
      SMART.TEXT                 = 123
      START.HASH                 = 1
      START.INDIV                = 0
      START.OFFICE.HOURS         = 800
      SURVIVE.NOUSER.ROOM        = FALSE
      SWITCH.BACK                = FALSE
      SYSOP.COMMANDS.DEFAULTS$   = "1234567"
      SYSOP.COMMANDS$            = SYSOP.COMMANDS.DEFAULTS$
      SYSOP.FUNCTION$(1,1)       = " 1 List comments      "
      SYSOP.FUNCTION$(2,1)       = " 2 List CALLERS log   "
      SYSOP.FUNCTION$(3,1)       = " 3 Recover a message  "
      SYSOP.FUNCTION$(4,1)       = " 4 Erase comments     "
      SYSOP.FUNCTION$(5,1)       = " 5 User maintenance   "
      SYSOP.FUNCTION$(6,1)       = " 6 Toggle Page bell   "
      SYSOP.FUNCTION$(7,1)       = " 7 Exit to DOS        "
      SYSOP.FUNCTION$(1,2)       = " 1"
      SYSOP.FUNCTION$(2,2)       = " 2"
      SYSOP.FUNCTION$(3,2)       = " 3"
      SYSOP.FUNCTION$(4,2)       = " 4"
      SYSOP.FUNCTION$(5,2)       = " 5"
      SYSOP.FUNCTION$(6,2)       = " 6"
      SYSOP.FUNCTION$(7,2)       = " 7"
      SYSOP.FIRST.NAME$          = "TOM"
      SYSOP.LAST.NAME$           = "MACK"
      SYSOP.MENU.SECURITY.LEVEL  = SYSOP.SECURITY.LEVEL
      SYSOP.PASSWORD.1$          = "SECRET"
      SYSOP.PASSWORD.2$          = "NAME"
      TEST.ANSI.TIME             = 0
      TIME.TO.DROP.TO.DOS        = 0
      TRASHCAN.FILE$             = D$ + "TRASHCAN"
      TURN.PRINTER.OFF           = FALSE
      TURBO.RBBS                 = TRUE
      TWIRL$                     = "-\|/"                            ' FIX052404
      UE                         = 5
      FMS.DIRECTORY$             = ""
      UPCAT.HELP$                = "UPCAT"
      UPLOAD.DIRECTORY$          = "99"
      UPLOAD.PATH$               = D$
      UPLOAD.SUBDIR$             = ""
      UPLOAD.TIME.FACTOR!        = 0
      UPLOAD.TO.SUBDIR           = FALSE
      USE.BASIC.WRITES           = FALSE
      USE.DEVICE.DRIVER$         = ""
      USER.LOCATION$             = "CITY and STATE"
      UTIL.COMMANDS.DEFAULTS$    = "BCEFGLMPRSTU"
      UTIL.COMMANDS$             = UTIL.COMMANDS.DEFAULTS$
      UTILITY.FUNCTION$(1,1)     = "B)ank time            "
      UTILITY.FUNCTION$(2,1)     = "C)lock (time)         "
      UTILITY.FUNCTION$(3,1)     = "E)cho                 "
      UTILITY.FUNCTION$(4,1)     = "F)ile x-fer protocol  "
      UTILITY.FUNCTION$(5,1)     = "G)raphics             "
      UTILITY.FUNCTION$(6,1)     = "L)ines per page       "
      UTILITY.FUNCTION$(7,1)     = "M)sg margin setting   "
      UTILITY.FUNCTION$(8,1)     = "P)ersonal info change "
      UTILITY.FUNCTION$(9,1)     = "R)eview defaults      "
      UTILITY.FUNCTION$(10,1)    = "S)tatistics           "
      UTILITY.FUNCTION$(11,1)    = "T)oggle               "
      UTILITY.FUNCTION$(12,1)    = "U)ser log scan        "
      VOICE.TYPE                 = 0
      VOICE.TYPE$                = NONE.PICKED$
      WHO.UPLOADED               = TRUE                              ' FIX050903
      XON.XOFF                   = FALSE
      ZCallersLst$               = D$ + "CALLLST.DEF"
      ZCopyrightSecs             = 8
      ZDistriHelp$               = "DISTRI"
      ZDistriPath$               = D$
      ZEnableCC                  = FALSE
      ZMaxBank                   = 60
      ZMinSecPersUpld            = SYSOP.SECURITY.LEVEL
      ZMsgSecCats$               = "URP"
      FOR I = 1 TO LEN(UTIL.COMMANDS.DEFAULTS$)
         UTILITY.FUNCTION$(I,2) = MID$(UTIL.COMMANDS.DEFAULTS$,I,1)
      NEXT
      WAIT.BEFORE.DISCONNECT     = 180
      WELCOME.FILE$              = D$ + "WELCOME"
      WELCOME.INTERRUPTABLE      = TRUE
      WILL.SUBDIRS.B.USED        = FALSE
      WRITE.BUF.DEF              = 1024
      FOR I = 1 TO NUM.SYSOP
         SYSOP.FUNCTION(I) = SF
      NEXT
      FOR I = 1 TO NUM.MAIN
         MAIN.FUNCTION(I) = MM
      NEXT
      FOR I = 1 TO NUM.FILES
         FILES.FUNCTION(I) = FC
      NEXT
      FOR I = 1 TO NUM.LIBRARY
         LIBRARY.FUNCTION(I) = PS
      NEXT
      FOR I = 1 TO NUM.UTILITY
         UTILITY.FUNCTION(I) = UE
      NEXT
      FOR I = 1 TO NUM.GLOBAL
         GLOBAL.FUNCTION(I) = GB
      NEXT
      CALL MODEMINITCMD
      END SUB
'  $SUBTITLE: 'GETINIT - get an integer'
'  $PAGE
'
'  SUBROUTINE NAME    --  GETINIT
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         ANS            WHERE TO PUT THE ANSWER IN
'                         STRNG$         STRING CONTAINING THE QUESTION
'                         RO             ROW TO ASK THE QUESTION ON
'                         MIN            MINIMUM ACCEPTABLE NUMBER
'                         MAX            MAXIMUM ACCEPTABLE NUMBER
'
'  OUTPUT PARAMETERS  --  ANS            RESPONSE FROM THE KEYBOARD
'
'  SUBROUTINE PURPOSE --  TO ASK A QUESTION ON THE PC'S DISPLAY AT A
'                         SPECIFIC ROW AND GET AN INTEGER BACK
'
      SUB GETINIT (STRNG$,RO,MIN,MAX,ANS,CR) STATIC
61110 LOCATE RO,1
      CR = FALSE
      ANS = MIN
      PRINT SPACE$(79);
      LOCATE RO,5
      PRINT STRNG$;" ";
      LINE INPUT;ANS$
      IF ANS$ = "" THEN _
         CR = TRUE : _
         EXIT SUB
      IF VAL(ANS$) < MIN OR _
         VAL(ANS$) > MAX THEN _
         GOTO 61110
      ANS = VAL(ANS$)
      IF ANS = 0 AND LEFT$(ANS$,1) <> "0" THEN _
         GOTO 61110
      END SUB
'  $SUBTITLE: 'GETNUMYN - get a TRUE-FALSE answer to a YES OR NO question'
'  $PAGE
'
'  SUBROUTINE NAME    --  GETNUMYN
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         STRNG$         STRING CONTAINING THE QUESTION
'
'  OUTPUT PARAMETERS  --  ANS            Returned value - -1 IF yes, 0 IF no
'
'  SUBROUTINE PURPOSE --  TO ASK A QUESTION ON THE PC'S DISPLAY AND GET A
'                         YES OR NO ANSWER CONVERTED TO TRUE/FALSE
'
       SUB GETNUMYN (STRNG$,ANS) STATIC
       CALL GETYESNO (STRNG$,ANS$)
       ANS = FNYESNO (ANS$)
       END SUB
'  $SUBTITLE: 'GETYESNO - Ask a YES OR NO question'
'  $PAGE
'
'  SUBROUTINE NAME    --  GETYESNO
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         ANS$           STRING TO PUT THE ANSWER IN
'                         STRNG$         STRING CONTAINING THE QUESTION
'
'  OUTPUT PARAMETERS  --  ANS$           RESPONSE FROM THE KEYBOARD
'
'  SUBROUTINE PURPOSE --  TO ASK A QUESTION ON THE PC'S DISPLAY AND GET A
'                         YES OR NO ANSWER
'
      SUB GETYESNO (STRNG$,ANS$) STATIC
61200 CALL ASKRO (STRNG$+" Y)es or N)o",24,HJ$)
      L = LEN(HJ$)
      IF L < 1 OR L > 3 THEN _
         GOTO 61207
      CALL ALLCAPS(HJ$)
      X = INSTR("NY",LEFT$(HJ$,1))
      ON X GOTO 61210,61212
61207 BEEP
      GOTO 61200
61210 ANS$ = "NO"
      EXIT SUB
61212 ANS$ = "YES"
      EXIT SUB
      END SUB
'  $SUBTITLE: 'ANYNUMBER - input any numeric value'
'  $PAGE
'
'  SUBROUTINE NAME    --  ANYNUMBER
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         PRMPT$           PROMPT
'
'  OUTPUT PARAMETERS  --  RETURNED.VALUE!  VALUE RETURNED
'
'  SUBROUTINE PURPOSE --  TO GET A NUMERIC VALUE
'
      SUB ANYNUMBER (PRMPT$,RETURNED.VALUE!) STATIC
61400 CALL ASKRO (PRMPT$,24,HJ$)
      RETURNED.VALUE! = VAL(HJ$)
      END SUB
'  $SUBTITLE: 'ANYINTEGER - input any integer value'
'  $PAGE
'
'  SUBROUTINE NAME    --  ANYINTEGER
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         PRMPT$           PROMPT TO DISPLAY
'
'  OUTPUT PARAMETERS  --  RETURNED.VALUE   VALUE RETURNED
'
'  SUBROUTINE PURPOSE --  TO GET AN INTEGER VALUE
'
      SUB ANYINTEGER (PRMPT$,RETURNED.VALUE) STATIC
61450 CALL ANYNUMBER (PRMPT$,RETURNED.VALUE!)
      IF RETURNED.VALUE! >  32767.0 OR _
         RETURNED.VALUE! < -32767.0 THEN_
         BEEP : _
         GOTO 61450
      RETURNED.VALUE = RETURNED.VALUE!
      END SUB
'  $SUBTITLE: 'MMINTEGER - input any integer value with range check'
'  $PAGE
'
'  SUBROUTINE NAME    --  MMINTEGER
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         PRMPT$           PROMPT
'                         MIN              MINIMUM VALUE (INCLUSIVE)
'                         MAX              MAXIMUM VALUE (INCLUSIVE)
'
'  OUTPUT PARAMETERS  --  RETURNED.VALUE   VALUE RETURNED
'
'  SUBROUTINE PURPOSE --  TO GET AN INTEGER VALUE WITHIN A RANGE
'
      SUB MMINTEGER (PRMPT$,MIN,MAX,RETURNED.VALUE) STATIC
61500 CALL ANYINTEGER (PRMPT$,RETURNED.VALUE)
      IF RETURNED.VALUE < MIN OR RETURNED.VALUE > MAX THEN _
         BEEP : _
         GOTO 61500
      END SUB
'  $SUBTITLE: 'MMREAL - input any single precision real # with range check'
'  $PAGE
'
'  SUBROUTINE NAME    --  MMREAL
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         PRMPT$           PROMPT
'                         MIN!             MINIMUM VALUE (INCLUSIVE)
'                         MAX!             MAXIMUM VALUE (INCLUSIVE)
'
'  OUTPUT PARAMETERS  --  RETURNED.VALUE!  VALUE RETURNED
'
'  SUBROUTINE PURPOSE --  TO GET AN REAL # VALUE WITHIN A RANGE
'
      SUB MMREAL (PRMPT$,MIN!,MAX!,RETURNED.VALUE!) STATIC
61550 CALL ANYNUMBER (PRMPT$,RETURNED.VALUE!)
      IF RETURNED.VALUE! < MIN! OR RETURNED.VALUE! > MAX! THEN _
         BEEP : _
         GOTO 61550
      END SUB
'  $SUBTITLE: 'CHKFMSDIR - Validate structure of FMS directory'
'  $PAGE
'
'  SUBROUTINE NAME    --  CHKFMSDIR
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         FMSDIR$         NAME OF FMS DIRECTORY
'                         LINELEN         PROPER LENGTH OF LINES
'                                         (EXCLUDING CR/LF AT END)
'                         FMS.DIRCAT$     CATEGORY FILE FOR FMS
'
'  OUTPUT PARAMETERS  --  RETURNED.VALUE   VALUE RETURNED
'
'  SUBROUTINE PURPOSE --  VERIFIES THAT FMS IS IN VALID FORMAT
'                         AND DIAGNOSES PROBLEMS
'
61700 SUB CHKFMSDIR (FMSDIR$,LINELEN,FMS.DIRCAT$) STATIC
      CALL GETNUMYN ("Really check FMS directory",AB)
      IF NOT AB THEN _
         EXIT SUB
      DIM CAT.CODE$(99)
      CALL SETSCRCHK ("FMS",FMSDIR$)
      NCATS = 0
      CALL FINDFILE (FMS.DIRCAT$,FEXISTS)
      IF NOT FEXISTS THEN _
         GOTO 61702
      NCATS = 1
      CAT.CODE$(1) = "***"
      IF NETWORK.TYPE = 6 THEN _
         OPEN FMS.DIRCAT$ FOR INPUT SHARED AS #2 _
      ELSE  OPEN FMS.DIRCAT$ FOR INPUT AS #2
      WHILE NOT EOF(2) AND NCATS < UBOUND(CAT.CODE$)
         NCATS = NCATS + 1
         INPUT #2,X$,Y$,X$
         CAT.CODE$(NCATS) = Y$
      WEND
      CLOSE 2
61702 GO.ON = -1
      CALL FINDFILE (FMSDIR$,FEXISTS)
      IF NOT FEXISTS THEN _
         LOCATE 6,25 : _
         PRINT "File not found"; : _
         GOTO 61750
      IF NETWORK.TYPE = 6 THEN _
         OPEN FMSDIR$ FOR INPUT SHARED AS #2 _
      ELSE OPEN FMSDIR$ FOR INPUT AS #2
      WHILE NOT EOF(2) AND GO.ON
         NLINES = NLINES + 1
         LINE INPUT #2, A$
         L = LEN(A$)
         LOCATE 7,36
         PRINT NLINES;
         IF L > LINELEN THEN _
            CALL HANDERR (A$,NLINES,"Too LONG: has" + STR$(L) + " chars but should have" + STR$(LINELEN),GO.ON):_
            IF NOT GO.ON THEN _
               GOTO 61740
         IF L < LINELEN THEN _
            X$ = "Too SHORT: has" + STR$(L) + " chars but should have" + STR$(LINELEN) : _
            CALL HANDERR (A$,NLINES,X$,GO.ON):_
            IF NOT GO.ON THEN _
               GOTO 61740
         IF L = LINELEN THEN _
            I = INSTR(A$," ") : _
            IF I = 0 OR I > 13 THEN _
               CALL HANDERR (A$,NLINES, "Space must begin line or be after file name",GO.ON) : _
               IF NOT GO.ON THEN _
                  GOTO 61740
         IF L > 0 THEN _
            IF INSTR ("\* ",LEFT$(A$,1)) THEN _
               GOTO 61740
         IF L > 30 THEN _
            X$ = MID$(A$,24,2) + _
                 MID$(A$,27,2) + _
                 MID$(A$,30,2) : _
            I = 1 : _
            WHILE I < 7 AND INSTR("0123456789",MID$(X$,I,1)) > 0 : _
               I = I + 1: _
            WEND: _
            IF I < 7 THEN _
               CALL HANDERR (A$,NLINES,"INVALID CHARACTER <" + MID$(X$,I,1) + "> in date field",GO.ON) : _
               IF NOT GO.ON THEN _
                  GOTO 61740
         I = 1
         Y$ = MID$(A$,L - 2)
         CALL REMOVE (Y$," ")
         WHILE I <= NCATS AND Y$ <> CAT.CODE$(I)
            I = I + 1
         WEND
         IF I > NCATS THEN _
            CALL HANDERR (A$,NLINES,"Category code <" + Y$ + "> NOT IN " + FMS.DIRCAT$,GO.ON)
61740 WEND
61750 CLOSE 2
      IF NOT GO.ON THEN _
         COLOR FG,BG,BORDER : _
         EXIT SUB
      CALL CHKRANDOM (FMSDIR$,LINELEN,"FMS")
      END SUB
61751 SUB CHKRANDOM (CHKTHIS$, LINELEN, KindChk$) STATIC
      LOCATE 15,15
      BEEP
      CALL ASKRO ("          1st check done.  Press [ENTER] to continue",20,ANS$)
      CALL SETSCRCHK (KindChk$,CHKTHIS$)
      RECLEN = LINELEN + 2
      IF NETWORK.TYPE = 6 THEN _
         OPEN CHKTHIS$ FOR RANDOM SHARED AS #2 LEN=RECLEN _
      ELSE OPEN "R",2,CHKTHIS$,RECLEN
      FIELD 2, RECLEN AS FMSREC$
      LASTREC = LOF(2)/RECLEN
      CRLF$ = CHR$(13) + CHR$(10)
      FOR NLINES = 1 TO LASTREC
         GET 2,NLINES
         LOCATE 7,36
         PRINT NLINES;
         IF INSTR ("\*=",MID$(FMSREC$,1,1)) THEN _
            GOTO 61753
         I = INSTR(FMSREC$," ") : _
         IF I = 0 OR I > 13 THEN _
            J = INSTR(FMSREC$,CHR$(0)) : _
            IF J > 0 AND J < I THEN _
               CALL HANDERR (FMSREC$,NLINES, "Space must begin line or be after file name",GO.ON) : _
               IF NOT GO.ON THEN _
                  GOTO 61752
         IF RIGHT$(FMSREC$,2) <> CRLF$ THEN _
            CALL HANDERR (FMSREC$,NLINES,"Does not end with carriage-return-line-feed",GO.ON) :_
            IF NOT GO.ON THEN _
               GOTO 61752
        GOTO 61753
61752   NLINES = LASTREC + 1
61753 NEXT
      CLOSE 2
      BEEP
      CALL ASKRO ("           Done checking.  Press [ENTER] to continue",20,ANS$)
      COLOR FG,BG,BORDER
      END SUB
61754 SUB SETSCRCHK (KindChk$,FileChk$) STATIC
      CLS
      LOCATE 5,14
      PRINT "Checking ";KindChk$;" Directory ";FileChk$
      NLINES = 0
      LOCATE 7,27
      PRINT "Line #";
      LOCATE 9,20
      COLOR 0,7
      PRINT " Last Line with an ERROR ";
      LOCATE 12,28
      PRINT " Last ERROR ";
      COLOR 7,0
      END SUB
'  $SUBTITLE: 'CHKPERSDIR - Validate personal directories'
'  $PAGE
'
'  SUBROUTINE NAME    --  CHKPERSDIR
'
'  INPUT PARAMETERS   --  PARAMETER         MENANING
'                         PDIR$           NAME OF PERSONAL DIRECTORY
'                         NAMELEN         PROPER LENGTH OF NAME FIELD
'
'  OUTPUT PARAMETERS  --  NONE
'
'  SUBROUTINE PURPOSE --  CHECKS PERSONAL DIRECTORY FOR PROPER FORMAT
'
61755 SUB CHKPERSDIR (PDIR$, DESC.LEN, NAMELEN) STATIC
      CALL GETNUMYN ("Really check Personal directory",AB)
      IF NOT AB THEN _
         EXIT SUB
      CLS
      LOCATE 5, 14
      PRINT "Checking Personal Directory "; PDIR$;
      NLINES = 0
      LOCATE 7, 27
      PRINT "Line #";
      LOCATE 9, 20
      COLOR 0, 7
      PRINT " Last Line with an ERROR ";
      LOCATE 12, 28
      PRINT " Last ERROR ";
      COLOR 7, 0
      GO.ON = -1
      CALL FINDFILE(PDIR$, FEXISTS)
      IF NOT FEXISTS THEN _
         LOCATE 6, 25: _
         PRINT "File not found"; : _
         GOTO 61775
      LINELEN = 34 + DESC.LEN + NAMELEN
      IF NETWORK.TYPE = 6 THEN _
         OPEN PDIR$ FOR INPUT SHARED AS #2 _
      ELSE OPEN PDIR$ FOR INPUT SHARED AS #2
      WHILE NOT EOF(2) AND GO.ON
         NLINES = NLINES + 1
         LINE INPUT #2, A$
         L = LEN(A$)
         LOCATE 7, 36
         PRINT NLINES;
         IF L > LINELEN THEN _
            CALL HANDERR(A$, NLINES, "Too LONG: has" + STR$(L) + " chars but should have" + STR$(LINELEN), GO.ON) : _
            IF NOT GO.ON THEN _
               GOTO 61770
         IF L < LINELEN THEN _
            CALL HANDERR(A$, NLINES, "Too SHORT: has" + STR$(L) + " chars but should have" + STR$(LINELEN), GO.ON) : _
               IF NOT GO.ON THEN _
                  GOTO 61770
         IF L > 30 AND (LEFT$(A$,1) <> " ") THEN _
            X$ = MID$(A$, 24, 2) + MID$(A$, 27, 2) + MID$(A$, 30, 2) : _
            I = 1 : _
            WHILE I < 7 AND INSTR("0123456789", MID$(X$, I, 1)) > 0 : _
               I = I + 1 : _
            WEND : _
            IF I < 7 THEN _
               CALL HANDERR(A$, NLINES, "INVALID CHARACTER <" + MID$(X$, I, 1) + "> in date field", GO.ON) : _
               IF NOT GO.ON THEN _
                  GOTO 61770
           IF L = LINELEN THEN _
              X$ = RIGHT$(A$, 1) : _
              IF INSTR("*!", X$) = 0 THEN _
                 CALL HANDERR(A$, NLINES, "Last char on line should be * or ! but found <" + X$ + ">", GO.ON) : _
                 IF NOT GO.ON THEN  _
                    GOTO 61770
           IF L = LINELEN THEN _
              X$ = MID$(A$, L - NAMELEN, LINELEN) : _
              IF LEFT$(X$, 1) = " " THEN _
                 IF INSTR("0123456789-", MID$(X$, 2, 1)) = 0 THEN _
                    CALL HANDERR(A$, NLINES, "Name field at col" + STR$(L - NAMELEN) + " has <" + LEFT$(X$, 1) + ">, needs non-blank or blank+number", GO.ON) : _
                    IF NOT GO.ON THEN _
                       GOTO 61770
           IF L = LINELEN THEN _
              I = INSTR(A$," ") : _
              IF I = 0 OR I > 13 THEN _
                 CALL HANDERR(A$,NLINES, "Space must begin line or be after file name",GO.ON) : _
                 IF NOT GO.ON THEN _
                    GOTO 61770
61770 WEND
61775 CLOSE 2
      IF NOT GO.ON THEN _
         EXIT SUB
      CALL CHKRANDOM (PDIR$,LINELEN,"Personal")
      END SUB
'  $SUBTITLE: 'HANDERR - subroutine to handle FMS errors'
'  $PAGE
'
'  SUBROUTINE NAME    -- HANDERR
'
'  INPUT PARAMETERS   -- PARAMETER                      MEANING
'                        ERRLINE$                LINE THAT HAS THE ERROR
'                        ERRL                    LINE NUMBER WITH ERROR
'                        ERRMES$                 ERROR MESSAGE TO ISSUE
'
'  OUTPUT PARAMETERS  -- GO.ON                   INIDCATE TO PROCEDURE OR NOT
'
'  SUBROUTINE PURPOSE -- TO HANDLE ERROR CHECKING OF THE FMS DIRECTORY
'
      SUB HANDERR (ERRLINE$,ERRL,ERRMES$,GO.ON) STATIC
      LOCATE 10,1
      PRINT SPACE$(80);
      LOCATE 10,1
      PRINT ERRLINE$;
      LOCATE 9,45
      PRINT STR$(ERRL);
      LOCATE 13,1
      PRINT SPACE$(79);
      L = LEN(ERRMES$)
      IF L > 68 THEN _
         STRT = 1 _
      ELSE STRT = (70 - L) / 2
      LOCATE 13,STRT
      PRINT ERRMES$;
      CALL ASKRO ("               CONTINUE checking (Y/N,[ENTER]=Y) ",20,ANS$)
      IF ANS$ = "" THEN _
         ANS$ = "Y"
      CALL ALLCAPS (ANS$)
      GO.ON = FNYESNO (ANS$)
      END SUB
' $SUBTITLE: 'REMOVE - subroutine to delete a string from within a string'
' $PAGE
'
'  SUBROUTINE NAME    -- REMOVE
'
'  INPUT PARAMETERS   -- PARAMETER                      MEANING
'                        BADSTRING$              STRING CONTAINING CHARACTERS
'                                                TO BE DELETED FROM "L$"
'                        L$                      STRING TO BE ALTERED
'
'  OUTPUT PARAMETERS  -- L$                      WITH THE CHARACTERS IN
'                                                "BADSTRING#" DELETED FROM IT
'
'  SUBROUTINE PURPOSE -- TO REMOVE ALL INSTANCES OF THE CHARACTERS IN
'                        "BADSTRING$" FROM "L$"
'
      SUB REMOVE (L$,BADSTRNG$) STATIC
61800 J = 0
      FOR I = 1 TO LEN(L$)
	 IF INSTR(BADSTRNG$,MID$(L$,I,1)) = 0 THEN _
	    J = J + 1: _
            MID$(L$,J,1) = MID$(L$,I,1)
      NEXT I
      L$ = LEFT$(L$,J)
      END SUB
' $SUBTITLE: 'GETASCII - subroutine to prompt for any ASCII values'
' $PAGE
'
'  SUBROUTINE NAME    -- GETASCII
'
'  INPUT PARAMETERS   -- PARAMETER                      MEANING
'                        TITLE$                  HEADER EXPANATION FOR PARAM
'
'  OUTPUT PARAMETERS  -- STRNG$                  RESULTANT CONFIG PARAMETER
'
'  SUBROUTINE PURPOSE -- ALLOWS ANY ASCII CHARACTER TO BE STORED IN A PARAMETER
'                        BY ENCLOSING IT IN SQUARE BRACKETS.  CHARACTERS NOT IN
'                        SQUARE BRACKETS ARE INTERPRETED EXACTLY AS ENTERED.
'                        CHARACTER'S ASCII VALUE EQUAL THE NUMERIC VALUE IN THE
'                        SQUARE BRACKETS.
'
      SUB GETASCII (TITLE$,STRNG$) STATIC
61810 CLS
      LOCATE 8,20                                                    ' FIX052404
      PRINT TITLE$;
      LOCATE 13,5
      CALL ANSI(FG2$ + "Current value is")                           ' FIX052403
      CALL ANSI(FG3$ + STRNG$)                                       ' FIX052403
      PRINT                                                          ' FIX052403
      PRINT "Please enter the new values by entering the character"
      PRINT "or enclosing its ASCII value in square brackets:"
      PRINT "(Press ENTER to keep current value.  Enter 'NONE' to make empty)"
      LINE INPUT "";X$                                               ' FIX052802
      STRNG$ = X$                                                    ' FIX052802
      CALL ALLCAPS(X$)                                               ' FIX052802
      IF X$ = "NONE" THEN _                                          ' FIX052802
	 STRNG$ = X$                                                 ' FIX052802
      END SUB
' $SUBTITLE: 'SECURE - subroutine to assign security to commands'
' $PAGE
'
'  SUBROUTINE NAME    -- SECURE
'
'  INPUT PARAMETERS   -- PARAMETER             MEANING
'                        SECTION$           NAME OF THE SECTION
'                        DEFAULTS$          DEFAULT COMMANDS FOR THE SECTION
'                        NUMBER.OF.COMMANDS NUMBER OF COMMANDS IN THE SECTION
'                        COMMANDS$()        CHARACTERS REPRESENTING THE ONE-
'                                              CHARACTER COMMANDS
'                        COMMANDS()         SECURITY LEVEL ASSOCIATED WITH
'                                           THE COMMAND
'                        SECTION.COMMANDS$  PROMPT STRING OF ALL COMMANDS IN
'                                             THE SECTION
'
'  OUTPUT PARAMETERS  -- COMMANDS$()        CHARACTERS REPRESENTING THE ONE-
'                                              CHARACTER COMMANDS
'                        COMMANDS()         SECURITY LEVEL ASSOCIATED WITH
'                                           THE COMMAND
'                        SECTION.COMMANDS$  PROMPT STRING OF ALL COMMANDS IN
'                                             THE SECTION
'
'  SUBROUTINE PURPOSE -- ALLOWS USERS TO MODIFY COMMANDS AND SECURITY FOR
'                        EACH COMMAND.
'
      SUB SECURE (SECTION$,DEFAULTS$,NUMBER.OF.COMMANDS,COMMANDS$(2),COMMANDS(1),SECTION.COMMANDS$) STATIC
61860 IF IPAGE = 2 OR _
         VAL(OPTION$) = 310 THEN _
         XX$ = "ALL " + _
               SECTION$ + _
               " commands use default letters?" _
      ELSE XX$ = "ALL " + _
               SECTION$ + _
               " commands = SAME security level?"
      LOCATE 24,1
      PRINT SPACE$(79);
      LOCATE 24,1
      CALL GETNUMYN (XX$,AB)
      IF NOT AB THEN _
         GOTO 61880
61870 IF IPAGE = 2 OR _
         VAL(OPTION$) = 310 THEN _
         SECTION.COMMANDS$ = DEFAULTS$ : _
         FOR I = 1 TO NUMBER.OF.COMMANDS : _
            COMMANDS$(I,2) = MID$(SECTION.COMMANDS$,I,1) : _
         NEXT : _
         EXIT SUB
      CALL MMINTEGER("Security level for all " + _
                      SECTION$ + _
                     " commands is?",-32767,32767,B1)
      FOR I = 1 TO NUMBER.OF.COMMANDS
         COMMANDS(I) = B1
      NEXT
      GB = B1
      EXIT SUB
61880 GOSUB 61900
      IROW = 4
      ICOL = 10
      FOR I = 1 TO NUMBER.OF.COMMANDS
         LOCATE IROW + I,ICOL
         IF IPAGE = 2 OR _
            VAL(OPTION$) = 310 THEN _
	    CALL ANSI(FG1$ + COMMANDS$(I,1) + " " + FG2$ + COMMANDS$(I,2))     _ ' FIX052403
	 ELSE CALL ANSI(FG1$ + COMMANDS$(I,1) + FG2$ + STR$(COMMANDS(I)))     ' FIX052403
      NEXT
61890 CALL ASKRO("Enter first character of command ([ENTER] quits)",24,X$)
      IF X$ = "" THEN _
         EXIT SUB
      IF LEN(X$) <> 1 THEN _
         GOTO 61890
      CALL ALLCAPS(X$)
      FF = INSTR(DEFAULTS$,X$)
      IF FF = 0 THEN _
         GOTO 61890
      IF IPAGE = 2 OR _
         VAL(OPTION$) = 310 THEN _
         GOTO 61892
      CALL MMINTEGER("Security level for all " + _
                      SECTION$ + _
                     " '" + _
                     X$ + _
                     "' commands is?",-32767,32767,B1)
      GOTO 61893
61892 CALL ASKRO("New command for " + _
                  MID$(COMMANDS$(FF,1),1,INSTR(COMMANDS$(FF,1),"  ")) + _
		 "is?",24,HK$)
      IF LEN(HK$) < 1 THEN _                                         ' FIX052001
	 GOTO 61880                                                  ' FIX052001
      IF HK$ = CHR$(34) THEN _
         GOTO 61892
      X$ = MID$(HK$,1,1)
      CALL ALLCAPS (X$)
      IF LEN(HK$) > 1 THEN _
         HK$ = X$ + MID$(HK$,2)
      IF LEN (HK$) = 1 THEN _
         HK$ = X$
      COMMANDS$(FF,2) = HK$
      MID$(SECTION.COMMANDS$,FF,1) = HK$
      GOTO 61880
61893 COMMANDS(FF) = B1
      GOTO 61880
'
' * COMMON ROUTINE TO DISPLAY SUBSYSTEM COMMANDS AND THEIR SECURITY LEVELS
'
61900 CLS
      I! = FRE(C$)
      COLOR 0,7,0
      LOCATE 1,23
      PRINT "RBBS-PC "+ CONFIG.VERSION$ + " Default Configuration";
      COLOR FG,BG,BORDER
      LOCATE  2,5
      PRINT "The RBBS-PC " + _
             SECTION$ + _
            " Commands are as follows:"
      LOCATE   3,10
      XX$ = "Command             Security"
      IF IPAGE = 2 OR _
         VAL(OPTION$) = 310 THEN _
         XX$ = "Description         Command"
      PRINT XX$
      RETURN
      END SUB
'  $SUBTITLE: 'GETCOLOR - get colors using natural language'
'  $PAGE
'
'  SUBROUTINE NAME    -- GETCOLOR
'
'  INPUT PARAMETERS   -- PARAMETER             MEANING
'                        STRNG$             TITLE OF WHAT COLOR IS FOR
'                        NUM.COLOR          CURRENT COLOR SETTING
'
'  OUTPUT PARAMETERS  -- NUM.COLOR          NEW COLOR SETTING
'
'  SUBROUTINE PURPOSE -- SET THE COLOR USING NATURAL LANGUAGE PHRASES
'
      SUB GETCOLOR (STRNG$,NUM.COLOR) STATIC
      CLS
61950 IF NUM.COLOR > 7 THEN _
         X = NUM.COLOR - 8 _
      ELSE X = NUM.COLOR
      X$ = MID$("<none>Blue  Green Cyan  Red   PurpleYellowWhite",X*6+1,6)
      LOCATE 9,15
      PRINT STRNG$;" now ";X$;"     ";
61955 CALL ASKRO ("Make N)one,R)ed,G)reen,Y)ellow,B)lue,P)urple,C)yan,W)hite,[ENTER] quits",20,ANS$)
      IF ANS$ = "" THEN _
         EXIT SUB
      CALL ALLCAPS (ANS$)
      Y = INSTR("NBGCRPYW",ANS$) - 1
      IF Y < 0 THEN _
         GOTO 61955
      NUM.COLOR = Y
      GOTO 61950
      END SUB
' $SUBTITLE: 'GETANSI - SUBROUTINE TO GET CALLERS COLOR VALUES'
' $PAGE
'
'  SUBROUTINE NAME    -- GETANSI
'
'  INPUT PARAMETERS   -- PARAMETER                      MEANING
'                        SELECTION$       NAME OF SELECTION TO HAVE COLOR
'                        PRMPT$           WHAT TO PROMPT ON THE SCREEN
'
'  OUTPUT PARAMETERS  -- FG.1.DEF$        FIRST  COLOR SELECTION
'                        FG.2.DEF$        SECOND COLOR SELECTION
'                        FG.3.DEF$        THIRD  COLOR SELECTION
'                        FG.4.DEF$        FOURTH COLOR SELECTION
'                        FG.5.DEF$        FIFTH  COLOR SELECTION     ' FIX062303
'
'  SUBROUTINE PURPOSE -- ASK THE SYSOP TO SELECT THE FOUR COLORS TO BE
'                        USED FOR CALLERS THAT SELECT COLOR DISPLAYS.
'
      SUB GETANSI (SELECTION$,PRMPT$) STATIC
      CLS
62000 LOCATE 8,10
      PRINT PRMPT$;" Foreground for caller now ";SELECTION$;"       "
      LOCATE 10,1
      PRINT "Current foreground selections: ";
      CALL COLORCODE (FG.1.DEF$,X$,X)
      COLOR X,CALLER.BKGRD
      PRINT "First ";
      CALL COLORCODE (FG.2.DEF$,X$,X)
      COLOR X
      PRINT "Second ";
      CALL COLORCODE (FG.3.DEF$,X$,X)
      COLOR X
      PRINT "Third ";
      CALL COLORCODE (FG.4.DEF$,X$,X)
      COLOR X
      PRINT "Fourth ";                                               ' FIX062303
      CALL COLORCODE (FG.5.DEF$,X$,X)                                ' FIX062303
      COLOR X                                                        ' FIX062303
      PRINT "Fifth"                                                  ' FIX062303
      COLOR FG,BG
62040 CALL ASKRO ("Make N)one,R)ed,G)reen,Y)ellow,B)lue,P)urple,C)yan,W)hite,[ENTER] quits",14,ANS$)
      IF ANS$ = "" THEN _
         EXIT SUB
      CALL ALLCAPS (ANS$)
      X = INSTR("NRGYBPCW",ANS$)
      IF X < 2 THEN _
         SELECTION$ = NONE.PICKED$ : _
         GOTO 62000
      X$ = MID$("Red   Green YellowBlue  PurpleCyan  White",X*6-11,6)
      CALL ASKRO ("Make "+X$+" [B]right, or N)ormal",17,ANS$)
      CALL ALLCAPS (ANS$)
      IF ANS$ <> "N" THEN _
         SELECTION$ = "Bright " + X$ _
      ELSE SELECTION$ = "Normal " + X$
      GOTO 62000
      END SUB
