TITLE  'Draw Character EGA - VIDEO SYSTEMS p.288'
NAME   DRAWCH
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Draw a character in EGA\VGA                            |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call DRAWCH(0,65,0,0,7,0)                              |
;    stack:     +06 = bg                                                |
;                08 = fg                                                |
;                10 = y0                                                |
;                12 = x0                                                |
;                14 = character code                                    |
;                16 = replace type                                      |
;  returns:      none                                                   |
;     NOTE:     SS overrides used to access some BSS data               |
;------------------------------------------------------------------------

PARMS           = 6
ARGaddtype      EQU [bp+16]
ARGchar         EQU [bp+14]
ARGx            EQU [bp+12]
ARGy            EQU [bp+10]
ARGfg           EQU [bp+08]
ARGbg           EQU [bp+06]
ByteOffsetShift EQU 3

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

DrawCh_TEXT     SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:DrawCh_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  DrawCh
DrawCh          PROC    FAR

                push    bp
                mov     bp,sp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGchar
                mov     ax,[bx]
                mov     char,ax
                mov     bx,ARGx
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy
                mov     ax,[bx]
                mov     y0,ax
                mov     bx,ARGfg
                mov     ax,[bx]
                mov     fg,ax
                mov     bx,ARGbg
                mov     ax,[bx]
                mov     bg,ax

                ;calculate first pixel address

                mov     ax,y0
                mov     bx,x0
                mov     cx,bpl
                call    PixelAddr       ;es:bx -> buffer
                                        ;cl = bits to shift left to mask pixel
                inc     cx
                and     cl,7            ;cl = bits to shift to mask char

                mov     ch,0FFh
                shl     ch,cl           ;ch = bit mask for right side of char
                mov     shift,cx

                push    es
                mov     si,bx           ;si = video buffer offset

                ;set up character definition addressing

                mov     ax,040h         ;BIOS data seg
                mov     ds,ax
                ASSUME ds:nothing
                mov     cx,ds:[085h]    ;cx = POINTS

                xor     ax,ax
                mov     ds,ax
                ASSUME ds:nothing

                mov     ax,ss:char
                mov     bx,043h * 4     ;ds:bx -> int 43h vector
                les     di,ds:[bx]      ;es:di -> start of character table
                mul     cl              ;ax = offset into char def table

                add     di,ax           ;di = addr of char def
                pop     ds              ;ds:si -> video buffer
                ASSUME ds:nothing

                ;set up graphics controller

                mov     dx,03CEh        ;controller port address
                mov     ax,0A05h        ;al = mode reg
                                        ;ah = write mode 2 (bits 0-1)
                                        ;     read mode 1 (bit 4)
                out     dx,ax
                mov     ah,byte ptr ss:RMWbits
                mov     al,3            ;al = data rotate/func select reg
                out     dx,ax

                mov     ax,0007         ;ah = color don't care bits
                                        ;al = color don't care reg
                out     dx,ax           ;don't care for all bit planes

                ;select output routine depending if byte-aligned

                mov     bl,byte ptr ss:fg
                mov     bh,byte ptr ss:bg
                cmp     byte ptr ss:shift,0     ;test bits to shift
                jne     L20             ;jump if char not byte-aligned

                ;routine for byte-aligned characters

                mov     al,8            ;al = bit mask reg

L10:            mov     ah,es:[di]      ;ah = pattern for next row of pixels
                out     dx,ax           ;update bit mask reg
                and     [si],bl         ;update fg pixels

                not     ah
                out     dx,ax
                and     [si],bh         ;update bg pixels
                inc     di              ;es:di -> next byte in char def table
                add     si,ss:bpl       ;increment to next line in video buffer
                loop    L10
                jmp     short Lexit

                ;routine for non-byte-aligned characters

L20:            push    cx
                mov     cx,ss:shift     ;ch = mask for left side of char
                                        ;cl = bits to shift left
                ;left side of character

                mov     al,es:[di]      ;al = bits for next row of pixels
                xor     ah,ah
                shl     ax,cl           ;ah = bits for left side of char
                                        ;al = bits for right side of char
                push    ax              ;save bits for right side

                mov     al,8            ;al = bit mask reg
                out     dx,ax           ;set bit mask for fg pixels

                and     [si],bl         ;update fg pixels

                not     ch              ;ch = mask for left side of char
                xor     ah,ch           ;ah = bits for bg pixels
                out     dx,ax           ;set bit mask

                and     [si],bh         ;update bg pixels

                ;right side of character

                pop     ax
                mov     ah,al           ;ah = bits for right side of char
                mov     al,8
                out     dx,ax           ;set bit mask

                inc     si              ;ds:si -> right side of char buffer
                and     [si],bl         ;update fg pixels

                not     ch              ;ch = mask for right side of char
                xor     ah,ch           ;ah = bits for bg pixels
                out     dx,ax           ;set bit mask

                and     [si],bh         ;update background pixels

                ;increment to next row of pixels in character

                inc     di              ;es:di -> next byte in char def table
                dec     si
                add     si,ss:bpl       ;ds:si -> next line in video buffer

                pop     cx
                loop    L20

                ;restore default graphics controller state and return to caller

Lexit:          mov     ax,0FF08h
                out     dx,ax           ;restore bit mask reg

                mov     ax,0005
                out     dx,ax           ;restore mode reg

                mov     ax,0003
                out     dx,ax           ;data rotate\function select reg

                mov     ax,0F07h
                out     dx,ax           ;default color don't care

                pop     di
                pop     si
                pop     ds
                ASSUME ds:dgroup
                mov     sp,bp
                pop     bp
                RET     PARMS*2

DrawCh          ENDP
DrawCh_TEXT     ENDS
                END

