/* v_putc.c- Write Character to Viewport */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_putc( viewport *v, int c, int move )
{
    /* Overwrite the character on which the viewport's cursor is
     * resting. The cursor position advances one notch if the move
     * argument is true. It won't move past the right edge of the
     * line, however. Note that all characters are printed literally,
     * \n yields a graphics character, it doesn't go to the next line.
     * Return true if the cursor moved (it won't at end of line),
     * false otherwise.
     */

    int outc;
    int col, row;

    if( v->magic != VMAGIC )
        return 0;

    if( v->inactive )
        v_open( v );

    /* output the character. Can't use putch() both because we
     * don't have enough control of the color and because it
     * screws up the cursor if we're writing to the bottom right
     * corner of the screen.
     */

    outc = (c & 0xff) | ((v->bcolor << 4 | v->fcolor) << 8);
    col  = v->col + v->cur_col + 1;
    row  = v->row + v->cur_row + 1;
    puttext( col, row, col, row, &outc );

    return( move ? v_advance(v) : 0 );
}
