// keyboard.cls	a Keyboard class for C++.
//
// this file implements a Keyboard class.  it hides system details from
// the class user.
//
// (c) Aspen Scientific 1989. All Rights Reserved.
// Author: Vaughn Vernon

#ifndef __KEYBOARD_CLASS__

# define __KEYBOARD_CLASS__	1

# define extMask	0x8000

// Keyboard class

class Keyboard {

protected:
	int	keyI;		// saves latest input
public:
	Keyboard()			{ keyI = -1; }
	~Keyboard()			{ }

	// methods

	int	input(int wait =1);
	int	value()			{ return keyI; }
	int	operator==(int keyComp) { return (keyI == keyComp); }
	Keyboard & operator>>(int & k)	{ k = input(1); return *this; }
	void	flush()			{ while (input(0) != -1) ; }
};


// KeyTypes class

class KeyTypes {
public:
	KeyTypes()	{ }
	~KeyTypes()	{ }

	// these methods are used to compare input to
	int	None()		{ return (-1); }
	int	Escape()	{ return 27; }
	int	SpaceBar()	{ return ' '; }
	int	Tab()		{ return '\t'; }
	int	BackTab()	{ return 15; }

	int	Printable(int key)	{
			return (key >= 32 && key <= 127);
	}
	int	ASCII(int key)	{
			return (key >= 0 && key <= 255);
	}
	int	Ctrl(char c)	{ return (c & 037); }

	int	Home()		{ return (71 | extMask); }
	int	End()		{ return (79 | extMask); }
	int	PgUp()		{ return (73 | extMask); }
	int	PgDn()		{ return (81 | extMask); }
	int	Left()		{ return (75 | extMask); }
	int	Right()		{ return (77 | extMask); }
	int	Up()		{ return (72 | extMask); }
	int	Down()		{ return (80 | extMask); }

	int	F1()		{ return (59 | extMask); }
	int	F2()		{ return (60 | extMask); }
	int	F3()		{ return (61 | extMask); }
	int	F4()		{ return (62 | extMask); }
	int	F5()		{ return (63 | extMask); }
	int	F6()		{ return (64 | extMask); }
	int	F7()		{ return (65 | extMask); }
	int	F8()		{ return (66 | extMask); }
	int	F9()		{ return (67 | extMask); }
	int	F10()		{ return (68 | extMask); }
};

#endif // __KEYBOARD_CLASS__
