// display.cls	a C++ Display class for placing data on the display.
//
// (c) Aspen Scientific 1989. All Rights Reserved.
// Author: Vaughn Vernon

#ifndef _DISPLAY_CLASS

# define _DISPLAY_CLASS_ 	1

# include "mouse.cls"
# include "point.cls"
# include "rect.cls"


// DisplayAttr class

typedef unsigned int	Attribute;

class DisplayAttr {

protected:
	Attribute	attribute;
public:
	// set like this:
	//
	// DisplayAttr attr;
	//
	// attr.set(attr.backGreen() | attr.foreBlack());

	Attribute	set(Attribute a) { return attribute = a; }
	Attribute	get()		{ return attribute; }

	// generic/monochrome attributes
	Attribute	blink()		{ return 0x8000; }
	Attribute	bold()		{ return 0x0800; }
	Attribute	normal()	{ return 0x0700; }
	Attribute	reverse()	{ return 0x7000; }
	Attribute	underline()	{ return 0x0100; }

	// color attributes
	Attribute	foreBlack()	{ return 0x0000; }
	Attribute	foreBlue()	{ return 0x0100; }
	Attribute	foreGreen()	{ return 0x0200; }
	Attribute	foreCyan()	{ return 0x0300; }
	Attribute	foreRed()	{ return 0x0400; }
	Attribute	foreMagenta()	{ return 0x0500; }
	Attribute	foreBrown()	{ return 0x0600; }
	Attribute	foreWhite()	{ return 0x0700; }
	Attribute	foreGray()	{ return 0x0800; }
	Attribute	foreLtBlue()	{ return 0x0900; }
	Attribute	foreLtGreen()	{ return 0x0a00; }
	Attribute	foreLtCyan()	{ return 0x0b00; }
	Attribute	foreLtRed()	{ return 0x0c00; }
	Attribute	foreLtMagenta()	{ return 0x0d00; }
	Attribute	foreYellow()	{ return 0x0e00; }
	Attribute	foreBrightWhite() { return 0x0f00; }

	Attribute	backBlack()	{ return 0x0000; }
	Attribute	backBlue()	{ return 0x1000; }
	Attribute	backGreen()	{ return 0x2000; }
	Attribute	backCyan()	{ return 0x3000; }
	Attribute	backRed()	{ return 0x4000; }
	Attribute	backMagenta()	{ return 0x5000; }
	Attribute	backBrown()	{ return 0x6000; }
	Attribute	backWhite()	{ return 0x7000; }

	DisplayAttr() { attribute = normal(); }
	~DisplayAttr() { }
};

// Display class

class Display : public Rectangle {

protected:
	Point		cursor;
	Mouse	*	mouse;
	DisplayAttr	defAttr;
	unsigned	color;
	unsigned	snow;
	static unsigned videoSeg;
	static char	init;
public:
	Display(const Mouse *);
	~Display();

	virtual void	clear();
	void		operator()(unsigned, unsigned);
	void		operator()(Point & p) { cursor = p; }
	Point &		operator()() { return cursor; }
	void		cursorOff();
	void		cursorOn();
	unsigned	hasColor()	{ return color; }
	void		defaultAttr(DisplayAttr & a) { defAttr = a; }
	virtual void	putString(Point &, const unsigned char *,
				DisplayAttr &);
	virtual void	putChar(Point &, unsigned char, DisplayAttr &);
	Display &	operator<<(const unsigned char * s) {
			putString(cursor, s, defAttr);
			return *this;
	}
	Display &	operator<<(unsigned char c) {
			putChar(cursor, c, defAttr);
			return *this;
	}
	virtual void	draw();
};

#endif // __DISPLAY_CLASS__
