UNIT MOUSE;

  INTERFACE

  Uses Dos;

  Const
    Mouse = $33;
    GraphicsCursorScreenMask : array[1..16] of word =
        ($FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,
         $FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF);
    GraphicsCursorShapeMask : array[1..16] of word =
        ($0000,$0000,$0080,$01C0,$03E0,$07F0,$0FF8,$3FFB,
         $0FF8,$07F0,$03E0,$01C0,$0080,$0000,$0000,$0000);
    Buttons : integer = 0;

  Var
    Regs : Registers;
    MouseAvail,SoftCursorHidden : boolean;
    MouseButtons : integer;
    Function InitializeMouse : integer;
    Procedure ShowSoftCursor;
    Procedure HideSoftCursor;
    Function ReadMousePosition(var MouseX,MouseY : integer) : integer;
    Procedure SetMousePosition(MouseX,MouseY : integer);
    Function MouseButtonPresses(Button : integer; Var MouseX,MouseY : integer) : integer;
    Function MouseButtonReleases(Button : integer; Var MouseX,MouseY : integer) : integer;
    Procedure MouseCursorLimits(MinX,MaxX,MinY,MaxY : integer);
    Procedure DefineGraphicsCursor(HotX,HotY : integer; Var Mask);
    Procedure DefineTextCursor(HardOrSoft,First,Last : integer);
    Procedure MouseMickeyCount(Var MouseX,MouseY : integer);
    Procedure SetMouseUserProc(EventMask : integer; Var ProcAddr);
    Procedure MickeyToPixelRatio(Horiz,Vert : integer);
    Procedure HighSpeedThreshold(Threshold : integer);

IMPLEMENTATION

    Function InitializeMouse : integer;
    begin
      Regs.AX := 0;
      Intr(Mouse,Regs);
      MouseAvail := Regs.AX = 65535;
      if MouseAvail then InitializeMouse := Regs.BX else
        InitializeMouse := 0;
    end;

    Procedure ShowSoftCursor;
    begin
      Regs.AX := 1;
      Intr(Mouse,Regs);
      SoftCursorHidden := false;
    end;

    Procedure HideSoftCursor;
    begin
      Regs.AX := 2;
      Intr(Mouse,Regs);
      SoftCursorHidden := true;
    end;

    Function ReadMousePosition { (var MouseX,MouseY : integer) } : integer;
    begin
      Regs.AX := 3;
      Intr(Mouse,Regs);
      MouseX := succ(Regs.CX div 8);
      MouseY := succ(Regs.DX div 8);
      Intr(Mouse,Regs);
      ReadMousePosition := Regs.BX
    end;

    Procedure SetMousePosition { (MouseX,MouseY : integer) } ;
    begin
      Regs.AX := 4;
      Regs.CX := pred(MouseX * 8);
      Regs.DX := pred(MouseY * 8);
      Intr(Mouse,Regs);
    end;

    Function MouseButtonPresses { (Button : integer; Var MouseX,MouseY : integer) } :
                                integer;
    begin
      Regs.AX := 5;
      Regs.BX := Button;
      Intr(Mouse,Regs);
      MouseX := succ(Regs.CX div 8);
      MouseY := succ(Regs.DX div 8);
      MouseButtonPresses := Regs.AX;
    end;

    Function MouseButtonReleases { (Button : integer; Var MouseX,MouseY : integer) } :
                                 integer;
    begin
      Regs.AX := 6;
      Regs.BX := Button;
      Intr(Mouse,Regs);
      MouseX := succ(Regs.CX div 8);
      MouseY := succ(Regs.DX div 8);
      MouseButtonReleases := Regs.AX;
    end;

    Procedure MouseCursorLimits { (MinX,MaxX,MinY,MaxY : integer) } ;
    begin
      Regs.AX := 7;
      Regs.CX := pred(MinX * 8);
      Regs.DX := pred(MaxX * 8);
      Intr(Mouse,Regs);
      Regs.AX := 8;
      Regs.CX := pred(MinY * 8);
      Regs.DX := pred(MaxY * 8);
      Intr(Mouse,Regs);
    end;

    Procedure DefineGraphicsCursor { (HotX,HotY : integer; Var Mask) } ;
    begin
      Regs.AX := 9;
      Regs.BX := HotX;
      Regs.CX := HotY;
      Regs.DX := ofs(mask);
      Regs.ES := seg(mask);
      Intr(Mouse,Regs);
    end;

    Procedure DefineTextCursor { (HardOrSoft,First,Last : integer) } ;
    begin
      Regs.AX := 10;
      Regs.BX := HardOrSoft;
      Regs.CX := First;
      Regs.DX := Last;
      Intr(Mouse,Regs);
    end;

    Procedure MouseMickeyCount { (Var MouseX,MouseY : integer) };
    begin
      Regs.AX := 11;
      Intr(Mouse,Regs);
      MouseX := Regs.CX;
      MouseY := Regs.DX;
    end;

    Procedure SetMouseUserProc { (EventMask : integer; Var ProcAddr) };
    begin
      Regs.AX := 12;
      Regs.CX := EventMask;
      Regs.DX := ofs(ProcAddr);
      Regs.ES := seg(ProcADDr);
      Intr(Mouse,Regs);
    end;

    Procedure MickeyToPixelRatio { (Horiz,Vert : integer) } ;
    begin
      Regs.AX := 15;
      Regs.CX := Horiz;
      Regs.DX := Vert;
      Intr(Mouse,Regs);
    end;

    Procedure HighSpeedThreshold { (Threshold : integer) } ;
    begin
      Regs.AX := 19;
      Regs.DX := Threshold;
      Intr(Mouse,Regs);
    end;

begin
  Buttons := InitializeMouse;
end.
