{
Ŀ
                                                                           
 Demonstrationsprogramm zur Anwendung von Routinen der Unit PLOT           
                                                                           
 Copyright (C) 1991, Hans-Jrgen Herrler und Dieter Sosna                  
                                                                           

}

{$A+,F+,R-,S-}
{$M 16384,0,655360}

PROGRAM Example;

USES Crt, Graph, Plot;

CONST
    TreiberPfad     = '';   { Pfad fr Grafiktreiber *.BGI, bitte anpassen! }

VAR
    GrafikTreiber,
    GrafikModus             : Integer;

    Matrix                  : Array[1..30,1..33] of Float;
{   Im Feld "Matrix" werden die an den Sttzstellen berechneten Funktions-
    werte abgelegt. Sollen wesentlich mehr Punkte bercksichtigt werden,
    so pat das Feld nicht mehr ins Datensegment - man kann dann die Matrix
    zeilenweise auf dem Heap ablegen, aber lckenlos(!) Zeile hinter Zeile. }

    MatrixParm              : MatrixParameter;
    BildParm                : BildParameter;

    Mono                    : Boolean;      { 2- oder 16-Farben-Modus       }

{ ========================================================================= }

FUNCTION Fkt(x, y: Float): Float;
BEGIN
{   Hier darzustellende Anwenderfunktion eintragen:                         }
    Fkt := (Cos(x) - Sin(2*x)) * Cos(y)
    END;

{ ------------------------------------------------------------------------- }
PROCEDURE FunktionswerteBerechnen;
VAR
    i, j                    : Byte;
    X, Y, Z,
    XMin, XMax, XSchritt,
    YMin, YMax, YSchritt    : Float;

BEGIN
{   Intervallgrenzen                                                        }
    XMin := 0;  XMax := 6;  YMin := -3; YMax := 6;

    WITH MatrixParm DO BEGIN
{   Zahl der Gitterpunkte                                                   }
        XGitter := 33;
        YGitter := 30;

{   Funktionswerte berechnen, in Matrix ablegen                             }
        XSchritt := (XMax-XMin)/(XGitter-1);
        YSchritt := (YMax-YMin)/(YGitter-1);
        ZMin := Fkt(1,1);   ZMax := ZMin;
        y := YMin;
        FOR i := 1 TO YGitter DO BEGIN
            x := XMin;
            FOR j:= 1 TO XGitter DO BEGIN
                z := Fkt(x, y);
                IF z > ZMax THEN ZMax := z;
                IF z < ZMin THEN ZMin := z;
                Matrix[i, j] := z;
                x := x + XSchritt
                END;
            y := y + YSchritt
            END
        END
    END;    { FunktionswerteBerechnen }
{ ------------------------------------------------------------------------- }
PROCEDURE VierBilder;
BEGIN

{ Teilbild links oben:                                                      }

    WITH BildParm DO BEGIN
        SchirmLinks := 0;       SchirmRechts    := 0.48;
        SchirmOben  := 0;       SchirmUnten     := 0.48;
        IF Mono THEN BEGIN
            ColorLine   := 1;
            ColorFrame  := 1;
            ColorFillO  := 0;
            ColorFillU  := 0;
            ColorFillX  := 0;
            ColorFillY  := 0
            END
        ELSE BEGIN
            ColorLine   := White;
            ColorFrame  := White;
            ColorFillO  := Green;
            ColorFillU  := Brown;
            ColorFillX  := Magenta;
            ColorFillY  := Cyan
            END;
        Projekt     := ParallelProjektion;
        BrennweiteZuAbstand := 0.11;
        Alpha       := 33;
        Gamma       := 25;
        END;
    VolumenPerspektive(Matrix, MatrixParm, BildParm, True);

{ Teilbild rechts oben:                                                     }

    WITH BildParm DO BEGIN
        SchirmLinks := 0.52;    SchirmRechts    := 1;
        SchirmOben  := 0;       SchirmUnten     := 0.48;
        IF Not Mono THEN BEGIN
            ColorLine   := Yellow;
            ColorFillO  := Brown;
            ColorFillU  := Blue;
            ColorFillX  := LightBlue;
            ColorFillY  := LightMagenta
            END;
        Projekt     := ZentralProjektion;
        Alpha       := -38;
        Gamma       := 23;
        Brennweite  := 30;
        Abstand     := 300
        END;
    VolumenPerspektive(Matrix, MatrixParm, BildParm, True);

{ Teilbild links unten:                                                     }

    WITH BildParm DO BEGIN
        SchirmLinks := 0;       SchirmRechts    := 0.48;
        SchirmOben  := 0.52;    SchirmUnten     := 1;
        IF Not Mono THEN ColorLine  := LightGreen;
        Projekt     := ParallelProjektion;
        BrennweiteZuAbstand := 0.11;
        Alpha       := -144;
        Gamma       := 20;
        END;
    AlphaScheibenPerspektive(Matrix, MatrixParm, BildParm);

{ Teilbild rechts unten:                                                    }

    WITH BildParm DO BEGIN
        SchirmLinks := 0.52;    SchirmRechts    := 1;
        SchirmOben  := 0.52;    SchirmUnten     := 1;
        IF Not Mono THEN ColorLine := LightMagenta;
        Projekt     := ParallelProjektion;
        BrennweiteZuAbstand := 0.11;
        Alpha       := -124;
        Gamma       := 30;
        END;
    GitterFlaechenPerspektive(Matrix, MatrixParm, BildParm, True);

    END;    { VierBilder }

{ ===== Hauptprogramm ===================================================== }

BEGIN
    GrafikTreiber := Detect;
    InitGraph(GrafikTreiber, GrafikModus, TreiberPfad);
    Mono := (GetMaxColor < 15);
    OutTextXY(20, 20, 'Funktionswerte werden berechnet ...');
    FunktionswerteBerechnen;
    ClearDevice;
    VierBilder;
    REPEAT UNTIL KeyPressed;
    CloseGraph
    END.
