Program Lisajous;
{This program creates a lisajous plot file}

Var
  I:              Integer;
  File_var:       Text;
  Pi2:            Real;
  t:              Real;

Begin
  Assign (File_var, 'Lisajous.dat');
  Rewrite(File_var);

  {Add header to data file; -1 indicates data file includes header.}
  Writeln(File_var, '-1');
  Writeln(File_var, 'Lisajous plot');                   {header line 1}
  Writeln(File_var, 'X = Sine(3t); Y = Sine(16t)');     {header line 2}
  Writeln(File_var, '3');  {3 sets of data in plot; one is the lisajous data,
                            the other two are for the axes}
  Writeln(File_var, '2001'); {points in the lisajous curve}
  Writeln(File_var, 'y');    {lines between points}
  Writeln(File_var, 'n');    {mark points with icons}
  Pi2 := pi/1000.0;
  For I:=0 to 2000 do
  Begin
    t := I * pi2;
    Writeln(File_var, sin(3*t));    {x coordinate}
    Writeln(File_var, sin(16*t));   {y coordinate}
  End;

  {This section puts a horizontal reference line through the plot}
  Writeln(File_var, '2');
  Writeln(File_var, 'y');   {lines between points}
  Writeln(File_var, 'n');   {mark points with icons}
  Writeln(File_var, '-1.1');{x position of start point}
  Writeln(File_var, '0.0'); {y position of start point}
  Writeln(File_var, '1.1'); {x position of end point}
  Writeln(File_var, '0.0'); {y position of end point}

  {This section puts a vertical reference line through the plot}
  Writeln(File_var, '2');
  Writeln(File_var, 'y');   {lines between points}
  Writeln(File_var, 'n');   {mark points with icons}
  Writeln(File_var, '0.0'); {x position of start point}
  Writeln(File_var, '1.1'); {y position of start point}
  Writeln(File_var, '0.0'); {x position of end point}
  Writeln(File_var, '-1.1');{y position of end point}

  Close(File_var);

End.
