//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW IDE                       |
// |  File:        TPROJECT.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Tproject class interface             |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#include "THIDE.H"
#include "OPTIONS.H"

#ifndef _TPROJECT_H_INCLUDED
#define _TPROJECT_H_INCLUDED

  #define cxPROJECT             100
  #define cmPRJ_ADD             cmUSER10
  #define cmPRJ_INS             cmUSER11
  #define cmPRJ_EDIT_FILE       cmOK
  #define cmPRJ_DEL             cmUSER12
  #define cmPRJ_OPTIONS         cmUSER13
  #define cmPRJ_DEPENDS         cmUSER14

  #define FIRST_MAKE            prj_compiler_options.memory_model==0
  #define FIRST_LINK            prj_linker_options.stack_size==0
  #define peDONT_LINK           0x0001
  #define peAUTO_DEPENDENCY     0x0002
  #define peBUILD               0x0004
  #define peEXCLUSIVE           0x0008

  struct Tproject_entry
  {
    uint options;
    char *command_line;
    char *compiler;
    Tlb_list *depends;
    char target[_MAX_PATH];
    char filename[_MAX_PATH];
  };
  #define TPROJECT_ENTRY_SIZE   (sizeof(Tproject_entry)-_MAX_PATH)

  class Tproject: public Thide_on_close
  {
    public:
      char filename[_MAX_PATH];
      Tcompiler_options prj_compiler_options;
      Tlinker_options prj_linker_options;
      Tproject( char *_filename, int _xl, int _yl, boolean show_error );
      virtual void fetch( char *buffer, uint row, uint column, uint width );
      void set_title( void );
      boolean save( void ); //save file (prompt the user if no name)
      boolean save_as( void ); //prompt the user and save the file
      boolean save_project( void ); //write project to disk
      void new_project_entry( uint i, char *_filename );
      void add_entry( void ); //prompt the user and add file to the project
      void ins_entry( uint i ); //prompt the user and ins file to the project
      void edit_file( uint i ); //pop up edit window for selected file
      void del_entry( uint i ); //erase project item
      void dependency( uint i ); //specify dependency list for selected file
      void export( void ); //export make file
      void local_options( uint i ); //set local options for selected file
      boolean entry_valid( uint i );
      boolean exe_valid( boolean general );
      boolean build_entry( uint i ); //build project entry
      boolean make_entry( uint i ); //build project entry if needed
      boolean make( void ); //make the project
      boolean build( void ); //build the project
      boolean link( boolean general ); //link the project

    protected:
      virtual void event_handler( Tevent &ev );
      virtual void update_commands( void );
  };

#endif //_TPROJECT_H_INCLUDED


#ifdef _DECLARE_TPROJECT_H
  #define GLOBAL
#else
  #define GLOBAL extern
#endif
  GLOBAL Tproject *project;
#undef GLOBAL

void open_project( char *filename, boolean show_error );
void project_open( void );
void win_project( void );
boolean project_build( void );
boolean project_make( void );
void project_run( void );
void project_params( void );
void project_export( void );
void project_close( void );
boolean project_compile( void );
boolean project_link( void );
