//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVEDITOR.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Text editor interface                |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

void __init_editors( void );

#ifndef _PVEDITOR_H
#define _PVEDITOR_H

#define cxEDITOR          1        //editor context

#define MAX_LINE_LENGTH 256        //max displayable line

//EDITOR SETUP
#define efOVERWRITE         0x0001 //editors work in overwrite mode
#define efAUTO_INDENT       0x0002 //editors work in auto indent mode
#define efCASE_SENSITIVE    0x0004 //serach/replace is case sensitive
#define efWHOLE_WORDS_ONLY  0x0008 //search/replace matches whole words only
#define efPROMPT_ON_REPLACE 0x0010 //replace shoud prompt on each replacement
#define efREPLACE_ALL       0x0020 //auto replace all occurences
#define efDO_REPLACE        0x0040 //now replacing
#define efBACKUP_FILES      0x0080 //backup files on save
#define efHARD_TABS         0x0100 //tabs or spaces

//EDITOR BOOLEANS
#define ebDIRTY             0x0001
#define ebMODIFIED          0x0002
#define ebSELECTING         0x0004
#define ebCAN_GROW          0x0008
#define ebCAN_UNDO          0x0010
#define ebDISPOSE_BUFFER    0x0020
#ifdef SYNTAXHILIGHT
#define ebSYNTAX_HILIGHT   0x0040
#endif

#ifdef SYNTAXHILIGHT

#ifdef CPPHILIGHT
#define syCPP             1
//CPP SYNTAX HILIGHTING COLOR INDEXES
#define cppWHITE          0
#define cppCOMMENTS       1
#define cppRESERVED_WORDS 2
#define cppIDENTIFIERS    3
#define cppSYMBOLS        4
#define cppSTRINGS        5
#define cppNUMBERS        6
#define cppPREPROCESSOR   7
#endif

#ifdef ASMHILIGHT
#define syASM             2
//ASM SYNTAX HILIGHTING COLOR INDEXES
#define asmWHITE          0
#define asmCOMMENTS       1
#define asmRESERVED_WORDS 2
#define asmIDENTIFIERS    3
#define asmSYMBOLS        4
#define asmSTRINGS        5
#define asmDECIMALS       6
#define asmHEXADECIMALS   7
#define asmBINARIES       8
#endif

#ifdef A51HILIGHT
#define syA51             3
//A51 SYNTAX HILIGHTING COLOR INDEXES
#define a51WHITE          0
#define a51COMMENTS       1
#define a51RESERVED_WORDS 2
#define a51IDENTIFIERS    3
#define a51SYMBOLS        4
#define a51STRINGS        5
#define a51DECIMALS       6
#define a51HEXADECIMALS   7
#define a51BINARIES       8
#endif

#endif //SYNTAXHILIGHT

//EDITOR COMMANDS
#define cmeINDENT          cmUSER50 //indent marked block by one column
#define cmeUNINDENT        cmUSER51 //unindent marked block by one column
#define cmeCHAR_LEFT       cmUSER52 //move cursor one character to the left
#define cmeCHAR_RIGHT      cmUSER53 //move cursor one character to the right
#define cmeWORD_LEFT       cmUSER54 //move cursor one word to the left
#define cmeWORD_RIGHT      cmUSER55 //move cursor one word to the right
#define cmeLINE_START      cmUSER56 //move cursor to start of the line
#define cmeLINE_END        cmUSER57 //move cursor to end of the line

//WARNING: multiply lines start!
#define cmeLINE_UP         cmUSER58 //move cursor to the previous line
#define cmeLINE_DOWN       cmUSER59 //move cursor to the next line
#define cmePAGE_UP         cmUSER60 //move cursor one page up
#define cmePAGE_DOWN       cmUSER61 //move cursor one page down
#define cmeTEXT_START      cmUSER62 //move cursor to top of the file
#define cmeTEXT_END        cmUSER63 //move cursor to bottom of the file
#define cmeSCREEN_TOP      cmUSER64 //move cursor to top visible line
#define cmeSCREEN_BOTTOM   cmUSER65 //move cursor to bottom visible line
#define cmeSCROLL_UP       cmUSER66 //scroll text up
#define cmeSCROLL_DOWN     cmUSER67 //scroll text down
#define cmeTAB             cmUSER68 //tab pressed
#define cmeNEW_LINE        cmUSER69 //cr
//WARNING: multiply lines end!

#define cmeBACK_SPACE      cmUSER70 //delete previous character
#define cmeDEL_CHAR        cmUSER71 //del current character
#define cmeDEL_WORD        cmUSER72 //del to the end of the current word
#define cmeDEL_START       cmUSER73 //del to start of the line
#define cmeDEL_END         cmUSER74 //del to end of the line
#define cmeDEL_LINE        cmUSER75 //del current line
#define cmeINS_MODE        cmUSER76 //toggle ins mode
#define cmeSTART_SELECT    cmUSER77 //select mode on
#define cmeHIDE_SELECT     cmUSER78 //hide selection (Ctrl-K H)
#define cmeINDENT_MODE     cmUSER79 //toggle auto indent mode
#define cmeMARK0           cmUSER80
#define cmeMARK1           cmUSER81
#define cmeMARK2           cmUSER82
#define cmeMARK3           cmUSER83
#define cmeMARK4           cmUSER84
#define cmeMARK5           cmUSER85
#define cmeMARK6           cmUSER86
#define cmeMARK7           cmUSER87
#define cmeMARK8           cmUSER88
#define cmeMARK9           cmUSER89
#define cmeGMARK0          cmUSER90
#define cmeGMARK1          cmUSER91
#define cmeGMARK2          cmUSER92
#define cmeGMARK3          cmUSER93
#define cmeGMARK4          cmUSER94
#define cmeGMARK5          cmUSER95
#define cmeGMARK6          cmUSER96
#define cmeGMARK7          cmUSER97
#define cmeGMARK8          cmUSER98
#define cmeGMARK9          cmUSER99
#define cmeFIND            0xF0     //find dialog
#define cmeREPLACE         0xF1     //replace dialog
#define cmeSEARCH_AGAIN    0xF2     //repeat last search/replace
#define cmeGOTO_LINE       0xF3     //goto line number dialog
#define cmeEDITOR_OPEN     (cmVALID-1)
#define cmeEDITOR_CLOSE    (cmVALID-2)

//EDITOR STANDARD DIALOG CODES
#define edOUT_OF_MEMORY          0 //buffer can't grow up
#define edREAD_ERROR             1 //can't read text
#define edWRITE_ERROR            2 //can't write text
#define edCREATE_ERROR           3 //can't create file
#define edSAVE_MODIFY            4 //save? (yes, no, cancel)
#define edSAVE_UNTITLED          5 //save untitled? (yes, no, cancel)
#define edSAVE_AS                6 //save file as
#define edFIND                   7 //find
#define edSEARCH_FAILED          8 //search string not found
#define edREPLACE                9 //search & replace
#define edREPLACE_PROMPT        10 //replace this occurence? (yes, no, cancel)
#define edGOTO_LINE             11 //goto line number

typedef void (*Teditors_supervisor) ( char *file_name, uint where, int bytes_inserted, int lines_inserted );

class Teditor;

class Ttext_editor
{
//<R> means read-only
//<R/W> means read/write
  public:
    Teditor *editor; //<R> item that displays text editor on the screen
    char *file_name; //<R> pointer to file name, or NULL
    uint date, time; //<R> file's date and time of last modification
    char assoc_number; //<R> number of items that dislay this text
    char *edit_buffer; //<R> <text><cursor/gap><text>
    uint buf_size; //<R> current size of the edit buffer
    uint buf_len; //<R> number of characters in the edit buffer
    uint gap_len; //<R> gap length
    uint cur_ptr; //<R> cursor offset
    uint sel_start; //<R> offset of the selection origin
    uint sel_end; //<R> offset of the selection end
    uint cur_pos_x; //<R> cursor x-pos
    uint cur_pos_y; //<R> cursor y-pos
    uint cur_after_eol; //<R> cursor is cur_after_eol columns after current line end
    uint limit_xl; //<R> max length for the lines
    uint limit_yl; //<R> current number of lines in the buffer
    Tset valid_chars; //<R/W>
    uint booleans;
//constructor/destructor
    Ttext_editor( uint _buf_size, Teditor *_editor );
    Ttext_editor( char *_edit_buffer, uint _buf_size, Teditor *_editor );
    virtual ~Ttext_editor( void );
//buffer manipulations
    boolean set_buf_size( uint new_size );
    void set_buf_len( uint length ); //update gap after loading text at the end of the edit_buffer
//cursor/selection
    void set_cur_ptr( uint p, char select_mode );
    void set_cur_xy( int _x, uint _y, char select_mode );
    void set_select( uint new_start, uint new_end, int cur_start );
    void hide_select( void );
    boolean has_selection( void );
    uint lines_selected( void );
//undo works for changes sinse last cursor movement
    void undo( void );
//text insert - at the current cursor position, mark is overwriten
    boolean insert_text( char *text, uint length, int select_text );
    boolean insert_string( char *text, int select_text );
    boolean insert_from( Ttext_editor *text_editor ); //insert selected text from another editor
    int smart_tab( void );
    void new_line( void ); //places a new line at the cursor
//text deletion
    void delete_select( void );
    void delete_range( uint start_ptr, uint end_ptr, int del_select);
//clipboard services
    boolean clip_copy( void );
    void clip_cut( void );
    void clip_paste( void );
//get text
    void get_text( char *text, uint ofs, uint length );
    void get_line_str( char *str, uint length );
    void get_word_str( char *str, uint length );
//browsing
    uint next_char( uint p ); //offset of the next char for p
    uint next_line( uint p ); //offset of the next line for p
    uint next_word( uint p ); //offset of the next word for p
    uint prev_char( uint p ); //offset of the prev char for p
    uint prev_line( uint p ); //offset of the next line for p
    uint prev_word( uint p ); //offset of the next word for p
    uint line_start( uint p ); //line start for p
    uint line_end( uint p ); //line end for p
    uint line_move( uint p, int count ); //count - lines to move up/down
    char buf_char( uint p ); //p-th character in the edit_buffer
    uint buf_ptr( uint p ); //return the edit_buffer position of the p-th char
    boolean search( char *find_str, uint options );
    virtual void format_line( word *draw_buf, uint line_ptr, int width,
                      char normal, char selected );
    uint editor_dialog( int dialog, void *info );
//file name/load/save
    virtual void set_name( char *_file_name );
    boolean load( void );
    boolean save( void );

  protected:
    uint del_count; //<R> used to undo deletions
    uint ins_count; //<R> used to undo insertions
    int char_pos( uint p, uint target ); //how many columns are between p and target
    uint char_ptr( uint p, int target ); //move target columns to right
    boolean insert_buffer( char *p, uint offset, uint length, int allow_undo, int select_text );
    void clear_eol_spaces( void );
    void start_select( void );
    void update( uint cur_ptr_inserted, int bytes_inserted, int lines_inserted );

  friend class Teditor;
  friend class Tfile_editor;
};

#ifdef SYNTAXHILIGHT
class Tsyntax_editor: public Ttext_editor
{
  public:
    uint syntax_type;
    Tsyntax_editor( uint _buf_size, Teditor *_editor );
    Tsyntax_editor( char *_edit_buffer, uint _buf_size, Teditor *_editor );
    virtual void set_name( char *_file_name );
    virtual void format_line( word *draw_buf, uint line_ptr, int width, char normal, char selected );
};
#endif

class Teditor: public Titem
{
//<R> means read-only
//<R/W> means read/write
  public:
    Titem *indicator;
    uint delta_x; //<R> leftmost visible column
    uint delta_y; //<R> topmost visible row
    uint cur_ptr_svd;
    uint cur_pos_x_svd;
    uint cur_pos_y_svd;
    uint marks[10]; //<R/W> used for marking current cursor position
    Ttext_editor *text_editor;
    Teditor( Ttext_editor *_text_editor, int _xl, int _yl );
    virtual ~Teditor( void );
    boolean cursor_visible( void );
    void track_cursor( boolean center );
    void scroll_to( int _x, int _y );
    uint get_mouse_ptr( int local_x, int local_y );
    void find( void );
    void replace( void );

  protected:
    uint draw_ptr;
    uint draw_line;
    virtual void get_focused( void );
    virtual boolean release_focus( void );
    virtual void calc_bounds( int delta_xl, int delta_yl );
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
    virtual void convert_event( Tevent &ev );
    virtual void update_commands( void );
    virtual void update( uint cur_ptr_inserted, int bytes_inserted, int lines_inserted );
    virtual uint editor_dialog( int dialog, void *info );
    void do_search_replace( void );

  private:
    void init( void );

  friend class Ttext_editor;
};

class Tmemo: public Teditor
{
  public:
    char *buffer;
    Tmemo( char *_buffer, uint buf_size, int _xl, int _yl );

  protected:
    virtual void ok_item( void );
};

class Tfile_editor: public Teditor
{
//<R> means read-only
//<R/W> means read/write
  public:
    Tfile_editor *next_editor; //<R> next file editor
    Tfile_editor( char *_file_name, int _xl, int _yl );
    virtual ~Tfile_editor( void );
    virtual boolean valid( uint command );
    boolean save( void );
    boolean save_as( void );

  protected:
    virtual void event_handler( Tevent &ev );
    virtual void update_commands( void );
    virtual void update( uint cur_ptr_inserted, int bytes_inserted, int lines_inserted );
    virtual uint editor_dialog( int dialog, void *info );

  friend class Ttext_editor;
};

struct Tedit_window_status
{
  int x;
  int y;
  int xl;
  int yl;
  uint state;
  int icon_x;
  int icon_y;
  uint cur_pos_x;
  uint cur_pos_y;
  uint delta_x;
  uint delta_y;
  uint marks[10];
  char file_name[_MAX_PATH];
};
#define TEDIT_WINDOW_STATUS_SIZE (sizeof(Tedit_window_status)-_MAX_PATH)

class Tedit_window: public Tfile_window
{
  public:
    Tfile_editor *editor;
    Tedit_window( char *fn, int _xl, int _yl );
    virtual ~Tedit_window( void );
    void save_status( Tedit_window_status &st );
    void restore_status( Tedit_window_status &st );

  protected:
    virtual void initialize( void );
};

#endif //_PVEDITOR_H

#ifdef DECLARE_PVEDITOR
Tset word_chars;
uint editor_flags = efAUTO_INDENT + efBACKUP_FILES + efPROMPT_ON_REPLACE;
uint tab_size = 8;
char find_str[81] = "";
char replace_str[81] = "";
char *filter_str = NULL;
Ttext_editor *clipboard = NULL;
Ttext_editor *current_editor = NULL;
Tfile_editor *open_editors = NULL;
Teditors_supervisor editors_supervisor = NULL;
#ifdef CPPHILIGHT
char *cpp_hilight_extensions = NULL;
char cpp_syntax_colors[16] = { 14,7,15,14,15,11,11,10 };
#endif
#ifdef ASMHILIGHT
char *asm_hilight_extensions = NULL;
char asm_syntax_colors[16] = { 14,7,15,14,15,11,11,10,13 };
#endif
#ifdef A51HILIGHT
char *a51_hilight_extensions = NULL;
char a51_syntax_colors[16] = { 14,7,15,14,15,11,11,10,13 };
#endif
#else
extern Tset word_chars;
extern uint editor_flags;
extern uint tab_size;
extern char find_str[81];
extern char replace_str[81];
extern char *filter_str;
extern Ttext_editor *clipboard;
extern Ttext_editor *current_editor;
extern Tfile_editor *open_editors;
extern Teditors_supervisor editors_supervisor;
#ifdef CPPHILIGHT
extern char *cpp_hilight_extensions;
extern char cpp_syntax_colors[16];
#endif
#ifdef ASMHILIGHT
extern char *asm_hilight_extensions;
extern char asm_syntax_colors[16];
#endif
#ifdef A51HILIGHT
extern char *a51_hilight_extensions;
extern char a51_syntax_colors[16];
#endif
#endif

Tmemo *memo( char *title, char *buffer, uint buf_size, int _xl, int _yl );
Tedit_window *edit_file( char *fn );
Tedit_window *open_file( char *fn );
Tedit_window *open_file( Tedit_window_status &st );
void show_clipboard( void );
