//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVDC.H                               |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Device Context interface             |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

void __init_dc( void );

#ifndef _PVDC_H
#define _PVDC_H

  class Tdc
  {
  //<R> means read-only
  //<R/W> means read/write
    public:
  #ifdef __FLAT__
      word *address; //<R> characters buffer
  #else
      word far *address; //<R> characters buffer
  #endif
      uint len; //<R> characters buffer length
      int x; //<R/W> screen-based x position
      int y; //<R/W> screen-based y position
      uint xl; //<R> width
      uint yl; //<R> heigh
      int base_x; //<R> logical 0 x
      int base_y; //<R> logical 0 y
      int cursor_x; //<R> logical cursor x-position
      int cursor_y; //<R> logical cursor y-position
      uint cursor_ofs; //<R> cursor offset: 2 * ( cursor_y * xl + cursor_x )
      int region_x; //<R> clip region x
      int region_y; //<R> clip region y
      int region_xl; //<R> clip region width
      int region_yl; //<R> clip region heigh
      int &region_x1; //<R> clip region left bound
      int &region_y1; //<R> clip region top bound
      int region_x2; //<R> clip region right bound
      int region_y2; //<R> clip region bottom bound
      Tdc( void );
      Tdc( uint _xl, uint _yl );
      virtual ~Tdc( void );
      void set_region( int _x, int _y, uint _xl, uint _yl ); //specify clip region
      void set_region_xy( int x1, int y1, int x2, int y2 ); //specify clip region
      void invalidate( int _x, int _y, uint _xl, uint _yl ); //invalidate rectangle
      void invalidate_xy( int x1, int y1, int x2, int y2 ); //invalidate rectangle
      void validate( void ); //validate all
      void goto_xy( int _x, int _y ); //set logical cursor position
      void goto_ofs( uint cur_ofs ); //set logical cursor offset
      int where_x( void ); //return logical cursor x-position
      int where_y( void ); //return logical cursor y-position
      void set_base( int _x, int _y ); //set logical 0 position
      void home( void ); //clear dc
      void fill_dc( char c ); //fill dc w/ char c
      virtual void print( word *p, int l ); //print formatted line
      void direct_txt( char *t ); //direct write to dc
      void txt( char *t ); //formatted write to dc
      void direct_txtf( char *t, ... ); //C-style formatted direct write to dc
      void txtf( char *t, ... ); //C-style formatted formatted write to dc
      void draw( void ); //draw this dc in current dc
  };

  class Tscreen_dc : public Tdc
  {
    public:
      Tscreen_dc( void );
      virtual ~Tscreen_dc( void );
      virtual void print( word *p, int l ); //print formatted line, avoid mouse pointer colision
      void update_cursor( void ); //set hardware cursor at where_x, where_y
  };

#endif

void set_dc( Tdc *dc ); //set current (active) dc
uint smart_len( char *str ); //calculate actual formatted string length
uint smart_index( char *str, uint i ); //convert i to actual formatted string index
boolean rect_colision( int _x, int _y, uint _xl, uint _yl,
  int &a, int &b, uint &al, uint &bl ); //check rectangle overlap, set up a, b, al, bl to overlapped area
boolean rect_colision_xy( int x1, int y1, int x2, int y2,
  int &a1, int &b1, int &a2, int &b2 ); //check rectangle overlap, set up a1, b1, a2, b2 to overlapped area

//CURRENT DC-BASED FUNCTIONS

void set_region( int _x, int _y, uint _xl, uint _yl ); //set clip region
void set_region_xy( int x1, int y1, int x2, int y2 ); //set clip region
void goto_xy( int _x, int _y ); //set cursor position
void goto_ofs( uint cur_ofs ); //set cursor offset
int where_x( void ); //return cursor x position
int where_y( void ); //return cursor y position
void set_base( int _x, int _y ); //set logical 0 position
void home( void ); //clear dc
void fill_dc( char c ); //fill dc w/ char c
void print( word *p, int l ); //print formatted line
void direct_txt( char *t ); //direct write to dc
void txt( char *t ); //formatted write to dc
void direct_txtf( char *t, ... ); //C-style formatted direct write to dc
void txtf( char *t, ... ); //C-style formatted formatted write to dc

#ifdef DECLARE_PVDC
Tscreen_dc *screen_dc;
Tdc *current_dc;
boolean draw_on_screen;
#else
extern Tscreen_dc *screen_dc;
extern Tdc *current_dc;
extern boolean draw_on_screen;
#endif
