//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVSYSTEM.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     OS interface & utils implementation  |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_conio
#define uses_fcntl
#define uses_malloc
#define uses_string
#define uses_comlin
#define uses_config
#define uses_ini
#define uses_system

#define DECLARE_PVSYSTEM
#include "PVuses.h"
#undef DECLARE_PVSYSTEM

#ifdef __FLAT__
static word *page_offset = (word *) BIOS_DTA( 0x4E );
static char *current_char_size = (char *) BIOS_DTA( 0x85 );
static char *current_mode = (char *) BIOS_DTA( 0x49 );
#else
static word far *page_offset = (word *) BIOS_DTA( 0x4E );
static char far *current_char_size = (char *) BIOS_DTA( 0x85 );
static char far *current_mode = (char *) BIOS_DTA( 0x49 );
#endif

//SYSTEM & DOS INTERFACE PROCS

static int cli_counter = 0;

void _cli( void )
{
  if( !cli_counter++ ) _disable();
}

void _sti( void )
{
  if( !--cli_counter ) _enable();
}

#ifdef __386__
int lock_region ( void *address, unsigned length )
{
  union REGS regs;
  unsigned linear;

  /* Thanks to DOS/4GW's zero-based flat memory model, converting
     a pointer of any type to a linear address is trivial.
  */
  linear = (unsigned) address;

  regs.w.ax = 0x600;                      /* DPMI Lock Linear Region */
  regs.w.bx = (word) ( linear >> 16 );    /* Linear address in BX:CX */
  regs.w.cx = (word) ( linear & 0xFFFF );
  regs.w.si = (word) ( length >> 16 );    /* Length in SI:DI */
  regs.w.di = (word) ( length & 0xFFFF );
  int386 (0x31, &regs, &regs);
  return !regs.w.cflag;                   /* Return 0 if can't lock */
}
#endif

static boolean critical_error_flag=0;
#pragma off( unreferenced )
static int _loadds critical_handler( unsigned deverror, unsigned errcode, unsigned far *devhdr )
{
  critical_error_flag++;
  return ( _HARDERR_FAIL );
}
#pragma on( unreferenced )

boolean critical_error( void )
{
  boolean result = critical_error_flag;
  critical_error_flag = 0;
  return result;
}

#ifdef __WATCOMC__
boolean memavail( unsigned long &mem )
{
  struct _heapinfo h_info;
  int heap_status;

  h_info._pentry = NULL;
  mem = 0;
  for(;;)
  {
    heap_status = _heapwalk( &h_info );
    if( heap_status != _HEAPOK ) break;
    if( h_info._useflag != _USEDENTRY ) mem += h_info._size;
  }
  switch( heap_status )
  {
    case _HEAPBADBEGIN:
    case _HEAPBADPTR:
    case _HEAPBADNODE:
      return 0;
  }
  return 1;
}
#else
boolean memavail( unsigned long &mem )
{
  struct heapinfo heap;

  mem = coreleft();
  switch( heapcheck() )
  {
    case _HEAPCORRUPT:
      return 0;
    case _HEAPOK:
      heap.ptr = NULL;
      while( heapwalk( &heap ) != _HEAPEND )
        if( !heap.in_use )
          mem += heap.size;
  }
  return 1;
}
#endif

char *fexpand( char *filespec )
{
  char buf[_MAX_PATH],
       _drive[_MAX_DRIVE],
       _dir[_MAX_DIR],
       _fname[_MAX_FNAME],
       _ext[_MAX_EXT], *p, *z;
  if( !*filespec ) return filespec;
  _fullpath( filespec, strcpy(buf,filespec), _MAX_PATH );
  //the garbage below fixes the shits of _fullpath
  while( ( p = strstr( filespec, "\\.." ) ) != NULL )
  {
    z = p;
    while( *--z != '\\' );
    strcpy( z, p + 3 );
  }
  _splitpath( filespec, _drive, _dir, _fname, NULL );
  _splitpath( buf,      NULL,   NULL, NULL,   _ext );
  _makepath ( filespec, _drive, _dir, _fname, _ext );
  return strupr(filespec);
}

char *add_ext( char *name, char *ext )
{
  char _drive[_MAX_DRIVE];
  char _dir[_MAX_DIR];
  char _file[_MAX_FNAME];
  char _ext[_MAX_EXT];

  _splitpath( name, _drive, _dir, _file, _ext );
  if( *_ext==0 ) strcpy( _ext, ext );
  _makepath( name, _drive, _dir, _file, _ext );
  return name;
}

char *min_path( char *filespec )
{
  char dr[_MAX_DRIVE], d[_MAX_DRIVE+_MAX_DIR], s[_MAX_DRIVE+_MAX_DIR];

  _splitpath( filespec, dr, s, NULL, NULL );
  strcpy( d, dr ); strcat( d, s );
  getcwd( s, sizeof( s ) ); strcat( s, "\\" );
  if( ( strlen(s) <= strlen( d ) ) && ( d[strlen( s )] = 0, ( strcmp( d, s ) == 0 ) ) )
    strcpy( filespec, filespec + strlen( s ) );
  else
    if( s[0] == d[0] ) strcpy( filespec, filespec + 2 );
  return filespec;
}

char *short_path( char *filespec, int n )
{
  boolean fl;
  char s[_MAX_PATH], x[_MAX_EXT], *i;

  if( strlen( filespec ) <= n ) return filespec;
  n -= 4;
  fl =  0;
  _splitpath( filespec, NULL, NULL, s, x );
  strcat( s, x );
  if( strlen( s ) >= n )
    strcpy( filespec, s );
  else
  {
    while( strlen( filespec ) > n )
    {
      i = filespec;
      if( *i == '\\' ) i++;
      while( *i != '\\' ) i++;
      strcpy( filespec, i );
      fl = 1;
    }
    if( fl )
    {
      strcpy( s, filespec );
      strcpy( filespec, "\\..." );
      strcat( filespec, s );
    }
  }
  return filespec;
}

long file_size( char *filespec )
{
  struct find_t d;

  if( _dos_findfirst( filespec, _A_NORMAL, &d ) ) return -1;
  return d.size;
}

boolean get_date_time( char *filespec, uint &date, uint &time )
{
  int handle;
  union REGS r;

  date = time = 0;
  if( _dos_open( filespec, O_RDONLY, &handle ) != 0 ) return 0;
  r.w.ax = 0x5700;
  r.w.bx = handle;
  INTR( 0x21, &r, &r );
  date = r.w.dx;
  time = r.w.cx;
  _dos_close( handle );
  return 1;
}

uint pack_time( char hours, char minutes, char seconds )
{
  return ( hours << 11 ) | ( minutes << 5 ) | ( seconds >> 1 );
}

uint pack_date( uint year, char month, char day )
{
  return ( ( year - 1980 ) << 9 ) | ( month << 5 ) | day;
}

void unpack_time( unsigned packed, char &hours, char &minutes, char &seconds )
{
  hours = (char) ( packed >> 11 );
  minutes = (char) ( ( packed >> 5 ) & 63 );
  seconds = (char) ( ( packed & 31 ) << 1 );
}

void unpack_date( unsigned packed, uint &year, char &month, char &day )
{
  year  = ( ( packed & 0xF800 ) >> 9 ) + 1980;
  month = ( ( packed & 0x01E0 ) >> 5 );
  day   = packed & 0x1F;
}

//SCREEN

void set_char_size( char size )
{
  union REGS r;

  if( size && ( *current_char_size != size ) )
  {
    r.h.ah = 0x11;
    switch( size )
    {
      case  8: r.h.al = 0x12; break;
      case 14: r.h.al = 0x11; break;
      case 16: r.h.al = 0x14;
    }
    INTR( 0x10, &r, &r );
#if !defined( NOICONS ) && !defined( HGR )
    if( size==16 ) set_char_width( 9 ); else set_char_width( 8 );
#endif
  }
}

void set_video_mode( char mode, char char_size )
{
  if( (char_size!=*current_char_size) || (mode!=*current_mode) )
    change_video_mode( mode, char_size );
}

#pragma off( unreferenced )
void direct_set_video_mode( char mode, char char_size )
{
  union REGS r;

#ifdef HGR
  r.w.ax = 0x12;
  INTR( 0x10, &r, &r );
#else
  if( mode && (mode!=*current_mode) )
  {
    r.w.ax = mode;
    INTR( 0x10, &r, &r );
  }
  if( char_size && ( char_size != *current_char_size ) )
    set_char_size( char_size );
#endif
  update_screen_information();
}
#pragma on( unreferenced )

#ifdef HGR
void update_screen_information( void )
{
  scr_bw = scr_forced_bw;
  scr_page = 0;
  scr_mode = 0x12;
  scr_columns = 80;
  scr_rows = 30;
  scr_soft_fonts = 0;
  scr_char_size = 16;
  scr_address = (word *) MKFP( 0xA000, 0 );
  scr_length = scr_rows*scr_columns;
}
#else
void update_screen_information( void )
{
  union REGS r;
  word ax;

  r.h.ah = 0x0F;
  INTR( 0x10, &r, &r );
  if( !scr_forced_bw ) scr_bw = (r.h.al==2) || (r.h.al==7);
  scr_page = r.h.bh;
  r.h.al &= 0x7F;
  ax = r.w.ax;
  r.w.ax = 0x1130;
  r.h.bh = 0;
  r.h.dl = -1;
  INTR( 0x10, &r, &r );
  r.w.ax = ax;
  r.h.dl++;
  r.h.dh = r.h.ah;
  r.h.ah = ( r.h.dl >= ( 25 + 1 ) );
  r.w.si = 0xB800;
  r.h.ch = 1;
  if( !r.h.dl )
  {
    r.w.cx = 8;
    r.h.dl = 25;
    if( r.h.al == 7 )
    {
      r.w.si = 0xB000;
      r.h.cl = 13;
    }
  }
  scr_mode = r.w.ax;
  scr_columns = r.h.dh;
  scr_rows = r.h.dl;
  scr_soft_fonts = r.h.ch;
  scr_char_size = r.h.cl;
  scr_address = (word *) MKFP( r.w.si, *page_offset );
  scr_length = scr_rows*scr_columns*2;
}
#endif

void set_page( char page_num )
{
  union REGS r;

#ifndef NOMOUSE
  hide_mouse();
#endif
  scr_page = page_num;
  r.h.al = page_num;
  r.h.ah = 5;
  INTR( 0x10, &r, &r );
  if( scr_mode == 7 )
    scr_address = (word *) MKFP( 0xB000, *page_offset );
  else
    scr_address = (word *) MKFP( 0xB800, *page_offset );
#ifndef NOMOUSE
  show_mouse();
#endif
}

char *save_screen_status( void )
{
  union REGS r;
  char *p, *result;

#ifndef NOMOUSE
  hide_mouse();
#endif
  update_screen_information();
  p = (char *)MALLOC( 9 + scr_length );
  result = p;
  r.h.ah = 0x0F;
  INTR( 0x10, &r, &r );
  *( p++ ) = r.h.al;
  *( p++ ) = scr_char_size;
  *( p++ ) = r.h.bh;
  r.h.ah = 3;
  INTR( 0x10, &r, &r );
  *( p++ ) = r.h.dl;
  *( p++ ) = r.h.dh;
  *( p++ ) = r.h.ch;
  *( p++ ) = r.h.cl;
  *((word *)p) = scr_length;
  p+=2;
  _fmemcpy( p, scr_address, scr_length );
#ifndef NOMOUSE
  show_mouse();
#endif
  return result;
}

void restore_screen_status( char *p )
{
  union REGS r;
  char *saved;

  if( p == NULL ) return;
  saved = p;
#ifndef NOMOUSE
  hide_mouse();
#endif
  set_video_mode( *( p ), *( p + 1 ) ); p += 2;
  r.h.al = *p;
  r.h.ah = 5;
  INTR( 0x10, &r, &r );
  r.h.bh = *( p++ );
  r.h.dl = *( p++ );
  r.h.dh = *( p++ );
  r.h.ah = 2;
  INTR( 0x10, &r, &r );
  r.h.ch = *( p++ );
  r.h.cl = *( p++ );
  r.h.ah = 1;
  INTR( 0x10, &r, &r );
  scr_length = *(word *)p;
  p+=2;
  if( scr_mode == 7 )
    scr_address = (word *) MKFP( 0xB000, *page_offset );
  else
    scr_address = (word *) MKFP( 0xB800, *page_offset );
  _fmemcpy( scr_address, p, scr_length );
  FREE( saved );
  update_screen_information();
#ifndef NOMOUSE
  show_mouse();
#endif
}

static char *dos_screen = NULL;

void save_dos_screen( void )
{
  dos_screen = save_screen_status();
}

void restore_dos_screen( void )
{
  restore_screen_status( dos_screen );
  dos_screen = NULL;
}

Tscreen_mode_proc hook_mode_proc( Tscreen_mode_proc p )
{
  Tscreen_mode_proc x;

  x = change_video_mode;
  change_video_mode = p;
  return x;
}


#ifndef HGR

//EGA/VGA FONTS MANAGEMENT

char seq_read( char reg )
{
  outp( 0x3C4, reg );
  return (char) inp( 0x3C5 );
}

void seq_write( char reg, char val )
{
  outp( 0x3C4, reg );
  outp( 0x3C5, val );
}

char gpx_read( char reg )
{
  outp( 0x3CE, reg );
  return (char) inp( 0x3CF );
}

void gpx_write( char reg, char val )
{
  outp( 0x3CE, reg );
  outp( 0x3CF, val );
}

void open_font_map( void )
{
  seq_write( 2, 4 );
  seq_write( 4, 7 );
  gpx_write( 5, 0 );
  gpx_write( 6, 4 );
  gpx_write( 4, 2 );
}

void close_font_map( void )
{
  seq_write( 2, 3 );
  seq_write( 4, 3 );
  gpx_write( 5, 0x10 );
  gpx_write( 6, 0x0E );
  gpx_write( 4, 0 );
}

char *get_char_def( int chr, char *buf )
{
#ifdef __FLAT__
  char *A000 = VGA_CHARS;
#else
  char far *A000 = VGA_CHARS;
#endif
  uint char_offset;

  char_offset = ( chr << 5 ) | ( scr_font_num << 14 );
  _fmemcpy( buf, A000 + char_offset, scr_char_size );
  return buf + scr_char_size;
}

char *set_char_def( int chr, char *buf )
{
#ifdef __FLAT__
  char *A000 = VGA_CHARS;
#else
  char far *A000 = VGA_CHARS;
#endif
  uint char_offset;

  char_offset = ( chr << 5 ) | ( scr_font_num << 14 );
  _fmemcpy( A000 + char_offset, buf, scr_char_size );
  return buf + scr_char_size;
}

char *xchg_char_def( int chr, char *buf )
{
  char tmp_buffer[0x10];
  char *result;

  get_char_def( chr, tmp_buffer );
  result = set_char_def( chr, buf );
  memmove( buf, tmp_buffer, scr_char_size );
  return result;
}

void set_char_width( char width )
{
  union REGS r;
  char x;

  r.w.bx = ( width == 8 ) ? 0x0001 : 0x0800;
  x = (char) ( inp( 0x3CC ) & ( 255 - 12 ) );
  if( width == 9 ) x |= 4;
  outp( 0x3C2, x );
  _cli();
  outpw( 0x3C4, 0x0100 );
  outpw( 0x3C4, 0x01 + ( r.h.bl << 8 ) );
  outpw( 0x3C4, 0x0300 );
  _sti();
  r.w.ax = 0x1000;
  r.h.bl = 0x13;
  INTR( 0x10, &r, &r );
}

void select_fonts( char font1, char font2 )
{
  union REGS r;

  r.h.bl = (char) ( font1 | ( font2 << 2 ) );
  r.w.ax = 0x1103;
  INTR( 0x10, &r, &r );
}

#endif //!HGR


//CURSOR MANAGEMENT

#ifdef HGR

void get_cursor( Tcursor &x )
{
  x = *current_cursor;
}

void set_cursor( Tcursor &x )
{
  current_cursor = &x;
}

#else

void get_cursor( Tcursor &x )
{
  union REGS r;

  r.h.ah = 0x0F;
  INTR( 0x10, &r, &r );
  r.h.ah = 0x03;
  INTR( 0x10, &r, &r );
  x.beg_line = r.h.ch;
  x.end_line = r.h.cl;
}

void set_cursor( Tcursor &x )
{
  union REGS r;

  r.h.ah=1;
  r.h.ch=x.beg_line;
  r.h.cl=x.end_line;
  INTR( 0x10, &r, &r );
}

#endif //HGR

#ifndef HGR

//EGA/VGA PALETTE MANAGEMENT

void set_blink( boolean blink )
{
  union REGS r;
#ifdef __FLAT__
  char *p = (char *) BIOS_DTA( 0x65 );
#else
  char far *p = (char *) BIOS_DTA( 0x65 );
#endif
  char x;

  r.w.ax = 0x1003;
  r.h.bl = blink;
  INTR( 0x10, &r, &r );
  x = *p;
  if( blink ) x &= !0x20; else x |= 0x20;
  outp( 0x3D8, x );
}

#ifndef NOPAL
void set_palette( char no, char value )
{
  union REGS r;

  r.w.ax = 0x1000;
  r.h.bl = no;
  r.h.bh = value;
  INTR( 0x10, &r, &r );
}

char get_palette( char no )
{
  union REGS r;

  r.w.ax = 0x1007;
  r.h.bl = no;
  INTR( 0x10, &r, &r );
  return r.h.bh;
}

void set_border( char color )
{
  union REGS r;

  r.w.ax = 0x1001;
  r.h.bh = color;
  INTR( 0x10, &r, &r );
}

char get_border( void )
{
  union REGS r;

  r.w.ax = 0x1008;
  INTR( 0x10, &r, &r );
  return r.h.bh;
}

void set_all_palette( Tpal &x )
{
  for( char i = 0; i <= 0x0F; i++ ) set_palette( i, x[i] );
}

void get_all_palette( Tpal &x )
{
  for( char i = 0; i <= 0x0F; i++ ) x[i] = get_palette( i );
}
#endif //!NOPAL

#endif //!HGR

//SOUND

void beep( uint hz, uint ms )
{
  sound( hz );
  delay( ms );
  nosound();
}

#ifndef NOTIMER
void smart_beep( uint hz, uint ticks )
{
  static int h = -1;

  free_timer( h );
  sound( hz );
  call_request( (h=alloc_timer()), nosound, ticks );
  if( !h ) nosound();
}
#endif


//STARTUP

static long startup_mode = 0;
static long startup_char_size = 0;

void __set_startup_video_mode( void )
{
  set_video_mode( (char) startup_mode, (char) startup_char_size );
}

#ifndef NOCONFIG
static void read_params( void )
{
  seek_section( 0, SECTION_SCREEN );
  ini( VAR_VIDEO_MODE, startup_mode, 0 );
  ini( VAR_CHAR_SIZE, startup_char_size, 0 );
  ini_lnerr( startup_char_size!= 0 && startup_char_size!= 8 &&
             startup_char_size!=14 && startup_char_size!=16, INIERR_RANGE );
  if( !scr_forced_bw ) ini( VAR_BW, scr_forced_bw, 0 );
}
#endif

static void init_cyr( void )
{
  union REGS r;

  r.w.ax = 0xEB01;
  INTR( 0x10, &r, &r );
  if( r.h.al != 0xEB ) return;
#ifdef CYR
  scr_font_num = 3;
  r.h.bl |= 0x30; //activate, set cyr font & cyr keymap
  r.h.bl &= ~0x02; //disable graphics keymap
#else
  scr_font_num = 0;
  r.h.bl |= 0x20; //activate, set eng font & qwerty keymap
  r.h.bl &= ~0x1A; //disable graphics keymap
#endif
  r.w.ax = 0xEB02;
  INTR( 0x10, &r, &r );
}

void __init_system( void )
{
  _harderr( critical_handler );
#ifndef HGR
  set_cursor( insert_cursor );
#endif
#ifndef NOPARAM
  if( param_opt( "/COLOR" ) ) scr_forced_bw = 0;
  if( param_opt( "/BW"    ) ) scr_forced_bw = 1;
#endif
#ifndef NOCONFIG
  read_params();
#endif
  scr_bw = scr_forced_bw;
  update_screen_information();
  init_cyr();
#ifdef CYR
  strcpy( frame_standard, frame_cyr );
#endif
}
